/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

class ConfigRecordTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private ArrayList timeList = new ArrayList();
    private ArrayList recordList = new ArrayList();

    ConfigRecordTable(boolean bl) throws BrokerException {
        if (bl) {
            this.clearAllRecords();
        } else {
            this.loadData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long l, byte[] byArray) throws BrokerException {
        boolean bl = false;
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.conn.setAutoCommit(true);
                    dBConnection.insertCCRecordStmt.setLong(1, l);
                    ByteArrayInputStream byteArrayInputStream = Util.setBytes(dBConnection.insertCCRecordStmt, 2, byArray);
                    dBConnection.insertCCRecordStmt.executeUpdate();
                    byteArrayInputStream.close();
                    this.timeList.add(new Long(l));
                    this.recordList.add(byArray);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.insertCCRecordSQL + "]", iOException);
                    logger.log(32, "B4083", iOException2);
                    throw new BrokerException(br.getString("B4083"), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.insertCCRecordSQL + "]", sQLException);
                    logger.log(32, "B4083", sQLException2);
                    throw new BrokerException(br.getString("B4083"), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getConfigChangeRecordsSince(long l) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.timeList;
        synchronized (arrayList2) {
            Long l2;
            int n;
            int n2 = this.timeList.size();
            for (n = 0; n < n2 && (l2 = (Long)this.timeList.get(n)) <= l; ++n) {
            }
            while (n < n2) {
                arrayList.add(this.recordList.get(n));
                ++n;
            }
            return arrayList;
        }
    }

    public Object[] getAllConfigRecords() throws BrokerException {
        Object[] objectArray = new Object[]{this.timeList.clone(), this.recordList.clone()};
        return objectArray;
    }

    private void loadData() throws BrokerException {
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            ResultSet resultSet = dBConnection.selectAllCCRecordsStmt.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(1);
                try {
                    byte[] byArray = Util.readBytes(resultSet, 2);
                    this.timeList.add(new Long(l));
                    this.recordList.add(byArray);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.selectAllCCRecordsSQL + "]", iOException);
                    logger.logStack(32, "B4123", new Long(l), (Throwable)iOException2);
                }
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + this.timeList.size() + " RECORDS FROM " + DBConnection.ccrecordTable);
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllCCRecordsSQL + "]", sQLException);
            logger.log(32, "B4082", sQLException2);
            throw new BrokerException(br.getString("B4082"), sQLException2);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Config change records(IMQCCREC35)", String.valueOf(this.timeList.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllRecords() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "ConfigRecordTable.clearAllRecords() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAllCCRecordsStmt.executeUpdate();
                    this.timeList.clear();
                    this.recordList.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllCCRecordsSQL + "]", sQLException);
                    logger.log(32, "B4096", sQLException2);
                    throw new BrokerException(br.getString("B4096"), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "ConfigRecordTable.close() called");
        }
    }
}

