/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class TxnAckList {
    static Logger logger = Globals.getLogger();
    static BrokerResources br = Globals.getBrokerResources();
    static BrokerConfig config = Globals.getConfig();
    static final String BASENAME = "txnack";
    private PHashMap tidMap = null;
    private HashMap emptyHashMap = new HashMap();
    private File backingFile = null;
    private LoadException loadException = null;

    TxnAckList(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = config.getSizeProperty("imq.persist.file.transaction.file.size", 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.tidMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            logger.log(32, "B4054", iOException);
            throw new BrokerException(br.getString("B4054"), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (IOException iOException) {
            logger.log(32, "B4054", iOException);
            throw new BrokerException(br.getString("B4054"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4054", classNotFoundException);
            throw new BrokerException(br.getString("B4054"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                logger.log(16, "B4198", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data", throwable);
        }
        if (bl && Store.DEBUG) {
            logger.log(1, "TxnAckList initialized with clear option");
        }
        if (Store.DEBUG) {
            logger.log(4, "TxnAckList: loaded acks for " + this.tidMap.size() + " transactions");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    TxnAckList(File file, File file2, boolean bl) throws BrokerException {
        Object object;
        Throwable throwable;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            logger.log(32, "B4156", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            logger.log(32, "B4156", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4156", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                logger.log(16, "B4203", throwable);
                object = new LoadException(throwable.getMessage(), throwable.getCause());
                ((LoadException)object).setKey(((PHashMapLoadException)throwable).getKey());
                ((LoadException)object).setValue(((PHashMapLoadException)throwable).getValue());
                ((LoadException)object).setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                ((LoadException)object).setValueCause(((PHashMapLoadException)throwable).getValueCause());
                ((LoadException)object).setNextException(this.loadException);
                this.loadException = object;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data in old store", throwable);
        }
        try {
            this.tidMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            logger.log(32, "B4156", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (IOException iOException) {
            logger.log(32, "B4156", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4156", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            logger.log(32, "B4156", file3, this.backingFile, pHashMapLoadException);
            throw new BrokerException(br.getString("B4156", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data", throwable);
        }
        object = pHashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.tidMap.put(k, v);
        }
        pHashMap.close();
        if (Store.DEBUG) {
            logger.log(4, "TxnAckList: upgraded acks for " + this.tidMap.size() + " txns");
        }
        if (bl && !file3.delete()) {
            logger.log(32, "B1044", file3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            HashSet<TransactionAcknowledgement> hashSet = (HashSet<TransactionAcknowledgement>)this.tidMap.get(transactionUID);
            if (hashSet == null) {
                hashSet = new HashSet<TransactionAcknowledgement>();
                this.tidMap.put(transactionUID, hashSet);
                if (bl) {
                    this.sync();
                }
            } else if (hashSet.contains(transactionAcknowledgement)) {
                logger.log(32, "B3062", (Object)transactionAcknowledgement, transactionUID);
                throw new BrokerException(br.getString("B3062", transactionAcknowledgement, transactionUID));
            }
            hashSet.add(transactionAcknowledgement);
            try {
                this.tidMap.put(transactionUID, hashSet);
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, "B4056", (Object)transactionAcknowledgement.toString(), transactionUID.toString());
                throw new BrokerException(br.getString("B4056", transactionAcknowledgement.toString(), transactionUID.toString()), runtimeException);
            }
        }
    }

    HashMap getAllAcks() {
        if (this.tidMap.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap hashMap = new HashMap(this.tidMap.size());
        Set set = this.tidMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashSet hashSet = (HashSet)entry.getValue();
            TransactionAcknowledgement[] transactionAcknowledgementArray = hashSet.toArray(new TransactionAcknowledgement[0]);
            hashMap.put(entry.getKey(), transactionAcknowledgementArray);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionUID[] getAllTids() {
        TransactionUID[] transactionUIDArray = null;
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            Set set = this.tidMap.keySet();
            transactionUIDArray = new TransactionUID[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                transactionUIDArray[n] = (TransactionUID)iterator.next();
            }
        }
        return transactionUIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionAcknowledgement[] getAcks(TransactionUID transactionUID) throws BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            HashSet hashSet = (HashSet)this.tidMap.get(transactionUID);
            TransactionAcknowledgement[] transactionAcknowledgementArray = new TransactionAcknowledgement[]{};
            if (hashSet != null) {
                return hashSet.toArray(transactionAcknowledgementArray);
            }
            return transactionAcknowledgementArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAcks(TransactionUID transactionUID, boolean bl) throws BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            try {
                HashSet hashSet = (HashSet)this.tidMap.remove(transactionUID);
                if (bl) {
                    this.sync();
                }
                if (hashSet != null) {
                    hashSet.clear();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, "B4060", transactionUID.toString());
                throw new BrokerException(br.getString("B4060", transactionUID.toString()), runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "TxnAckList.clearAll() called");
        }
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            try {
                this.tidMap.clear();
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, br.getString("B4055", this.backingFile), runtimeException);
            }
            if (bl) {
                try {
                    this.sync();
                }
                catch (BrokerException brokerException) {
                    logger.log(32, "Got exception while synchronizing data to disk", brokerException);
                }
            }
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "TxnAckList: closing, " + this.tidMap.size() + " transactions has acks");
        }
        this.tidMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Txn acks", String.valueOf(this.tidMap.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nTransaction acknowledgements");
        printStream.println("----------------------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("Number of transactions containing acknowledgements: " + this.tidMap.size());
    }

    public int getNumberOfTxnAcks() {
        int n = 0;
        Iterator iterator = this.tidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashSet hashSet = (HashSet)entry.getValue();
            n += hashSet.size();
        }
        return n;
    }

    private void sync() throws BrokerException {
        try {
            this.tidMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }
}

