/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TxnAckList;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.PHashMap;
import com.sun.messaging.jmq.util.PHashMapLoadException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

class TidList {
    static Logger logger = Globals.getLogger();
    static BrokerResources br = Globals.getBrokerResources();
    static BrokerConfig config = Globals.getConfig();
    static final String TXN_FILE_SIZE_PROP = "imq.persist.file.transaction.file.size";
    static final long DEFAULT_TXN_FILE_SIZE = 1024L;
    static final String BASENAME = "txn";
    private PHashMap tidMap = null;
    private File backingFile = null;
    private TxnAckList txnAckList = null;
    private LoadException loadException = null;

    TidList(File file, boolean bl) throws BrokerException {
        Throwable throwable;
        SizeString sizeString = config.getSizeProperty(TXN_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(file, BASENAME);
        try {
            this.tidMap = new PHashMap(this.backingFile, sizeString.getBytes(), false, bl);
        }
        catch (IOException iOException) {
            logger.log(32, "B4032", iOException);
            throw new BrokerException(br.getString("B4032"), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (IOException iOException) {
            logger.log(32, "B4032", iOException);
            throw new BrokerException(br.getString("B4032"), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4032", classNotFoundException);
            throw new BrokerException(br.getString("B4032"), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                logger.log(16, "B4197", throwable);
                LoadException loadException = new LoadException(throwable.getMessage(), throwable.getCause());
                loadException.setKey(((PHashMapLoadException)throwable).getKey());
                loadException.setValue(((PHashMapLoadException)throwable).getValue());
                loadException.setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                loadException.setValueCause(((PHashMapLoadException)throwable).getValueCause());
                loadException.setNextException(this.loadException);
                this.loadException = loadException;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data", throwable);
        }
        if (bl && Store.DEBUG) {
            logger.log(1, "TidList initialized with clear option");
        }
        if (Store.DEBUG) {
            logger.log(4, "TidList: loaded " + this.tidMap.size() + " transactions");
        }
        this.txnAckList = new TxnAckList(file, bl);
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    LoadException getLoadTransactionAckException() {
        return this.txnAckList.getLoadException();
    }

    TidList(FileStore fileStore, File file, File file2) throws BrokerException {
        Object object;
        Throwable throwable;
        File file3 = new File(file2, BASENAME);
        PHashMap pHashMap = null;
        this.backingFile = new File(file, BASENAME);
        try {
            pHashMap = new PHashMap(file3, false, false);
        }
        catch (IOException iOException) {
            logger.log(32, "B4157", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), iOException);
        }
        try {
            pHashMap.load();
        }
        catch (IOException iOException) {
            logger.log(32, "B4157", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4157", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), classNotFoundException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            while (throwable != null) {
                logger.log(16, "B4202", throwable);
                object = new LoadException(throwable.getMessage(), throwable.getCause());
                ((LoadException)object).setKey(((PHashMapLoadException)throwable).getKey());
                ((LoadException)object).setValue(((PHashMapLoadException)throwable).getValue());
                ((LoadException)object).setKeyCause(((PHashMapLoadException)throwable).getKeyCause());
                ((LoadException)object).setValueCause(((PHashMapLoadException)throwable).getValueCause());
                ((LoadException)object).setNextException(this.loadException);
                this.loadException = object;
                throwable = ((PHashMapLoadException)throwable).getNextException();
            }
        }
        throwable = pHashMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data in old store", throwable);
        }
        try {
            this.tidMap = new PHashMap(this.backingFile, file3.length(), false, false);
        }
        catch (IOException iOException) {
            logger.log(32, "B4157", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), iOException);
        }
        try {
            this.tidMap.load();
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4157", file3, this.backingFile, classNotFoundException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), classNotFoundException);
        }
        catch (IOException iOException) {
            logger.log(32, "B4157", file3, this.backingFile, iOException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), iOException);
        }
        catch (PHashMapLoadException pHashMapLoadException) {
            logger.log(32, "B4157", file3, this.backingFile, pHashMapLoadException);
            throw new BrokerException(br.getString("B4157", file3, this.backingFile), pHashMapLoadException);
        }
        throwable = this.tidMap.getWarning();
        if (throwable != null) {
            logger.log(16, "possible loss of transaction data", throwable);
        }
        object = pHashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.tidMap.put(k, v);
        }
        pHashMap.close();
        if (Store.DEBUG) {
            logger.log(4, "TidList: upgraded " + this.tidMap.size() + " transactions");
        }
        if (fileStore.upgradeNoBackup() && !file3.delete()) {
            logger.log(32, "B1044", file3);
        }
        this.txnAckList = new TxnAckList(file, file2, fileStore.upgradeNoBackup());
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "TidList: closing, " + this.tidMap.size() + " persisted transactions");
        }
        this.tidMap.close();
        this.txnAckList.close(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            if (this.tidMap.containsKey(transactionUID)) {
                logger.log(32, "B3015", transactionUID.toString());
                throw new BrokerException(br.getString("B3015", transactionUID.toString()));
            }
            try {
                this.tidMap.put(transactionUID, new TransactionState(transactionState));
                if (bl) {
                    this.sync();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, "B4019", (Object)transactionUID.toString(), (Throwable)runtimeException);
                throw new BrokerException(br.getString("B4019", transactionUID.toString()), runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction(TransactionUID transactionUID, boolean bl) throws BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            if (!this.tidMap.containsKey(transactionUID)) {
                logger.log(32, "B3016", transactionUID.toString());
                throw new BrokerException(br.getString("B3016", transactionUID.toString()));
            }
            try {
                this.tidMap.remove(transactionUID);
                if (bl) {
                    this.sync();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, "B4138", (Object)transactionUID.toString(), (Throwable)runtimeException);
                throw new BrokerException(br.getString("B4138", transactionUID.toString()), runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            TransactionState transactionState = (TransactionState)this.tidMap.get(transactionUID);
            if (transactionState == null) {
                logger.log(32, "B3016", transactionUID.toString());
                throw new BrokerException(br.getString("B3016", transactionUID.toString()));
            }
            if (transactionState.getState() != n) {
                try {
                    transactionState.setState(n);
                    this.tidMap.put(transactionUID, transactionState);
                    if (bl) {
                        this.sync();
                    }
                }
                catch (RuntimeException runtimeException) {
                    logger.log(32, "B4137", (Object)transactionUID.toString(), (Throwable)runtimeException);
                    throw new BrokerException(br.getString("B4137", transactionUID.toString()), runtimeException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getAllTransactionStates() throws IOException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            return (HashMap)this.tidMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "TidList.clearAll() called");
        }
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            try {
                this.tidMap.clear();
                if (bl) {
                    this.sync();
                }
            }
            catch (BrokerException brokerException) {
                logger.log(32, br.getString("B4020", this.backingFile), brokerException);
            }
            catch (RuntimeException runtimeException) {
                logger.log(32, br.getString("B4020", this.backingFile), runtimeException);
            }
        }
        this.txnAckList.clearAll(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(int n, boolean bl) throws BrokerException {
        boolean bl2 = false;
        Exception exception = null;
        TransactionUID[] transactionUIDArray = this.tidMap;
        synchronized (this.tidMap) {
            Object object;
            Iterator iterator = this.tidMap.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    object = (Map.Entry)iterator.next();
                    TransactionUID transactionUID = (TransactionUID)object.getKey();
                    TransactionState transactionState = (TransactionState)object.getValue();
                    if (transactionState.getState() == n) continue;
                    iterator.remove();
                    try {
                        this.txnAckList.removeAcks(transactionUID, bl);
                    }
                    catch (BrokerException brokerException) {
                        bl2 = true;
                        exception = brokerException;
                        break;
                    }
                }
                catch (RuntimeException runtimeException) {
                    bl2 = true;
                    exception = runtimeException;
                    logger.log(32, "B4139", (Object)new Integer(n), (Throwable)runtimeException);
                }
            }
            if (bl) {
                this.sync();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (!bl2) {
                transactionUIDArray = this.txnAckList.getAllTids();
                for (int i = 0; i < transactionUIDArray.length; ++i) {
                    object = (TransactionState)this.tidMap.get(transactionUIDArray[i]);
                    if (object != null && ((TransactionState)object).getState() == n) continue;
                    try {
                        this.txnAckList.removeAcks(transactionUIDArray[i], bl);
                        continue;
                    }
                    catch (BrokerException brokerException) {
                        bl2 = true;
                        exception = brokerException;
                        break;
                    }
                }
            }
            if (bl2) {
                this.clearAll(bl);
                throw new BrokerException(br.getString("B4139", new Integer(n)), exception);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        PHashMap pHashMap = this.tidMap;
        synchronized (pHashMap) {
            if (!this.tidMap.containsKey(transactionUID)) {
                logger.log(32, "B3016", transactionUID.toString());
                throw new BrokerException(br.getString("B3016", transactionUID.toString()));
            }
        }
        this.txnAckList.storeAck(transactionUID, transactionAcknowledgement, bl);
    }

    void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        this.txnAckList.removeAcks(transactionUID, bl);
    }

    TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        return this.txnAckList.getAcks(transactionUID);
    }

    HashMap getAllTransactionAcks() {
        return this.txnAckList.getAllAcks();
    }

    public int getNumberOfTxnAcks() {
        return this.txnAckList.getNumberOfTxnAcks();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Transactions", String.valueOf(this.tidMap.size()));
        hashtable.putAll(this.txnAckList.getDebugState());
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nTransaction IDs");
        printStream.println("---------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("number of transaction ids: " + this.tidMap.size());
        this.txnAckList.printInfo(printStream);
    }

    private void sync() throws BrokerException {
        try {
            this.tidMap.force();
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }
}

