/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class MessageAckHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public MessageAckHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 3) {
            this.handleMessageAck(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 4) {
            this.handleMessageAckReply(brokerAddress, gPacket);
        } else {
            logger.log(16, "MessageAckHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleMessageAck(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        ConsumerUID consumerUID;
        SysMessageID sysMessageID;
        int n = (Integer)gPacket.getProp("T");
        byte[] byArray = gPacket.getPayload().array();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            sysMessageID = new SysMessageID();
            sysMessageID.readID(dataInputStream);
            consumerUID = this.p.readConsumerUID(dataInputStream);
        }
        catch (Exception exception) {
            logger.logStack(4, "Exception reading packet ", exception);
            return;
        }
        if (DEBUG) {
            object = "\n\tackType = " + n + "\n\tSysMessageID = " + sysMessageID + "\n\tConsumerUID = " + consumerUID + "\n\tSender = " + brokerAddress + "\n";
            logger.log(1, "MessageBus: Received message acknowledgement : {0}", object);
        }
        messageBusCallback.processRemoteAck(sysMessageID, consumerUID, n);
        if (gPacket.getBit(1)) {
            object = GPacket.getInstance();
            ((GPacket)object).setType((short)4);
            ((GPacket)object).putProp("S", new Integer(200));
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleMessageAckReply(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received reset G_MESSAGE_ACK_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

