/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.UpdateProperties;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.Resource;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClientClosedHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClusterFlowControlHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ConfigChangeEventHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.DestinationUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetConfigChangesHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetInterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.InterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.LockHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageAckHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageDataHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NewInterestHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.RemDurableHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.UnknownPacketHandler;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class RaptorProtocol
implements Protocol {
    protected static final long ConsumerVersionUID = 99353142765567461L;
    public static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    protected static boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    protected static boolean DEBUG_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty("imq.cluster.debug.lock");
    protected static boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn");
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected CallbackDispatcher cbDispatcher = null;
    protected int version = 350;
    protected HashMap brokerList = null;
    protected int lockTimeout = Globals.getConfig().getIntProperty("imq.cluster.locktimeout", 60);
    protected HashMap resTable = null;
    protected Random r = null;
    protected long startTime = 0L;
    protected boolean configSyncComplete = false;
    protected boolean storeDirtyFlag = false;
    protected boolean isMasterBroker = false;
    private Map eventLogWaiters = null;
    protected Object cfgSrvWaitObject = null;
    protected int cfgSrvRequestCount = 0;
    protected boolean cfgSrvRequestErr = false;
    protected Store store = null;
    protected GPacketHandler[] handlers;
    protected GPacketHandler unknownPacketHandler;
    protected boolean flowStopped = false;

    public RaptorProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Initializing RaptorProtocol");
        }
        this.eventLogWaiters = Collections.synchronizedMap(new LinkedHashMap());
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
        this.cbDispatcher = new CallbackDispatcher(messageBusCallback);
        this.store = Globals.getStore();
        this.resTable = new HashMap();
        this.r = new Random();
        this.brokerList = new HashMap();
        this.cfgSrvWaitObject = new Object();
        this.initHandlers();
        String string = Globals.getConfig().getProperty("imq.cluster.masterbroker.backup");
        String string2 = Globals.getConfig().getProperty("imq.cluster.masterbroker.restore");
        if (string != null) {
            this.configServerBackup(string);
        }
        if (string2 != null) {
            this.configServerRestore(string2);
        }
    }

    private void addHandler(int n, GPacketHandler gPacketHandler) {
        if (n > 36) {
            throw new ArrayIndexOutOfBoundsException("Bad ProtocolHandler");
        }
        this.handlers[n] = gPacketHandler;
    }

    private void initHandlers() {
        if (DEBUG) {
            logger.log(4, "Initializing RaptorProtocol handlers");
        }
        this.handlers = new GPacketHandler[37];
        GPacketHandler gPacketHandler = new MessageDataHandler(this);
        this.addHandler(1, gPacketHandler);
        this.addHandler(2, gPacketHandler);
        gPacketHandler = new MessageAckHandler(this);
        this.addHandler(3, gPacketHandler);
        this.addHandler(4, gPacketHandler);
        gPacketHandler = new NewInterestHandler(this);
        this.addHandler(5, gPacketHandler);
        this.addHandler(6, gPacketHandler);
        this.addHandler(35, gPacketHandler);
        this.addHandler(36, gPacketHandler);
        gPacketHandler = new RemDurableHandler(this);
        this.addHandler(7, gPacketHandler);
        this.addHandler(8, gPacketHandler);
        gPacketHandler = new InterestUpdateHandler(this);
        this.addHandler(9, gPacketHandler);
        this.addHandler(10, gPacketHandler);
        gPacketHandler = new LockHandler(this);
        this.addHandler(11, gPacketHandler);
        this.addHandler(12, gPacketHandler);
        gPacketHandler = new DestinationUpdateHandler(this);
        this.addHandler(13, gPacketHandler);
        this.addHandler(14, gPacketHandler);
        this.addHandler(15, gPacketHandler);
        this.addHandler(16, gPacketHandler);
        gPacketHandler = new ConfigChangeEventHandler(this);
        this.addHandler(17, gPacketHandler);
        this.addHandler(18, gPacketHandler);
        gPacketHandler = new GetConfigChangesHandler(this);
        this.addHandler(19, gPacketHandler);
        this.addHandler(20, gPacketHandler);
        gPacketHandler = new ClientClosedHandler(this);
        this.addHandler(21, gPacketHandler);
        this.addHandler(22, gPacketHandler);
        gPacketHandler = new ClusterFlowControlHandler(this);
        this.addHandler(23, gPacketHandler);
        this.addHandler(24, gPacketHandler);
        this.addHandler(25, gPacketHandler);
        this.addHandler(26, gPacketHandler);
        gPacketHandler = new ReloadClusterHandler(this);
        this.addHandler(27, gPacketHandler);
        this.addHandler(28, gPacketHandler);
        gPacketHandler = new GetInterestUpdateHandler(this);
        this.addHandler(29, gPacketHandler);
        this.addHandler(30, gPacketHandler);
        gPacketHandler = new PingHandler(this);
        this.addHandler(33, gPacketHandler);
        this.addHandler(34, gPacketHandler);
        this.unknownPacketHandler = new UnknownPacketHandler(this);
    }

    public int getClusterVersion() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.getClusterVersion : 300");
        }
        return 300;
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveUnicast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 36) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            logger.log(2, "RaptorProtocol.receiveBroadcast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 36) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void handleGPacket(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        this.handlers[gPacket.getType()].handle(messageBusCallback, brokerAddress, gPacket);
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) {
        logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public BrokerInfo getBrokerInfo() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.getBrokerInfo");
        }
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerAddr(this.selfAddress);
        brokerInfo.setStartTime(this.startTime);
        brokerInfo.setStoreDirtyFlag(this.storeDirtyFlag);
        brokerInfo.setClusterProtocolVersion(new Integer(350));
        return brokerInfo;
    }

    public void setMatchProps(Properties properties) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.setMatchProps :\n" + properties);
        }
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.startClusterIO");
        }
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null) {
                this.configSyncComplete = true;
                if (DEBUG) {
                    logger.log(4, "No master broker. configSyncComplete=true");
                }
            } else if (brokerAddress.equals(this.selfAddress)) {
                this.initConfigServer();
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest(this.selfAddress, l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopClusterIO() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopClusterIO");
        }
    }

    public void shutdown() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.shutdown");
        }
        this.cbDispatcher.shutdown();
    }

    private void initConfigServer() {
        this.isMasterBroker = true;
        logger.log(8, "B1069");
        try {
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray[1];
            if (arrayList.size() == 0) {
                logger.log(8, "B1068");
                byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Master broker initialization failed.", (Throwable)exception);
        }
    }

    public void reloadCluster() {
        logger.log(8, "B1074");
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)27);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.c.reloadCluster();
    }

    public void stopMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = true;
        this.sendFlowControlUpdate(null);
    }

    public void resumeMessageFlow() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = false;
        this.sendFlowControlUpdate(null);
    }

    private void sendFlowControlUpdate(BrokerAddress brokerAddress) {
        GPacket gPacket = GPacket.getInstance();
        if (this.flowStopped) {
            gPacket.setType((short)23);
        } else {
            gPacket.setType((short)25);
        }
        try {
            if (brokerAddress == null) {
                this.c.broadcast(gPacket);
            } else {
                this.c.unicast(brokerAddress, gPacket);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        return !this.configSyncComplete;
    }

    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        Cloneable cloneable;
        Object object;
        Object object2;
        HashMap<Object, Cloneable> hashMap = new HashMap<Object, Cloneable>();
        if (DEBUG) {
            logger.log(2, "MessageBus: sending message {0} to {1} targets.", (Object)packetReference.getSysMessageID(), Integer.toString(collection.size()));
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object2 = (Consumer)iterator.next();
            object = ((Consumer)object2).getConsumerUID().getBrokerAddress();
            cloneable = (ArrayList)hashMap.get(object);
            if (cloneable == null) {
                cloneable = new ArrayList();
                hashMap.put(object, cloneable);
            }
            ((ArrayList)cloneable).add(object2);
            stringBuffer.append("\t").append(((Consumer)object2).toString()).append("\n");
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Local Targets = {0}", stringBuffer);
        }
        object2 = null;
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            cloneable = (BrokerAddress)object.next();
            ArrayList arrayList = (ArrayList)hashMap.get(cloneable);
            GPacket gPacket = GPacket.getInstance();
            gPacket.setType((short)1);
            gPacket.putProp("D", new Boolean(bl));
            gPacket.putProp("C", new Integer(arrayList.size()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            stringBuffer = new StringBuffer("\n");
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)arrayList.get(i)).getConsumerUID();
                    ConsumerUID consumerUID2 = ((Consumer)arrayList.get(i)).getStoredConsumerUID();
                    try {
                        packetReference.delivered(consumerUID, consumerUID2, consumerUID.isUnsafeAck(), true);
                    }
                    catch (Exception exception) {
                        logger.logStack(16, "B3100", "saving redeliver flag for " + packetReference.getSysMessageID() + " to " + consumerUID, (Throwable)exception);
                    }
                    RaptorProtocol.writeConsumerUID(consumerUID, dataOutputStream);
                    if (!DEBUG) continue;
                    stringBuffer.append("\t").append(consumerUID).append("\n");
                }
                if (object2 == null) {
                    object2 = packetReference.getPacket();
                }
                ((Packet)object2).generateTimestamp(false);
                ((Packet)object2).generateSequenceNumber(false);
                ((Packet)object2).writePacket(dataOutputStream);
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                logger.logStack(16, "Exception writing packet ", exception);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            gPacket.setPayload(ByteBuffer.wrap(byArray));
            try {
                this.c.unicast((BrokerAddress)cloneable, gPacket, true);
                if (!DEBUG) continue;
                logger.log(1, "MessageBus: Broker {0} Targets = {1}", (Object)cloneable, stringBuffer);
            }
            catch (IOException iOException) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)arrayList.get(i)).getConsumerUID();
                    this.cb.processRemoteAck(packetReference.getSysMessageID(), consumerUID, 2);
                }
                if (!DEBUG) continue;
                logger.log(1, "RaptorProtocol: Could not deliver message to broker {0}", cloneable);
            }
        }
    }

    public void sendMessageAck(BrokerAddress brokerAddress, PacketReference packetReference, ConsumerUID consumerUID, int n) {
        Object object;
        if (DEBUG) {
            object = new StringBuffer();
            ((StringBuffer)object).append("\n\tackType = ").append(n);
            ((StringBuffer)object).append("\n\tSysMessageID = ");
            ((StringBuffer)object).append(packetReference.getSysMessageID());
            ((StringBuffer)object).append("\n\tConsumerUID = ").append(consumerUID);
            ((StringBuffer)object).append("\n\tMessageHome = ").append(brokerAddress);
            ((StringBuffer)object).append("\n\tMy Adderss = ").append(this.selfAddress);
            ((StringBuffer)object).append("\n");
            logger.log(1, "MessageBus: Sending message acknowledgement : {0}", object);
        }
        object = GPacket.getInstance();
        ((GPacket)object).setType((short)3);
        ((GPacket)object).putProp("T", new Integer(n));
        SysMessageID sysMessageID = packetReference.getSysMessageID();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            sysMessageID.writeID(dataOutputStream);
            RaptorProtocol.writeConsumerUID(consumerUID, dataOutputStream);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ((GPacket)object).setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, (GPacket)object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] prepareResetPersistenceRecord() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareResetPersistenceRecord");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)31);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static GPacket prepareNewInterestUpdate(Collection collection) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareNewInterestUpdate");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)5);
        gPacket.putProp("C", new Integer(collection.size()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = collection.iterator();
            while (object.hasNext()) {
                Consumer consumer = (Consumer)object.next();
                RaptorProtocol.writeConsumer(consumer, dataOutputStream);
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap((byte[])object));
        return gPacket;
    }

    private void sendNewInterestUpdate(Consumer consumer) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewInterestUpdate : " + consumer.toString());
        }
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        GPacket gPacket = RaptorProtocol.prepareNewInterestUpdate(hashSet);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendNewInterestUpdate(BrokerAddress brokerAddress, Collection collection) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewInterestUpdate to " + brokerAddress);
        }
        GPacket gPacket = RaptorProtocol.prepareNewInterestUpdate(collection);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendAttachDurable(String string, String string2, Consumer consumer) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendAttachDurable : " + string + ":" + string2 + " --- " + consumer);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)35);
        if (string != null) {
            gPacket.putProp("N", new String(string));
        }
        gPacket.putProp("I", new String(string2));
        gPacket.putProp("allowsNonDurable", new Boolean(true));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            RaptorProtocol.writeConsumer(consumer, dataOutputStream);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static GPacket prepareRemDurableUpdate(Consumer consumer) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareRemDurableUpdate");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)7);
        gPacket.putProp("C", new Integer(1));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = null;
            object = consumer instanceof Subscription ? (Object)((Subscription)consumer) : (Object)consumer.getSubscription();
            dataOutputStream.writeUTF(((Subscription)object).getDurableName());
            dataOutputStream.writeUTF(((Subscription)object).getClientID());
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap((byte[])object));
        return gPacket;
    }

    private void sendRemDurableUpdate(Consumer consumer) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendRemDurableUpdate : " + consumer);
        }
        GPacket gPacket = RaptorProtocol.prepareRemDurableUpdate(consumer);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private GPacket prepareInterestUpdate(Collection collection, int n) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareInterestUpdate. Type = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)9);
        gPacket.putProp("T", new Integer(n));
        gPacket.putProp("C", new Integer(collection.size()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            object = collection.iterator();
            while (object.hasNext()) {
                Consumer consumer = (Consumer)object.next();
                RaptorProtocol.writeConsumerUID(consumer.getConsumerUID(), dataOutputStream);
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap((byte[])object));
        return gPacket;
    }

    public void sendInterestUpdate(Consumer consumer, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendInterestUpdate. interest = " + consumer);
        }
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        hashSet.add(consumer);
        GPacket gPacket = this.prepareInterestUpdate(hashSet, n);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendInterestUpdate(BrokerAddress brokerAddress, Collection collection, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendInterestUpdate. to = " + brokerAddress);
        }
        GPacket gPacket = this.prepareInterestUpdate(collection, n);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendClientClosedUpdate(ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendClientClosedUpdate. conid = " + connectionUID);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)21);
        gPacket.putProp("I", new Long(connectionUID.longValue()));
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        Object object;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.clientClosed. conid = " + connectionUID);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            object = this.resTable.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                if (!connectionUID.equals(resource.getOwner())) continue;
                arrayList.add(string);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            this.unlockResource((String)object);
        }
        if (bl) {
            this.sendClientClosedUpdate(connectionUID);
            this.cbDispatcher.clientDown(connectionUID);
        }
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID, true);
    }

    public int lockResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", timestamp = " + l + ", owner = " + connectionUID);
        }
        return this.lockResource(string, l, connectionUID, false);
    }

    private int lockResource(String string, long l, ConnectionUID connectionUID, boolean bl) {
        int n = 1;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.tryLockResource(string, l, connectionUID, bl)) == 0 || n3 == 1) {
                if (DEBUG) {
                    logger.log(4, "Lock resId = " + string + "returned : " + n3);
                }
                return n3;
            }
            if (++n2 == 10) break;
            int n4 = this.r.nextInt(n *= 2);
            try {
                Thread.sleep(n4 * 1000);
            }
            catch (Exception exception) {}
        }
        logger.log(16, "B2034", string);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryLockResource(String string, long l, ConnectionUID connectionUID, boolean bl) {
        Resource resource;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.tryLockResource.resId = " + string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
            if (resource != null) {
                if (bl && resource.getShared()) {
                    return 0;
                }
                return 1;
            }
            resource = new Resource(string);
            resource.setShared(bl);
            resource.setOwner(connectionUID);
            if (l != 0L) {
                resource.setTimestamp(l);
            }
            this.resTable.put(string, resource);
        }
        resource.setLockState(0);
        block15: while (true) {
            if (DEBUG) {
                logger.log(4, "MessageBus: Trying to lock resource {0}", string);
            }
            int n = 0;
            if (this.brokerList.size() > 0) {
                this.sendLockRequest(resource);
                n = resource.waitForStatusChange(this.lockTimeout);
            } else {
                n = 0;
            }
            if (DEBUG) {
                logger.log(4, "MessageBus: Lock attempt status = {0} for resource {1}", (Object)Integer.toString(n), string);
            }
            switch (n) {
                case 0: {
                    resource.setLockState(1);
                    return n;
                }
                case 1: 
                case 2: {
                    HashMap hashMap2 = this.resTable;
                    synchronized (hashMap2) {
                        this.resTable.remove(string);
                    }
                    return n;
                }
                case -1: {
                    logger.log(16, "B2062", (Object)resource.getResId(), resource.showRecipients());
                    HashMap hashMap3 = this.resTable;
                    synchronized (hashMap3) {
                        this.resTable.remove(string);
                    }
                    return 1;
                }
                case 3: {
                    if (!DEBUG_CLUSTER_ALL && !DEBUG_CLUSTER_LOCK) continue block15;
                    logger.log(4, "Active brokerlist changed. Restarting Lock election for {0}." + resource.getResId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResource(String string) {
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            logger.log(4, "MessageBus: Unlocking resource = {0}", string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Resource resource = (Resource)this.resTable.remove(string);
            if (resource != null) {
                resource.impliedFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLockRequest(Resource resource) {
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendLockRequest");
        }
        long l = System.currentTimeMillis();
        BrokerAddress[] brokerAddressArray = null;
        Object object = this.brokerList;
        synchronized (object) {
            brokerAddressArray = new BrokerAddress[this.brokerList.size()];
            n = 0;
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BrokerInfo brokerInfo = (BrokerInfo)iterator.next();
                brokerAddressArray[n++] = brokerInfo.getBrokerAddr();
            }
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            object = "";
            for (n = 0; n < brokerAddressArray.length; ++n) {
                object = (String)object + "\n\t" + brokerAddressArray[n];
            }
            logger.log(4, "Sending resource lock request for : " + resource.getResId() + "\nExpecting responses from : " + (String)object);
        }
        resource.prepareLockRequest(brokerAddressArray, l);
        object = GPacket.getInstance();
        ((GPacket)object).setType((short)11);
        ((GPacket)object).putProp("I", new String(resource.getResId()));
        ((GPacket)object).putProp("TS", new Long(resource.getTimestamp()));
        ((GPacket)object).putProp("X", new Long(l));
        ((GPacket)object).putProp("SH", new Boolean(resource.getShared()));
        try {
            this.c.broadcast((GPacket)object);
        }
        catch (Exception exception) {
            logger.log(8, "Unexpected protocol exception broadcasing msgs", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockRequest(BrokerAddress brokerAddress, String string, long l, long l2, boolean bl) {
        int n;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveLockRequest. resId = " + string + ", xid = " + l2);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null || bl && resource.getShared()) {
            n = 0;
        } else if (resource.getLockState() == 1) {
            n = 1;
        } else if (l < resource.getTimestamp()) {
            resource.impliedFailure();
            n = 0;
        } else {
            n = l > resource.getTimestamp() ? 1 : 2;
        }
        this.sendLockResponse(brokerAddress, string, l2, n);
    }

    private void sendLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendLockResponse. resId = " + string + ", xid = " + l + "to = " + brokerAddress + ", response = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)12);
        gPacket.putProp("I", new String(string));
        gPacket.putProp("X", new Long(l));
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            logger.log(16, br.getString("B2101", string, brokerAddress.toString()), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveLockResponse. resId = " + string + ", xid = " + l + "from = " + brokerAddress + ", response = " + n);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null) {
            return;
        }
        if ((DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) && resource.getXid() == l) {
            logger.log(4, "Received Lock Response.\n\tSender = " + brokerAddress + "\n\tResource = " + resource.getResId() + "\n\tResponse = " + ProtocolGlobals.lockResponseStrings[n]);
        }
        resource.consumeResponse(l, brokerAddress, n);
    }

    public int recordAddDurableEvent(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordAddDurableEvent");
        }
        HashSet<Subscription> hashSet = new HashSet<Subscription>();
        hashSet.add(subscription);
        GPacket gPacket = RaptorProtocol.prepareNewInterestUpdate(hashSet);
        gPacket.putProp("N", new String(subscription.getDurableName()));
        gPacket.putProp("I", new String(subscription.getClientID()));
        return this.recordConfigChangeEvent(gPacket);
    }

    public int recordRemDurableEvent(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordRemDurableEvent");
        }
        GPacket gPacket = RaptorProtocol.prepareRemDurableUpdate(subscription);
        gPacket.putProp("N", new String(subscription.getDurableName()));
        gPacket.putProp("I", new String(subscription.getClientID()));
        return this.recordConfigChangeEvent(gPacket);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordUpdateDestination");
        }
        String string = destination.getDestinationName();
        int n = destination.getType();
        HashMap hashMap = destination.getDestinationProperties();
        GPacket gPacket = RaptorProtocol.prepareUpdateDestination(string, n, hashMap);
        this.recordConfigChangeEvent(gPacket);
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordRemoveDestination");
        }
        String string = destination.getDestinationName();
        int n = destination.getType();
        GPacket gPacket = RaptorProtocol.prepareRemDestination(string, n);
        this.recordConfigChangeEvent(gPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordConfigChangeEvent(GPacket gPacket) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.recordConfigChangeEvent");
        }
        gPacket.putProp("M", new Boolean(true));
        if (DEBUG) {
            logger.log(1, "Event = " + gPacket.toLongString());
        }
        if (this.c.getConfigServer() == null) {
            return 2;
        }
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        EventLogWaiter eventLogWaiter = new EventLogWaiter(0);
        this.eventLogWaiters.put(l, eventLogWaiter);
        try {
            EventLogWaiter eventLogWaiter2 = eventLogWaiter;
            synchronized (eventLogWaiter2) {
                this.sendConfigChangeEvent(l, gPacket);
                while (eventLogWaiter.getStatus() == 0) {
                    try {
                        eventLogWaiter.wait();
                    }
                    catch (Exception exception) {}
                }
                if (eventLogWaiter.getStatus() == 1) {
                    this.storeDirtyFlag = true;
                }
                return eventLogWaiter.getStatus();
            }
        }
        catch (BrokerException brokerException) {
            this.eventLogWaiters.remove(l);
            if (DEBUG) {
                logger.logStack(16, brokerException.getMessage() + ": " + gPacket.toLongString(), brokerException);
            }
            throw brokerException;
        }
    }

    private void sendConfigChangeEvent(long l, GPacket gPacket) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangeEvent. xid = " + l);
        }
        BrokerAddress brokerAddress = this.c.getConfigServer();
        GPacket gPacket2 = GPacket.getInstance();
        gPacket2.setType((short)17);
        gPacket2.putProp("X", new Long(l));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket2.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket2);
        }
        catch (Exception exception) {
            throw new BrokerException(br.getKString("B4094"), "B4094", null, 403);
        }
    }

    public void receiveConfigChangeEvent(BrokerAddress brokerAddress, Long l, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangeEvent. xid = " + l);
        }
        try {
            this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            this.sendConfigChangeEventAck(brokerAddress, l, 1);
        }
        catch (Exception exception) {
            this.sendConfigChangeEventAck(brokerAddress, l, 2);
            return;
        }
    }

    private void sendConfigChangeEventAck(BrokerAddress brokerAddress, Long l, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangeEventAck. xid = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)18);
        gPacket.putProp("X", l);
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEventReply(BrokerAddress brokerAddress, long l, int n) {
        Long l2;
        EventLogWaiter eventLogWaiter;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangeEventAck. xid = " + l);
        }
        if ((eventLogWaiter = (EventLogWaiter)this.eventLogWaiters.remove(l2 = new Long(l))) == null) {
            Object[] objectArray = new String[]{String.valueOf(l), String.valueOf(n)};
            logger.log(16, "B2107", objectArray);
            return;
        }
        EventLogWaiter eventLogWaiter2 = eventLogWaiter;
        synchronized (eventLogWaiter2) {
            eventLogWaiter.setStatus(n);
            eventLogWaiter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangesRequest. timestamp = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)19);
        gPacket.putProp("TS", new Long(l));
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            try {
                this.c.unicast(brokerAddress, gPacket);
                ++this.cfgSrvRequestCount;
                this.cfgSrvRequestErr = false;
            }
            catch (Exception exception) {
                this.cfgSrvRequestCount = 0;
                this.cfgSrvRequestErr = true;
                this.cfgSrvWaitObject.notifyAll();
            }
        }
    }

    public void receiveConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangesRequest. from = " + brokerAddress);
        }
        try {
            ArrayList arrayList = this.store.getConfigChangeRecordsSince(l);
            long l2 = System.currentTimeMillis();
            this.sendConfigChangesResponse(brokerAddress, l2, arrayList);
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Could not send config change response..", (Throwable)exception);
            return;
        }
    }

    private void sendConfigChangesResponse(BrokerAddress brokerAddress, long l, ArrayList arrayList) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendConfigChangesResponse. to = " + brokerAddress);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)20);
        gPacket.putProp("TS", new Long(l));
        gPacket.putProp("C", new Integer(arrayList.size()));
        gPacket.putProp("S", new Integer(200));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangesReply(BrokerAddress brokerAddress, long l, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.receiveConfigChangesResponse.");
        }
        boolean bl = false;
        BrokerAddress brokerAddress2 = this.getLastConfigServer();
        if (brokerAddress2 != null && !brokerAddress2.equals(brokerAddress)) {
            bl = true;
            if (n == 0) {
                logger.log(32, "B3095");
                System.exit(1);
            }
        }
        DataInputStream dataInputStream = null;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
        }
        try {
            boolean bl2 = false;
            ArrayList<GPacket> arrayList = null;
            for (int i = 0; i < n; ++i) {
                GPacket gPacket = GPacket.getInstance();
                gPacket.read(dataInputStream);
                if (i == 0) {
                    if (gPacket.getType() == 31) {
                        bl2 = true;
                        arrayList = new ArrayList<GPacket>();
                    }
                    if (bl && !bl2) {
                        logger.log(32, "B3095");
                        System.exit(1);
                    }
                }
                if (bl2) {
                    arrayList.add(gPacket);
                    continue;
                }
                this.receiveBroadcast(brokerAddress, gPacket);
            }
            if (bl2) {
                this.applyPersistentStateChanges(brokerAddress, arrayList);
            }
            if (!this.configSyncComplete) {
                this.configSyncComplete = true;
                this.cbDispatcher.configSyncComplete();
                this.sendGetInterestUpdate(brokerAddress);
                logger.log(8, "B1075");
            }
            Object object = this.cfgSrvWaitObject;
            synchronized (object) {
                --this.cfgSrvRequestCount;
                if (this.cfgSrvRequestCount == 0) {
                    this.cfgSrvWaitObject.notifyAll();
                }
            }
            this.storeLastRefreshTime(l - 120000L);
            this.storeLastConfigServer(brokerAddress);
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Error while applying the config changes...", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitConfigChangesResponse() {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.waitConfigChangesResponse.");
        }
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            while (this.cfgSrvRequestCount > 0) {
                try {
                    this.cfgSrvWaitObject.wait();
                }
                catch (Exception exception) {}
            }
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.waitConfigChangesResponse returning :" + !this.cfgSrvRequestErr);
            }
            return !this.cfgSrvRequestErr;
        }
    }

    private void applyPersistentStateChanges(BrokerAddress brokerAddress, ArrayList arrayList) throws Exception {
        String string;
        Object object;
        Serializable serializable;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.applyPersistentStateChanges.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<DestinationUID, Serializable> hashMap2 = new HashMap<DestinationUID, Serializable>();
        Set set = Subscription.getAllSubscriptions(null);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (Subscription)iterator.next();
            object = ((Consumer)serializable).getConsumerUID();
            string = ((Subscription)serializable).getDurableName() + ":" + ((Subscription)serializable).getClientID();
            hashMap.put(string, object);
        }
        set = null;
        iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            serializable = (Destination)iterator.next();
            if (((Destination)serializable).isAutoCreated() || ((Destination)serializable).isInternal() || ((Destination)serializable).isTemporary() || ((Destination)serializable).isDMQ()) continue;
            hashMap2.put(((Destination)serializable).getDestinationUID(), serializable);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (GPacket)arrayList.get(i);
            if (((GPacket)object).getType() == 31) {
                if (!DEBUG) continue;
                logger.log(4, "applyPersistentStateChanges : RESET_PERSISTENCE");
                continue;
            }
            if (((GPacket)object).getType() == 5 || ((GPacket)object).getType() == 7) {
                this.receiveBroadcast(brokerAddress, (GPacket)object);
                string = (String)((GPacket)object).getProp("N") + ":" + (String)((GPacket)object).getProp("I");
                hashMap.remove(string);
                if (!DEBUG) continue;
                if (((GPacket)object).getType() == 5) {
                    logger.log(4, "Added subscription : " + string);
                    continue;
                }
                logger.log(4, "Remove subscription : " + string);
                continue;
            }
            if (((GPacket)object).getType() != 13 && ((GPacket)object).getType() != 15) continue;
            string = (String)((GPacket)object).getProp("N");
            int n = (Integer)((GPacket)object).getProp("DT");
            DestinationUID destinationUID = DestinationUID.getUID(string, DestType.isQueue(n));
            Destination destination = (Destination)hashMap2.get(destinationUID);
            if (((GPacket)object).getType() == 13 && destination != null && destination.getType() != n) {
                DestinationUID destinationUID2 = DestinationUID.getUID(destination.getDestinationName(), DestType.isQueue(destination.getType()));
                this.cbDispatcher.notifyDestroyDestination(destinationUID2);
            }
            this.receiveBroadcast(brokerAddress, (GPacket)object);
            hashMap2.remove(destinationUID);
            if (!DEBUG) continue;
            if (((GPacket)object).getType() == 13) {
                logger.log(4, "Updated destination : " + destinationUID);
                continue;
            }
            logger.log(4, "Removed destination : " + destinationUID);
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            object = Consumer.getConsumer(consumerUID);
            if (object == null) continue;
            this.cbDispatcher.interestRemoved((Consumer)object);
            if (!DEBUG) continue;
            logger.log(4, "Removed stale subscription : " + object);
        }
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            DestinationUID destinationUID = (DestinationUID)iterator.next();
            this.cbDispatcher.notifyDestroyDestination(destinationUID);
            if (!DEBUG) continue;
            logger.log(4, "Removed stale destination : " + destinationUID);
        }
    }

    private static GPacket prepareUpdateDestination(String string, int n, Map map) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareUpdateDestination. name = " + string + ", type = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)13);
        gPacket.putProp("N", string);
        gPacket.putProp("DT", new Integer(n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PacketProperties.write(map, byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        return gPacket;
    }

    private void sendUpdateDestination(String string, int n, Map hashMap) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Broadcasting G_UPDATE_DESTINATION. Name = {0}, Type = {1}", (Object)string, DestType.toString(n));
        }
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        GPacket gPacket = RaptorProtocol.prepareUpdateDestination(string, n, hashMap);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static GPacket prepareRemDestination(String string, int n) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.prepareRemDestination. name = " + string + ", type = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)15);
        gPacket.putProp("N", string);
        gPacket.putProp("DT", new Integer(n));
        return gPacket;
    }

    private void sendRemDestination(String string, int n) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Broadcasting G_REM_DESTINATION. Name = {0}, Type = {1}", (Object)string, DestType.toString(n));
        }
        GPacket gPacket = RaptorProtocol.prepareRemDestination(string, n);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + destination);
        }
        this.sendUpdateDestination(destination.getDestinationName(), destination.getType(), destination.getDestinationProperties());
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending Update Destination " + destination);
        }
        this.sendUpdateDestination(destination.getDestinationName(), destination.getType(), destination.getDestinationProperties());
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "Sending New Destination " + destination);
        }
        this.sendRemDestination(destination.getDestinationName(), destination.getType());
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        this.recordAddDurableEvent(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        this.recordRemDurableEvent(subscription);
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewSubscription");
        }
        this.sendNewInterestUpdate(subscription);
        this.sendAttachDurable(subscription.getDurableName(), subscription.getClientID(), consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendNewConsumer");
        }
        this.sendNewInterestUpdate(consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendRemovedConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendRemovedConsumer");
        }
        if (consumer instanceof Subscription) {
            this.sendRemDurableUpdate(consumer);
        } else if (consumer.getSubscription() != null) {
            this.sendInterestUpdate(consumer, 3);
        } else {
            this.sendInterestUpdate(consumer, 2);
        }
    }

    public void sendActivateConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendActivateConsumer");
        }
        this.sendInterestUpdate(consumer, 4);
    }

    private void sendGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.sendGetInterestUpdate");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)29);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "MessageBus: Received request for a full interest update from {0}.", brokerAddress);
        }
        this.forwardLocalInterests(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addBrokerInfo(BrokerInfo brokerInfo) {
        long l;
        BrokerInfo brokerInfo2;
        Cloneable cloneable;
        block20: {
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.addBrokerInfo : " + brokerInfo);
            }
            cloneable = this.brokerList;
            synchronized (cloneable) {
                brokerInfo2 = this.brokerList.put(brokerInfo.getBrokerAddr(), brokerInfo);
            }
            try {
                if (brokerInfo.getClusterProtocolVersion() == null) {
                    logger.log(16, "B2086", brokerInfo.getBrokerAddr());
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.configSyncComplete) {
                try {
                    cloneable = this.c.getConfigServer();
                    if (cloneable != null && ((BrokerAddress)cloneable).equals(brokerInfo.getBrokerAddr())) {
                        l = -1L;
                        l = this.getLastRefreshTime();
                        this.sendConfigChangesRequest((BrokerAddress)cloneable, l);
                        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
                            logger.log(8, "B1070");
                        }
                        break block20;
                    }
                    if (DEBUG) {
                        logger.log(4, "Config sync not complete. Rejecting addBrokerInfo : " + brokerInfo);
                    }
                    return 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (brokerInfo2 == null) {
            if (DEBUG) {
                logger.log(4, "MessageBus: New Broker : {0}", brokerInfo);
            }
            try {
                cloneable = this.c.getConfigServer();
                if (brokerInfo.getStoreDirtyFlag() && cloneable != null && !((BrokerAddress)cloneable).equals(brokerInfo.getBrokerAddr())) {
                    l = -1L;
                    l = this.getLastRefreshTime();
                    this.sendConfigChangesRequest((BrokerAddress)cloneable, l);
                    if (!this.waitConfigChangesResponse()) {
                        return 2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.flowStopped) {
                this.sendFlowControlUpdate(brokerInfo.getBrokerAddr());
            }
            this.forwardLocalInterests(brokerInfo.getBrokerAddr());
            this.restartElections(brokerInfo.getBrokerAddr());
            logger.log(64, "B1071", brokerInfo.getBrokerAddr().toString());
        }
        this.updateActivelistProperty();
        return 0;
    }

    private void forwardLocalInterests(BrokerAddress brokerAddress) {
        Serializable serializable;
        Consumer consumer;
        Serializable serializable2;
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.forwardLocalInterests to : " + brokerAddress);
        }
        Iterator iterator = Destination.getTempDestinations(this.selfAddress);
        while (iterator.hasNext()) {
            serializable2 = (Destination)iterator.next();
            this.sendUpdateDestination(((Destination)serializable2).getDestinationName(), ((Destination)serializable2).getType(), ((Destination)serializable2).getDestinationProperties());
        }
        serializable2 = new HashSet();
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        HashSet<Consumer> hashSet2 = new HashSet<Consumer>();
        HashSet<Subscription> hashSet3 = new HashSet<Subscription>();
        iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            consumer = (Consumer)iterator.next();
            serializable = consumer.getDestination();
            if (((Destination)serializable).getIsLocal() || consumer instanceof Subscription) continue;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (this.selfAddress == consumerUID.getBrokerAddress()) {
                if (consumer.getSubscription() != null) {
                    Subscription subscription = consumer.getSubscription();
                    hashSet2.add(consumer);
                    if (!consumer.getSubscription().isDurable()) {
                        hashSet3.add(subscription);
                    } else {
                        hashSet3.add(subscription);
                    }
                } else {
                    serializable2.add(consumer);
                }
            }
            if (!consumer.getIsActiveConsumer() || serializable == null || ((Destination)serializable).getMaxActiveConsumers() != 1) continue;
            hashSet.add(consumer);
        }
        if (!hashSet2.isEmpty()) {
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                this.sendNewInterestUpdate(consumer);
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                serializable = consumer.getSubscription();
                this.sendAttachDurable(((Subscription)serializable).getDurableName(), ((Subscription)serializable).getClientID(), consumer);
            }
        }
        if (!serializable2.isEmpty()) {
            this.sendNewInterestUpdate(brokerAddress, (Collection)((Object)serializable2));
        }
        if (!hashSet.isEmpty()) {
            this.sendInterestUpdate(brokerAddress, hashSet, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartElections(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.restartElections. broker : " + brokerAddress);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set set = this.resTable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                resource.brokerAdded(brokerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBrokerInfo(BrokerAddress brokerAddress) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Serializable serializable;
        block23: {
            BrokerInfo brokerInfo;
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.removeBrokerInfo. broker : " + brokerAddress);
            }
            serializable = this.brokerList;
            synchronized (serializable) {
                brokerInfo = (BrokerInfo)this.brokerList.remove(brokerAddress);
            }
            if (DEBUG) {
                logger.log(4, "MessageBus: Broker down : {0}", brokerInfo);
            }
            try {
                if (!this.c.getConfigServer().equals(brokerAddress)) break block23;
                serializable = null;
                object4 = null;
                object3 = this.eventLogWaiters.keySet();
                object2 = this.eventLogWaiters;
                synchronized (object2) {
                    object = object3.iterator();
                    while (object.hasNext()) {
                        serializable = (Long)object.next();
                        object4 = (EventLogWaiter)this.eventLogWaiters.get(serializable);
                        object.remove();
                        Object object5 = object4;
                        synchronized (object5) {
                            if (((EventLogWaiter)object4).getStatus() == 0) {
                                ((EventLogWaiter)object4).setStatus(2);
                            }
                            object4.notify();
                        }
                    }
                }
                object2 = this.cfgSrvWaitObject;
                synchronized (object2) {
                    if (this.cfgSrvRequestCount > 0) {
                        this.cfgSrvRequestCount = 0;
                        this.cfgSrvRequestErr = true;
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.log(64, "B1072", brokerAddress.toString());
        this.cbDispatcher.brokerDown(brokerAddress);
        serializable = this.resTable;
        synchronized (serializable) {
            object4 = this.resTable.keySet();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (Resource)this.resTable.get(object2);
                ((Resource)object).brokerRemoved(brokerAddress);
            }
        }
        this.updateActivelistProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateActivelistProperty() {
        Object object;
        Object object2;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add(this.selfAddress.toString());
        Object object3 = this.brokerList;
        synchronized (object3) {
            object2 = this.brokerList.values();
            object = object2.iterator();
            while (object.hasNext()) {
                BrokerInfo brokerInfo = (BrokerInfo)object.next();
                treeSet.add(brokerInfo.getBrokerAddr().toString());
            }
        }
        object3 = null;
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            if (object3 == null) {
                object3 = (String)object2.next();
                continue;
            }
            object3 = (String)object3 + ", " + (String)object2.next();
        }
        object = Globals.getConfig();
        ((UpdateProperties)object).putOne("imq.cluster.brokerlist.active", (String)object3);
    }

    private void configServerBackup(String string) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerBackup. fileName : " + string);
        }
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            logger.log(16, "B2054");
            return;
        }
        if (brokerAddress == null || !brokerAddress.equals(this.selfAddress)) {
            logger.log(16, "B2054");
            return;
        }
        try {
            Object object;
            ChangeRecord changeRecord;
            File file = new File(string);
            if (!file.createNewFile()) {
                logger.log(16, "B2055", string);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = (ArrayList)objectArray[1];
            ArrayList<ChangeRecord> arrayList2 = new ArrayList<ChangeRecord>();
            HashMap<String, ChangeRecord> hashMap = new HashMap<String, ChangeRecord>();
            if (DEBUG) {
                logger.log(4, "RaptorProtocol.configServerBackup: Retrieved " + arrayList.size() + " change records");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                changeRecord = ChangeRecord.makeChangeRecord(byArray);
                if (DEBUG) {
                    logger.log(4, "RaptorProtocol.configServerBackup: #" + i + " " + ((ArrayList)objectArray[0]).get(i) + " " + ProtocolGlobals.getPacketTypeString(changeRecord.getOperation()) + " key=" + changeRecord.getUniqueKey());
                }
                arrayList2.add(changeRecord);
                object = (ChangeRecord)hashMap.get(changeRecord.getUniqueKey());
                if (object != null) {
                    ((ChangeRecord)object).discard = true;
                    if (DEBUG) {
                        logger.log(4, ">>>>RaptorProtocol.configServerBackup: discard previous record " + ProtocolGlobals.getPacketTypeString(((ChangeRecord)object).getOperation()) + " key=" + changeRecord.getUniqueKey());
                    }
                }
                if (!changeRecord.isAddOp()) {
                    changeRecord.discard = true;
                    logger.log(4, ">>>>RaptorProtocol.configServerBackup: discard this 'non-add' record ");
                }
                hashMap.put(changeRecord.getUniqueKey(), changeRecord);
            }
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF("imq.cluster.masterbroker.backup");
            byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            for (int i = 0; i < arrayList2.size(); ++i) {
                changeRecord = (ChangeRecord)arrayList2.get(i);
                if (changeRecord.discard) continue;
                object = changeRecord.getBytes();
                dataOutputStream.writeInt(((Object)object).length);
                dataOutputStream.write((byte[])object, 0, ((Object)object).length);
            }
            dataOutputStream.writeInt(0);
        }
        catch (Exception exception) {
            logger.logStack(16, "B2056", exception);
        }
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerBackup complete.");
        }
    }

    private void configServerRestore(String string) {
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerRestore. fileName = " + string);
        }
        try {
            int n;
            File file = new File(string);
            if (!file.exists()) {
                logger.log(16, "B2057", string);
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n2 = dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            if (!string2.equals("imq.cluster.masterbroker.backup")) {
                logger.log(16, "B2058", string);
                return;
            }
            if (n2 < 350 || n2 > this.version) {
                logger.log(16, "B2059");
                return;
            }
            this.store.clearAllConfigChangeRecords(false);
            while ((n = dataInputStream.readInt()) != 0) {
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            logger.logStack(16, "B2060", exception);
            return;
        }
        if (DEBUG) {
            logger.log(4, "RaptorProtocol.configServerRestore complete.");
        }
    }

    private void storeLastConfigServer(BrokerAddress brokerAddress) throws BrokerException {
        this.store.updateProperty("MessageBus.lastConfigServer", brokerAddress, false);
    }

    private BrokerAddress getLastConfigServer() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = (BrokerAddress)this.store.getProperty("MessageBus.lastConfigServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brokerAddress;
    }

    private void storeLastRefreshTime(long l) throws BrokerException {
        Long l2 = new Long(l);
        this.store.updateProperty("MessageBus.lastRefreshTime", l2, false);
    }

    private long getLastRefreshTime() {
        Long l = null;
        try {
            l = (Long)this.store.getProperty("MessageBus.lastRefreshTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == null) {
            return -1L;
        }
        return l;
    }

    protected static void writeConsumer(Consumer consumer, DataOutputStream dataOutputStream) throws IOException {
        String string = consumer.getDestinationUID().getName();
        ConsumerUID consumerUID = consumer.getConsumerUID();
        String string2 = null;
        String string3 = null;
        String string4 = consumer.getSelectorStr();
        boolean bl = consumer.getNoLocal();
        boolean bl2 = consumer.getDestinationUID().isQueue();
        boolean bl3 = true;
        boolean bl4 = false;
        int n = 1;
        if (consumer instanceof Subscription) {
            Subscription subscription = (Subscription)consumer;
            n = subscription.getMaxNumActiveConsumers();
            bl4 = true;
            string2 = subscription.getDurableName();
            string3 = subscription.getClientID();
            if (!subscription.isActive()) {
                bl3 = false;
            }
        }
        dataOutputStream.writeLong(99353142765567461L);
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeBoolean(consumerUID != null);
        if (consumerUID != null) {
            RaptorProtocol.writeConsumerUID(consumerUID, dataOutputStream);
        }
        dataOutputStream.writeBoolean(string3 != null);
        if (string3 != null) {
            dataOutputStream.writeUTF(string3);
        }
        dataOutputStream.writeBoolean(string2 != null);
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
        dataOutputStream.writeBoolean(string4 != null);
        if (string4 != null) {
            dataOutputStream.writeUTF(string4);
        }
        dataOutputStream.writeBoolean(bl2);
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeBoolean(bl3);
        dataOutputStream.writeBoolean(bl4);
        if (bl4) {
            dataOutputStream.writeInt(n);
        }
    }

    public static void writeConsumerUID(ConsumerUID consumerUID, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeLong(consumerUID.longValue());
        dataOutputStream.writeLong(consumerUID.getConnectionUID() == null ? 0L : consumerUID.getConnectionUID().longValue());
        BrokerAddress brokerAddress = consumerUID.getBrokerAddress();
        if (brokerAddress == null) {
            brokerAddress = Globals.getMyAddress();
        }
        if (brokerAddress == null) {
            try {
                brokerAddress = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        brokerAddress.writeBrokerAddress(dataOutputStream);
    }

    public Consumer readConsumer(DataInputStream dataInputStream) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        ConsumerUID consumerUID = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = dataInputStream.readLong();
        if (l != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + l + " expected " + 99353142765567461L);
        }
        string = dataInputStream.readUTF();
        boolean bl4 = dataInputStream.readBoolean();
        if (bl4) {
            consumerUID = this.readConsumerUID(dataInputStream);
        }
        if (bl3 = dataInputStream.readBoolean()) {
            string2 = dataInputStream.readUTF();
        }
        if (bl2 = dataInputStream.readBoolean()) {
            string3 = dataInputStream.readUTF();
        }
        if (bl = dataInputStream.readBoolean()) {
            string4 = dataInputStream.readUTF();
        }
        boolean bl5 = dataInputStream.readBoolean();
        boolean bl6 = dataInputStream.readBoolean();
        boolean bl7 = dataInputStream.readBoolean();
        boolean bl8 = false;
        int n = 1;
        try {
            bl8 = dataInputStream.readBoolean();
            if (bl8) {
                n = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DestinationUID destinationUID = DestinationUID.getUID(string, bl5);
        try {
            if (string3 != null) {
                Subscription subscription = Subscription.findCreateDurableSubscription(string2, string3, destinationUID, string4, bl6);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            if (bl8) {
                Subscription subscription = Subscription.findCreateNonDurableSubscription(string2, string4, destinationUID, bl6, consumerUID);
                if (subscription != null) {
                    subscription.setMaxNumActiveConsumers(n);
                }
                return subscription;
            }
            Consumer consumer = new Consumer(destinationUID, string4, bl6, consumerUID);
            return consumer;
        }
        catch (SelectorFormatException selectorFormatException) {
            logger.log(8, "Internal Error: Got bad selector[" + string4 + "] ", selectorFormatException);
            throw new IOException("bad selector " + string4);
        }
        catch (BrokerException brokerException) {
            logger.logStack(8, "Internal Error: error creating consumer ", brokerException);
            throw new IOException("error creating consumer ");
        }
    }

    public ConsumerUID readConsumerUID(DataInputStream dataInputStream) throws IOException {
        long l = dataInputStream.readLong();
        ConnectionUID connectionUID = new ConnectionUID(dataInputStream.readLong());
        BrokerAddress brokerAddress = Globals.getMyAddress();
        BrokerAddress brokerAddress2 = (BrokerAddress)brokerAddress.clone();
        brokerAddress2.readBrokerAddress(dataInputStream);
        ConsumerUID consumerUID = new ConsumerUID(l);
        consumerUID.setConnectionUID(connectionUID);
        consumerUID.setBrokerAddress(brokerAddress2);
        return consumerUID;
    }

    protected void writeDestination(Destination destination, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(destination.getDestinationName());
        dataOutputStream.writeInt(destination.getType());
    }

    protected Destination readDestination(DataInputStream dataInputStream) throws IOException, BrokerException {
        int n;
        String string = dataInputStream.readUTF();
        DestinationUID destinationUID = DestinationUID.getUID(string, n = dataInputStream.readInt());
        Destination destination = Destination.getDestination(destinationUID);
        if (destination == null) {
            destination = Destination.createDestination(string, n, !DestType.isTemporary(n), false, this.selfAddress);
            this.cbDispatcher.notifyCreateDestination(destination);
        }
        return destination;
    }

    public boolean getConfigSyncComplete() {
        return this.configSyncComplete;
    }

    private static byte[] getEventData(GPacket gPacket) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] generateAddDurableRecord(Subscription subscription) {
        try {
            HashSet<Subscription> hashSet = new HashSet<Subscription>();
            hashSet.add(subscription);
            GPacket gPacket = RaptorProtocol.prepareNewInterestUpdate(hashSet);
            gPacket.putProp("N", new String(subscription.getDurableName()));
            gPacket.putProp("I", new String(subscription.getClientID()));
            gPacket.putProp("M", new Boolean(true));
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error: generateAddDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDurableRecord(Subscription subscription) {
        try {
            GPacket gPacket = RaptorProtocol.prepareRemDurableUpdate(subscription);
            gPacket.putProp("N", new String(subscription.getDurableName()));
            gPacket.putProp("I", new String(subscription.getClientID()));
            gPacket.putProp("M", new Boolean(true));
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error: generateRemDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateAddDestinationRecord(Destination destination) {
        try {
            GPacket gPacket = RaptorProtocol.prepareUpdateDestination(destination.getDestinationName(), destination.getType(), destination.getDestinationProperties());
            gPacket.putProp("M", new Boolean(true));
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDestinationRecord(String string, int n) {
        try {
            GPacket gPacket = RaptorProtocol.prepareRemDestination(string, n);
            gPacket.putProp("M", new Boolean(true));
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            logger.logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    class EventLogWaiter {
        private int status = 2;

        public EventLogWaiter(int n) {
            this.status = n;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized void setStatus(int n) {
            this.status = n;
        }
    }
}

