/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLink;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterListener;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.WarningTask;
import com.sun.messaging.jmq.jmsserver.persist.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ClusterImpl
implements Cluster,
ConfigListener {
    ClusterCallback cb = null;
    private boolean supportClusters = false;
    private int connLimit = 0;
    private Properties matchProps = null;
    protected boolean useGPackets = false;
    private BrokerAddressImpl self;
    private HashMap connectList;
    private HashSet dynamicConnectList;
    private HashMap brokerList;
    private boolean readyForBroadcast = false;
    private int flowControlState = 6;
    private String transport = null;
    private String listenHost = null;
    private int listenPort = 0;
    private ClusterListener listener = null;
    private PingTimerTask pingTimer = null;
    private static final long pingInterval = 60000L;
    private BrokerAddressImpl configServer = null;
    private boolean configServerResolved = false;
    public static final String SERVICE_NAME = "cluster";
    public static final String SERVICE_TYPE = "CLUSTER";
    private static final String TRANSPORT_PROPERTY = "imq.cluster.transport";
    private static final String HOST_PROPERTY = "imq.cluster.hostname";
    private static final String PORT_PROPERTY = "imq.cluster.port";
    private static final String AUTOCONNECT_PROPERTY = "imq.cluster.brokerlist";
    private static final String CONFIG_SERVER = "imq.cluster.masterbroker";
    public static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private JMQTimerTask warningTask = null;

    public ClusterImpl(int n) throws BrokerException {
        BrokerConfig brokerConfig = Globals.getConfig();
        brokerConfig.addListener(HOST_PROPERTY, this);
        brokerConfig.addListener(TRANSPORT_PROPERTY, this);
        brokerConfig.addListener(PORT_PROPERTY, this);
        brokerConfig.addListener(AUTOCONNECT_PROPERTY, this);
        brokerConfig.addListener(CONFIG_SERVER, this);
        this.transport = brokerConfig.getProperty(TRANSPORT_PROPERTY);
        if (this.transport == null) {
            this.transport = "tcp";
        }
        this.listenHost = brokerConfig.getProperty(HOST_PROPERTY);
        if (this.listenHost == null) {
            this.listenHost = Globals.getHostname();
        }
        String string = brokerConfig.getProperty(PORT_PROPERTY);
        try {
            this.listenPort = Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.self = new BrokerAddressImpl(this.listenHost, true);
        }
        catch (Exception exception) {
            throw new BrokerException("Could not resolve self BrokerAddress", exception);
        }
        if (!this.self.verifyAddress()) {
            logger.log(32, "B3153", HOST_PROPERTY);
            if (brokerConfig.getProperty(HOST_PROPERTY) == null && brokerConfig.getProperty("imq.hostname") == null) {
                throw new BrokerException("Could not find a suitable network interface for the cluster service. Cluster service cannot run on the localhost interface.");
            }
            System.exit(1);
        }
        LicenseBase licenseBase = Globals.getCurrentLicense(null);
        this.supportClusters = licenseBase.getBooleanProperty("imq.enable_cluster", false);
        this.connLimit = n;
        this.readyForBroadcast = false;
        string = brokerConfig.getProperty(CONFIG_SERVER);
        this.initConfigServer(string);
        this.initBrokerList(brokerConfig);
    }

    private void initConfigServer(String string) throws BrokerException {
        if (string == null) {
            this.configServer = null;
            this.configServerResolved = true;
            return;
        }
        if (!this.supportClusters) {
            logger.log(32, "B3123", Globals.getBrokerResources().getString("B0038"));
            System.exit(1);
        }
        if (Globals.getHAEnabled()) {
            logger.log(32, "HA clusters cannot have a master broker. **** TBD : I18N", Integer.toString(this.connLimit + 1));
            System.exit(1);
        }
        this.checkStoredLastConfigServer();
        try {
            this.configServer = new BrokerAddressImpl(string);
        }
        catch (Exception exception) {
            this.configServer = null;
            this.configServerResolved = false;
            throw new BrokerException(exception.getMessage(), exception);
        }
        String string2 = this.configServer.getIpPortString();
        String string3 = this.self.getIpPortString();
        if (string2.equals(string3)) {
            this.configServer = this.self;
            this.configServerResolved = true;
            return;
        }
        this.configServerResolved = false;
    }

    private void checkStoredLastConfigServer() throws BrokerException {
        Store store = Globals.getStore();
        boolean bl = false;
        boolean bl2 = false;
        LoadException loadException = store.getLoadPropertyException();
        LoadException loadException2 = null;
        while (loadException != null) {
            Object object = loadException.getKey();
            if (object == null || !(object instanceof String)) {
                bl2 = true;
                loadException2 = loadException;
                loadException = loadException.getNextException();
                continue;
            }
            if (((String)object).equals("MessageBus.lastConfigServer")) {
                logger.log(32, "B3161", loadException);
                bl = true;
                break;
            }
            if (((String)object).equals("MessageBus.lastRefreshTime")) {
                logger.log(16, "B2100", loadException);
                try {
                    store.updateProperty("MessageBus.lastRefreshTime", new Long(-1L), false);
                }
                catch (BrokerException brokerException) {
                    logger.log(32, "B3162", brokerException);
                    bl = true;
                    break;
                }
            }
            loadException = loadException.getNextException();
        }
        if (bl2 && !bl) {
            try {
                if (store.getProperty("MessageBus.lastConfigServer") == null) {
                    logger.log(32, "B3161", loadException2);
                    bl = true;
                }
            }
            catch (BrokerException brokerException) {
                logger.log(32, brokerException.getMessage(), brokerException);
                logger.log(32, "B3161", loadException2);
                bl = true;
            }
        }
        if (bl) {
            System.exit(1);
        }
    }

    private void initBrokerList(BrokerConfig brokerConfig) throws BrokerException {
        this.connectList = new HashMap();
        this.dynamicConnectList = new HashSet();
        String string = brokerConfig.getProperty(AUTOCONNECT_PROPERTY);
        if (string != null) {
            this.setConnectList(string, true);
        }
        string = brokerConfig.getProperty("imq.cluster.brokerlist.manual");
        String string2 = this.self.getIpPortString();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                BrokerAddressImpl brokerAddressImpl;
                String string3 = stringTokenizer.nextToken();
                try {
                    brokerAddressImpl = new BrokerAddressImpl(string3);
                }
                catch (Exception exception) {
                    throw new BrokerException(exception.getMessage(), exception);
                }
                String string4 = brokerAddressImpl.getIpPortString();
                if (string4.equals(string2) || this.connectList.containsKey(string4)) continue;
                BrokerLink brokerLink = new BrokerLink(this.self, brokerAddressImpl, this);
                brokerLink.setAutoConnect(true);
                this.connectList.put(string4, brokerLink);
            }
        }
        if (this.connectList.size() > 0 && !this.supportClusters) {
            logger.log(32, "B3123", Globals.getBrokerResources().getString("B0038"));
            System.exit(1);
        }
        if (this.connectList.size() > this.connLimit) {
            logger.log(32, "B3091", Integer.toString(this.connLimit + 1));
            System.exit(1);
        }
        this.brokerList = new HashMap();
    }

    private void setConnectList(String string, boolean bl) throws BrokerException {
        Object object;
        String string2;
        String string3;
        Iterator<Object> iterator;
        Object object2;
        if (string == null) {
            string = "";
        }
        String string4 = this.self.getIpPortString();
        if (DEBUG) {
            logger.log(4, "ClusterImpl: setConnectList. selfKey = {0}", string4);
        }
        HashMap hashMap = new HashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            try {
                iterator = new BrokerAddressImpl((String)object2);
            }
            catch (Exception exception) {
                throw new BrokerException(exception.getMessage(), exception);
            }
            string3 = ((BrokerAddressImpl)((Object)iterator)).getIpPortString();
            if (string3.equals(string4) || hashMap.containsKey(string3)) continue;
            hashMap.put(string3, iterator);
        }
        object2 = new ArrayList();
        iterator = this.dynamicConnectList.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (hashMap.containsKey(string3)) continue;
            ((ArrayList)object2).add(string3);
        }
        int n = this.connectList.size() - ((ArrayList)object2).size();
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (this.connectList.containsKey(string5)) continue;
            ++n;
        }
        if (n > 0 && !this.supportClusters) {
            logger.log(32, "B3123", Globals.getBrokerResources().getString("B0038"));
            if (bl) {
                System.exit(1);
            } else {
                return;
            }
        }
        if (n > this.connLimit) {
            logger.log(32, "B3091", Integer.toString(this.connLimit + 1));
            if (bl) {
                System.exit(1);
            } else {
                return;
            }
        }
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            string2 = (String)((ArrayList)object2).get(i);
            this.dynamicConnectList.remove(string2);
            object = (BrokerLink)this.connectList.remove(string2);
            if (DEBUG) {
                logger.log(4, "ClusterImpl: Removing link from connectList - {0}", object);
            }
            ((BrokerLink)object).shutdown();
        }
        Set set = hashMap.keySet();
        iterator = set.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            object = (BrokerAddressImpl)hashMap.get(string2);
            if (this.connectList.containsKey(string2)) continue;
            boolean bl2 = false;
            BrokerLink brokerLink = this.searchBrokerList(string2);
            if (brokerLink == null) {
                brokerLink = new BrokerLink(this.self, (BrokerAddressImpl)object, this);
                bl2 = true;
            }
            brokerLink.setAutoConnect(true);
            this.dynamicConnectList.add(string2);
            this.connectList.put(string2, brokerLink);
            if (DEBUG) {
                logger.log(4, "ClusterImpl: Adding link to connectList - {0}", brokerLink);
            }
            if (!bl2 || bl) continue;
            brokerLink.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerLink searchBrokerList(String string) {
        if (this.brokerList == null) {
            return null;
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Iterator iterator = this.brokerList.keySet().iterator();
            while (iterator.hasNext()) {
                BrokerAddressImpl brokerAddressImpl = (BrokerAddressImpl)iterator.next();
                if (!string.equals(brokerAddressImpl.getIpPortString())) continue;
                return (BrokerLink)this.brokerList.get(brokerAddressImpl);
            }
            return null;
        }
    }

    protected String getTransport() {
        return this.transport;
    }

    private void setListenHost(String string) throws IOException {
        if (DEBUG) {
            logger.log(4, "ClusterImpl: Changing the listening hostname to {0}", string);
        }
        if (!this.supportClusters) {
            return;
        }
        String string2 = this.listenHost;
        try {
            this.listenHost = string;
            ClusterListener clusterListener = new ClusterListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = clusterListener;
        }
        catch (IOException iOException) {
            this.listenHost = string2;
            throw iOException;
        }
    }

    protected String getListenHost() {
        return this.listenHost;
    }

    private void setListenPort(int n) throws IOException {
        Object[] objectArray = new String[]{SERVICE_NAME, String.valueOf(n), String.valueOf(1), String.valueOf(1)};
        logger.log(8, "B1090", objectArray);
        if (!this.supportClusters) {
            return;
        }
        int n2 = this.listenPort;
        try {
            this.listenPort = n;
            ClusterListener clusterListener = new ClusterListener(this);
            if (this.listener != null) {
                this.listener.shutdown();
            }
            this.listener = clusterListener;
        }
        catch (IOException iOException) {
            this.listenPort = n2;
            throw iOException;
        }
    }

    protected int getListenPort() {
        return this.listenPort;
    }

    protected boolean isConfigServerResolved() {
        return this.configServerResolved;
    }

    protected boolean checkConfigServer(BrokerAddressImpl brokerAddressImpl) {
        if (this.configServerResolved) {
            return true;
        }
        if (this.configServer == null) {
            return false;
        }
        String string = brokerAddressImpl.getIpPortString();
        String string2 = this.configServer.getIpPortString();
        if (string2.equals(string)) {
            this.configServer = brokerAddressImpl;
            this.configServerResolved = true;
            if (this.warningTask != null) {
                this.warningTask.cancel();
                this.warningTask = null;
            }
        }
        return this.configServerResolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addBroker(BrokerAddressImpl brokerAddressImpl, BrokerLink brokerLink) {
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Activating link = {0}", brokerLink);
        }
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            if (this.brokerList.get(brokerAddressImpl) != null) {
                return false;
            }
            this.brokerList.put(brokerAddressImpl, brokerLink);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBroker(BrokerAddressImpl brokerAddressImpl, BrokerLink brokerLink) {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            BrokerLink brokerLink2 = (BrokerLink)this.brokerList.get(brokerAddressImpl);
            if (brokerLink2 != null && brokerLink2 != brokerLink) {
                return;
            }
            if (this.brokerList.remove(brokerAddressImpl) == null) {
                return;
            }
        }
        this.cb.removeBrokerInfo(brokerAddressImpl);
        if (DEBUG) {
            logger.log(2, "ClusterImpl: Removed link with = {0}", brokerAddressImpl);
        }
    }

    protected void handleBrokerLinkShutdown(BrokerAddressImpl brokerAddressImpl) {
        String string = brokerAddressImpl.getIpPortString();
        this.dynamicConnectList.remove(string);
        this.connectList.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acceptConnection(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        Packet packet = new Packet();
        packet.readPacket(inputStream);
        if (packet.getPacketType() != 4) {
            socket.close();
            return;
        }
        LinkInfo linkInfo = null;
        try {
            linkInfo = this.processLinkInit(packet);
        }
        catch (Exception exception) {
            logger.logStack(16, "Broker internal error : processLinkInit failed.", exception);
            socket.close();
            return;
        }
        BrokerAddressImpl brokerAddressImpl = linkInfo.getAddress();
        if (!brokerAddressImpl.verifyAddress()) {
            logger.log(32, "B3099", (Object)socket.getInetAddress().toString(), brokerAddressImpl.toString());
            socket.close();
            return;
        }
        if (!this.checkConfigServer(brokerAddressImpl)) {
            logger.log(4, "Closing cluster connection with " + brokerAddressImpl + ". Waiting for master broker");
            socket.close();
            return;
        }
        String string = brokerAddressImpl.getIpPortString();
        Object object = this.connectList;
        synchronized (object) {
            BrokerLink brokerLink = (BrokerLink)this.connectList.get(string);
            if (brokerLink != null) {
                if (this.connectionInitiator(brokerAddressImpl)) {
                    this.dynamicConnectList.remove(string);
                    this.connectList.remove(string);
                    brokerLink.shutdown();
                } else {
                    brokerLink.acceptConnection(brokerAddressImpl, socket);
                    return;
                }
            }
        }
        object = new BrokerLink(this.self, brokerAddressImpl, this);
        ((BrokerLink)object).setAutoConnect(false);
        if (((BrokerLink)object).acceptConnection(brokerAddressImpl, socket)) {
            ((Thread)object).start();
        }
    }

    protected Packet getLinkInitPkt() {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.self.getClusterVersion());
            dataOutputStream.writeUTF(this.self.getHostName());
            dataOutputStream.writeUTF(this.self.getInstName());
            dataOutputStream.writeInt(this.self.getPort());
            dataOutputStream.writeBoolean(this.configServer != null);
            if (this.configServer != null) {
                dataOutputStream.writeUTF(this.configServer.getHostName());
                dataOutputStream.writeUTF(this.configServer.getInstName());
                dataOutputStream.writeInt(this.configServer.getPort());
            }
            dataOutputStream.writeInt(this.matchProps.size());
            object2 = this.matchProps.propertyNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeUTF(this.matchProps.getProperty((String)object));
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = new Packet();
        ((Packet)object).setPacketType(4);
        ((Packet)object).setPacketBody((byte[])object2);
        ((Packet)object).setDestId(0);
        return object;
    }

    protected LinkInfo processLinkInit(Packet packet) throws Exception {
        int n;
        Object object;
        String string = null;
        String string2 = null;
        int n2 = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(packet.getPacketBody());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n3 = dataInputStream.readInt();
        string = dataInputStream.readUTF();
        string2 = dataInputStream.readUTF();
        n2 = dataInputStream.readInt();
        BrokerAddressImpl brokerAddressImpl = new BrokerAddressImpl(string, string2, n2);
        brokerAddressImpl.setClusterVersion(n3);
        BrokerAddressImpl brokerAddressImpl2 = null;
        if (dataInputStream.readBoolean()) {
            object = null;
            String string3 = null;
            n = 0;
            object = dataInputStream.readUTF();
            string3 = dataInputStream.readUTF();
            n = dataInputStream.readInt();
            brokerAddressImpl2 = new BrokerAddressImpl((String)object, string3, n);
        }
        object = new Properties();
        int n4 = dataInputStream.readInt();
        for (n = 0; n < n4; ++n) {
            String string4 = dataInputStream.readUTF();
            String string5 = dataInputStream.readUTF();
            ((Properties)object).setProperty(string4, string5);
        }
        return new LinkInfo(brokerAddressImpl, brokerAddressImpl2, (Properties)object);
    }

    protected boolean connectionInitiator(BrokerAddressImpl brokerAddressImpl) {
        String string = brokerAddressImpl.getIpPortString();
        String string2 = this.self.getIpPortString();
        return string2.hashCode() > string.hashCode();
    }

    protected Packet getBrokerInfoPkt() {
        Object object;
        BrokerInfo brokerInfo = this.cb.getBrokerInfo();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(brokerInfo);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = byteArrayOutputStream.toByteArray();
        Packet packet = new Packet();
        packet.setPacketType(3);
        packet.setPacketBody((byte[])object);
        packet.setDestId(0);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveBrokerInfo(BrokerAddressImpl brokerAddressImpl, byte[] byArray) {
        BrokerInfo brokerInfo;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            brokerInfo = (BrokerInfo)objectInputStream.readObject();
        }
        catch (Exception exception) {
            logger.log(16, "B2068", brokerAddressImpl);
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.shutdown();
                }
            }
            return;
        }
        int n = this.cb.addBrokerInfo(brokerInfo);
        if (n == 1) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.closeConn();
                }
            }
        }
        if (n == 2) {
            HashMap hashMap = this.brokerList;
            synchronized (hashMap) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                if (brokerLink != null) {
                    brokerLink.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlowControl(BrokerAddressImpl brokerAddressImpl, boolean bl) {
        BrokerLink brokerLink = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
        }
        if (brokerLink != null) {
            brokerLink.setFlowControl(bl);
        }
    }

    protected void receivePacket(BrokerAddressImpl brokerAddressImpl, Packet packet) {
        if (this.cb == null) {
            return;
        }
        switch (packet.getPacketType()) {
            case 1: {
                this.cb.receiveUnicast(brokerAddressImpl, packet.getDestId(), packet.getPacketBody());
                break;
            }
            case 2: {
                this.cb.receiveBroadcast(brokerAddressImpl, packet.getDestId(), packet.getPacketBody());
                break;
            }
            case 3: {
                this.receiveBrokerInfo(brokerAddressImpl, packet.getPacketBody());
                break;
            }
            case 5: {
                this.setFlowControl(brokerAddressImpl, true);
                break;
            }
            case 6: {
                this.setFlowControl(brokerAddressImpl, false);
                break;
            }
            case 7: {
                if (!DEBUG) break;
                logger.log(4, "ClusterImpl: Received ping from : " + brokerAddressImpl);
                break;
            }
            default: {
                logger.log(16, "ClusterImpl: INTERNAL ERROR - Received Unknown packet from : " + brokerAddressImpl);
            }
        }
    }

    protected void receivePacket(BrokerAddressImpl brokerAddressImpl, GPacket gPacket) {
        if (this.cb == null) {
            return;
        }
        if (gPacket.getBit(2)) {
            this.cb.receiveBroadcast(brokerAddressImpl, gPacket);
        } else {
            this.cb.receiveUnicast(brokerAddressImpl, gPacket);
        }
    }

    public void useGPackets(boolean bl) {
        this.useGPackets = bl;
    }

    public void setCallback(ClusterCallback clusterCallback) {
        this.cb = clusterCallback;
        this.self.setClusterVersion(clusterCallback.getClusterVersion());
    }

    public void setMatchProps(Properties properties) {
        this.matchProps = properties;
    }

    protected Properties getMatchProps() {
        return this.matchProps;
    }

    public BrokerAddress getSelfAddress() {
        return this.self;
    }

    public BrokerAddress getConfigServer() throws BrokerException {
        if (!this.configServerResolved) {
            if (Globals.getConfig().getBooleanProperty("imq.cluster.masterbroker.enforce", true)) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4118"));
            }
            return null;
        }
        return this.configServer;
    }

    public void start() throws IOException {
        Object[] objectArray;
        if (!this.supportClusters) {
            return;
        }
        Collection collection = this.connectList.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            objectArray.start();
        }
        this.listener = new ClusterListener(this);
        objectArray = new Object[]{SERVICE_NAME, this.getTransport() + " [ " + this.getListenPort() + " ]", new Integer(1), new Integer(1)};
        logger.log(8, "B1004", objectArray);
        if (!this.configServerResolved) {
            this.warningTask = new WarningTask(this.configServer, this);
            Globals.getTimer().schedule(this.warningTask, 60000L, 180000L);
        }
        this.pingTimer = new PingTimerTask();
        Globals.getTimer().schedule((JMQTimerTask)this.pingTimer, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BrokerLink brokerLink;
        Iterator iterator;
        Collection collection;
        if (!this.supportClusters) {
            return;
        }
        if (this.listener != null) {
            this.listener.shutdown();
        }
        if (this.brokerList == null) {
            return;
        }
        ArrayList<BrokerLink> arrayList = new ArrayList<BrokerLink>();
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            collection = this.brokerList.values();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                brokerLink = (BrokerLink)iterator.next();
                brokerLink.shutdown();
                arrayList.add(brokerLink);
            }
        }
        hashMap = (HashMap)this.connectList.clone();
        collection = hashMap.values();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            brokerLink = (BrokerLink)iterator.next();
            if (arrayList.contains(brokerLink)) continue;
            brokerLink.shutdown();
        }
    }

    public void waitClusterInit() {
        HashMap hashMap = (HashMap)this.connectList.clone();
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BrokerLink brokerLink = (BrokerLink)iterator.next();
            brokerLink.waitLinkInit();
        }
        this.readyForBroadcast = true;
    }

    public void sendFlowControlUpdate(BrokerAddressImpl brokerAddressImpl) throws IOException {
        if (this.flowControlState == 5) {
            this.sendFlowControlUpdate(brokerAddressImpl, this.flowControlState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFlowControlUpdate(BrokerAddressImpl brokerAddressImpl, int n) throws IOException {
        Packet packet = new Packet();
        packet.setPacketType(n);
        packet.setPacketBody(null);
        packet.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            if (brokerAddressImpl != null) {
                BrokerLink brokerLink = (BrokerLink)this.brokerList.get(brokerAddressImpl);
                brokerLink.sendPacket(packet);
            } else {
                Collection collection = this.brokerList.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    BrokerLink brokerLink = (BrokerLink)iterator.next();
                    brokerLink.sendPacket(packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 5;
        }
        this.sendFlowControlUpdate(null, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeMessageFlow() throws IOException {
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            this.flowControlState = 6;
        }
        this.sendFlowControlUpdate(null, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingGPacket() throws Exception {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)33);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BrokerLink brokerLink = (BrokerLink)iterator.next();
                brokerLink.sendPacket(gPacket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPingPacket() throws Exception {
        Packet packet = new Packet();
        packet.setPacketType(7);
        packet.setPacketBody(null);
        packet.setDestId(0);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BrokerLink brokerLink = (BrokerLink)iterator.next();
                brokerLink.sendPacket(packet);
            }
        }
    }

    public void unicast(BrokerAddress brokerAddress, GPacket gPacket) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        this.unicast(brokerAddress, gPacket, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unicast(BrokerAddress brokerAddress, GPacket gPacket, boolean bl) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket unicast on old cluster");
            Thread.dumpStack();
        }
        if (brokerAddress.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, gPacket);
            }
            return;
        }
        BrokerLink brokerLink = null;
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddress);
        }
        if (brokerLink == null) {
            throw new IOException(br.getString("B4205", brokerAddress.toString()));
        }
        gPacket.setBit(32, bl);
        brokerLink.sendPacket(gPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(GPacket gPacket) throws IOException {
        if (!this.useGPackets) {
            logger.log(16, "Protocol mismatch. GPacket broadcast on old cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        gPacket.setBit(2, true);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BrokerLink brokerLink = (BrokerLink)iterator.next();
                brokerLink.sendPacket(gPacket);
            }
        }
    }

    public void unicast(BrokerAddress brokerAddress, int n, byte[] byArray) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        this.unicast(brokerAddress, n, byArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unicast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet unicast on raptor cluster");
            Thread.dumpStack();
        }
        if (brokerAddress.equals(this.self)) {
            if (this.cb != null) {
                this.cb.receiveUnicast(this.self, n, byArray);
            }
            return;
        }
        BrokerLink brokerLink = null;
        Object object = this.brokerList;
        synchronized (object) {
            brokerLink = (BrokerLink)this.brokerList.get(brokerAddress);
        }
        if (brokerLink == null) {
            throw new IOException("Packet send failed. Unreachable BrokerAddress : " + brokerAddress);
        }
        object = new Packet();
        ((Packet)object).setPacketType(1);
        ((Packet)object).setPacketBody(byArray);
        ((Packet)object).setDestId(n);
        ((Packet)object).setFlag(1, bl);
        brokerLink.sendPacket((Packet)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(int n, byte[] byArray) throws IOException {
        if (this.useGPackets) {
            logger.log(16, "Protocol mismatch. Old packet broadcast on raptor cluster");
            Thread.dumpStack();
        }
        if (!this.readyForBroadcast) {
            this.waitClusterInit();
        }
        Packet packet = new Packet();
        packet.setPacketType(2);
        packet.setPacketBody(byArray);
        packet.setDestId(n);
        HashMap hashMap = this.brokerList;
        synchronized (hashMap) {
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BrokerLink brokerLink = (BrokerLink)iterator.next();
                brokerLink.sendPacket(packet);
            }
        }
    }

    public void reloadCluster() {
        BrokerConfig brokerConfig = Globals.getConfig();
        String[] stringArray = new String[]{"imq.cluster.url", AUTOCONNECT_PROPERTY};
        try {
            brokerConfig.reloadProps(Globals.getConfigName(), stringArray, false);
        }
        catch (Exception exception) {
            logger.logStack(16, "Broker internal error : config.reloadProps failed.", exception);
            return;
        }
        String string = brokerConfig.getProperty(AUTOCONNECT_PROPERTY);
        try {
            this.setConnectList(string, false);
        }
        catch (BrokerException brokerException) {
            logger.logStack(16, brokerException.getMessage(), brokerException);
        }
    }

    public int getIntProperty(String string, String string2) throws PropertyUpdateException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyUpdateException(br.getString("B4027", string + "=" + string2));
        }
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals(PORT_PROPERTY)) {
            this.getIntProperty(string, string2);
        } else if (!string.equals(AUTOCONNECT_PROPERTY)) {
            throw new PropertyUpdateException(br.getString("B4028", string));
        }
    }

    public boolean update(String string, String string2) {
        try {
            if (string.equals(PORT_PROPERTY)) {
                this.setListenPort(this.getIntProperty(string, string2));
            } else if (string.equals(AUTOCONNECT_PROPERTY)) {
                this.setConnectList(string2, false);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private class PingTimerTask
    extends JMQTimerTask {
        private PingTimerTask() {
        }

        public void run() {
            try {
                if (ClusterImpl.this.useGPackets) {
                    ClusterImpl.this.sendPingGPacket();
                } else {
                    ClusterImpl.this.sendPingPacket();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

