/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.falcon.FalconProtocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;

public class CommonProtocol
implements Protocol {
    public static boolean DEBUG = false;
    protected static final Logger logger = Globals.getLogger();
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected Protocol realProtocol = null;
    protected boolean protocolInitComplete = false;
    protected long startTime = 0L;
    private Object protocolInitWaitObject = new Object();

    public CommonProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress) throws BrokerException {
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
    }

    public int getClusterVersion() {
        return 300;
    }

    private void initOldProtocol() {
        if (DEBUG) {
            logger.log(4, "Using FALCON cluster protocol.");
        }
        try {
            this.realProtocol = new FalconProtocol(this.cb, this.c, this.selfAddress);
            this.realProtocol.startClusterIO();
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Initializing the cluster protcol", (Throwable)exception);
        }
    }

    private void initNewProtocol() {
        if (DEBUG) {
            logger.log(4, "Using RAPTOR cluster protocol.");
        }
        try {
            this.c.useGPackets(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.realProtocol = new RaptorProtocol(this.cb, this.c, this.selfAddress);
            this.realProtocol.startClusterIO();
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "Initializing the cluster protcol", (Throwable)exception);
        }
    }

    public BrokerInfo getBrokerInfo() {
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerAddr(this.selfAddress);
        brokerInfo.setStartTime(this.startTime);
        brokerInfo.setStoreDirtyFlag(false);
        brokerInfo.setClusterProtocolVersion(new Integer(350));
        return brokerInfo;
    }

    public int addBrokerInfo(BrokerInfo brokerInfo) {
        BrokerAddress brokerAddress;
        if (this.getProtocolInitComplete()) {
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            logger.logStack(16, "B3100", "getConfigServer()", (Throwable)exception);
            return 1;
        }
        if (brokerAddress != null && brokerAddress.equals(brokerInfo.getBrokerAddr())) {
            boolean bl = false;
            Integer n = brokerInfo.getClusterProtocolVersion();
            if (n != null && n >= 350) {
                bl = true;
            }
            if (bl) {
                this.initNewProtocol();
            } else {
                this.initOldProtocol();
            }
            this.setProtocolInitComplete(true);
            return this.realProtocol.addBrokerInfo(brokerInfo);
        }
        return 1;
    }

    public void removeBrokerInfo(BrokerAddress brokerAddress) {
        if (this.realProtocol != null) {
            this.realProtocol.removeBrokerInfo(brokerAddress);
        }
    }

    public void setMatchProps(Properties properties) {
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        if (DEBUG) {
            logger.log(4, "CommonProtocol.startClusterIO()");
        }
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null || brokerAddress.equals(this.selfAddress)) {
                this.initNewProtocol();
                this.setProtocolInitComplete(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.c.start();
        }
        catch (Exception exception) {
            logger.logStack(32, "B4210", "cluster", exception.getMessage(), exception);
            System.exit(1);
        }
    }

    public void stopClusterIO() {
        if (this.realProtocol != null) {
            this.realProtocol.shutdown();
        }
        this.c.shutdown();
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast GPacket");
        }
        this.realProtocol.receiveUnicast(brokerAddress, gPacket);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast GPacket");
        }
        this.realProtocol.receiveBroadcast(brokerAddress, gPacket);
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "receiveUnicast");
        }
        this.realProtocol.receiveUnicast(brokerAddress, n, byArray);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        if (DEBUG) {
            logger.log(4, "receiveBroadcast");
        }
        this.realProtocol.receiveBroadcast(brokerAddress, n, byArray);
    }

    public void shutdown() {
        if (this.realProtocol != null) {
            this.realProtocol.shutdown();
        }
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        if (!this.getProtocolInitComplete()) {
            return true;
        }
        return this.realProtocol.waitForConfigSync();
    }

    public void reloadCluster() {
        this.waitForProtocolInit();
        this.realProtocol.reloadCluster();
    }

    public void stopMessageFlow() throws IOException {
        this.realProtocol.stopMessageFlow();
    }

    public void resumeMessageFlow() throws IOException {
        this.realProtocol.resumeMessageFlow();
    }

    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        this.realProtocol.sendMessage(packetReference, collection, bl);
    }

    public void sendMessageAck(BrokerAddress brokerAddress, PacketReference packetReference, ConsumerUID consumerUID, int n) {
        this.realProtocol.sendMessageAck(brokerAddress, packetReference, consumerUID, n);
    }

    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.clientClosed(connectionUID, bl);
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockSharedResource(string, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        if (!this.getProtocolInitComplete()) {
            return 0;
        }
        return this.realProtocol.lockResource(string, l, connectionUID);
    }

    public void unlockResource(String string) {
        if (!this.getProtocolInitComplete()) {
            return;
        }
        this.realProtocol.unlockResource(string);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUpdateDestination(destination);
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordRemoveDestination(destination);
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendNewDestination(destination);
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendRemovedDestination(destination);
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.sendUpdateDestination(destination);
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordCreateSubscription(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        this.waitForProtocolInit();
        this.realProtocol.recordUnsubscribe(subscription);
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendNewSubscription(subscription, consumer, bl);
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendNewConsumer(consumer, bl);
    }

    public void sendRemovedConsumer(Consumer consumer) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendRemovedConsumer(consumer);
    }

    public void sendActivateConsumer(Consumer consumer) throws BrokerException {
        if (this.realProtocol == null) {
            return;
        }
        this.realProtocol.sendActivateConsumer(consumer);
    }

    public void handleGPacket(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (this.realProtocol == null) {
            logger.logStack(32, "No protocol", new Exception("No protocol"));
            return;
        }
        this.realProtocol.handleGPacket(messageBusCallback, brokerAddress, gPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProtocolInit() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            while (!this.getProtocolInitComplete()) {
                try {
                    this.protocolInitWaitObject.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProtocolInitComplete() {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            return this.protocolInitComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolInitComplete(boolean bl) {
        Object object = this.protocolInitWaitObject;
        synchronized (object) {
            this.protocolInitComplete = bl;
            this.protocolInitWaitObject.notifyAll();
        }
    }
}

