/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterConnection;
import com.sun.messaging.jmq.jmsserver.multibroker.CommonProtocol;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.standalone.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class ClusterBroadcaster
implements ClusterBroadcast,
MessageBusCallback {
    public static boolean DEBUG;
    static Logger logger;
    static BrokerConfig config;
    static BrokerResources br;
    private int version = 0;
    private BrokerAddress selfAddress = null;
    private String driver = null;
    private Cluster c = null;
    private HashMap brokerList = null;
    private ClusterConnection clustercon = null;
    private int connLimit = 0;
    private Protocol protocol = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClusterBroadcaster(Integer n, Integer n2) throws BrokerException {
        this((int)n, (int)n2);
    }

    public ClusterBroadcaster(int n, int n2) throws BrokerException {
        this.version = n2;
        this.brokerList = new HashMap();
        this.connLimit = n;
        this.driver = config.getProperty("imq.topology");
        if (this.driver == null) {
            this.driver = "fullyconnected";
        }
        if (this.driver.equals("fullyconnected")) {
            this.c = new com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl(this.connLimit);
            logger.log(8, "B1041");
        } else {
            this.driver = "standalone";
        }
        if (this.driver.equals("standalone")) {
            this.c = new ClusterImpl();
            logger.log(8, "B1042");
        }
        this.selfAddress = this.c.getSelfAddress();
        this.protocol = new CommonProtocol(this, this.c, this.selfAddress);
        this.c.setCallback(this.protocol);
        this.clustercon = new BrokerConsumers(this.protocol);
    }

    public int getClusterVersion() {
        return this.version;
    }

    public void startClusterIO() {
        this.protocol.startClusterIO();
    }

    public void stopClusterIO() {
        this.protocol.stopClusterIO();
    }

    public void shutdown() {
        this.protocol.shutdown();
    }

    public void reloadCluster() {
        this.protocol.reloadCluster();
    }

    public void pauseMessageFlow() throws IOException {
        this.protocol.stopMessageFlow();
    }

    public void resumeMessageFlow() throws IOException {
        this.protocol.resumeMessageFlow();
    }

    public void setMatchProps(Properties properties) {
        this.protocol.setMatchProps(properties);
    }

    public boolean waitForConfigSync() {
        return this.protocol.waitForConfigSync();
    }

    public BrokerAddress getMyAddress() {
        return this.selfAddress;
    }

    public boolean lockSharedResource(String string, Object object) {
        if (DEBUG) {
            logger.log(8, "lockSharedResource : " + string);
        }
        return this.protocol.lockSharedResource(string, (ConnectionUID)object) == 0;
    }

    public boolean lockDestination(DestinationUID destinationUID, Object object) {
        if (DEBUG) {
            logger.log(8, "lockDestination " + destinationUID);
        }
        return this.protocol.lockResource("destCreate:" + destinationUID.toString(), 0L, (ConnectionUID)object) == 0;
    }

    public void unlockDestination(DestinationUID destinationUID, Object object) {
        if (DEBUG) {
            logger.log(8, "unlockDestination " + destinationUID);
        }
        this.protocol.unlockResource("destCreate:" + destinationUID.toString());
    }

    public boolean lockClientID(String string, Object object, boolean bl) {
        if (DEBUG) {
            logger.log(8, "lockClientID " + string);
        }
        if (bl) {
            return this.protocol.lockSharedResource("clientid:" + string.toString(), (ConnectionUID)object) == 0;
        }
        return this.protocol.lockResource("clientid:" + string.toString(), 0L, (ConnectionUID)object) == 0;
    }

    public void unlockClientID(String string, Object object) {
        if (DEBUG) {
            logger.log(8, "unlockClientID " + string);
        }
        this.protocol.unlockResource("clientid:" + string.toString());
    }

    public boolean getConsumerLock(ConsumerUID consumerUID, DestinationUID destinationUID, int n, int n2, Object object) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "getConsumerLock " + consumerUID);
        }
        if (n2 > 1 && this.version != 350) {
            throw new BrokerException("Feature not support in this cluster protocol");
        }
        return this.protocol.lockResource("queue:" + destinationUID.getName() + "_" + n, 0L, (ConnectionUID)object) == 0;
    }

    public void unlockConsumer(ConsumerUID consumerUID, DestinationUID destinationUID, int n) {
        if (DEBUG) {
            logger.log(8, "unlockConsumer " + consumerUID);
        }
        this.protocol.unlockResource("queue:" + destinationUID.getName() + "_" + n);
    }

    private int convertLocalType(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private int convertClusterType(int n) {
        switch (n) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return -1;
    }

    public void acknowledgeMessage(BrokerAddress brokerAddress, PacketReference packetReference, ConsumerUID consumerUID, int n) {
        if (brokerAddress != null && brokerAddress != this.selfAddress) {
            this.protocol.sendMessageAck(brokerAddress, packetReference, consumerUID, this.convertLocalType(n));
        }
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "recordUpdateDestination : " + destination);
        }
        this.protocol.recordUpdateDestination(destination);
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "recordRemoveDestination : " + destination);
        }
        this.protocol.recordRemoveDestination(destination);
    }

    public void createDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "createDestination " + destination);
        }
        this.protocol.sendNewDestination(destination);
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "recordCreateSubscription " + subscription);
        }
        this.protocol.recordCreateSubscription(subscription);
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "recordUnsubscribe " + subscription);
        }
        this.protocol.recordUnsubscribe(subscription);
    }

    public void createSubscription(Subscription subscription, Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "createSubscription " + subscription);
        }
        this.protocol.sendNewSubscription(subscription, consumer, false);
    }

    public void createConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "createConsumer " + consumer);
        }
        this.protocol.sendNewConsumer(consumer, true);
    }

    public void consumerActive(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "consumerActive " + consumer);
        }
        this.protocol.sendActivateConsumer(consumer);
    }

    public void consumerFailover(Consumer consumer) {
    }

    public void updateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "updateDestination " + destination);
        }
        this.protocol.sendUpdateDestination(destination);
    }

    public void updateSubscription(Subscription subscription) throws BrokerException {
    }

    public void updateConsumer(Consumer consumer) throws BrokerException {
    }

    public void destroyDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "destroyDestination " + destination);
        }
        this.protocol.sendRemovedDestination(destination);
    }

    public void destroySubscription(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "destroySubscription " + subscription);
        }
        this.protocol.sendRemovedConsumer(subscription);
    }

    public void destroyConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            logger.log(8, "destroyConsumer " + consumer);
        }
        this.protocol.sendRemovedConsumer(consumer);
    }

    public void connectionClosed(ConnectionUID connectionUID, boolean bl) {
        if (DEBUG) {
            logger.log(8, "connectionClosed " + connectionUID);
        }
        if (!bl) {
            this.protocol.clientClosed(connectionUID, true);
        }
    }

    public void messageDelivered(SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(8, "messageDelivered - XXX not implemented");
        }
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        this.clustercon.sendMessagesToRemote(packetReference, collection);
        this.protocol.sendMessage(packetReference, collection, false);
    }

    public boolean lockUIDPrefix(short s) {
        if (DEBUG) {
            logger.log(8, "lockUIDPrefix " + s);
        }
        return this.protocol.lockResource("uidprefix:" + Short.toString(s), 0L, new ConnectionUID(0L)) == 0;
    }

    public void deliverMessage(PacketReference packetReference, ConsumerUID consumerUID, BrokerAddress brokerAddress, boolean bl) {
        Consumer consumer;
        if (DEBUG) {
            logger.log(8, "deliverMessage" + packetReference);
        }
        if ((consumer = Consumer.getConsumer(consumerUID)) == null) {
            // empty if block
        }
        consumer.routeMessage(packetReference, false);
    }

    public void configSyncComplete() {
        ServiceManager serviceManager = Globals.getServiceManager();
        try {
            serviceManager.resumeAllActiveServices(0);
        }
        catch (Exception exception) {
            logger.logStack(32, "B3100", "during broker initialization", (Throwable)exception);
        }
        Random random = new Random();
        boolean bl = false;
        for (int i = 0; i < 5; ++i) {
            short s = (short)random.nextInt(Short.MAX_VALUE);
            if (!this.lockUIDPrefix(s)) continue;
            UID.setPrefix(s);
            bl = true;
            break;
        }
        if (!bl) {
            logger.log(16, "B3100", "Could not generate a unique prefix for UIDs.");
        }
    }

    public void interestCreated(Consumer consumer) {
        try {
            this.clustercon.addConsumer(consumer);
        }
        catch (Exception exception) {
            logger.log(8, "Internal Error:  unable to add remote consumer " + consumer, exception);
        }
    }

    public void unsubscribe(Subscription subscription) {
        if (DEBUG) {
            logger.log(4, "callback unsubscribe : " + subscription);
        }
        if (!$assertionsDisabled && subscription == null) {
            throw new AssertionError();
        }
        try {
            Subscription.remoteUnsubscribe(subscription.getDurableName(), subscription.getClientID());
        }
        catch (Exception exception) {
            int n = 32;
            if (exception instanceof BrokerException && (((BrokerException)exception).getStatusCode() == 412 || ((BrokerException)exception).getStatusCode() == 404)) {
                n = 16;
            }
            if (n == 32 || DEBUG) {
                Object[] objectArray = new String[]{subscription.getDurableName(), subscription.getClientID(), exception.getMessage()};
                logger.logStack(n, "B3165", objectArray, (Throwable)exception);
            }
            logger.log(n, exception.getMessage());
        }
    }

    public void interestRemoved(Consumer consumer) {
        if (DEBUG) {
            logger.log(8, "callback interestRemoved " + consumer);
        }
        try {
            this.clustercon.removeConsumer(consumer.getConsumerUID());
        }
        catch (Exception exception) {
            logger.log(8, "Internal Error:  unable to remove remote consumer " + consumer, exception);
        }
    }

    public void activeStateChanged(Consumer consumer) {
        if (DEBUG) {
            logger.log(8, "callback activeStateChanged " + consumer);
        }
    }

    public void clientDown(ConnectionUID connectionUID) {
        if (DEBUG) {
            logger.log(8, "clientDown " + connectionUID);
        }
        try {
            this.clustercon.removeConsumers(connectionUID);
        }
        catch (Exception exception) {
            logger.log(8, "Internal Error: unable to remove remote consumers " + connectionUID, exception);
        }
    }

    public void brokerDown(BrokerAddress brokerAddress) {
        if (DEBUG) {
            logger.log(8, "brokerDown " + brokerAddress);
        }
        try {
            this.clustercon.removeConsumers(brokerAddress);
        }
        catch (Exception exception) {
            logger.log(8, "Internal Error: unable to remove remote consumers " + brokerAddress, exception);
        }
    }

    public void notifyCreateDestination(Destination destination) {
        try {
            Destination.addDestination(destination);
            destination.store();
        }
        catch (Exception exception) {
            logger.log(4, "Received exception adding new destination is caused because the destination " + destination + " is being autocreated on both sides", exception);
        }
    }

    public void notifyDestroyDestination(DestinationUID destinationUID) {
        try {
            Destination.removeDestination(destinationUID, false, Globals.getBrokerResources().getString("B0071"));
        }
        catch (Exception exception) {
            logger.log(4, "Internal Error: unable to remove stored destination " + destinationUID, exception);
        }
    }

    public void notifyUpdateDestination(DestinationUID destinationUID, Map map) {
        Destination destination = Destination.getDestination(destinationUID);
        if (destination != null) {
            try {
                destination.setDestinationProperties(map);
            }
            catch (Exception exception) {
                logger.log(8, "Internal Error, unable to update destination " + destinationUID.toString(), exception);
            }
        }
    }

    public void processRemoteAck(SysMessageID sysMessageID, ConsumerUID consumerUID, int n) {
        int n2;
        if (DEBUG) {
            logger.log(8, "processRemoteAck: " + sysMessageID + ":" + consumerUID + ":" + n + " converted type " + this.convertClusterType(n));
        }
        if ((n2 = this.convertClusterType(n)) == 1) {
            this.clustercon.acknowledgeMessageFromRemote(sysMessageID, consumerUID);
        } else if (n2 == 0) {
            Consumer consumer = Consumer.getConsumer(consumerUID);
            if (consumer != null) {
                consumer.resumeFlow();
            }
        } else if (n2 == 2 && DEBUG) {
            logger.log(4, " got message ignored ack, can not process [" + sysMessageID + "," + consumerUID + "]" + n + "," + n2);
        }
    }

    public void goHAActive() {
    }

    static {
        $assertionsDisabled = !ClusterBroadcaster.class.desiredAssertionStatus();
        DEBUG = false;
        logger = Globals.getLogger();
        config = Globals.getConfig();
        br = Globals.getBrokerResources();
    }
}

