/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterConnection;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BrokerConsumers
implements Runnable,
ClusterConnection,
EventListener {
    Thread thr = null;
    Logger logger = Globals.getLogger();
    Protocol protocol = null;
    boolean valid = true;
    Set activeConsumers = Collections.synchronizedSet(new HashSet());
    Map consumers = Collections.synchronizedMap(new HashMap());
    Map listeners = Collections.synchronizedMap(new HashMap());
    public static int BTOBFLOW;
    Map deliveredMessages = new LinkedHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BrokerConsumers(Protocol protocol) {
        this.protocol = protocol;
        MQThread mQThread = new MQThread(this, "Broker Monitor");
        mQThread.setDaemon(true);
        mQThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.valid = false;
        Set set = this.activeConsumers;
        synchronized (set) {
            this.activeConsumers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventOccured(EventType eventType, Reason reason, Object object, Object object2, Object object3, Object object4) {
        if (eventType != EventType.BUSY_STATE_CHANGED && !$assertionsDisabled) {
            throw new AssertionError();
        }
        Consumer consumer = (Consumer)object;
        Set set = this.activeConsumers;
        synchronized (set) {
            if (consumer.isBusy()) {
                this.activeConsumers.add(consumer);
            }
            this.activeConsumers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumers(BrokerAddress brokerAddress) throws BrokerException {
        Object object;
        HashSet<ConsumerUID> hashSet = new HashSet<ConsumerUID>();
        Object object2 = this.consumers;
        synchronized (object2) {
            object = this.consumers.keySet().iterator();
            while (object.hasNext()) {
                ConsumerUID consumerUID = (ConsumerUID)object.next();
                if (!brokerAddress.equals(consumerUID.getBrokerAddress())) continue;
                hashSet.add(consumerUID);
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (ConsumerUID)object2.next();
            this.removeConsumer((ConsumerUID)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessagesToRemote(PacketReference packetReference, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Consumer consumer = (Consumer)iterator.next();
            ConsumerUID consumerUID = consumer.getStoredConsumerUID();
            if (consumer.getConsumerUID().isNoAck()) continue;
            ackEntry ackEntry2 = new ackEntry(packetReference, consumer.getConsumerUID(), consumerUID);
            Map map = this.deliveredMessages;
            synchronized (map) {
                this.deliveredMessages.put(ackEntry2, ackEntry2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException {
        Object object;
        HashSet<ConsumerUID> hashSet = new HashSet<ConsumerUID>();
        Object object2 = this.consumers;
        synchronized (object2) {
            object = this.consumers.keySet().iterator();
            while (object.hasNext()) {
                ConsumerUID consumerUID = (ConsumerUID)object.next();
                if (!connectionUID.equals(consumerUID.getConnectionUID())) continue;
                hashSet.add(consumerUID);
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (ConsumerUID)object2.next();
            this.removeConsumer((ConsumerUID)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ConsumerUID consumerUID) throws BrokerException {
        Consumer consumer = (Consumer)this.consumers.remove(consumerUID);
        if (consumer == null) {
            return;
        }
        consumer.pause("MultiBroker - removing consumer");
        Destination destination = Destination.getDestination(consumer.getDestinationUID());
        Object v = this.listeners.remove(consumerUID);
        if (v != null) {
            consumer.removeEventListener(v);
        }
        this.activeConsumers.remove(consumer);
        LinkedHashSet<PacketReference> linkedHashSet = new LinkedHashSet<PacketReference>();
        Map map = this.deliveredMessages;
        synchronized (map) {
            Iterator iterator = this.deliveredMessages.values().iterator();
            while (iterator.hasNext()) {
                ackEntry ackEntry2 = (ackEntry)iterator.next();
                if (ackEntry2.getConsumerUID() != consumerUID) continue;
                iterator.remove();
                if (consumer.isFalconRemote()) {
                    ackEntry2.acknowledged(false);
                    continue;
                }
                linkedHashSet.add(ackEntry2.getReference());
            }
        }
        consumer.destroyConsumer(linkedHashSet, false, false);
        if (destination != null) {
            destination.removeConsumer(consumerUID, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeMessageFromRemote(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        ackEntry ackEntry2 = new ackEntry(sysMessageID, consumerUID, null);
        Map map = this.deliveredMessages;
        synchronized (map) {
            ackEntry ackEntry3 = (ackEntry)this.deliveredMessages.remove(ackEntry2);
            if (ackEntry3 == null) {
                return;
            }
            ackEntry3.acknowledged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Consumer consumer) throws BrokerException {
        block21: {
            int n;
            DestinationUID destinationUID;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (!(consumer instanceof Subscription)) {
                this.consumers.put(consumerUID, consumer);
                this.listeners.put(consumerUID, consumer.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
            }
            int n2 = (destinationUID = consumer.getDestinationUID()).isQueue() ? 1 : 2;
            Destination destination = null;
            try {
                for (n = 0; n < 2 && destination == null; ++n) {
                    destination = Destination.getDestination(destinationUID.getName(), n2, true, true);
                    try {
                        if (destination == null) continue;
                        destination.incrementRefCount();
                        break;
                    }
                    catch (BrokerException brokerException) {
                        destination = null;
                    }
                }
                if (destination == null) {
                    throw new BrokerException("Unable to attach to destination " + destinationUID);
                }
            }
            catch (IOException iOException) {
                throw new BrokerException("Unable to autocreate destination " + destinationUID, iOException);
            }
            try {
                if (!consumer.getDestinationUID().isQueue() && !(consumer instanceof Subscription) && consumer.getSubscription() == null) {
                    consumer.setFalconRemote(true);
                } else {
                    n = 100;
                    if (destination != null) {
                        n = destination.getMaxPrefetch();
                    } else {
                        this.logger.log(8, "Internal Error: Unknown destination for consumer " + consumer.getDestinationUID() + " can not determine prefetch ");
                    }
                    if (n > BTOBFLOW) {
                        n = BTOBFLOW;
                    }
                    consumer.setPrefetch(n);
                }
                try {
                    if (consumer.getSubscription() == null) {
                        destination.addConsumer(consumer, false);
                    }
                }
                catch (SelectorFormatException selectorFormatException) {
                    throw new BrokerException("unable to add destination " + destination, selectorFormatException);
                }
                if (consumer instanceof Subscription || !consumer.isBusy()) break block21;
                Set set = this.activeConsumers;
                synchronized (set) {
                    this.activeConsumers.add(consumer);
                    this.activeConsumers.notify();
                }
            }
            finally {
                destination.decrementRefCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.valid) {
            boolean bl;
            Object object;
            Consumer consumer = null;
            Object object2 = this.activeConsumers;
            synchronized (object2) {
                while (this.valid && this.activeConsumers.isEmpty()) {
                    try {
                        this.activeConsumers.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.valid) {
                    object = this.activeConsumers.iterator();
                    consumer = (Consumer)object.next();
                    object.remove();
                    if (consumer.isBusy()) {
                        this.activeConsumers.add(consumer);
                    }
                }
            }
            if (consumer == null || (object2 = consumer.getAndFillNextPacket(null)) == null) continue;
            object = new HashSet();
            ((HashSet)object).add(consumer);
            boolean bl2 = bl = ((PacketReference)object2).getMessageDeliveredAck(consumer.getConsumerUID()) || consumer.isPaused();
            if (!consumer.getConsumerUID().isNoAck()) {
                ackEntry ackEntry2 = new ackEntry((PacketReference)object2, consumer.getConsumerUID(), consumer.getStoredConsumerUID());
                Map map = this.deliveredMessages;
                synchronized (map) {
                    this.deliveredMessages.put(ackEntry2, ackEntry2);
                }
            }
            this.protocol.sendMessage((PacketReference)object2, (Collection)object, bl);
        }
    }

    static {
        $assertionsDisabled = !BrokerConsumers.class.desiredAssertionStatus();
        BTOBFLOW = Globals.getConfig().getIntProperty("imq.cluster.consumerFlowLimit", 1000);
    }

    class ackEntry {
        ConsumerUID uid = null;
        ConsumerUID storedcid = null;
        WeakReference pref = null;
        SysMessageID id = null;
        BrokerAddress address = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ackEntry(SysMessageID sysMessageID, ConsumerUID consumerUID, BrokerAddress brokerAddress) {
            if (!$assertionsDisabled && sysMessageID == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && consumerUID == null) {
                throw new AssertionError();
            }
            this.id = sysMessageID;
            this.uid = consumerUID;
            this.address = brokerAddress;
            this.pref = null;
        }

        public BrokerAddress getBrokerAddress() {
            return this.address;
        }

        public ConsumerUID getConsumerUID() {
            return this.uid;
        }

        public SysMessageID getSysMessageID() {
            return this.id;
        }

        public PacketReference getReference() {
            return (PacketReference)this.pref.get();
        }

        public ackEntry(PacketReference packetReference, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
            this.pref = new WeakReference<PacketReference>(packetReference);
            this.id = packetReference.getSysMessageID();
            this.storedcid = consumerUID2;
            this.uid = consumerUID;
        }

        public void acknowledged(boolean bl) {
            block6: {
                if (!$assertionsDisabled && this.pref == null) {
                    throw new AssertionError();
                }
                PacketReference packetReference = (PacketReference)this.pref.get();
                try {
                    if (packetReference == null) {
                        packetReference = Destination.get(this.id);
                    }
                    if (packetReference == null) {
                        return;
                    }
                    if (packetReference.acknowledged(this.uid, this.storedcid, !this.uid.isDupsOK(), bl)) {
                        Destination destination = Destination.getDestination(packetReference.getDestinationUID());
                        destination.removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                }
                catch (Exception exception) {
                    BrokerConsumers.this.logger.logStack(4, "Unable to process acknowledgement, Ignoring", exception);
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError(packetReference);
                }
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof ackEntry)) {
                return false;
            }
            ackEntry ackEntry2 = (ackEntry)object;
            return this.uid.equals(ackEntry2.uid) && this.id.equals(ackEntry2.id);
        }

        public int hashCode() {
            return this.id.hashCode() * 15 + this.uid.hashCode();
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$jmsserver$multibroker$BrokerConsumers == null ? (class$com$sun$messaging$jmq$jmsserver$multibroker$BrokerConsumers = BrokerConsumers.class$("com.sun.messaging.jmq.jmsserver.multibroker.BrokerConsumers")) : class$com$sun$messaging$jmq$jmsserver$multibroker$BrokerConsumers).desiredAssertionStatus();
        }
    }
}

