/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;

public class UpdateDestinationHandler
extends AdminCmdHandler {
    public UpdateDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + hashtable);
        }
        String string = (String)hashtable.get("JMQDestination");
        DestinationInfo destinationInfo = (DestinationInfo)this.getBodyObject(packet);
        int n = 200;
        String string2 = null;
        try {
            object = Destination.getDestination(destinationInfo.name, DestType.isQueue(destinationInfo.type));
            if (object == null) {
                string2 = rb.getString("B4017", destinationInfo.name);
                n = 404;
            } else {
                if (destinationInfo.isModified(4)) {
                    int bl = destinationInfo.maxMessages;
                    ((Destination)object).setCapacity(bl);
                }
                if (destinationInfo.isModified(16)) {
                    SizeString sizeString = new SizeString();
                    sizeString.setBytes(destinationInfo.maxMessageSize);
                    ((Destination)object).setMaxByteSize(sizeString);
                }
                if (destinationInfo.isModified(8)) {
                    SizeString sizeString = new SizeString();
                    sizeString.setBytes(destinationInfo.maxMessageBytes);
                    ((Destination)object).setByteCapacity(sizeString);
                }
                if (destinationInfo.isModified(32)) {
                    int n2 = destinationInfo.destScope;
                    ((Destination)object).setScope(n2);
                }
                if (destinationInfo.isModified(64)) {
                    int n3 = destinationInfo.destLimitBehavior;
                    ((Destination)object).setLimitBehavior(n3);
                }
                if (destinationInfo.isModified(128)) {
                    int n4 = destinationInfo.maxPrefetch;
                    ((Destination)object).setMaxPrefetch(n4);
                }
                if (destinationInfo.isModified(256)) {
                    int n5 = destinationInfo.destCDP;
                    ((Destination)object).setClusterDeliveryPolicy(n5);
                }
                if (destinationInfo.isModified(512)) {
                    int n6 = destinationInfo.maxActiveConsumers;
                    ((Destination)object).setMaxActiveConsumers(n6);
                }
                if (destinationInfo.isModified(1024)) {
                    int n7 = destinationInfo.maxFailoverConsumers;
                    ((Destination)object).setMaxFailoverConsumers(n7);
                }
                if (destinationInfo.isModified(2048)) {
                    int n8 = destinationInfo.maxProducers;
                    ((Destination)object).setMaxProducers(n8);
                }
                if (destinationInfo.isModified(4096)) {
                    int n9 = destinationInfo.maxNumSharedConsumers;
                    ((Destination)object).setMaxSharedConsumers(n9);
                }
                if (destinationInfo.isModified(8192)) {
                    int n10 = destinationInfo.sharedConsumerFlowLimit;
                    ((Destination)object).setSharedFlowLimit(n10);
                }
                if (destinationInfo.isModified(16384)) {
                    boolean bl = destinationInfo.useDMQ;
                    ((Destination)object).setUseDMQ(bl);
                }
                ((Destination)object).update();
            }
        }
        catch (Exception exception) {
            string2 = UpdateDestinationHandler.getMessageFromException(exception);
            n = 500;
        }
        object = new Packet(iMQConnection.useDirectBuffers());
        ((Packet)object).setPacketType(5);
        UpdateDestinationHandler.setProperties((Packet)object, 41, n, string2);
        this.parent.sendReply(iMQConnection, packet, (Packet)object);
        return true;
    }
}

