/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class SessionHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        int n = 200;
        String string = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            object = packet.getProperties();
            Session session = null;
            if (packet.getPacketType() == 68) {
                Integer n2 = object == null ? null : (Integer)((Hashtable)object).get("JMQAckMode");
                int n3 = n2 == null ? 0 : n2;
                session = Session.createSession(iMQConnection.getConnectionUID());
                session.setAckType(n3);
                iMQConnection.attachSession(session);
                hashtable.put("JMQSessionID", new Long(session.getSessionUID().longValue()));
            } else {
                if (!$assertionsDisabled && packet.getPacketType() != 70) {
                    throw new AssertionError();
                }
                Long l = (Long)((Hashtable)object).get("JMQSessionID");
                if (l == null) {
                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "protocol error, no session"));
                }
                SessionUID sessionUID = new SessionUID(l);
                if (!$assertionsDisabled && iMQConnection.getSession(sessionUID) == null) {
                    throw new AssertionError();
                }
                Session.closeSession(sessionUID);
                iMQConnection.closeSession(sessionUID);
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            string = exception.getMessage();
            if (exception instanceof BrokerException) {
                n = ((BrokerException)exception).getStatusCode();
                bl = false;
            } else {
                n = 500;
                bl = true;
            }
            if (bl) {
                this.logger.logStack(8, Globals.getBrokerResources().getString("B4117", " session "), exception);
            }
            this.logger.log(8, exception.getMessage());
        }
        hashtable.put("JMQStatus", new Integer(n));
        if (string != null) {
            hashtable.put("JMQReason", string);
        }
        if (packet.getSendAcknowledge()) {
            object = new Packet(iMQConnection.useDirectBuffers());
            ((Packet)object).setConsumerID(packet.getConsumerID());
            ((Packet)object).setPacketType(packet.getPacketType() + 1);
            ((Packet)object).setProperties(hashtable);
            iMQConnection.sendControlMessage((Packet)object);
        }
        return true;
    }

    static {
        $assertionsDisabled = !SessionHandler.class.desiredAssertionStatus();
        DEBUG = false;
    }
}

