/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

class TransactionInformation {
    ArrayList published = new ArrayList();
    HashMap consumed = new HashMap();
    TransactionState state;
    HashMap cuidToStored = new HashMap();
    HashMap orphanedMessages = new HashMap();
    TransactionUID tid = null;

    public TransactionInformation(TransactionUID transactionUID, TransactionState transactionState) {
        this.state = transactionState;
        this.tid = transactionUID;
    }

    public String toString() {
        return "TransactionInfo[" + this.tid + "]";
    }

    public void addOrphanAck(SysMessageID sysMessageID, ConsumerUID consumerUID) {
        ArrayList<ConsumerUID> arrayList = (ArrayList<ConsumerUID>)this.orphanedMessages.get(sysMessageID);
        if (arrayList == null) {
            arrayList = new ArrayList<ConsumerUID>();
            this.orphanedMessages.put(sysMessageID, arrayList);
        }
        arrayList.add(consumerUID);
    }

    public Map getOrphanAck() {
        return this.orphanedMessages;
    }

    public Hashtable getDebugState() {
        Map.Entry entry;
        Iterator iterator;
        Cloneable cloneable;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("state", this.state.getDebugState());
        hashtable.put("consumed#", new Integer(this.consumed.size()));
        hashtable.put("published#", new Integer(this.published.size()));
        hashtable.put("cuidToStored#", new Integer(this.cuidToStored.size()));
        if (this.cuidToStored.size() > 0) {
            cloneable = new Hashtable();
            iterator = hashtable.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                ((Hashtable)cloneable).put(entry.getKey().toString(), entry.getValue().toString());
            }
            hashtable.put("cuidToStored", cloneable);
        }
        if (this.consumed.size() > 0) {
            cloneable = new Hashtable();
            iterator = this.consumed.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String string = entry.getKey().toString();
                ArrayList arrayList = (ArrayList)entry.getValue();
                if (arrayList.size() == 0) continue;
                if (arrayList.size() == 1) {
                    ((Hashtable)cloneable).put(string, arrayList.get(0).toString());
                    continue;
                }
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    vector.add(arrayList.get(i).toString());
                }
                ((Hashtable)cloneable).put(string, vector);
            }
            if (((Hashtable)cloneable).size() > 0) {
                hashtable.put("consumed", cloneable);
            }
        }
        if (this.published.size() > 0) {
            cloneable = new Vector();
            for (int i = 0; i < this.published.size(); ++i) {
                ((Vector)cloneable).add(this.published.get(i).toString());
            }
            hashtable.put("published", cloneable);
        }
        return hashtable;
    }

    public List getPublishedMessages() {
        return this.published;
    }

    public int getNPublishedMessages() {
        if (this.published != null) {
            return this.published.size();
        }
        return 0;
    }

    public HashMap getConsumedMessages() {
        return this.consumed;
    }

    public HashMap getStoredConsumerUIDs() {
        return this.cuidToStored;
    }

    public int getNConsumedMessages() {
        if (this.consumed != null) {
            return this.consumed.size();
        }
        return 0;
    }

    public TransactionState getState() {
        return this.state;
    }

    public void addPublishedMessage(SysMessageID sysMessageID) {
        this.published.add(sysMessageID);
    }

    public void addConsumedMessage(SysMessageID sysMessageID, ConsumerUID consumerUID, ConsumerUID consumerUID2) {
        ArrayList<ConsumerUID> arrayList = (ArrayList<ConsumerUID>)this.consumed.get(sysMessageID);
        if (arrayList == null) {
            arrayList = new ArrayList<ConsumerUID>();
            this.consumed.put(sysMessageID, arrayList);
        }
        arrayList.add(consumerUID);
        this.cuidToStored.put(consumerUID, consumerUID2);
    }
}

