/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.server.AccessControlException;
import com.sun.messaging.jmq.auth.server.model.AccessControlModel;
import com.sun.messaging.jmq.auth.server.model.Subject;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class JMQFileAccessControlModel
implements AccessControlModel {
    public static final String VERSION = "JMQFileAccessControlModel/100";
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String DEFAULT_ACL_FILENAME = "accesscontrol.properties";
    public static boolean DEBUG = false;
    private static final Logger logger = Globals.getLogger();
    private static final String VERSION_PROPNAME = "version";
    private static final String ALLOW_SUFFIX = ".allow";
    private static final String DENY_SUFFIX = ".deny";
    private static final String USER_SUFFIX = ".user";
    private static final String GROUP_SUFFIX = ".group";
    private static final String ALL = "*";
    private static final String WILDCARD = "*";
    private static final int ALLOW_BIT = 0;
    private static final int DENY_BIT = 1;
    private String type;
    private Properties authProps;
    private String aclfname = null;
    private Properties acs = null;

    public String getType() {
        return TYPE;
    }

    public void initialize(String string, Properties properties) throws AccessControlException {
        this.type = string;
        if (!string.equals(TYPE)) {
            Object[] objectArray = new String[]{string, TYPE, this.getClass().getName()};
            String string2 = Globals.getBrokerResources().getKString("B4072", objectArray);
            logger.log(32, string2);
            throw new AccessControlException(string2);
        }
        this.authProps = properties;
        this.load();
    }

    public void load() throws AccessControlException {
        String string = this.authProps.getProperty("imq.user_repository.file.dirpath", Globals.getInstanceEtcDir());
        this.aclfname = this.authProps.getProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        if (this.aclfname == null) {
            String string2 = Globals.getBrokerResources().getKString("B4046", this.type);
            logger.log(32, string2);
            throw new AccessControlException(string2);
        }
        String string3 = string + File.separator + this.aclfname;
        this.acs = new Properties();
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(string3);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.acs.load(bufferedInputStream);
            bufferedInputStream.close();
            fileInputStream.close();
            String string4 = this.acs.getProperty(VERSION_PROPNAME);
            if (string4 == null || !string4.equals(VERSION)) {
                string4 = string4 == null ? "null" : string4;
                Object[] objectArray = new String[]{VERSION_PROPNAME, string4, this.aclfname, VERSION, this.getClass().getName()};
                String string5 = Globals.getBrokerResources().getKString("B4073", objectArray);
                logger.log(32, string5);
                throw new AccessControlException(string5);
            }
        }
        catch (IOException iOException) {
            this.acs = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            logger.log(32, iOException.getMessage(), iOException);
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4047", this.type) + " - " + iOException.getMessage());
        }
    }

    public void checkConnectionPermission(String string, String string2, Subject subject) throws AccessControlException {
        Set set = subject.getGroups();
        String string3 = subject.getUser();
        this.validate(string3, set);
        this.load();
        ArrayList arrayList = this.getRules("connection", string2, null, false);
        this.computePermission(string3, set, arrayList, GROUP_SUFFIX);
    }

    public void checkDestinationPermission(String string, String string2, Subject subject, String string3, String string4, String string5) throws AccessControlException {
        Set set = subject.getGroups();
        String string6 = subject.getUser();
        this.validate(string6, set);
        this.load();
        ArrayList arrayList = this.getRules(string5, string4, string3, true);
        this.computePermission(string6, set, arrayList, GROUP_SUFFIX);
    }

    private void computePermission(String string, Set set, ArrayList arrayList, String string2) throws AccessControlException {
        BitSet bitSet = new BitSet(2);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            HashMap hashMap = this.getRuleRightHand(string3 + ALLOW_SUFFIX + USER_SUFFIX);
            HashMap hashMap2 = this.getRuleRightHand(string3 + DENY_SUFFIX + USER_SUFFIX);
            BitSet bitSet2 = this.getPermission("*", hashMap, hashMap2);
            BitSet bitSet3 = this.getPermission(string, hashMap, hashMap2);
            BitSet bitSet4 = new BitSet(2);
            BitSet bitSet5 = new BitSet(2);
            if (set != null && set.size() > 0) {
                if (set.size() >= Integer.MAX_VALUE) {
                    throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "too many groups for user " + string));
                }
                hashMap = this.getRuleRightHand(string3 + ALLOW_SUFFIX + string2);
                hashMap2 = this.getRuleRightHand(string3 + DENY_SUFFIX + string2);
                bitSet5 = this.getPermission("*", hashMap, hashMap2);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    bitSet4.or(this.getPermission(string4, hashMap, hashMap2));
                }
            }
            if (DEBUG) {
                logger.log(4, "computePermission:ubs=" + bitSet3);
                logger.log(4, "computePermission:gbs=" + bitSet4);
                logger.log(4, "computePermission:ubsall=" + bitSet2);
                logger.log(4, "computePermission:gbsall=" + bitSet5);
            }
            this.overridePermission(bitSet4, bitSet3);
            this.overridePermission(bitSet5, bitSet2);
            this.overridePermission(bitSet5, bitSet4);
            if (DEBUG) {
                logger.log(4, "computePermission:" + string3 + ":bs=" + bitSet5);
            }
            this.overridePermission(bitSet, bitSet5);
            if (!DEBUG) continue;
            logger.log(4, "computePermission:total=" + bitSet);
        }
        if (bitSet.get(0) && !bitSet.get(1)) {
            return;
        }
        throw new AccessControlException(Globals.getBrokerResources().getKString("B4051", string));
    }

    private void overridePermission(BitSet bitSet, BitSet bitSet2) {
        if (bitSet2.get(0) && bitSet2.get(1)) {
            return;
        }
        if (bitSet2.get(0)) {
            bitSet.set(0);
            bitSet.clear(1);
        }
        if (bitSet2.get(1)) {
            bitSet.set(1);
            bitSet.clear(0);
        }
    }

    private BitSet getPermission(String string, HashMap hashMap, HashMap hashMap2) {
        BitSet bitSet = new BitSet(2);
        if (hashMap != null && hashMap.get(string) != null) {
            bitSet.set(0);
        }
        if (hashMap2 != null && hashMap2.get(string) != null) {
            bitSet.set(1);
        }
        if (bitSet.get(0) && bitSet.get(1)) {
            bitSet.clear(0);
            bitSet.clear(1);
        }
        return bitSet;
    }

    private ArrayList getRules(String string, String string2, String string3, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = null;
        if (string2 == null && string3 != null) {
            string4 = string + "." + string3;
            arrayList.add(string4);
            return arrayList;
        }
        string4 = string + "." + "*";
        if (string3 != null) {
            string4 = string4 + "." + string3;
        }
        arrayList.add(string4);
        if (!string2.equals("*")) {
            string4 = string + "." + string2;
            if (string3 != null) {
                string4 = string4 + "." + string3;
            }
            arrayList.add(string4);
        }
        return arrayList;
    }

    private HashMap getRuleRightHand(String string) {
        String string2;
        if (DEBUG) {
            logger.log(4, "check permission " + string);
        }
        if ((string2 = this.acs.getProperty(string)) == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreElements()) {
            hashMap.put(stringTokenizer.nextToken(), "");
        }
        if (hashMap.size() == 0) {
            return null;
        }
        return hashMap;
    }

    private void validate(String string, Set set) throws AccessControlException {
        if (string == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4048"));
        }
        if (string.equals("*")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4049", "*"));
        }
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) {
                    iterator.remove();
                    continue;
                }
                if (!string2.equals("*")) continue;
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4069", "*"));
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DEBUG = true;
        Properties properties = new Properties();
        properties.setProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        JMQFileAccessControlModel jMQFileAccessControlModel = new JMQFileAccessControlModel();
        jMQFileAccessControlModel.initialize(TYPE, properties);
        String string = "akang";
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("student");
        hashSet.add("Accounting Managers");
        ArrayList arrayList = jMQFileAccessControlModel.getRules("topic", "abc", "produce", true);
        System.out.println(arrayList);
        jMQFileAccessControlModel.computePermission(string, hashSet, arrayList, GROUP_SUFFIX);
        System.out.println("--DONE--");
    }
}

