/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.FailedLoginException;
import com.sun.messaging.jmq.auth.LoginException;
import com.sun.messaging.jmq.auth.server.AccessControlContext;
import com.sun.messaging.jmq.auth.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.server.model.Subject;
import com.sun.messaging.jmq.auth.server.model.UserRepository;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.util.BASE64Decoder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Properties;

public class JMQBasicAuthenticationHandler
implements AuthenticationProtocolHandler {
    private AccessControlContext acc = null;
    private Properties authProps;
    private Object cacheData = null;
    private boolean cacheDataMaystaled;

    public String getType() {
        return "basic";
    }

    public byte[] init(int n, Properties properties, Object object, boolean bl) throws LoginException {
        this.authProps = properties;
        this.cacheData = object;
        this.cacheDataMaystaled = bl;
        return null;
    }

    public byte[] handleReponse(byte[] byArray, int n) throws LoginException {
        Subject subject = null;
        this.acc = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            String string = dataInputStream.readUTF();
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            String string2 = dataInputStream.readUTF();
            String string3 = new String(bASE64Decoder.decodeBuffer(string2), "UTF8");
            dataInputStream.close();
            String string4 = this.authProps.getProperty("imq.authentication." + this.getType() + ".user_repository");
            if (string4 == null || string4.trim().equals("")) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4041", this.getType()));
            }
            String string5 = this.authProps.getProperty("imq.user_repository." + string4 + ".class");
            if (string5 == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4042", string4, this.getType()));
            }
            UserRepository userRepository = (UserRepository)Class.forName(string5).newInstance();
            userRepository.open(this.getType(), this.authProps, this.cacheData, this.cacheDataMaystaled);
            subject = userRepository.findMatch(string, string3, null, this.getMatchType());
            this.cacheData = userRepository.getCacheData();
            userRepository.close();
            userRepository = null;
            if (subject == null) {
                FailedLoginException failedLoginException = new FailedLoginException(Globals.getBrokerResources().getKString("B4051", string));
                failedLoginException.setUser(string);
                throw failedLoginException;
            }
            this.acc = new JMQAccessControlContext(subject, this.authProps);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassNotFoundException: " + classNotFoundException.getMessage()));
        }
        catch (IOException iOException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IOException: " + iOException.getMessage()));
        }
        catch (InstantiationException instantiationException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "InstantiationException: " + instantiationException.getMessage()));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "IllegalAccessException: " + illegalAccessException.getMessage()));
        }
        catch (ClassCastException classCastException) {
            throw new LoginException(Globals.getBrokerResources().getString("B4117", "ClassCastException: " + classCastException.getMessage()));
        }
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    public Object getCacheData() {
        return this.cacheData;
    }

    public void logout() {
    }

    public String getMatchType() {
        return this.getType();
    }
}

