/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.license.LicenseManager;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ClusterDiscoveryService;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.LoggerManager;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryManager;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Properties;

public class Globals {
    public static final String IMQ = "imq";
    public static final String HOSTNAME_ALL = "*";
    private static GlobalErrorHandler errhandler = null;
    private static final Object lock = Globals.class;
    private static Globals globals = null;
    private static BrokerResources br = null;
    private static Logger logger = null;
    private static Version version = null;
    private static PortMapper portMapper = null;
    private static ClusterDiscoveryService cds = null;
    private static LicenseManager licenseManager = null;
    private static LicenseBase currentLicense = null;
    private static ServiceManager serviceManager = null;
    private static ConnectionManager connectionManager = null;
    private static ClusterBroadcast messageBus = null;
    private static MetricManager metricManager = null;
    private static TransactionList transList = null;
    private static JMQTimer timer = null;
    private static boolean clearProps = false;
    private static boolean HAEnabled = false;
    private static String hostname = null;
    private static BrokerAddress myaddr = null;
    private static InetAddress brokerInetAddress = null;
    public static int HA_UNKNOWN = 0;
    public static int HA_STANDBY = 1;
    public static int HA_ACTIVE = 2;
    private static int HAState = HA_UNKNOWN;
    private static PacketRouter[] routers = null;
    private static MemoryManager mem_manager = null;
    private static MQAuditSession audit = null;
    public static String INTERNAL_PREFIX = "MQ_";
    public static final String DEFAULT_INSTANCE = "imqbroker";
    private static String configName = "imqbroker";
    private static Properties parameters = null;
    private static BrokerConfig config = null;
    private static MQAddress mqAddress = null;
    public static final String JMQ_HOME_PROPERTY = "imq.home";
    public static final String JMQ_VAR_HOME_PROPERTY = "imq.varhome";
    public static final String JMQ_INSTANCES_HOME_PROPERTY = "imq.instanceshome";
    public static final String JMQ_ETC_HOME_PROPERTY = "imq.etchome";
    public static final String JMQ_LIB_HOME_PROPERTY = "imq.libhome";
    public static final String JMQ_HOME_default = ".";
    public static final String JMQ_VAR_HOME_default = "var";
    public static final String JMQ_ETC_HOME_default = "etc";
    public static final String JMQ_HOME;
    public static final String JMQ_VAR_HOME;
    public static final String JMQ_ETC_HOME;
    public static final String JMQ_LIB_HOME;
    public static final String INSTANCES_HOME_DIRECTORY = "instances";
    public static final String JMQ_INSTANCES_HOME;
    public static final String JMQ_BROKER_PROP_LOC;
    public static final String KEYSTORE_USE_PASSFILE_PROP = "imq.passfile.enabled";
    public static final String KEYSTORE_PASSDIR_PROP = "imq.passfile.dirpath";
    public static final String KEYSTORE_PASSFILE_PROP = "imq.passfile.name";

    private Globals() {
    }

    public static void init(Properties properties, boolean bl) {
        clearProps = bl;
        if (properties == null) {
            return;
        }
        configName = properties.getProperty("imq.instancename", DEFAULT_INSTANCE);
        properties.setProperty(JMQ_VAR_HOME_PROPERTY, JMQ_VAR_HOME);
        properties.setProperty(JMQ_LIB_HOME_PROPERTY, JMQ_LIB_HOME);
        properties.setProperty(JMQ_ETC_HOME_PROPERTY, JMQ_ETC_HOME);
        properties.setProperty(JMQ_INSTANCES_HOME_PROPERTY, JMQ_INSTANCES_HOME);
        properties.setProperty(JMQ_HOME_PROPERTY, JMQ_HOME);
        properties.setProperty("imq.instancename", configName);
        parameters = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryManager getMemManager() {
        if (mem_manager == null) {
            Object object = lock;
            synchronized (object) {
                if (mem_manager == null) {
                    mem_manager = new MemoryManager();
                }
            }
        }
        return mem_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Globals getGlobals() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new Globals();
                }
            }
        }
        return globals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMQTimer getTimer() {
        if (timer == null) {
            Object object = lock;
            synchronized (object) {
                if (timer == null) {
                    timer = new JMQTimer(true);
                    JMQTimer.setLogger(Globals.getLogger());
                }
            }
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerResources getBrokerResources() {
        if (br == null) {
            Object object = lock;
            synchronized (object) {
                if (br == null) {
                    br = BrokerResources.getResources(Locale.getDefault());
                }
            }
        }
        return br;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        if (logger == null) {
            Object object = lock;
            synchronized (object) {
                if (logger == null) {
                    logger = new Logger(JMQ_VAR_HOME);
                    logger.setResourceBundle(Globals.getBrokerResources());
                }
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version getVersion() {
        if (version == null) {
            Object object = lock;
            synchronized (object) {
                if (version == null) {
                    version = new Version();
                }
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortMapper getPortMapper() {
        if (portMapper == null) {
            Object object = lock;
            synchronized (object) {
                if (portMapper == null) {
                    portMapper = new PortMapper(configName);
                    try {
                        portMapper.setParameters(Globals.getConfig());
                        portMapper.bind();
                    }
                    catch (PropertyUpdateException propertyUpdateException) {
                        Logger logger = Globals.getLogger();
                        logger.log(32, propertyUpdateException.getMessage());
                    }
                }
            }
        }
        return portMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClusterDiscoveryService getClusterDiscoveryService() {
        if (!HAEnabled) {
            return null;
        }
        if (cds == null) {
            Object object = lock;
            synchronized (object) {
                if (cds == null) {
                    cds = new ClusterDiscoveryService(configName, Globals.getHostname());
                    try {
                        cds.init();
                    }
                    catch (PropertyUpdateException propertyUpdateException) {
                        Logger logger = Globals.getLogger();
                        logger.log(32, propertyUpdateException.getMessage());
                    }
                }
            }
        }
        return cds;
    }

    public static LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = new LicenseManager();
        }
        return licenseManager;
    }

    public static LicenseBase getCurrentLicense(String string) throws BrokerException {
        if (currentLicense == null) {
            currentLicense = Globals.getLicenseManager().getLicense(string);
        }
        return currentLicense;
    }

    public static String getHostname() {
        return hostname;
    }

    public static boolean getHAEnabled() {
        return HAEnabled;
    }

    public static int getHAState() {
        return HAState;
    }

    public static ServiceManager getServiceManager() {
        return serviceManager;
    }

    public static MetricManager getMetricManager() {
        return metricManager;
    }

    public static TransactionList getTransactionList() {
        return transList;
    }

    public static ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public static ClusterBroadcast getClusterBroadcast() {
        return messageBus;
    }

    public static BrokerAddress getMyAddress() {
        return myaddr;
    }

    public static void setHostname(String string) {
        hostname = string;
    }

    public static void setHAEnabled(boolean bl) {
        HAEnabled = bl;
    }

    public static void setHAState(int n) {
        HAState = n;
    }

    public static void setServiceManager(ServiceManager serviceManager) {
        Globals.serviceManager = serviceManager;
    }

    public static void setMetricManager(MetricManager metricManager) {
        Globals.metricManager = metricManager;
    }

    public static void setTransactionList(TransactionList transactionList) {
        transList = transactionList;
    }

    public static void setConnectionManager(ConnectionManager connectionManager) {
        Globals.connectionManager = connectionManager;
    }

    public static void setClusterBroadcast(ClusterBroadcast clusterBroadcast) {
        messageBus = clusterBroadcast;
    }

    public static void setMyAddress(BrokerAddress brokerAddress) {
        myaddr = brokerAddress;
    }

    public static void setBrokerInetAddress(InetAddress inetAddress) {
        brokerInetAddress = inetAddress;
    }

    public static InetAddress getBrokerInetAddress() {
        return brokerInetAddress;
    }

    public static String getBrokerHostName() {
        if (hostname != null && !hostname.equals(HOSTNAME_ALL)) {
            return hostname;
        }
        if (brokerInetAddress == null) {
            return null;
        }
        return brokerInetAddress.getCanonicalHostName();
    }

    public static void setGlobalErrorHandler(GlobalErrorHandler globalErrorHandler) {
        errhandler = globalErrorHandler;
    }

    public static void handleGlobalError(Throwable throwable, String string) {
        if (!errhandler.handleGlobalError(throwable, string)) {
            logger.logStack(32, "B3100", "received unexpected exception  ", throwable);
            Throwable throwable2 = new Throwable();
            throwable2.fillInStackTrace();
            logger.logStack(4, "Calling stack trace", throwable2);
        }
    }

    public static void setPacketRouters(PacketRouter[] packetRouterArray) {
        routers = packetRouterArray;
    }

    public static PacketRouter getPacketRouter(int n) throws IndexOutOfBoundsException {
        if (routers == null || n > routers.length) {
            throw new IndexOutOfBoundsException(Globals.getBrokerResources().getKString("B4117", "requested invalid packet router " + n));
        }
        return routers[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerConfig getConfig() {
        if (config == null) {
            Object object = lock;
            synchronized (object) {
                if (config == null) {
                    Object object2;
                    try {
                        config = new BrokerConfig(configName, parameters, clearProps);
                    }
                    catch (BrokerException brokerException) {
                        Globals.getLogger().logStack(32, "Internal Error: Unable to load broker, configuration properties are not available. Exiting", brokerException.getCause());
                        System.exit(-1);
                    }
                    if (parameters != null) {
                        object2 = parameters.propertyNames();
                        Properties properties = System.getProperties();
                        while (object2.hasMoreElements()) {
                            String string = (String)object2.nextElement();
                            if (string.startsWith("imq.")) continue;
                            properties.put(string, parameters.getProperty(string));
                        }
                    }
                    object2 = Globals.getLogger();
                    ((Logger)object2).configure(config, IMQ);
                    new LoggerManager(logger, config);
                    ((Logger)object2).open();
                }
            }
        }
        return config;
    }

    public static void reInitializeConfig(String string) {
        config = null;
        if (string == null) {
            string = DEFAULT_INSTANCE;
        }
        configName = string;
    }

    public static String getConfigName() {
        return configName;
    }

    public static String getInstanceDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName;
    }

    public static String getInstanceEtcDir() {
        return JMQ_INSTANCES_HOME + File.separator + configName + File.separator + JMQ_ETC_HOME_default;
    }

    public static Store getStore() throws BrokerException {
        return StoreManager.getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQAuditSession getAuditSession() {
        if (audit == null) {
            Object object = lock;
            synchronized (object) {
                if (audit == null) {
                    try {
                        audit = MQAuditService.getAuditSession();
                        LockFile lockFile = LockFile.getCurrentLockFile();
                        if (lockFile != null) {
                            audit.setInstance(lockFile.getInstance(), lockFile.getHost(), lockFile.getPort());
                        }
                    }
                    catch (BrokerException brokerException) {
                        Globals.getLogger().logStack(32, brokerException.toString(), brokerException);
                        System.exit(1);
                    }
                }
            }
        }
        return audit;
    }

    public static void releaseStore() throws BrokerException {
        StoreManager.releaseStore(true);
    }

    public static void setMQAddress(MQAddress mQAddress) {
        mqAddress = mQAddress;
    }

    public static MQAddress getMQAddress() {
        return mqAddress;
    }

    static {
        String string = System.getProperty(JMQ_HOME_PROPERTY, JMQ_HOME_default);
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.log(32, "B3139", (Object)string, (Throwable)iOException);
        }
        JMQ_HOME = string;
        string = System.getProperty(JMQ_VAR_HOME_PROPERTY, JMQ_HOME + File.separator + JMQ_VAR_HOME_default);
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.log(32, "B3140", (Object)string, (Throwable)iOException);
        }
        JMQ_VAR_HOME = string;
        string = System.getProperty(JMQ_LIB_HOME_PROPERTY, JMQ_HOME + File.separator + "lib");
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.log(32, "B3141", (Object)string, (Throwable)iOException);
        }
        JMQ_LIB_HOME = string;
        string = System.getProperty(JMQ_ETC_HOME_PROPERTY, JMQ_HOME + File.separator + JMQ_ETC_HOME_default);
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            logger.log(32, "B3142", (Object)string, (Throwable)iOException);
        }
        JMQ_ETC_HOME = string;
        JMQ_INSTANCES_HOME = JMQ_VAR_HOME + File.separator + INSTANCES_HOME_DIRECTORY;
        JMQ_BROKER_PROP_LOC = "props" + File.separator + "broker" + File.separator;
    }
}

