/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.timer;

import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import com.sun.messaging.jmq.util.timer.TaskQueue;
import com.sun.messaging.jmq.util.timer.TimerThread;
import java.util.Date;

public class JMQTimer {
    public static boolean DEBUG = false;
    public static Logger logger = null;
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = JMQTimer.this.queue;
            synchronized (taskQueue) {
                if (DEBUG && logger != null) {
                    RuntimeException runtimeException = new RuntimeException("threadReaper: finalize");
                    runtimeException.fillInStackTrace();
                    logger.logStack(4, "Internal Error: timer canceled ", runtimeException);
                }
                ((JMQTimer)JMQTimer.this).thread.newTasksMayBeScheduled = false;
                JMQTimer.this.queue.notify();
            }
        }
    };

    public static void setLogger(Logger logger) {
        JMQTimer.logger = logger;
    }

    public JMQTimer() {
        this.thread.start();
    }

    public JMQTimer(boolean bl) {
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    public void schedule(JMQTimerTask jMQTimerTask, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(jMQTimerTask, System.currentTimeMillis() + l, 0L);
    }

    public void schedule(JMQTimerTask jMQTimerTask, Date date) {
        this.sched(jMQTimerTask, date.getTime(), 0L);
    }

    public void schedule(JMQTimerTask jMQTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(jMQTimerTask, System.currentTimeMillis() + l, -l2);
    }

    public void schedule(JMQTimerTask jMQTimerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(jMQTimerTask, date.getTime(), -l);
    }

    public void scheduleAtFixedRate(JMQTimerTask jMQTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(jMQTimerTask, System.currentTimeMillis() + l, l2);
    }

    public void scheduleAtFixedRate(JMQTimerTask jMQTimerTask, Date date, long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(jMQTimerTask, date.getTime(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(JMQTimerTask jMQTimerTask, long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = jMQTimerTask.lock;
            synchronized (object) {
                if (jMQTimerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                jMQTimerTask.nextExecutionTime = l;
                jMQTimerTask.period = l2;
                jMQTimerTask.state = 1;
            }
            this.queue.add(jMQTimerTask);
            if (this.queue.getMin() == jMQTimerTask) {
                this.queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            if (DEBUG && logger != null) {
                RuntimeException runtimeException = new RuntimeException("threadReaper: cancel");
                runtimeException.fillInStackTrace();
                logger.logStack(4, "Internal Error: timer canceled ", runtimeException);
            }
            this.queue.clear();
            this.queue.notify();
        }
    }
}

