/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.ConsoleUtils;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreConFactoryListCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDestListCObj;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;

public class ObjStoreCObj
extends ObjStoreAdminCObj {
    private ObjStore os = null;
    private ObjStoreDestListCObj objStoreDestList = null;
    private ObjStoreConFactoryListCObj objStoreConFactoryList = null;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();

    public ObjStoreCObj(ObjStore objStore) {
        this.os = objStore;
        this.objStoreDestList = new ObjStoreDestListCObj(objStore);
        this.objStoreConFactoryList = new ObjStoreConFactoryListCObj(objStore);
        this.insert(this.objStoreDestList, 0);
        this.insert(this.objStoreConFactoryList, 1);
    }

    public void setObjStore(ObjStore objStore) {
        this.os = objStore;
    }

    public ObjStore getObjStore() {
        return this.os;
    }

    public String getExplorerLabel() {
        if (this.os.getDescription() != null) {
            return this.os.getDescription();
        }
        return this.os.getID();
    }

    public String getExplorerToolTip() {
        return null;
    }

    public ImageIcon getExplorerIcon() {
        if (this.os.isOpen()) {
            return AGraphics.adminImages[5];
        }
        return AGraphics.adminImages[18];
    }

    public ObjStoreDestListCObj getObjStoreDestListCObj() {
        return this.objStoreDestList;
    }

    public ObjStoreConFactoryListCObj getObjStoreConFactoryListCObj() {
        return this.objStoreConFactoryList;
    }

    public String getActionLabel(int n, boolean bl) {
        if (bl) {
            switch (n) {
                case 1024: {
                    return acr.getString("A1025");
                }
                case 2048: {
                    return acr.getString("A1028");
                }
                case 2: {
                    return acr.getString("A1018");
                }
                case 32: {
                    return acr.getString("A1005");
                }
            }
        } else {
            switch (n) {
                case 1024: {
                    return acr.getString("A1140");
                }
                case 2048: {
                    return acr.getString("A1143");
                }
                case 2: {
                    return acr.getString("A1133");
                }
                case 32: {
                    return acr.getString("A1122");
                }
            }
        }
        return null;
    }

    public ImageIcon getActionIcon(int n) {
        switch (n) {
            case 1024: {
                return AGraphics.adminImages[31];
            }
            case 2048: {
                return AGraphics.adminImages[33];
            }
        }
        return null;
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        if (mutableTreeNode instanceof ObjStoreDestListCObj || mutableTreeNode instanceof ObjStoreConFactoryListCObj) {
            super.insert(mutableTreeNode, n);
        } else {
            super.insert(mutableTreeNode, n);
        }
    }

    public int getExplorerPopupMenuItemMask() {
        return 3106;
    }

    public int getActiveActions() {
        int n = this.os.isOpen() ? 18466 : 1058;
        return n;
    }

    public String getInspectorPanelClassName() {
        return ConsoleUtils.getPackageName(this) + ".ObjStoreInspector";
    }

    public String getInspectorPanelId() {
        return "Object Store";
    }

    public String getInspectorPanelHeader() {
        return this.getInspectorPanelId();
    }
}

