/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.ReadChannel;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.ServerSessionRunner;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.SessionReader;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jms.ra.ManagedConnection;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.ServerSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionRolledBackException;

public class SessionImpl
implements Traceable {
    private ServerSessionRunner serverSessionRunner = null;
    protected ConnectionImpl connection = null;
    protected boolean isTransacted = false;
    protected int acknowledgeMode = 1;
    protected SessionReader sessionReader = null;
    protected SessionQueue sessionQueue = null;
    protected ReadChannel readChannel = null;
    protected Hashtable consumers = new Hashtable();
    protected Vector producers = new Vector();
    protected WriteChannel writeChannel = null;
    protected Long sessionId = null;
    protected ProtocolHandler protocolHandler = null;
    protected Transaction transaction = null;
    protected boolean failoverOccurred = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    protected int ackCounter = 0;
    protected Vector unAckedMessageQueue = new Vector();
    protected boolean isClosed = false;
    protected boolean isStopped = false;
    protected boolean isXAClosed = false;
    protected boolean isXAInRC = false;
    protected boolean protectMode = false;
    protected Hashtable browserConsumers = new Hashtable();
    ReadWritePacket ackPkt = new ReadWritePacket();
    ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
    DataOutputStream dos = new DataOutputStream(this.bos);
    protected boolean setJMSXConsumerTXID = false;
    protected boolean debug = Debug.debug;
    private Object syncObject = new Object();
    private boolean inSyncState = false;
    protected boolean xaTxnMode = false;
    private Object raEndpointSyncObj = new Object();
    private boolean raEndpointSession = false;
    private ManagedConnection mc = null;
    private boolean isDedicatedToServerSession = false;
    private long brokerSessionID;
    private int TEST_ackCount = 0;
    private int TEST_rxCount = 0;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected boolean dupsOkAckOnLimit = false;
    protected boolean dupsOkAckOnTimeout = false;
    protected long dupsOkAckTimeout = 0L;
    protected long dupsOkTimestamp = 0L;
    protected Object dupsOkSyncObj = new Object();
    protected boolean allowExtensions = false;

    protected SessionImpl() {
    }

    public SessionImpl(ConnectionImpl connectionImpl) throws JMSException {
        this(connectionImpl, false, 1, false, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n) throws JMSException {
        this(connectionImpl, bl, n, false, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n, ManagedConnection managedConnection) throws JMSException {
        this(connectionImpl, bl, n, false, managedConnection);
    }

    public SessionImpl(ConnectionImpl connectionImpl, int n) throws JMSException {
        this(connectionImpl, false, n, true, null);
    }

    public SessionImpl(ConnectionImpl connectionImpl, boolean bl, int n, boolean bl2, ManagedConnection managedConnection) throws JMSException {
        this.sessionQueue = new SessionQueue();
        this.sessionQueue.validateQueue();
        this.allowExtensions = bl2;
        this.connection = connectionImpl;
        if (!bl) {
            if (n == 0) {
                n = 1;
            }
            this.checkAckMode(n);
        }
        this.writeChannel = connectionImpl.getWriteChannel();
        this.readChannel = connectionImpl.getReadChannel();
        this.protocolHandler = connectionImpl.getProtocolHandler();
        this.isTransacted = bl;
        this.acknowledgeMode = n;
        this.sessionId = connectionImpl.getNextSessionId();
        if (managedConnection != null) {
            this.mc = managedConnection;
        }
        this.init();
    }

    private void checkAckMode(int n) throws JMSException {
        if (n != 1 && n != 2 && n != 3) {
            if (this.allowExtensions && n == 32768) {
                if (this.connection.getBrokerProtocolLevel() <= 350) {
                    String string = AdministeredObject.cr.getKString("C4092", this.connection.getBrokerVersion());
                    throw new com.sun.messaging.jms.JMSException(string, "C4092");
                }
                return;
            }
            String string = String.valueOf(n);
            String string2 = AdministeredObject.cr.getKString("C4067", string);
            throw new JMSException(string2, "C4067");
        }
    }

    private void init() throws JMSException {
        this.serverSessionRunner = new ServerSessionRunner(this, null);
        if (this.isTransacted) {
            if (this.mc == null) {
                this.transaction = new Transaction(this, true);
            } else {
                this.transaction = new Transaction(this, false);
                if (this.mc.xaTransactionStarted()) {
                    this.transaction.setTransactionID(this.mc.getTransactionID());
                    this.xaTxnMode = true;
                }
            }
        }
        if (this.connection.getIsStopped()) {
            this.sessionQueue.setIsLocked(true);
        }
        this.connection.addToReadQTable(this.sessionId, this.sessionQueue);
        this.connection.addSession(this);
        this.dupsOkLimit = this.connection.getDupsOkLimit();
        this.isAckLimited = this.connection.getIsAckLimited();
        this.ackLimit = this.connection.getAckLimit();
        this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID && this.isTransacted;
        this.protectMode = this.connection.getProtectMode();
        this.isDedicatedToServerSession = this.connection.getIsDedicatedToConnectionConsumer();
        this.dupsOkInit();
        this.sessionReader = new SessionReader(this);
        if (this.isDedicatedToServerSession) {
            this.sessionReader.close();
        } else {
            this.sessionReader.start();
        }
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
    }

    protected void dupsOkInit() {
        if (!this.isTransacted && this.acknowledgeMode == 3) {
            if (this.isDedicatedToServerSession) {
                this.dupsOkAckOnEmptyQueue = true;
            } else {
                this.dupsOkAckOnEmptyQueue = this.connection.dupsOkAckOnEmptyQueue;
                if (!this.dupsOkAckOnEmptyQueue) {
                    this.dupsOkAckTimeout = this.connection.dupsOkAckTimeout;
                    if (this.dupsOkAckTimeout > 0L) {
                        this.dupsOkAckOnTimeout = true;
                    } else {
                        this.dupsOkAckOnLimit = true;
                        this.dupsOkAckTimeout = 0L;
                    }
                }
            }
        }
        if (this.debug) {
            if (this.dupsOkAckOnTimeout || this.dupsOkAckOnEmptyQueue || this.dupsOkAckOnLimit) {
                Debug.println("*** dupsOkAckOnEmptyQueue: " + this.dupsOkAckOnEmptyQueue);
                Debug.println("*** dupsOkAckOnTimeout: " + this.dupsOkAckOnTimeout);
                Debug.println("*** dupsOkAckTimeout: " + this.dupsOkAckTimeout);
                Debug.println("*** dupsOkAckOnLimit: " + this.dupsOkAckOnLimit);
            } else {
                Debug.println("*** Session ackMode:  " + this.acknowledgeMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchOnXATransaction() throws JMSException {
        if (this.xaTxnMode) {
            return;
        }
        if (this.isTransacted) {
            this.setInSyncState();
            try {
                this.receiveRollback();
                this.transaction.rollbackToXA();
            }
            finally {
                this.releaseInSyncState();
            }
        }
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
            this.isTransacted = true;
            this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID;
        }
        this.xaTxnMode = true;
    }

    protected void switchOffXATransaction() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    protected void addMessageConsumer(MessageConsumerImpl messageConsumerImpl) throws JMSException {
        this.consumers.put(messageConsumerImpl.interestId, messageConsumerImpl);
    }

    protected void checkBrowserCreation() throws JMSException {
        if (this.isDedicatedToServerSession) {
            this.checkConsumerCreation();
        }
    }

    protected void checkConsumerCreation() throws JMSException {
        if (this.isDedicatedToServerSession || this.serverSessionRunner.getMessageListener() != null) {
            String string = AdministeredObject.cr.getKString("C4031");
            throw new IllegalStateException(string, "C4031");
        }
    }

    protected void removeMessageConsumer(MessageConsumerImpl messageConsumerImpl) {
        this.consumers.remove(messageConsumerImpl.interestId);
    }

    protected MessageConsumerImpl getMessageConsumer(Object object) {
        return (MessageConsumerImpl)this.consumers.get(object);
    }

    protected void addBrowserConsumer(BrowserConsumer browserConsumer) {
        browserConsumer.getBrowser().addBrowserConsumer(browserConsumer);
        this.browserConsumers.put(browserConsumer.interestId, browserConsumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer browserConsumer) {
        this.browserConsumers.remove(browserConsumer.interestId);
        browserConsumer.getBrowser().removeBrowserConsumer(browserConsumer);
    }

    protected BrowserConsumer getBrowserConsumer(Object object) {
        return (BrowserConsumer)this.browserConsumers.get(object);
    }

    protected void addMessageProducer(MessageProducerImpl messageProducerImpl) {
        this.producers.add(messageProducerImpl);
    }

    protected void removeMessageProducer(MessageProducerImpl messageProducerImpl) {
        this.producers.remove(messageProducerImpl);
    }

    protected void verifyDestination(Destination destination, String string, boolean bl) throws JMSException {
        this.protocolHandler.verifyDestination(destination, string, bl);
    }

    protected SysMessageID[] getMessageIdSet(Consumer consumer) throws JMSException {
        return this.protocolHandler.browse(consumer);
    }

    protected boolean requestMessages(ByteArrayOutputStream byteArrayOutputStream, BrowserConsumer browserConsumer) throws JMSException {
        return this.protocolHandler.deliver(byteArrayOutputStream, browserConsumer);
    }

    protected ProtocolHandler getProtocolHandler() {
        return this.connection.getProtocolHandler();
    }

    protected Long getSessionId() {
        return this.sessionId;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4059");
            throw new IllegalStateException(string, "C4059");
        }
        if (this.isTransacted) {
            this.transaction.send(message);
        } else {
            this.writeChannel.writeJMSMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stopFromRA() throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.stop();
        }
    }

    protected void stop() throws JMSException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(boolean bl) throws JMSException {
        if (this.isStopped || this.isClosed) {
            return;
        }
        this.checkPermission();
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            this.sessionQueue.stop(bl);
            this.serverSessionRunner.serverSessionStop();
            MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < messageConsumerImplArray.length; ++i) {
                messageConsumerImplArray[i].stop();
            }
            this.isStopped = true;
        }
    }

    protected synchronized void reset() throws JMSException {
        this.stop(false);
        this.sessionQueue.clear();
        MessageConsumerImpl messageConsumerImpl = null;
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            messageConsumerImpl.receiveQueue.clear();
        }
        if (this.unAckedMessageQueue != null) {
            this.unAckedMessageQueue.removeAllElements();
        }
        this.start();
    }

    protected void recreateSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted) {
            this.transaction = new Transaction(this, true);
        }
        this.failoverOccurred = true;
    }

    protected synchronized void start() throws JMSException {
        this.sessionQueue.start();
        this.serverSessionRunner.serverSessionRun();
        MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < messageConsumerImplArray.length; ++i) {
            messageConsumerImplArray[i].start();
        }
        this.isStopped = false;
    }

    protected void checkPermission() throws IllegalStateException {
        if (Thread.currentThread() == this.sessionReader.sessionThread || Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            String string = AdministeredObject.cr.getKString("C4049");
            throw new IllegalStateException(string, "C4049");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverableFromRAEndpoint(MessageImpl messageImpl, XAResourceForRA xAResourceForRA, boolean bl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xAResourceForRA != null && xAResourceForRA.started()) {
                    XAResourceForRA xAResourceForRA2 = xAResourceForRA;
                    synchronized (xAResourceForRA2) {
                        this.ackPkt.setTransactionID(xAResourceForRA.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(messageImpl);
                this.doAcknowledgeUndeliverable(true, bl);
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl messageImpl, XAResourceForRA xAResourceForRA) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.readChannel.flowControl.messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
            this.readChannel.flowControl.messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xAResourceForRA != null && xAResourceForRA.started()) {
                    XAResourceForRA xAResourceForRA2 = xAResourceForRA;
                    synchronized (xAResourceForRA2) {
                        this.ackPkt.setTransactionID(xAResourceForRA.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(messageImpl);
                this.doAcknowledge(true);
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl messageImpl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.acknowledge(messageImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void acknowledge(MessageImpl messageImpl) throws JMSException {
        this.readChannel.flowControl.messageDelivered();
        Consumer consumer = (Consumer)this.consumers.get(new Long(messageImpl.getInterestID()));
        if (consumer == null) {
            consumer = this.connection.interestTable.getConsumer(new Long(messageImpl.getInterestID()));
        }
        this.readChannel.flowControl.messageDelivered(consumer);
        ++this.TEST_rxCount;
        try {
            this.setInSyncState();
            if (this.isTransacted) {
                this.transactedAcknowledge(messageImpl);
                return;
            }
            switch (this.acknowledgeMode) {
                case 1: {
                    this.autoAcknowledge(messageImpl);
                    return;
                }
                case 2: {
                    this.prepareClientAcknowledge(messageImpl);
                    return;
                }
                case 3: {
                    if (this.dupsOkAckOnTimeout) {
                        this.syncedDupsOkAcknowledge(messageImpl);
                        return;
                    } else {
                        this.dupsOkAcknowledge(messageImpl);
                        return;
                    }
                }
                case 32768: {
                    return;
                }
                default: {
                    this.autoAcknowledge(messageImpl);
                    return;
                }
            }
        }
        finally {
            this.releaseInSyncState();
        }
    }

    protected void autoAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.writeMessageID(messageImpl);
        this.doAcknowledge(true);
    }

    protected void transactedAcknowledge(MessageImpl messageImpl) throws JMSException {
        boolean bl = this.prepareTransactedAcknowledge(messageImpl);
        if (bl) {
            this.ackPkt.setTransactionID(this.transaction.getTransactionID());
            this.writeMessageID(messageImpl);
            this.doAcknowledge(true);
        }
    }

    protected void writeMessageID(MessageImpl messageImpl) throws JMSException {
        try {
            this.dos.writeLong(messageImpl.getInterestID());
            messageImpl.getMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    protected void writeMessageID(UnAckedMessage unAckedMessage) throws JMSException {
        try {
            this.dos.writeLong(unAckedMessage.getConsumerID());
            unAckedMessage.getMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    protected void writeMessageID(ReadOnlyPacket readOnlyPacket) throws JMSException {
        try {
            this.dos.writeLong(readOnlyPacket.getConsumerID());
            readOnlyPacket.getSysMessageID().writeID(this.dos);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4038");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledgeUndeliverable(boolean bl, boolean bl2) throws JMSException {
        try {
            try {
                this.dos.flush();
                this.bos.flush();
                this.ackPkt.setMessageBody(this.bos.toByteArray());
                this.ackPkt.setSendAcknowledge(bl);
                this.protocolHandler.acknowledgeUndeliverable(this.ackPkt, bl2);
                ++this.TEST_ackCount;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4016");
                Object var5_4 = null;
                this.bos.reset();
                this.ackCounter = 0;
                this.dupsOkTimestamp = 0L;
            }
            Object var5_3 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledge(boolean bl) throws JMSException {
        try {
            try {
                this.dos.flush();
                this.bos.flush();
                this.ackPkt.setMessageBody(this.bos.toByteArray());
                this.ackPkt.setSendAcknowledge(bl);
                this.protocolHandler.acknowledge(this.ackPkt);
                ++this.TEST_ackCount;
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException, "C4016");
                Object var4_3 = null;
                this.bos.reset();
                this.ackCounter = 0;
                this.dupsOkTimestamp = 0L;
            }
            Object var4_2 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.bos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
            throw throwable;
        }
    }

    protected void dupsOkAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.addMessageToAckList(messageImpl);
        if (this.dupsOkShouldAcknowledge()) {
            this.dupsOkCommitAcknowledge();
        }
    }

    protected void dupsOkCommitAcknowledge() throws JMSException {
        if (this.debug) {
            Debug.println("***** dups ok committing ack .... size: " + this.ackCounter);
        }
        this.dequeueUnAckedMessages();
        this.doAcknowledge(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkAcknowledge(MessageImpl messageImpl) throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter == 0) {
                this.dupsOkTimestamp = System.currentTimeMillis();
            }
            this.dupsOkAcknowledge(messageImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkCommitAcknowledge() throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter > 0) {
                this.dupsOkCommitAcknowledge();
            }
        }
    }

    protected boolean dupsOkShouldAcknowledge() {
        if (this.dupsOkAckOnTimeout) {
            boolean bl = System.currentTimeMillis() - this.dupsOkTimestamp >= this.dupsOkAckTimeout;
            return this.ackCounter == this.dupsOkLimit || bl;
        }
        if (this.dupsOkAckOnEmptyQueue) {
            return this.ackCounter == this.dupsOkLimit || this.sessionQueue.isEmpty();
        }
        return this.ackCounter == this.dupsOkLimit;
    }

    protected boolean addMessageToAckList(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        if (messageImpl != null && !messageImpl.getIsOnAckList()) {
            messageImpl.setIsOnAckList(true);
            UnAckedMessage unAckedMessage = new UnAckedMessage(messageImpl);
            this.unAckedMessageQueue.addElement(unAckedMessage);
            ++this.ackCounter;
            bl = true;
        }
        return bl;
    }

    protected void removeMessageFromAckList(UnAckedMessage unAckedMessage) {
        this.unAckedMessageQueue.removeElement(unAckedMessage);
        --this.ackCounter;
    }

    protected void prepareClientAcknowledge(MessageImpl messageImpl) throws JMSException {
        this.addMessageToAckList(messageImpl);
        if (this.isAckLimited) {
            this.checkClientAckLimit();
        }
    }

    protected void checkClientAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String string = AdministeredObject.cr.getKString("C4023");
            Debug.println(string);
        }
    }

    protected boolean prepareTransactedAcknowledge(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        bl = this.addMessageToAckList(messageImpl);
        if (this.isAckLimited) {
            this.checkTransactedAckLimit();
        }
        return bl;
    }

    protected void checkTransactedAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String string = AdministeredObject.cr.getKString("C4026");
            Debug.println(string);
        }
    }

    protected void clientAcknowledge(MessageImpl messageImpl) throws JMSException {
        if (this.failoverOccurred) {
            String string = AdministeredObject.cr.getKString("C4075");
            throw new JMSException(string, "C4075");
        }
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            if (this.unAckedMessageQueue.size() > 0) {
                this.dequeueUnAckedMessages();
                this.doAcknowledge(true);
            }
        }
    }

    protected void clientAcknowledgeThisMessage(MessageImpl messageImpl) throws JMSException {
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            UnAckedMessage unAckedMessage = null;
            for (int i = 0; i < this.unAckedMessageQueue.size(); ++i) {
                unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (!messageImpl.messageID.equals(unAckedMessage.getMessageID())) continue;
                this.writeMessageID(unAckedMessage);
                this.unAckedMessageQueue.removeElementAt(i);
                this.doAcknowledge(true);
                return;
            }
        }
    }

    protected void clientAcknowledgeUpThroughThisMessage(MessageImpl messageImpl) throws JMSException {
        if (this.failoverOccurred) {
            String string = AdministeredObject.cr.getKString("C4075");
            throw new JMSException(string, "C4075");
        }
        this.checkClientAckMessage(messageImpl);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(messageImpl);
            if (this.isMessageInUnAckedQueue(messageImpl)) {
                UnAckedMessage unAckedMessage = null;
                boolean bl = false;
                while (!bl) {
                    unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.firstElement();
                    this.writeMessageID(unAckedMessage);
                    this.unAckedMessageQueue.removeElementAt(0);
                    if (!messageImpl.messageID.equals(unAckedMessage.getMessageID())) continue;
                    bl = true;
                }
                this.doAcknowledge(true);
            }
        }
    }

    protected boolean isMessageInUnAckedQueue(MessageImpl messageImpl) throws JMSException {
        boolean bl = false;
        UnAckedMessage unAckedMessage = null;
        int n = this.unAckedMessageQueue.size();
        for (int i = 0; i < n; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            if (!messageImpl.messageID.equals(unAckedMessage.getMessageID())) continue;
            bl = true;
            i = n;
        }
        return bl;
    }

    protected void checkSessionState() throws IllegalStateException {
        if (this.isClosed) {
            String string = AdministeredObject.cr.getKString("C4059");
            throw new IllegalStateException(string, "C4059");
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkSessionState();
        return new BytesMessageImpl(true);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkSessionState();
        return new MapMessageImpl();
    }

    public Message createMessage() throws JMSException {
        this.checkSessionState();
        MessageImpl messageImpl = new MessageImpl();
        return messageImpl;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkSessionState();
        return new ObjectMessageImpl();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkSessionState();
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setObject(serializable);
        return objectMessageImpl;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkSessionState();
        return new StreamMessageImpl(true);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkSessionState();
        return new TextMessageImpl();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkSessionState();
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setText(string);
        return textMessageImpl;
    }

    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        return this.isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        this.checkSessionState();
        if (!this.isTransacted) {
            String string = AdministeredObject.cr.getKString("C4024");
            throw new IllegalStateException(string, "C4024");
        }
        if (this.failoverOccurred) {
            this.rollback();
            String string = AdministeredObject.cr.getKString("C4074");
            throw new TransactionRolledBackException(string, "C4074");
        }
        this.setInSyncState();
        try {
            this.receiveCommit();
            this.transaction.commit();
        }
        finally {
            this.releaseInSyncState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        this.checkSessionState();
        if (!this.isTransacted) {
            String string = AdministeredObject.cr.getKString("C4024");
            throw new IllegalStateException(string, "C4024");
        }
        this.setInSyncState();
        try {
            this.receiveRollback();
            this.transaction.rollback();
        }
        finally {
            this.failoverOccurred = false;
            this.releaseInSyncState();
        }
    }

    private void closeConsumers() throws JMSException {
        MessageConsumerImpl[] messageConsumerImplArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < messageConsumerImplArray.length; ++i) {
            messageConsumerImplArray[i].close();
        }
        this.consumers.clear();
    }

    private void closeProducers() throws JMSException {
        MessageProducerImpl[] messageProducerImplArray = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < messageProducerImplArray.length; ++i) {
            messageProducerImplArray[i].close();
        }
        this.producers.clear();
    }

    private void closeBrowserConsumers() throws JMSException {
        BrowserConsumer[] browserConsumerArray = this.browserConsumers.values().toArray(new BrowserConsumer[0]);
        for (int i = 0; i < browserConsumerArray.length; ++i) {
            browserConsumerArray[i].close();
        }
        this.browserConsumers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.checkPermission();
        try {
            SessionImpl sessionImpl = this;
            synchronized (sessionImpl) {
                block13: {
                    if (!this.isClosed) break block13;
                    return;
                }
                this.sessionQueue.stop(true);
                this.prepareToClose();
                if (this.isTransacted) {
                    if (this.xaTxnMode) {
                        this.receiveCommit();
                    } else {
                        this.transaction.releaseBrokerResource();
                    }
                }
                this.closeConsumers();
                this.closeProducers();
                this.closeBrowserConsumers();
                this.sessionReader.close();
                this.serverSessionRunner.serverSessionClose();
                this.connection.removeSession(this);
                this.connection.removeFromReadQTable(this.sessionId);
                if (this.connection.getBrokerProtocolLevel() >= 350 && !this.connection.isBroken()) {
                    this.protocolHandler.deleteSession(this);
                }
                this.isClosed = true;
            }
        }
        finally {
            this.isClosed = true;
            this.releaseInSyncState();
        }
        if (this.debug) {
            Debug.println("session closed ...");
            Debug.println(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFromRA() {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.sessionReader.close();
        }
    }

    public void _setRAEndpointSession() {
        this.raEndpointSession = true;
    }

    public void _startLocalTransaction() throws JMSException {
        if (this.isTransacted) {
            if (this.transaction == null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-transacted w/o Transaction Object");
            }
        } else {
            if (this.transaction != null) {
                throw new com.sun.messaging.jms.JMSException("MQRA:S:Can't start local transaction-already transacted");
            }
            this.transaction = new Transaction(this, true);
            this.isTransacted = true;
        }
    }

    protected boolean needToWait() {
        return !this.connection.isBroken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void recover() throws JMSException {
        var1_1 = false;
        this.checkSessionState();
        if (this.isTransacted) {
            var2_2 = AdministeredObject.cr.getKString("C4025");
            throw new IllegalStateException(var2_2, "C4025");
        }
        if (this.acknowledgeMode == 32768) {
            var2_3 = AdministeredObject.cr.getKString("C4091");
            throw new IllegalStateException(var2_3, "C4091");
        }
        this.setInSyncState();
        try {
            switch (this.acknowledgeMode) {
                case 1: {
                    if (Thread.currentThread() != this.sessionReader.sessionThread) ** GOTO lbl20
                    this.sessionReader.currentMessage.doAcknowledge = false;
                    ** GOTO lbl22
lbl20:
                    // 1 sources

                    if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
                        this.serverSessionRunner.currentMessage.doAcknowledge = false;
                    }
                }
lbl22:
                // 5 sources

                case 2: 
                case 3: {
                    if (Thread.currentThread() == this.sessionReader.sessionThread) {
                        this.prepareClientAcknowledge(this.sessionReader.currentMessage);
                        break;
                    }
                    if (Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) break;
                    this.prepareClientAcknowledge(this.serverSessionRunner.currentMessage);
                }
            }
        }
        catch (Exception var2_4) {
            // empty catch block
        }
        try {
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop();
            }
            this.redeliverMessagesInQueues(false);
            this.redeliverUnAckedMessages(true);
            this.failoverOccurred = false;
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
        }
        finally {
            this.releaseInSyncState();
            this.resumeSession();
        }
    }

    protected void stopSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.incStoppedCount();
            this.protocolHandler.stop();
        } else {
            this.protocolHandler.stopSession(this.brokerSessionID);
        }
    }

    protected void resumeSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.decStoppedCount();
            if (!this.connection.getIsStopped()) {
                this.protocolHandler.start();
            }
        } else {
            this.protocolHandler.resumeSession(this.brokerSessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInSyncState() throws JMSException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkSessionState();
            if (this.inSyncState) {
                String string = AdministeredObject.cr.getKString("C4055");
                throw new IllegalStateException(string, "C4055");
            }
            this.inSyncState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInSyncState() {
        Object object = this.syncObject;
        synchronized (object) {
            this.inSyncState = false;
            this.syncObject.notifyAll();
        }
    }

    protected boolean getInSyncState() {
        return this.inSyncState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToClose() {
        Object object = this.syncObject;
        synchronized (object) {
            while (this.inSyncState) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    Debug.printStackTrace(interruptedException);
                }
            }
            this.inSyncState = true;
        }
    }

    protected void receiveCommit() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.transactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.transactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
        this.unAckedMessageQueue.clear();
    }

    protected void receiveRollback() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.prepareTransactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.prepareTransactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
        this.stopSession();
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.stop();
        }
        this.redeliverMessagesInQueues(false);
        this.redeliverUnAckedMessages(true);
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.start();
        }
        this.resumeSession();
    }

    protected void redeliverUnAckedMessages(boolean bl) throws JMSException {
        this.dequeueUnAckedMessages();
        this.redeliver(bl);
    }

    protected void redeliverMessagesInQueues(boolean bl) throws JMSException {
        this.dequeueMessagesInQueues();
        this.redeliver(bl);
    }

    protected void dequeueMessagesInQueues() throws JMSException {
        MessageConsumerImpl messageConsumerImpl = null;
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            this.dequeueReceiveQ(messageConsumerImpl.receiveQueue);
            this.readChannel.flowControl.resetFlowControl(messageConsumerImpl);
        }
        this.dequeueSessionQ(this.sessionQueue);
    }

    protected void dequeueReceiveQ(ReceiveQueue receiveQueue) throws JMSException {
        MessageImpl messageImpl = null;
        while (!receiveQueue.isEmpty()) {
            messageImpl = (MessageImpl)receiveQueue.dequeue();
            if (messageImpl == null) continue;
            this.writeMessageID(messageImpl);
        }
    }

    protected void dequeueSessionQ(SessionQueue sessionQueue) throws JMSException {
        ReadOnlyPacket readOnlyPacket = null;
        while (!sessionQueue.isEmpty()) {
            readOnlyPacket = (ReadOnlyPacket)sessionQueue.dequeue();
            if (readOnlyPacket == null) continue;
            this.writeMessageID(readOnlyPacket);
        }
    }

    private void dequeueUnAckedMessages() throws JMSException {
        UnAckedMessage unAckedMessage = null;
        int n = this.unAckedMessageQueue.size();
        for (int i = 0; i < n; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            this.writeMessageID(unAckedMessage);
        }
        this.unAckedMessageQueue.removeAllElements();
        this.ackCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _redeliverMessageFromRA(MessageImpl messageImpl) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            if (messageImpl != null) {
                this.writeMessageID(messageImpl);
                ReadWritePacket readWritePacket = new ReadWritePacket();
                try {
                    this.dos.flush();
                    this.bos.flush();
                    readWritePacket.setMessageBody(this.bos.toByteArray());
                    this.protocolHandler.redeliver(readWritePacket, true);
                    this.bos.reset();
                }
                catch (IOException iOException) {
                    ExceptionHandler.handleException((Exception)iOException, "C4018");
                }
            }
        }
    }

    protected void redeliver(boolean bl) throws JMSException {
        if (this.bos.size() == 0) {
            return;
        }
        ReadWritePacket readWritePacket = new ReadWritePacket();
        try {
            this.dos.flush();
            this.bos.flush();
            readWritePacket.setMessageBody(this.bos.toByteArray());
            if (this.isTransacted) {
                readWritePacket.setTransactionID(this.transaction.getTransactionID());
            }
            this.protocolHandler.redeliver(readWritePacket, bl);
            this.bos.reset();
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException, "C4018");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkSessionState();
        return this.serverSessionRunner.getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkSessionState();
        if (messageListener != null && this.consumers.size() > 0) {
            String string = AdministeredObject.cr.getKString("C4031");
            throw new IllegalStateException(string, "C4031");
        }
        this.serverSessionRunner.setMessageListener(messageListener);
    }

    public void run() {
        this.serverSessionRunner.run();
    }

    protected void loadMessageToServerSession(MessageImpl messageImpl, ServerSession serverSession) {
        this.serverSessionRunner.loadMessage(messageImpl, serverSession);
    }

    protected SessionQueue getSessionQueue() {
        return this.sessionQueue;
    }

    public boolean _getAckSendAcknowledge() {
        return this.ackPkt.getSendAcknowledge();
    }

    public int _getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    protected boolean _getXaTxnMode() {
        return this.xaTxnMode;
    }

    protected void _setXaTxnMode(boolean bl) {
        this.xaTxnMode = bl;
    }

    public long getBrokerSessionID() {
        return this.brokerSessionID;
    }

    public void setBrokerSessionID(long l) {
        this.brokerSessionID = l;
    }

    public Transaction _getTransaction() {
        return this.transaction;
    }

    public void _initXATransactionForMC(long l) throws JMSException {
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
        }
        this.transaction.setTransactionID(l);
        this.xaTxnMode = true;
        this.isTransacted = true;
    }

    public void _finishXATransactionForMC() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ SessionImpl dump ------");
        printStream.println("broker session ID: " + this.brokerSessionID);
        printStream.println("session ID: " + this.sessionId);
        if (this.sessionReader != null) {
            this.sessionReader.dump(printStream);
        }
        if (this.sessionQueue != null) {
            this.sessionQueue.dump(printStream);
        }
        if (this.unAckedMessageQueue != null) {
            printStream.println("Number of Unacked messages: " + this.unAckedMessageQueue.size());
        }
        printStream.println("# of message consumers: " + this.consumers.size());
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            MessageConsumerImpl messageConsumerImpl = (MessageConsumerImpl)enumeration.nextElement();
            messageConsumerImpl.dump(printStream);
        }
        this.serverSessionRunner.dump(printStream);
    }

    protected Hashtable getDebugState(boolean bl) {
        MessageProducerImpl[] messageProducerImplArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("sessionId", String.valueOf(this.sessionId));
        hashtable.put("brokerSessionID", String.valueOf(this.brokerSessionID));
        hashtable.put("isTransacted", String.valueOf(this.isTransacted));
        hashtable.put("ackMode", String.valueOf(this.acknowledgeMode));
        hashtable.put("dupsOkLimit", String.valueOf(this.dupsOkLimit));
        hashtable.put("isAckLimited", String.valueOf(this.isAckLimited));
        hashtable.put("ackLimit", String.valueOf(this.ackLimit));
        hashtable.put("ackCounter", String.valueOf(this.ackCounter));
        hashtable.put("xaTxnMode", String.valueOf(this.xaTxnMode));
        hashtable.put("rxCount", String.valueOf(this.TEST_rxCount));
        hashtable.put("ackCount", String.valueOf(this.TEST_ackCount));
        hashtable.put("isStopped", String.valueOf(this.isStopped));
        hashtable.put("# Consumers", String.valueOf(this.consumers.size()));
        int n = 0;
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            messageProducerImplArray = (MessageProducerImpl[])enumeration.nextElement();
            hashtable.put("Consumer[" + n + "]", messageProducerImplArray.getDebugState(bl));
            ++n;
        }
        hashtable.put("# Producers", String.valueOf(this.producers.size()));
        messageProducerImplArray = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < messageProducerImplArray.length; ++i) {
            hashtable.put("Producer[" + i + "]", messageProducerImplArray[i].getDebugState(bl));
        }
        if (bl) {
            hashtable.put("unacked", this.unAckedMessageQueue);
        }
        return hashtable;
    }

    private void checkClientAckMessage(MessageImpl messageImpl) throws JMSException {
        Long l;
        if (this.connection.getBrokerProtocolLevel() < 350 && !this.consumers.containsKey(l = new Long(messageImpl.getInterestID()))) {
            String string = AdministeredObject.cr.getKString("C4058");
            throw new IllegalStateException(string, "C4058");
        }
    }

    protected void removeUnAckedMessages(Long l) throws JMSException {
        int n = this.unAckedMessageQueue.size();
        if (n > 0) {
            int n2;
            Vector<UnAckedMessage> vector = new Vector<UnAckedMessage>();
            long l2 = l;
            for (n2 = 0; n2 < n; ++n2) {
                UnAckedMessage unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(n2);
                if (unAckedMessage.getConsumerID() != l2) continue;
                vector.addElement(unAckedMessage);
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (this.debug) {
                    Debug.println("removing msg from unackq: " + vector.elementAt(n2));
                }
                this.removeMessageFromAckList((UnAckedMessage)vector.elementAt(n2));
            }
        }
    }

    private class UnAckedMessage {
        private SysMessageID mid = null;
        private long cid = -1L;

        private UnAckedMessage(MessageImpl messageImpl) {
            this.mid = messageImpl.getMessageID();
            this.cid = messageImpl.getInterestID();
        }

        public SysMessageID getMessageID() {
            return this.mid;
        }

        public long getConsumerID() {
            return this.cid;
        }
    }
}

