/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;

class ReceiveQueue
extends SessionQueue
implements Traceable {
    private boolean receiveInProcess = false;

    public ReceiveQueue() {
    }

    public ReceiveQueue(boolean bl, int n) {
        super(bl, n);
    }

    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    protected synchronized Object dequeueWait(long l) {
        long l2 = l;
        boolean bl = false;
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed || bl) {
                return null;
            }
            try {
                long l3;
                if (l == 0L) {
                    this.wait(0L);
                    continue;
                }
                long l4 = System.currentTimeMillis();
                this.wait(l2);
                if (!this.isEmpty() && !this.isLocked || (l2 -= (l3 = System.currentTimeMillis() - l4)) > 0L) continue;
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isClosed) {
            return null;
        }
        this.receiveInProcess = true;
        return this.dequeue();
    }

    protected synchronized void setReceiveInProcess(boolean bl) {
        this.receiveInProcess = bl;
        this.notifyAll();
    }

    protected synchronized void stop() {
        this.isLocked = true;
        this.waitUntilReceiveIsDone();
        if (this.debug) {
            Debug.println("receive queue 'stop' called ...");
        }
    }

    protected synchronized void start() {
        if (!this.isEmpty()) {
            this.setIsLocked(false);
        } else {
            this.isLocked = false;
        }
        if (this.debug) {
            Debug.println("receive queue 'start' called ...");
        }
    }

    protected synchronized void waitUntilReceiveIsDone() {
        try {
            while (this.isLocked && this.receiveInProcess) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ReceiveQueue dump ------");
        printStream.println("isLocked: " + this.isLocked);
        printStream.println("receiveInProcess: " + this.receiveInProcess);
        printStream.println("isClosed: " + this.isClosed);
        if (this.size() > 0) {
            printStream.println("^^^^^^ receive queue super class dump ^^^^^^");
            super.dump(printStream);
            printStream.println("^^^^^^ end receive queue super class dump ^^^^^^");
        }
    }
}

