/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.MQAddressList;
import com.sun.messaging.jmq.jmsclient.ConnectException;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.StreamHandler;
import com.sun.messaging.jmq.jmsclient.StreamHandlerFactory;
import java.net.MalformedURLException;
import javax.jms.JMSException;

public class ConnectionInitiator {
    private ConnectionImpl connection = null;
    private int next = 0;
    private MQAddressList addrList = null;
    private String addrListString = null;
    private boolean useAddressList = true;
    private int nextStart = 0;
    private int reconnectDelay = 3000;
    private int reconnectRetries = 0;
    private int addressListIterations = 0;
    private boolean debug = Debug.debug;

    public ConnectionInitiator(ConnectionImpl connectionImpl) throws JMSException, MalformedURLException {
        this.connection = connectionImpl;
        this.init();
    }

    private void init() throws JMSException, MalformedURLException {
        String string;
        if (this.debug) {
            Debug.println("In ConnectionInitiator.init()");
        }
        if ((string = this.connection.getTrimmedProperty("imqReconnectInterval")) != null) {
            this.reconnectDelay = Integer.parseInt(string);
        }
        if ((string = this.connection.getTrimmedProperty("imqReconnectAttempts")) != null) {
            this.reconnectRetries = Integer.parseInt(string);
        }
        if ((string = this.connection.getTrimmedProperty("imqAddressListIterations")) != null) {
            this.addressListIterations = Integer.parseInt(string);
        }
        this.addrList = null;
        this.addrListString = string = this.connection.getTrimmedProperty("imqAddressList");
        if (string != null && !string.equals("")) {
            this.addrList = MQAddressList.createMQAddressList(string);
        }
        if (this.addrList != null && this.addrList.size() > 0) {
            this.useAddressList = true;
            string = this.connection.getProperty("imqAddressListBehavior");
            if (string.equalsIgnoreCase("PRIORITY")) {
                this.addrList.setBehavior(1);
            } else if (string.equalsIgnoreCase("RANDOM")) {
                this.addrList.setBehavior(2);
            } else {
                throw new JMSException("Bad imqAddressListBehavior value : " + string);
            }
            if (this.debug) {
                Debug.println("Address list : \n" + this.addrList);
            }
        } else {
            this.useAddressList = false;
        }
    }

    protected ConnectionHandler createConnection() throws JMSException {
        return this.createConnection(false);
    }

    protected ConnectionHandler reconnect() throws JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.reconnect()");
        }
        return this.createConnection(true);
    }

    private ConnectionHandler createConnection(boolean bl) throws JMSException {
        if (this.useAddressList) {
            return this.createConnectionNew(bl);
        }
        return this.createConnectionOld(bl);
    }

    private ConnectionHandler createConnectionNew(boolean bl) throws JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionNew()");
        }
        Exception[] exceptionArray = new Exception[this.addrList.size()];
        String[] stringArray = new String[this.addrList.size()];
        Exception exception = null;
        for (int i = 0; this.addressListIterations <= 0 || i < this.addressListIterations; ++i) {
            block9: for (int j = 0; j < this.addrList.size(); ++j) {
                int n = (this.nextStart + j) % this.addrList.size();
                MQAddress mQAddress = (MQAddress)this.addrList.get(n);
                int n2 = 0;
                while (true) {
                    if (this.connection.isCloseCalled) {
                        if (this.debug) {
                            Debug.println("#### connection.isClosed = true");
                        }
                        return null;
                    }
                    ++n2;
                    try {
                        if (this.debug) {
                            Debug.println("#### Connecting to :" + mQAddress);
                        }
                        String string = mQAddress.getHandlerClass();
                        StreamHandler streamHandler = StreamHandlerFactory.getStreamHandler(string);
                        ConnectionHandler connectionHandler = streamHandler.openConnection(mQAddress, this.connection);
                        this.nextStart = this.reconnectRetries > 0 ? n : (bl ? (this.connection.failoverEnabled ? (n + 1) % this.addrList.size() : n) : (n + 1) % this.addrList.size());
                        return connectionHandler;
                    }
                    catch (Exception exception2) {
                        if (this.debug) {
                            Debug.println("\nConnection Attempt failed.\nIteration# = " + i + ", Address = " + mQAddress + ", attempt# = " + n2);
                            Debug.printStackTrace(exception2);
                        }
                        exceptionArray[j] = exception2;
                        stringArray[j] = mQAddress.toString();
                        exception = exception2;
                        if (this.reconnectRetries > 0 && n2 < this.reconnectRetries) {
                            try {
                                Thread.sleep(this.reconnectDelay);
                            }
                            catch (Exception exception3) {}
                            continue;
                        }
                        if (j == this.addrList.size() - 1) continue block9;
                        try {
                            Thread.sleep(this.reconnectDelay);
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                        continue block9;
                    }
                    break;
                }
            }
            if (i == this.addressListIterations - 1) continue;
            try {
                Thread.sleep(this.reconnectDelay);
                continue;
            }
            catch (Exception exception5) {
                // empty catch block
            }
        }
        if (exceptionArray.length == 1) {
            MQAddress mQAddress = (MQAddress)this.addrList.get(0);
            String string = mQAddress.getURL();
            this.connection.getExceptionHandler().handleConnectException(exceptionArray[0], string);
            return null;
        }
        String string = AdministeredObject.cr.getKString("C4003", "[" + this.addrListString + "]");
        ConnectException connectException = new ConnectException(string, "C4003", exceptionArray, stringArray);
        this.connection.getExceptionHandler().handleConnectException(connectException, "");
        return null;
    }

    private ConnectionHandler createConnectionOld(boolean bl) throws JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionOld()");
        }
        if (bl) {
            int n = 0;
            while (true) {
                if (this.connection.isCloseCalled) {
                    return null;
                }
                ++n;
                try {
                    Thread.sleep(this.reconnectDelay);
                    String string = this.connection.getProperty("imqConnectionHandler");
                    StreamHandler streamHandler = StreamHandlerFactory.getStreamHandler(string);
                    return streamHandler.openConnection(this.connection);
                }
                catch (Exception exception) {
                    if (this.reconnectRetries <= 0 || n < this.reconnectRetries) continue;
                    throw new JMSException("Unable to connect.");
                }
                break;
            }
        }
        String string = this.connection.getProperty("imqConnectionHandler");
        StreamHandler streamHandler = null;
        try {
            streamHandler = StreamHandlerFactory.getStreamHandler(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return streamHandler.openConnection(this.connection);
    }

    public boolean getUseAddressList() {
        return this.useAddressList;
    }

    public int getAddrListSize() {
        int n = 0;
        if (this.addrList != null) {
            n = this.addrList.size();
        }
        return n;
    }
}

