/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.xml.messaging.JAXMException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageTransformer {
    private MessageTransformer() {
    }

    public static Message SOAPMessageIntoJMSMessage(SOAPMessage sOAPMessage, Session session) throws JAXMException {
        try {
            BytesMessage bytesMessage = session.createBytesMessage();
            sOAPMessage.saveChanges();
            MessageTransformer.writeMimeHeaders(sOAPMessage, bytesMessage);
            MessageTransformer.writeSOAPBody(sOAPMessage, bytesMessage);
            return bytesMessage;
        }
        catch (JAXMException jAXMException) {
            throw jAXMException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JAXMException((Throwable)exception);
        }
    }

    public static SOAPMessage SOAPMessageFromJMSMessage(Message message, MessageFactory messageFactory) throws JAXMException {
        SOAPMessage sOAPMessage = null;
        BytesMessage bytesMessage = (BytesMessage)message;
        try {
            int n = bytesMessage.readInt();
            byte[] byArray = new byte[n];
            bytesMessage.readBytes(byArray, n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Hashtable hashtable = (Hashtable)objectInputStream.readObject();
            MimeHeaders mimeHeaders = MessageTransformer.hashtableToMime(hashtable);
            int n2 = bytesMessage.readInt();
            byte[] byArray2 = new byte[n2];
            bytesMessage.readBytes(byArray2, n2);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
            if (messageFactory == null) {
                messageFactory = MessageTransformer.getMessageFactory();
            }
            sOAPMessage = messageFactory.createMessage(mimeHeaders, (InputStream)byteArrayInputStream2);
        }
        catch (Exception exception) {
            throw new JAXMException((Throwable)exception);
        }
        return sOAPMessage;
    }

    private static void writeMimeHeaders(SOAPMessage sOAPMessage, BytesMessage bytesMessage) throws Exception {
        MimeHeaders mimeHeaders = sOAPMessage.getMimeHeaders();
        Hashtable hashtable = MessageTransformer.MimeToHashtable(mimeHeaders);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(hashtable);
        objectOutputStream.flush();
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bytesMessage.writeInt(byArray.length);
        bytesMessage.writeBytes(byArray);
        byteArrayOutputStream.close();
    }

    private static void writeSOAPBody(SOAPMessage sOAPMessage, BytesMessage bytesMessage) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bytesMessage.writeInt(byArray.length);
        bytesMessage.writeBytes(byArray);
        byteArrayOutputStream.close();
    }

    private static Hashtable MimeToHashtable(MimeHeaders mimeHeaders) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            hashtable.put(mimeHeader.getName(), mimeHeader.getValue());
        }
        return hashtable;
    }

    private static MimeHeaders hashtableToMime(Hashtable hashtable) {
        MimeHeaders mimeHeaders = new MimeHeaders();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            mimeHeaders.addHeader((String)k, (String)hashtable.get(k));
        }
        return mimeHeaders;
    }

    private static MessageFactory getMessageFactory() throws SOAPException {
        return MessageFactory.newInstance();
    }
}

