/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.server;

import com.sun.messaging.jmq.transport.httptunnel.server.DefaultTrustManager;
import com.sun.messaging.jmq.transport.httptunnel.server.HttpTunnelServerDriver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpsTunnelServerDriver
extends HttpTunnelServerDriver {
    protected boolean trustServlet = true;

    public HttpsTunnelServerDriver(String string, boolean bl) throws IOException {
        this(string, InetAddress.getLocalHost().getHostAddress(), 7674, bl);
    }

    public HttpsTunnelServerDriver(String string, String string2, int n, boolean bl) throws IOException {
        super(string, string2, n);
        this.trustServlet = bl;
        this.setName("HttpsTunnelServerDriver");
        if (DEBUG || DEBUGLINK) {
            System.out.println("Created HttpsTunnelServerDriver for " + string + " to " + string2 + ":" + n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createLink() {
        this.totalRetryWaited = 0;
        if (DEBUG) {
            System.out.println("http:connecting to " + this.webServerHost + ":" + this.webServerPort);
        }
        while (true) {
            try {
                this.serverConn = this.rxBufSize > 0 ? HttpsTunnelServerDriver.getSSLSocket(this.webServerHost, this.webServerPort, this.rxBufSize, this.trustServlet) : HttpsTunnelServerDriver.getSSLSocket(this.webServerHost, this.webServerPort, this.trustServlet);
                this.serverConn.setTcpNoDelay(true);
                if (DEBUG) {
                    System.out.println("######## rcvbuf = " + this.serverConn.getReceiveBufferSize());
                }
                this.is = this.serverConn.getInputStream();
                this.os = this.serverConn.getOutputStream();
                if (DEBUG || DEBUGLINK) {
                    System.out.println("Broker HTTPS link up");
                }
                this.totalRetryWaited = 0;
            }
            catch (Exception exception) {
                if (DEBUG || DEBUGLINK) {
                    System.out.println("Got exception while connecting to servlet: " + exception.getMessage());
                }
                try {
                    Thread.sleep(5000L);
                    this.totalRetryWaited += 5000;
                    if (this.totalRetryWaited < this.inactiveConnAbortInterval * 1000) continue;
                    if (DEBUG || DEBUGLINK) {
                        System.out.println("Retry connect to servlet timeout - cleanup all (" + this.connTable.size() + ") " + "connections and stop retry ...");
                    }
                    this.cleanupAllConns();
                    this.totalRetryWaited = 0;
                    continue;
                }
                catch (Exception exception2) {
                    if (exception2 instanceof IllegalStateException) throw (IllegalStateException)exception2;
                    continue;
                }
            }
            break;
        }
        this.sendLinkInitPacket();
        this.sendListenStatePacket();
    }

    private static SSLSocket getSSLSocket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        if (DEBUG || DEBUGLINK) {
            System.out.println("Creating SSL Socket...");
        }
        try {
            SSLSocketFactory sSLSocketFactory = null;
            sSLSocketFactory = bl ? HttpsTunnelServerDriver.getTrustedSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(inetAddress, n);
            return sSLSocket;
        }
        catch (Exception exception) {
            if (!(exception instanceof IOException)) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.setStackTrace(exception.getStackTrace());
                throw iOException;
            }
            throw (IOException)exception;
        }
    }

    private static SSLSocket getSSLSocket(InetAddress inetAddress, int n, int n2, boolean bl) throws IOException {
        if (DEBUG || DEBUGLINK) {
            System.out.println("Creating SSL Socket with rxBufSize...");
        }
        try {
            SSLSocketFactory sSLSocketFactory = null;
            sSLSocketFactory = bl ? HttpsTunnelServerDriver.getTrustedSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
            sSLSocket.setReceiveBufferSize(n2);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
            sSLSocket.connect(inetSocketAddress);
            return sSLSocket;
        }
        catch (Exception exception) {
            if (!(exception instanceof IOException)) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.setStackTrace(exception.getStackTrace());
                throw iOException;
            }
            throw (IOException)exception;
        }
    }

    private static SSLSocketFactory getTrustedSocketFactory() throws Exception {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
        sSLContext.init(null, trustManagerArray, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory;
    }
}

