/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.memory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public abstract class MemoryLevelHandler {
    protected static Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
    protected String MEMORY_NAME_KEY = null;
    protected String localLevelName = null;
    protected int threshold = 0;
    protected int timeBetweenChecks = 0;
    protected boolean inLevel = false;
    protected long enteredLevelTime = 0L;
    protected long totalTimeInLevel = 0L;
    protected long totalCleanupCount = 0L;
    protected long totalTimesEnteredLevel = 0L;
    protected String levelName = "none";
    protected long MAX_MEMORY_DELTA = 10240L;
    protected long LEVEL_DELTA = 1024L;
    protected static final int NEVER_GC = 0;
    protected static final int PAUSED = 0;

    public MemoryLevelHandler(String string) {
        this.levelName = string;
        this.threshold = Globals.getConfig().getIntProperty("imq." + string + ".threshold", 0);
        this.timeBetweenChecks = Globals.getConfig().getIntProperty("imq." + string + ".seconds", 5) * 1000;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("levelName", this.levelName);
        hashtable.put("threshold", new Integer(this.threshold));
        hashtable.put("timeBetweenChecks", new Integer(this.timeBetweenChecks));
        hashtable.put("threshold", new Integer(this.threshold));
        hashtable.put("enteredLevelTime", new Long(this.enteredLevelTime));
        hashtable.put("totalTimeInLevel", new Long(this.totalTimeInLevel));
        hashtable.put("totalCleanupCount", new Long(this.totalCleanupCount));
        hashtable.put("totalTimesEnteredLevel", new Long(this.totalTimesEnteredLevel));
        hashtable.put("MAX_MEMORY_DELTA", new Long(this.MAX_MEMORY_DELTA));
        hashtable.put("LEVEL_DELTA", new Long(this.LEVEL_DELTA));
        hashtable.put("NEVER_GC", new Integer(0));
        hashtable.put("PAUSED", new Integer(0));
        hashtable.put("gcCount", new Integer(this.gcCount()));
        hashtable.put("gcIteration", new Integer(this.gcIteration()));
        hashtable.put("inLevel", new Boolean(this.inLevel));
        return hashtable;
    }

    public int getThresholdPercent() {
        return this.threshold;
    }

    public int getTimeBetweenChecks() {
        return this.timeBetweenChecks;
    }

    public abstract int getMessageCount(long var1, int var3);

    public abstract long getMemory(long var1, int var3);

    public boolean cleanup(int n) {
        if (DEBUG) {
            logger.log(4, "MM: cleanup() " + this.toDebugString());
        }
        ++this.totalCleanupCount;
        return true;
    }

    public boolean enter(boolean bl) {
        if (DEBUG) {
            logger.log(4, "MM: enter(" + bl + ") " + this.toDebugString());
        }
        this.enteredLevelTime = System.currentTimeMillis();
        ++this.totalTimesEnteredLevel;
        this.inLevel = true;
        return true;
    }

    public boolean leave(boolean bl) {
        if (DEBUG) {
            logger.log(4, "MM: leave(" + bl + ") " + this.toDebugString());
        }
        this.inLevel = false;
        this.totalTimeInLevel += System.currentTimeMillis() - this.enteredLevelTime;
        this.enteredLevelTime = 0L;
        return false;
    }

    public abstract int gcCount();

    public abstract int gcIteration();

    public String toString() {
        return "MemoryLevelHandler[" + this.levelName() + "]";
    }

    public String levelName() {
        return this.levelName;
    }

    public String localizedLevelName() {
        if (this.localLevelName == null) {
            this.localLevelName = this.MEMORY_NAME_KEY != null ? Globals.getBrokerResources().getKString(this.MEMORY_NAME_KEY, this.levelName) : this.levelName;
        }
        return this.localLevelName;
    }

    public long getTotalTimeInLevel() {
        return this.totalTimeInLevel + this.getCurrentTimeInLevel();
    }

    public boolean getIsInLevel() {
        return this.inLevel;
    }

    public long getTotalCleanupCount() {
        return this.totalCleanupCount;
    }

    public long getTotalTimesEnteredLevel() {
        return this.totalTimesEnteredLevel;
    }

    public long getCurrentTimeInLevel() {
        if (this.enteredLevelTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.enteredLevelTime;
    }

    public String toDebugString() {
        return this.toString() + "\n\t" + " inLevel=" + this.inLevel + "\n\t" + ", ThresholdPercent " + this.getThresholdPercent() + "\n\t" + ", totalTimeInLevel " + this.getTotalTimeInLevel() + "\n\t" + ", TotalCleanupCount " + this.getTotalCleanupCount() + "\n\t" + ", totalTimesEnteredLevel " + this.getTotalTimesEnteredLevel() + "\n\t" + ", CurrentTimeInLevel " + this.getCurrentTimeInLevel() + "\n\t" + ", TotalCleanupCount " + this.getTotalCleanupCount() + "\n\t" + ", gcCount " + this.gcCount() + "\n\t" + ", timeBetweenChecks " + this.timeBetweenChecks / 1000 + " sec\n\t" + ", gcIteration " + this.gcIteration();
    }
}

