/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class StateTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private JDBCStore store = null;
    private HashMap midMap = new HashMap();

    StateTable(JDBCStore jDBCStore, boolean bl) throws BrokerException {
        this.store = jDBCStore;
        if (bl) {
            this.clearAll();
        } else {
            this.loadStates();
        }
    }

    public void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        String string = this.store.getMsgTable().checkMessage(sysMessageID);
        this.storeStates(null, sysMessageID, string, consumerUIDArray, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        boolean bl = true;
        String string = sysMessageID.getUniqueName();
        Integer n2 = null;
        HashMap hashMap = null;
        HashMap hashMap2 = this.midMap;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.midMap.get(string);
            if (hashMap == null || (n2 = (Integer)hashMap.get(consumerUID)) == null) {
                logger.log(32, "B3014", (Object)consumerUID.toString(), sysMessageID.toString());
                throw new BrokerException(br.getString("B3014", consumerUID.toString(), sysMessageID.toString()));
            }
            if (n2 != n) {
                boolean bl2 = false;
                do {
                    bl2 = false;
                    DBConnection dBConnection = DBConnection.getDBConnection();
                    try {
                        dBConnection.getConnection().setAutoCommit(true);
                        dBConnection.updateConsumerStateStmt.setInt(1, n);
                        dBConnection.updateConsumerStateStmt.setString(2, string);
                        dBConnection.updateConsumerStateStmt.setLong(3, consumerUID.longValue());
                        dBConnection.updateConsumerStateStmt.executeUpdate();
                        hashMap.put(consumerUID, new Integer(n));
                    }
                    catch (SQLException sQLException) {
                        bl2 = DBConnection.handleException(dBConnection, sQLException);
                        if (bl2) continue;
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.updateConsumerStateSQL + "]", sQLException);
                        logger.log(32, "B4015", consumerUID.toString(), sysMessageID.toString(), sQLException2);
                        throw new BrokerException(br.getString("B4015", consumerUID.toString(), sysMessageID.toString()), sQLException2);
                    }
                    finally {
                        DBConnection.putDBConnection(dBConnection);
                    }
                } while (bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        Integer n = null;
        HashMap hashMap = this.midMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.midMap.get(sysMessageID.getUniqueName());
            if (hashMap2 != null) {
                n = (Integer)hashMap2.get(consumerUID);
            }
        }
        if (n == null) {
            logger.log(32, "B3014", (Object)consumerUID.toString(), sysMessageID.toString());
            throw new BrokerException(br.getString("B3014", consumerUID.toString(), sysMessageID.toString()));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsumerUID[] getConsumerUIDs(SysMessageID sysMessageID) {
        ConsumerUID[] consumerUIDArray = new ConsumerUID[]{};
        HashMap hashMap = this.midMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.midMap.get(sysMessageID.getUniqueName());
            if (hashMap2 != null) {
                ArrayList arrayList = new ArrayList();
                Set set = hashMap2.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Integer n = (Integer)entry.getValue();
                    if (n == 2) continue;
                    arrayList.add(entry.getKey());
                }
                consumerUIDArray = arrayList.toArray(consumerUIDArray);
            }
        }
        return consumerUIDArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStates(SysMessageID sysMessageID) throws BrokerException {
        HashMap hashMap = null;
        HashMap hashMap2 = this.midMap;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.midMap.remove(sysMessageID.getUniqueName());
            if (hashMap == null) {
                return;
            }
            hashMap.clear();
        }
    }

    void removeStates(Set set) throws BrokerException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.removeStates((SysMessageID)iterator.next());
        }
    }

    void loadStates() throws BrokerException {
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            int n = 0;
            ResultSet resultSet = dBConnection.selectAllConsumerStatesStmt.executeQuery();
            while (resultSet.next()) {
                int n2 = resultSet.getInt(3);
                if (n2 == 2) continue;
                String string = resultSet.getString(1);
                long l = resultSet.getLong(2);
                ConsumerUID consumerUID = new ConsumerUID(l);
                HashMap<ConsumerUID, Integer> hashMap = (HashMap<ConsumerUID, Integer>)this.midMap.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap<ConsumerUID, Integer>();
                    this.midMap.put(string, hashMap);
                }
                hashMap.put(consumerUID, new Integer(n2));
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + n + " INTEREST STATES FROM DATABASE");
            }
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllConsumerStatesSQL + "]", sQLException);
            logger.log(32, "B4038", sQLException2);
            throw new BrokerException(br.getString("B4038"), sQLException2);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDebugState() {
        int n = 0;
        Map<String, String> map = this.midMap;
        synchronized (map) {
            Iterator iterator = this.midMap.values().iterator();
            while (iterator.hasNext()) {
                HashMap hashMap = (HashMap)iterator.next();
                n += hashMap.size();
            }
        }
        map = new Hashtable();
        ((Hashtable)map).put("Message/Consumer states(IMQILIST35)", String.valueOf(n));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "StateTable.clearAll() called");
        }
        HashMap hashMap = this.midMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAllConsumerStatesStmt.executeUpdate();
                    HashMap[] hashMapArray = this.midMap.values().toArray(new HashMap[0]);
                    for (int i = 0; i < hashMapArray.length; ++i) {
                        hashMapArray[i].clear();
                    }
                    this.midMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllConsumerStatesSQL + "]", sQLException);
                    logger.log(32, "B4081", sQLException);
                    throw new BrokerException(br.getString("B4081"), sQLException);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        boolean bl = false;
        do {
            bl = false;
            DBConnection dBConnection = null;
            try {
                dBConnection = DBConnection.getDBConnection();
                dBConnection.getConnection().setAutoCommit(true);
                int n = dBConnection.deleteAckStatesStmt.executeUpdate();
                if (!Store.DEBUG) continue;
                logger.log(4, n + " state entries deleted in cleanup");
            }
            catch (BrokerException brokerException) {
                logger.log(16, "B4104", brokerException);
            }
            catch (SQLException sQLException) {
                bl = DBConnection.handleException(dBConnection, sQLException);
                if (bl) continue;
                logger.log(16, "B4104", DBManager.wrapSQLException("[" + DBConnection.deleteAckStatesSQL + "]", sQLException));
            }
            finally {
                if (dBConnection != null) {
                    DBConnection.putDBConnection(dBConnection);
                }
            }
        } while (bl);
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "StateTable.close() called");
        }
        if (bl) {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap moveStates(DBConnection dBConnection, SysMessageID sysMessageID, DestinationUID destinationUID, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException, SQLException {
        HashMap hashMap = null;
        String string = sysMessageID.getUniqueName();
        HashMap hashMap2 = this.midMap;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.midMap.remove(string);
            if (hashMap != null) {
                try {
                    dBConnection.deleteConsumerStatesForMsgStmt.setString(1, string);
                    dBConnection.deleteConsumerStatesForMsgStmt.executeUpdate();
                    if (consumerUIDArray != null && consumerUIDArray.length > 0) {
                        HashMap hashMap3 = this.storeStatesInDB(dBConnection, string, destinationUID.toString(), consumerUIDArray, nArray);
                        this.midMap.put(string, hashMap3);
                    }
                }
                catch (SQLException sQLException) {
                    this.midMap.put(string, hashMap);
                    throw DBManager.wrapSQLException("[" + DBConnection.deleteConsumerStatesForDstSQL + "]", sQLException);
                }
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreStates(SysMessageID sysMessageID, HashMap hashMap) {
        HashMap hashMap2 = this.midMap;
        synchronized (hashMap2) {
            this.midMap.put(sysMessageID.getUniqueName(), hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStates(DBConnection dBConnection, SysMessageID sysMessageID, String string, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        HashMap hashMap = this.midMap;
        synchronized (hashMap) {
            String string2 = sysMessageID.getUniqueName();
            HashMap hashMap2 = (HashMap)this.midMap.get(string2);
            if (hashMap2 != null) {
                logger.log(16, "B3084", sysMessageID.toString());
                throw new BrokerException(br.getString("B3084", sysMessageID.toString()));
            }
            hashMap2 = this.storeStatesInDB(dBConnection, string2, string, consumerUIDArray, nArray);
            this.midMap.put(string2, hashMap2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap storeStatesInDB(DBConnection dBConnection, String string, String string2, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        HashMap<ConsumerUID, Integer> hashMap = new HashMap<ConsumerUID, Integer>(consumerUIDArray.length);
        boolean bl = false;
        if (dBConnection == null) {
            bl = true;
            dBConnection = DBConnection.getDBConnection();
        }
        int n = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        do {
            bl3 = false;
            try {
                dBConnection.getConnection().setAutoCommit(false);
                while (n < consumerUIDArray.length) {
                    hashMap.put(consumerUIDArray[n], new Integer(nArray[n]));
                    dBConnection.insertConsumerStatesStmt.setString(1, string);
                    dBConnection.insertConsumerStatesStmt.setLong(2, consumerUIDArray[n].longValue());
                    dBConnection.insertConsumerStatesStmt.setString(3, string2);
                    dBConnection.insertConsumerStatesStmt.setInt(4, nArray[n]);
                    if (bl2) {
                        try {
                            dBConnection.insertConsumerStatesStmt.addBatch();
                        }
                        catch (SQLException sQLException) {
                            if (n == 0) {
                                bl2 = false;
                                --n;
                            }
                            throw DBManager.wrapSQLException("[" + DBConnection.insertConsumerStatesSQL + "]", sQLException);
                        }
                    } else {
                        dBConnection.insertConsumerStatesStmt.executeUpdate();
                    }
                    ++n;
                }
                if (bl2) {
                    dBConnection.insertConsumerStatesStmt.executeBatch();
                }
                if (bl) {
                    dBConnection.getConnection().commit();
                }
                HashMap<ConsumerUID, Integer> hashMap2 = hashMap;
                return hashMap2;
            }
            catch (SQLException sQLException) {
                if (Store.DEBUG && n < consumerUIDArray.length) {
                    logger.log(4, "Failed to persist interest:" + consumerUIDArray[n].toString() + "(" + consumerUIDArray[n].getUniqueName() + ")");
                }
                if (bl) {
                    bl3 = DBConnection.handleException(dBConnection, sQLException);
                    if (!bl3) {
                        try {
                            dBConnection.getConnection().rollback();
                        }
                        catch (SQLException sQLException2) {
                            logger.log(32, "B4080", sQLException2);
                        }
                    } else {
                        dBConnection = DBConnection.getDBConnection();
                    }
                }
                if (bl3) continue;
                SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.insertConsumerStatesSQL + "]", sQLException);
                logger.log(32, "B4105", (Object)string, (Throwable)sQLException3);
                throw new BrokerException(br.getString("B4105", string), sQLException3);
            }
            finally {
                if (bl) {
                    DBConnection.putDBConnection(dBConnection);
                }
            }
        } while (bl3);
        return hashMap;
    }
}

