/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;

class PropertiesTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private HashMap propMap = new HashMap();

    PropertiesTable(boolean bl) throws BrokerException {
        if (bl) {
            this.clearAll();
        } else {
            this.loadProps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void updateProperty(String string, Object object) throws BrokerException {
        String string2 = null;
        HashMap hashMap = this.propMap;
        synchronized (hashMap) {
            Object v = this.propMap.get(string);
            boolean bl = false;
            do {
                IOException iOException2222;
                Object var12_11;
                ByteArrayInputStream byteArrayInputStream;
                DBConnection dBConnection;
                block24: {
                    block23: {
                        bl = false;
                        dBConnection = DBConnection.getDBConnection();
                        byteArrayInputStream = null;
                        dBConnection.getConnection().setAutoCommit(true);
                        if (v != null) {
                            if (object != null) {
                                string2 = DBConnection.updatePropSQL;
                                byteArrayInputStream = Util.setObject(dBConnection.updatePropStmt, 1, object);
                                dBConnection.updatePropStmt.setString(2, string);
                                dBConnection.updatePropStmt.executeUpdate();
                            } else {
                                string2 = DBConnection.deletePropSQL;
                                dBConnection.deletePropStmt.setString(1, string);
                                dBConnection.deletePropStmt.executeUpdate();
                            }
                        } else if (object != null) {
                            string2 = DBConnection.insertPropSQL;
                            dBConnection.insertPropStmt.setString(1, string);
                            byteArrayInputStream = Util.setObject(dBConnection.insertPropStmt, 2, object);
                            dBConnection.insertPropStmt.executeUpdate();
                        }
                        if (object == null) {
                            if (v != null) {
                                this.propMap.remove(string);
                            }
                            break block23;
                        }
                        this.propMap.put(string, object);
                    }
                    var12_11 = null;
                    if (byteArrayInputStream == null) break block24;
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                DBConnection.putDBConnection(dBConnection);
                {
                    continue;
                    catch (IOException iOException3) {
                        IOException iOException4 = DBManager.wrapIOException("[" + string2 + "]", iOException3);
                        logger.log(32, "B4112", (Object)string, (Throwable)iOException4);
                        throw new BrokerException(br.getString("B4112", string), iOException4);
                    }
                    catch (SQLException sQLException) {
                        bl = DBConnection.handleException(dBConnection, sQLException);
                        if (!bl) {
                            SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                            logger.log(32, "B4112", (Object)string, (Throwable)sQLException2);
                            throw new BrokerException(br.getString("B4112", string), sQLException2);
                        }
                        var12_11 = null;
                        if (byteArrayInputStream != null) {
                            try {
                                byteArrayInputStream.close();
                            }
                            catch (IOException iOException2222) {
                                // empty catch block
                            }
                        }
                        DBConnection.putDBConnection(dBConnection);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException2222) {
                            // empty catch block
                        }
                    }
                    DBConnection.putDBConnection(dBConnection);
                    throw throwable;
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String string) throws BrokerException {
        HashMap hashMap = this.propMap;
        synchronized (hashMap) {
            return this.propMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPropertyNames() throws BrokerException {
        HashMap hashMap = this.propMap;
        synchronized (hashMap) {
            return this.propMap.keySet().toArray(new String[this.propMap.size()]);
        }
    }

    private void loadProps() throws BrokerException {
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            ResultSet resultSet = dBConnection.selectAllPropsStmt.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                try {
                    Object object = Util.readObject(resultSet, 2);
                    this.propMap.put(string, object);
                }
                catch (IOException iOException) {
                    logger.logStack(32, "B4126", iOException);
                }
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + new Integer(this.propMap.size()) + " PROPERTIES FROM DATABASE");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4113", classNotFoundException);
            throw new BrokerException(br.getString("B4113"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllPropsSQL + "]", sQLException);
            logger.log(32, "B4113", sQLException2);
            throw new BrokerException(br.getString("B4113"), sQLException2);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Properties(IMQPROPS35)", String.valueOf(this.propMap.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "PropertiesTable.clearAll() called");
        }
        HashMap hashMap = this.propMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAllPropsStmt.executeUpdate();
                    this.propMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllPropsSQL + "]", sQLException);
                    logger.log(32, "B4081", sQLException);
                    throw new BrokerException(br.getString("B4081"), sQLException);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "PropertiesTable.close() called");
        }
    }
}

