/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class MsgTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private JDBCStore store = null;
    private PreparedStatement selectAllIDsStmt = null;
    private static String selectAllIDsSQL = null;
    private static int selectAllIdsIdIndex = 1;
    private HashMap messageMap = new HashMap();
    private HashMap dstMap = new HashMap();
    private Object dummymsg = new Object();
    private boolean loaded = false;
    private ArrayList namesFromDB = null;
    private int nameindex = 0;
    private Packet tobeReturned = null;
    private Object loadlock = new Object();

    MsgTable(JDBCStore jDBCStore, boolean bl) throws BrokerException {
        this.store = jDBCStore;
        if (bl) {
            this.clearAll();
        }
    }

    void storeMessage(Packet packet) throws BrokerException {
        this.storeMessage(packet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
        String string = sysMessageID.getUniqueName();
        String string2 = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
        DestinationInfo destinationInfo = this.getDestinationInfo(string2);
        int n = packet.getPacketSize();
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            if (this.messageMap.containsKey(sysMessageID)) {
                logger.log(32, "B3008", sysMessageID.toString());
                throw new BrokerException(br.getString("B3008", sysMessageID.toString()));
            }
            boolean bl = false;
            boolean bl2 = false;
            do {
                Object object;
                bl2 = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(false);
                    dBConnection.insertMsgStmt.setString(1, string);
                    dBConnection.insertMsgStmt.setString(2, string2);
                    dBConnection.insertMsgStmt.setInt(3, n);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                    packet.writePacket(byteArrayOutputStream);
                    object = byteArrayOutputStream.toByteArray();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    dBConnection.insertMsgStmt.setBinaryStream(4, (InputStream)byteArrayInputStream, ((Object)object).length);
                    dBConnection.insertMsgStmt.executeUpdate();
                    byteArrayOutputStream.close();
                    byteArrayInputStream.close();
                    if (consumerUIDArray != null) {
                        this.store.getStateTable().storeStates(dBConnection, sysMessageID, string2, consumerUIDArray, nArray);
                        bl = true;
                    }
                    dBConnection.getConnection().commit();
                    this.messageMap.put(sysMessageID, string2);
                    destinationInfo.storeMsg(sysMessageID, n);
                }
                catch (IOException iOException) {
                    if (bl) {
                        this.store.getStateTable().removeStates(sysMessageID);
                    }
                    try {
                        dBConnection.getConnection().rollback();
                    }
                    catch (SQLException sQLException) {
                        logger.log(32, "B4080", sQLException);
                    }
                    object = DBManager.wrapIOException("[" + DBConnection.insertMsgSQL + "]", iOException);
                    logger.log(32, "B4004", (Object)sysMessageID.toString(), (Throwable)object);
                    throw new BrokerException(br.getString("B4004", sysMessageID.toString()), (Throwable)object);
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        this.store.getStateTable().removeStates(sysMessageID);
                    }
                    if (bl2 = DBConnection.handleException(dBConnection, sQLException)) continue;
                    try {
                        dBConnection.getConnection().rollback();
                    }
                    catch (SQLException sQLException2) {
                        logger.log(32, "B4080", sQLException2);
                    }
                    object = DBManager.wrapSQLException("[" + DBConnection.insertMsgSQL + "]", sQLException);
                    logger.log(32, "B4004", (Object)sysMessageID.toString(), (Throwable)object);
                    throw new BrokerException(br.getString("B4004", sysMessageID.toString()), (Throwable)object);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String checkMessage(SysMessageID sysMessageID) throws BrokerException {
        String string = null;
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            string = (String)this.messageMap.get(sysMessageID);
            if (string == null) {
                logger.log(16, "B3007", sysMessageID.toString());
                throw new BrokerException(br.getString("B3007", sysMessageID.toString()));
            }
        }
        return string;
    }

    public Packet getMessage(SysMessageID sysMessageID) throws BrokerException {
        this.checkMessage(sysMessageID);
        return this.loadMessage(sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
        this.checkMessage(sysMessageID);
        DestinationInfo destinationInfo = this.getDestinationInfo(destinationUID.toString());
        DestinationInfo destinationInfo2 = this.getDestinationInfo(destinationUID2.toString());
        if (!destinationInfo.containsMsg(sysMessageID)) {
            logger.log(32, "B3160", (Object)sysMessageID, destinationUID);
            throw new BrokerException(br.getString("B3160", sysMessageID, destinationUID));
        }
        int n = packet.getPacketSize();
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            boolean bl2 = false;
            boolean bl3 = false;
            HashMap hashMap2 = null;
            do {
                Object[] objectArray;
                Object object;
                bl2 = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(false);
                    dBConnection.updateMsgStmt.setString(1, destinationUID2.toString());
                    dBConnection.updateMsgStmt.setInt(2, n);
                    dBConnection.updateMsgStmt.setString(4, sysMessageID.getUniqueName());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                    packet.writePacket(byteArrayOutputStream);
                    object = byteArrayOutputStream.toByteArray();
                    objectArray = new ByteArrayInputStream((byte[])object);
                    dBConnection.updateMsgStmt.setBinaryStream(3, (InputStream)objectArray, ((Object)object).length);
                    dBConnection.updateMsgStmt.executeUpdate();
                    byteArrayOutputStream.close();
                    objectArray.close();
                    hashMap2 = this.store.getStateTable().moveStates(dBConnection, sysMessageID, destinationUID2, consumerUIDArray, nArray);
                    bl3 = true;
                    dBConnection.getConnection().commit();
                    this.messageMap.put(sysMessageID, destinationUID2.toString());
                    destinationInfo.removeMsg(sysMessageID);
                    destinationInfo2.storeMsg(sysMessageID, n);
                }
                catch (SQLException sQLException) {
                    if (bl3) {
                        this.store.getStateTable().restoreStates(sysMessageID, hashMap2);
                    }
                    if (bl2 = DBConnection.handleException(dBConnection, sQLException)) continue;
                    try {
                        dBConnection.getConnection().rollback();
                    }
                    catch (SQLException sQLException2) {
                        logger.log(32, "B4080", sQLException2);
                    }
                    object = DBManager.wrapSQLException("[" + DBConnection.updateMsgSQL + "]", sQLException);
                    objectArray = new Object[]{sysMessageID, destinationUID, destinationUID2};
                    logger.log(32, "B4187", objectArray, (Throwable)object);
                    throw new BrokerException(br.getString("B4187", objectArray), (Throwable)object);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessage(SysMessageID sysMessageID) throws BrokerException {
        String string = null;
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            string = (String)this.messageMap.remove(sysMessageID);
            if (string == null) {
                logger.log(32, "B3007", sysMessageID.toString());
                throw new BrokerException(br.getString("B3007", sysMessageID.toString()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(false);
                    dBConnection.deleteMsgStmt.setString(1, sysMessageID.getUniqueName());
                    dBConnection.deleteMsgStmt.executeUpdate();
                    dBConnection.deleteConsumerStatesForMsgStmt.setString(1, sysMessageID.getUniqueName());
                    dBConnection.deleteConsumerStatesForMsgStmt.executeUpdate();
                    dBConnection.getConnection().commit();
                    this.store.getStateTable().removeStates(sysMessageID);
                    this.removeMessageInfo(sysMessageID, string);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    try {
                        dBConnection.getConnection().rollback();
                    }
                    catch (SQLException sQLException2) {
                        logger.log(32, "B4080", sQLException2);
                    }
                    SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.deleteMsgSQL + "/" + DBConnection.deleteConsumerStatesForMsgSQL + "]", sQLException);
                    logger.log(32, "B4033", (Object)sysMessageID.toString(), (Throwable)sQLException3);
                    throw new BrokerException(br.getString("B4033", sysMessageID.toString()), sQLException3);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(DBConnection dBConnection, String string) throws BrokerException {
        DestinationInfo destinationInfo = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            destinationInfo = (DestinationInfo)this.dstMap.remove(string);
        }
        if (destinationInfo == null) {
            destinationInfo = new DestinationInfo(string, this, dBConnection);
        }
        if (destinationInfo.getMsgCount() == 0) {
            return;
        }
        this.removeAllMessagesFromDB(dBConnection, destinationInfo);
        destinationInfo.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllMessages(String string) throws IOException, BrokerException {
        DestinationInfo destinationInfo;
        DestinationInfo destinationInfo2 = destinationInfo = this.getDestinationInfo(string);
        synchronized (destinationInfo2) {
            if (destinationInfo.getMsgCount() == 0) {
                return;
            }
            this.removeAllMessagesFromDB(null, destinationInfo);
            destinationInfo.reset();
        }
    }

    Enumeration messageEnumeration() throws BrokerException {
        Enumeration enumeration = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgTable.this.store.getDestTable().getAllDestinationNames().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        String string = (String)this.dstitr.next();
                        try {
                            this.tempenum = MsgTable.this.messageEnumeration(string);
                            break;
                        }
                        catch (BrokerException brokerException) {
                            Logger logger = logger;
                            logger;
                            br;
                            logger.log(32, "B4145", (Object)string, (Throwable)brokerException);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object object = this.nextToReturn;
                    this.nextToReturn = null;
                    return object;
                }
                throw new NoSuchElementException();
            }
        };
        return enumeration;
    }

    Enumeration messageEnumeration(String string) throws BrokerException {
        DestinationInfo destinationInfo = this.getDestinationInfo(string);
        return destinationInfo.messageEnumeration();
    }

    int getMessageCount(String string) throws BrokerException {
        DestinationInfo destinationInfo = this.getDestinationInfo(string);
        return destinationInfo.getMsgCount();
    }

    long getByteCount(String string) throws BrokerException {
        DestinationInfo destinationInfo = this.getDestinationInfo(string);
        return destinationInfo.getByteCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Messages(IMQMSG35)", String.valueOf(this.messageMap.size()));
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            Iterator iterator = this.dstMap.values().iterator();
            while (iterator.hasNext()) {
                DestinationInfo destinationInfo = (DestinationInfo)iterator.next();
                hashtable.put(destinationInfo.dst, String.valueOf(destinationInfo.msgCount));
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "MsgTable.clearAll() called");
        }
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                if (Store.DEBUG) {
                    logger.log(1, "\tSQL='" + DBConnection.truncateMsgsTableSQL + "'");
                }
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.truncateMsgsTableStmt.executeUpdate();
                    this.messageMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.truncateMsgsTableSQL + "]", sQLException);
                    logger.log(32, "B4081", sQLException2);
                    throw new BrokerException(br.getString("B4081"), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "MsgTable.close() called");
        }
    }

    private Packet loadMessage(SysMessageID sysMessageID) throws BrokerException {
        try {
            Packet packet = this.loadMessage(sysMessageID.getUniqueName());
            if (packet == null) {
                logger.log(16, "B3007", sysMessageID.toString());
                throw new BrokerException(br.getString("B3007", sysMessageID.toString()));
            }
            return packet;
        }
        catch (IOException iOException) {
            logger.log(32, "B4107", (Object)sysMessageID.toString(), (Throwable)iOException);
            throw new BrokerException(br.getString("B4107", sysMessageID.toString()), iOException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B4107", (Object)sysMessageID.toString(), (Throwable)sQLException);
            throw new BrokerException(br.getString("B4107", sysMessageID.toString()), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet loadMessage(String string) throws BrokerException, SQLException, IOException {
        boolean bl = false;
        do {
            bl = false;
            DBConnection dBConnection = DBConnection.getDBConnection();
            try {
                Object object;
                dBConnection.selectMsgStmt.setString(1, string);
                ResultSet resultSet = dBConnection.selectMsgStmt.executeQuery();
                Packet packet = null;
                if (resultSet.next()) {
                    packet = new Packet(false);
                    packet.generateTimestamp(false);
                    packet.generateSequenceNumber(false);
                    object = resultSet.getBinaryStream(1);
                    packet.readPacket((InputStream)object);
                    if (Store.DEBUG) {
                        logger.log(4, "loaded message from database for " + string);
                    }
                }
                resultSet.close();
                object = packet;
                return object;
            }
            catch (IOException iOException) {
                throw DBManager.wrapIOException("[" + DBConnection.selectMsgSQL + "]", iOException);
            }
            catch (SQLException sQLException) {
                bl = DBConnection.handleException(dBConnection, sQLException);
                if (bl) continue;
                throw DBManager.wrapSQLException("[" + DBConnection.selectMsgSQL + "]", sQLException);
            }
            finally {
                DBConnection.putDBConnection(dBConnection);
            }
        } while (bl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator loadMessageIDs(String string) throws SQLException, BrokerException {
        boolean bl = false;
        do {
            bl = false;
            DBConnection dBConnection = DBConnection.getDBConnection();
            try {
                dBConnection.selectMsgIDsForDstStmt.setString(1, string);
                ResultSet resultSet = dBConnection.selectMsgIDsForDstStmt.executeQuery();
                ArrayList<String> arrayList = new ArrayList<String>();
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString(1));
                }
                resultSet.close();
                if (Store.DEBUG) {
                    logger.log(4, "loaded message ids from database for " + string);
                }
                Iterator iterator = arrayList.iterator();
                return iterator;
            }
            catch (SQLException sQLException) {
                bl = DBConnection.handleException(dBConnection, sQLException);
                if (bl) continue;
                throw DBManager.wrapSQLException("[" + DBConnection.selectMsgIDsForDstSQL + "]", sQLException);
            }
            finally {
                DBConnection.putDBConnection(dBConnection);
            }
        } while (bl);
        return new ArrayList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationInfo getDestinationInfo(String string) throws BrokerException {
        this.store.getDestTable().checkDestination(string);
        DestinationInfo destinationInfo = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            destinationInfo = (DestinationInfo)this.dstMap.get(string);
            if (destinationInfo == null) {
                destinationInfo = new DestinationInfo(string, this, null);
                this.dstMap.put(string, destinationInfo);
            }
        }
        return destinationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheMessage(SysMessageID sysMessageID, String string) {
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            this.messageMap.put(sysMessageID, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessagesFromCache(Set set) {
        Iterator iterator = set.iterator();
        HashMap hashMap = this.messageMap;
        synchronized (hashMap) {
            while (iterator.hasNext()) {
                this.messageMap.remove(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessageInfo(SysMessageID sysMessageID, String string) {
        DestinationInfo destinationInfo = null;
        HashMap hashMap = this.dstMap;
        synchronized (hashMap) {
            destinationInfo = (DestinationInfo)this.dstMap.get(string);
        }
        if (destinationInfo != null) {
            destinationInfo.removeMsg(sysMessageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllMessagesFromDB(DBConnection dBConnection, DestinationInfo destinationInfo) throws BrokerException {
        String string = destinationInfo.getDst();
        boolean bl = false;
        if (dBConnection == null) {
            bl = true;
            dBConnection = DBConnection.getDBConnection();
        }
        boolean bl2 = false;
        do {
            bl2 = false;
            try {
                dBConnection.getConnection().setAutoCommit(false);
                dBConnection.deleteMsgsForDstStmt.setString(1, string);
                dBConnection.deleteMsgsForDstStmt.executeUpdate();
                dBConnection.deleteConsumerStatesForDstStmt.setString(1, string);
                dBConnection.deleteConsumerStatesForDstStmt.executeUpdate();
                if (bl) {
                    dBConnection.getConnection().commit();
                }
                Set set = destinationInfo.getMsgSet();
                this.removeMessagesFromCache(set);
                this.store.getStateTable().removeStates(set);
            }
            catch (SQLException sQLException) {
                if (bl) {
                    bl2 = DBConnection.handleException(dBConnection, sQLException);
                    if (!bl2) {
                        try {
                            dBConnection.getConnection().rollback();
                        }
                        catch (SQLException sQLException2) {
                            logger.log(32, "B4080", sQLException2);
                        }
                    } else {
                        dBConnection = DBConnection.getDBConnection();
                    }
                }
                if (bl2) continue;
                SQLException sQLException3 = DBManager.wrapSQLException("[" + DBConnection.deleteMsgsForDstSQL + "/" + DBConnection.deleteConsumerStatesForDstSQL + "]", sQLException);
                logger.log(32, "B4150", (Object)string, (Throwable)sQLException3);
                throw new BrokerException(br.getString("B4150", string), sQLException3);
            }
            finally {
                if (bl) {
                    DBConnection.putDBConnection(dBConnection);
                }
            }
        } while (bl2);
    }

    private static class MsgEnumeration
    implements Enumeration {
        DestinationInfo parent = null;
        MsgTable msgstore = null;
        Iterator itr = null;
        Object msgToReturn = null;

        MsgEnumeration(MsgTable msgTable, DestinationInfo destinationInfo, Iterator iterator) {
            this.msgstore = msgTable;
            this.parent = destinationInfo;
            this.itr = iterator;
        }

        public boolean hasMoreElements() {
            Packet packet = null;
            while (this.itr.hasNext()) {
                Object var2_2 = null;
                try {
                    var2_2 = this.itr.next();
                    if (var2_2 instanceof String) {
                        packet = this.msgstore.loadMessage(var2_2);
                        this.parent.cacheMsg((SysMessageID)packet.getSysMessageID().clone(), packet.getPacketSize());
                    } else {
                        packet = this.msgstore.loadMessage(var2_2);
                    }
                    this.msgToReturn = packet;
                    return true;
                }
                catch (IOException iOException) {
                    if (!Store.DEBUG) continue;
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(32, "B4107", (Object)var2_2, (Throwable)iOException);
                }
                catch (SQLException sQLException) {
                    if (!Store.DEBUG) continue;
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(32, "B4107", (Object)var2_2, (Throwable)sQLException);
                }
                catch (BrokerException brokerException) {
                    if (!Store.DEBUG) continue;
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(32, "B4107", (Object)var2_2, (Throwable)brokerException);
                }
            }
            this.parent.enumerated = true;
            return false;
        }

        public Object nextElement() {
            if (this.msgToReturn != null) {
                return this.msgToReturn;
            }
            throw new NoSuchElementException();
        }
    }

    private static class DestinationInfo {
        String dst;
        boolean enumerated = false;
        MsgTable parent;
        int msgCount = 0;
        long byteCount = 0L;
        HashMap msgMap = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DestinationInfo(String string, MsgTable msgTable, DBConnection dBConnection) throws BrokerException {
            this.dst = string;
            this.parent = msgTable;
            this.msgMap = new HashMap();
            boolean bl = false;
            if (dBConnection == null) {
                bl = true;
                dBConnection = DBConnection.getDBConnection();
            }
            boolean bl2 = false;
            do {
                bl2 = false;
                try {
                    dBConnection.getCountsStmt.setString(1, string);
                    ResultSet resultSet = dBConnection.getCountsStmt.executeQuery();
                    if (resultSet.next()) {
                        this.msgCount = resultSet.getInt(1);
                        this.byteCount = resultSet.getLong(2);
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    if (bl && (bl2 = DBConnection.handleException(dBConnection, sQLException))) {
                        dBConnection = DBConnection.getDBConnection();
                    }
                    if (bl2) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.getCountsSQL + "]", sQLException);
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(32, "B4152", (Object)string, (Throwable)sQLException);
                    BrokerResources brokerResources = br;
                    br;
                    throw new BrokerException(brokerResources.getString("B4152", string), sQLException);
                }
                finally {
                    if (bl) {
                        DBConnection.putDBConnection(dBConnection);
                    }
                }
            } while (bl2);
        }

        synchronized boolean containsMsg(SysMessageID sysMessageID) {
            return this.msgMap.containsKey(sysMessageID);
        }

        synchronized void storeMsg(SysMessageID sysMessageID, int n) {
            this.msgMap.put(sysMessageID, new Integer(n));
            ++this.msgCount;
            this.byteCount += (long)n;
        }

        synchronized void removeMsg(SysMessageID sysMessageID) {
            Integer n = (Integer)this.msgMap.remove(sysMessageID);
            if (n != null) {
                --this.msgCount;
                this.byteCount -= (long)n.intValue();
            }
        }

        synchronized void cacheMsg(SysMessageID sysMessageID, int n) {
            this.msgMap.put(sysMessageID, new Integer(n));
            this.parent.cacheMessage(sysMessageID, this.dst);
        }

        synchronized Set getMsgSet() {
            return this.msgMap.keySet();
        }

        synchronized Enumeration messageEnumeration() throws BrokerException {
            Object var1_1 = null;
            Iterator iterator = null;
            if (this.enumerated) {
                iterator = this.msgMap.keySet().iterator();
            } else {
                try {
                    iterator = this.parent.loadMessageIDs(this.dst);
                }
                catch (SQLException sQLException) {
                    Logger logger = logger;
                    logger;
                    br;
                    logger.log(32, "B4145", (Object)this.dst, (Throwable)sQLException);
                    BrokerResources brokerResources = br;
                    br;
                    throw new BrokerException(brokerResources.getString("B4145", this.dst), sQLException);
                }
            }
            return new MsgEnumeration(this.parent, this, iterator);
        }

        String getDst() {
            return this.dst;
        }

        int getMsgCount() {
            return this.msgCount;
        }

        long getByteCount() {
            return this.byteCount;
        }

        void reset() {
            this.enumerated = true;
            this.msgCount = 0;
            this.byteCount = 0L;
            this.msgMap.clear();
        }
    }
}

