/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConfigRecordTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBTool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DestTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.InterestTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MsgTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertiesTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StateTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.TxnTable;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class JDBCStore
extends Store
implements DBConstants {
    private DBManager dbmgr = new DBManager(false);
    String brokerid = this.dbmgr.getBrokerID();
    private StateTable stateTable = null;
    private MsgTable msgTable = null;
    private InterestTable interestTable = null;
    private DestTable destTable = null;
    private TxnTable txnTable = null;
    private ConfigRecordTable recordTable = null;
    private PropertiesTable propTable = null;
    private int _CONTINUE = 0;
    private int _UPGRADE = 1;
    private int _REMOVEOLD = 2;
    private int _CREATENEW = 3;
    boolean supportBatch = true;

    public JDBCStore() throws BrokerException {
        if (this.brokerid.length() > 0) {
            this.logger.logToAll(8, this.br.getString("B1067", this.dbmgr.getOpenDBURL(), this.brokerid));
        } else {
            this.logger.logToAll(8, this.br.getString("B1142", this.dbmgr.getOpenDBURL()));
        }
        Connection connection = this.dbmgr.connectToUse(true);
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.supportBatch = databaseMetaData.supportsBatchUpdates();
            if (DEBUG) {
                this.logger.log(4, "database support batch = " + this.supportBatch);
            }
        }
        catch (SQLException sQLException) {
            this.logger.log(32, "B4164", sQLException);
            throw new BrokerException(this.br.getString("B4164"), sQLException);
        }
        int n = this.checkStore(connection);
        if (this.removeStore) {
            int n2 = n == this._REMOVEOLD ? 200 : 350;
            try {
                DBTool.dropTables(connection, true, this.logger, this.dbmgr.getTableNames(n2));
                this.closeDB(false);
                return;
            }
            catch (SQLException sQLException) {
                throw new BrokerException(this.br.getString("B3121", this.dbmgr.getOpenDBURL()), sQLException);
            }
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        DBConnection.init(this.dbmgr);
        this.destTable = new DestTable(this, this.resetStore);
        this.stateTable = new StateTable(this, this.resetStore || this.resetMessage);
        this.msgTable = new MsgTable(this, this.resetStore || this.resetMessage);
        this.interestTable = new InterestTable(this.resetStore || this.resetInterest);
        this.txnTable = new TxnTable(this.resetStore);
        this.recordTable = new ConfigRecordTable(this.resetStore);
        this.propTable = new PropertiesTable(this.resetStore);
        if (DEBUG) {
            this.logger.log(4, "JDBCStore instantiated.");
        }
    }

    private void createTables(Connection connection) throws BrokerException {
        try {
            DBTool.createTables(this.dbmgr, connection);
        }
        catch (SQLException sQLException) {
            throw new BrokerException("Failed to create new tables during upgrade", sQLException);
        }
    }

    public void storeMessage(Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        this.storeMessage(null, packet, consumerUIDArray, nArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeMessage() called with message:" + packet.getSysMessageID().hashCode());
        }
        if (packet == null || consumerUIDArray == null || nArray == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(this.br.getString("B3085"));
            }
            this.msgTable.storeMessage(packet, consumerUIDArray, nArray);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeMessage(Packet packet, boolean bl) throws BrokerException {
        DestinationUID destinationUID = DestinationUID.getUID(packet.getDestination(), packet.getIsQueue());
        this.storeMessage(destinationUID, packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeMessage() called with message:" + packet.getSysMessageID().hashCode());
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgTable.storeMessage(packet);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.moveMessage() called for:" + packet.getSysMessageID() + " from " + destinationUID + " to " + destinationUID2);
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        super.checkClosedAndSetInProgress();
        try {
            this.msgTable.moveMessage(packet, destinationUID, destinationUID2, consumerUIDArray, nArray, bl);
        }
        finally {
            super.setInProgress(false);
        }
    }

    public void removeMessage(SysMessageID sysMessageID, boolean bl) throws BrokerException {
        this.removeMessage(null, sysMessageID, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeMessage() called with message:" + sysMessageID.hashCode());
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgTable.removeMessage(sysMessageID);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeAllMessages() for dst:" + destination);
        }
        if (destination == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgTable.removeAllMessages(destination.getUniqueName());
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.messageEnumeration() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgTable.messageEnumeration();
            return enumeration;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.messageEnumeration() called for " + destination);
        }
        this.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgTable.messageEnumeration(destination.getUniqueName());
            return enumeration;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getMessageCount() called for " + destination);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            int n = this.msgTable.getMessageCount(destination.getUniqueName());
            return n;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getByteCount(Destination destination) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getByteCount() called for " + destination);
        }
        super.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            long l = this.msgTable.getByteCount(destination.getUniqueName());
            return l;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public Packet getMessage(SysMessageID sysMessageID) throws BrokerException {
        return this.getMessage(null, sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getMessage() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgTable.getMessage(sysMessageID);
            return packet;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void storeInterestStates(SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        this.storeInterestStates(null, sysMessageID, consumerUIDArray, nArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeInterestStates() called with message: " + sysMessageID.hashCode());
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(this.br.getString("B3085"));
            }
            this.stateTable.storeInterestStates(sysMessageID, consumerUIDArray, nArray);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void updateInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        this.updateInterestState(null, sysMessageID, consumerUID, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateInterestState() called with message: " + sysMessageID.hashCode() + ", iid: " + consumerUID.hashCode() + ", state=" + n);
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            this.msgTable.checkMessage(sysMessageID);
            this.stateTable.updateInterestState(sysMessageID, consumerUID, n);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int getInterestState(SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        return this.getInterestState(null, sysMessageID, consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getInterestState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            this.msgTable.checkMessage(sysMessageID);
            int n = this.stateTable.getInterestState(sysMessageID, consumerUID);
            return n;
        }
        finally {
            this.setInProgress(false);
        }
    }

    public ConsumerUID[] getConsumerUIDs(SysMessageID sysMessageID) throws BrokerException {
        return this.getConsumerUIDs(null, sysMessageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getConsumerUIDs() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null) {
                throw new NullPointerException();
            }
            this.msgTable.checkMessage(sysMessageID);
            ConsumerUID[] consumerUIDArray = this.stateTable.getConsumerUIDs(sysMessageID);
            return consumerUIDArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeInterest() called with interest: " + consumer.getConsumerUID().hashCode());
        }
        this.checkClosedAndSetInProgress();
        try {
            this.interestTable.storeInterest(consumer);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeInterest() called with interest: " + consumer.getConsumerUID().hashCode());
        }
        this.checkClosedAndSetInProgress();
        try {
            this.interestTable.removeInterest(consumer);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.interestTable.getAllInterests();
            return consumerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.destTable.storeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.destTable.updateDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.destTable.removeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllDestinations() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.destTable.getAllDestinations();
            return destinationArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionState == null) {
                throw new NullPointerException();
            }
            this.txnTable.storeTransaction(transactionUID, transactionState);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.txnTable.removeTransaction(transactionUID);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransactionState(TransactionUID transactionUID, int n, boolean bl) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.updateTransactionState( id=" + transactionUID + ", ts=" + n + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.txnTable.updateTransactionState(transactionUID, n);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnTable.getAllTransactionStates();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllTransactions(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearAllTransactions() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnTable.clearAll();
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransactions(int n, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearTransactions(state=" + n + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnTable.clear(n);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionAcknowledgement == null) {
                throw new NullPointerException();
            }
            this.txnTable.storeTransactionAck(transactionUID, transactionAcknowledgement);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.removeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.txnTable.removeTransactionAck(transactionUID);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnTable.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.txnTable.getTransactionAcks(transactionUID);
            return transactionAcknowledgementArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.updateProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            this.propTable.updateProperty(string, object);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            Object object = this.propTable.getProperty(string);
            return object;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyNames() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propTable.getPropertyNames();
            return stringArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.storeConfigChangeRecord() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (l <= 0L) {
                this.logger.log(32, "B3074", new Long(l));
                throw new BrokerException(this.br.getString("B3074", new Long(l)));
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.recordTable.storeConfigChangeRecord(l, byArray);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConfigChangeRecordsSince(long l) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            ArrayList arrayList = this.recordTable.getConfigChangeRecordsSince(l);
            return arrayList;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllConfigRecords() throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(4, "JDBCStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Object[] objectArray = this.recordTable.getAllConfigRecords();
            return objectArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.recordTable.clearAllRecords();
        }
        finally {
            this.setInProgress(false);
        }
    }

    public int getNumberOfTxnAcks() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll(boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgTable.clearAll();
            this.interestTable.clearAll();
            this.stateTable.clearAll();
            this.destTable.clearAll();
            this.propTable.clearAll();
            this.txnTable.clearAll();
            this.recordTable.clearAllRecords();
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void close(boolean bl) {
        this.setClosedAndWait();
        this.msgTable.close(bl);
        this.interestTable.close(bl);
        this.stateTable.close(bl);
        this.destTable.close(bl);
        this.txnTable.close(bl);
        this.recordTable.close(bl);
        this.propTable.close(bl);
        this.closeDB(true);
        if (DEBUG) {
            this.logger.log(4, "JDBCStore.close(" + bl + ") done.");
        }
    }

    StateTable getStateTable() {
        return this.stateTable;
    }

    DestTable getDestTable() {
        return this.destTable;
    }

    MsgTable getMsgTable() {
        return this.msgTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeDB(boolean bl) {
        block9: {
            block10: {
                DBConnection dBConnection = null;
                try {
                    block8: {
                        try {
                            if (!bl) break block8;
                            dBConnection = DBConnection.getDBConnection();
                            dBConnection.getConnection().setAutoCommit(false);
                            DBManager.lockTables(dBConnection.getConnection(), "IMQSV35" + this.brokerid, false);
                        }
                        catch (BrokerException brokerException) {
                            this.logger.log(16, "B4103", brokerException);
                            Object var5_4 = null;
                            if (dBConnection != null) {
                                DBConnection.putDBConnection(dBConnection);
                            }
                            DBConnection.reset();
                            break block9;
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(16, "B4103", sQLException);
                            Object var5_5 = null;
                            if (dBConnection != null) {
                                DBConnection.putDBConnection(dBConnection);
                            }
                            DBConnection.reset();
                            break block9;
                        }
                    }
                    Object var5_3 = null;
                    if (dBConnection == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (dBConnection != null) {
                        DBConnection.putDBConnection(dBConnection);
                    }
                    DBConnection.reset();
                    throw throwable;
                }
                DBConnection.putDBConnection(dBConnection);
            }
            DBConnection.reset();
        }
        this.dbmgr.close();
    }

    public String getStoreType() {
        return "jdbc";
    }

    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        throw new BrokerException(this.br.getString("B3136"));
    }

    public Hashtable getDebugState() {
        String string = this.dbmgr.getOpenDBURL();
        String string2 = "";
        if (this.brokerid != null && this.brokerid.length() > 0) {
            string2 = "(" + this.brokerid + ")";
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("JDBC-based store", string + string2);
        hashtable.put("Store version", String.valueOf(350));
        hashtable.putAll(this.destTable.getDebugState());
        hashtable.putAll(this.msgTable.getDebugState());
        hashtable.putAll(this.interestTable.getDebugState());
        hashtable.putAll(this.stateTable.getDebugState());
        hashtable.putAll(this.txnTable.getDebugState());
        hashtable.putAll(this.propTable.getDebugState());
        hashtable.putAll(this.recordTable.getDebugState());
        return hashtable;
    }

    public void compactDestination(Destination destination) throws BrokerException {
        throw new BrokerException(this.br.getString("B3136"));
    }

    private int checkStore(Connection connection) throws BrokerException {
        int n = this._CONTINUE;
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new BrokerException("Failed to set autocommit", sQLException);
        }
        String string = "IMQSV35" + this.brokerid;
        String string2 = "IMQSV" + this.brokerid;
        if (this.checkAndLock(connection, string)) {
            if (this.checkVersion(connection, string2, "STOREVERSION", 200) && !this.removeStore) {
                this.logger.logToAll(8, "B1111");
            }
        } else if (this.checkVersion(connection, string2, "STOREVERSION", 200)) {
            if (this.removeStore) {
                this.logger.logToAll(8, "B1112");
                n = this._REMOVEOLD;
            } else if (this.resetStore) {
                this.logger.logToAll(8, "B1113");
                this.logger.logToAll(8, "B1114");
                try {
                    DBTool.dropTables(connection, true, this.logger, this.dbmgr.getTableNames(200));
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(this.br.getString("B3133"), sQLException);
                }
                this.createTables(connection);
            } else {
                Object[] objectArray = new Object[]{new Integer(200)};
                this.logger.logToAll(8, "B1109", objectArray);
                if (this.upgradeNoBackup && !Broker.force) {
                    this.getConfirmation();
                }
                UpgradeStore.upgradeStore(this, this.dbmgr, connection);
            }
        } else {
            this.logger.log(32, "B3132");
            throw new BrokerException(this.br.getString("B3132"));
        }
        return n;
    }

    private boolean checkAndLock(Connection connection, String string) throws BrokerException {
        if (!this.checkVersion(connection, string, "STOREVERSION", 350)) {
            return false;
        }
        try {
            connection.setAutoCommit(false);
            DBManager.lockTables(connection, string, true);
            connection.setAutoCommit(true);
            return true;
        }
        catch (SQLException sQLException) {
            throw new BrokerException(sQLException.getMessage());
        }
    }

    private boolean checkVersion(Connection connection, String string, String string2, int n) throws BrokerException {
        ResultSet resultSet;
        Statement statement;
        block19: {
            String string3 = "SELECT " + string2 + " FROM " + string;
            int n2 = 1;
            statement = null;
            resultSet = null;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string3);
            }
            catch (SQLException sQLException) {
                block18: {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException2) {
                            if (!DEBUG) break block18;
                            this.logger.log(4, "Got exception while closing a Statement", sQLException);
                        }
                    }
                }
                return false;
            }
            if (!resultSet.next()) break block19;
            int n3 = resultSet.getInt(n2);
            if (n3 != n) {
                String string4 = n == 350 ? "B3092" : "B3125";
                this.logger.log(32, string4, (Object)new Integer(n3), new Integer(n));
                throw new BrokerException(this.br.getString(string4, new Integer(n3), new Integer(n)));
            }
            boolean bl = true;
            Object var12_15 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4114", sQLException);
            }
            return bl;
        }
        try {
            try {
                this.logger.log(32, "B3131", string);
                throw new BrokerException(this.br.getString("B3131", string));
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4114", sQLException);
                throw new BrokerException(this.br.getString("B4114"), sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(32, "B4114", sQLException);
            }
            throw throwable;
        }
    }

    boolean resetMessage() {
        return this.resetMessage;
    }

    boolean resetInterest() {
        return this.resetInterest;
    }
}

