/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnection;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;

class InterestTable
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private HashMap interestMap = new HashMap();

    InterestTable(boolean bl) throws BrokerException {
        if (bl) {
            this.clearAll();
        } else {
            this.loadInterests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeInterest(Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        HashMap hashMap = this.interestMap;
        synchronized (hashMap) {
            if (this.interestMap.get(consumerUID) != null) {
                logger.log(32, "B3010", (Object)consumerUID, consumer.getDestinationUID().getLongString());
                throw new BrokerException(br.getString("B3010", consumerUID, consumer.getDestinationUID().getLongString()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.insertConsumerStmt.setLong(1, consumerUID.longValue());
                    ByteArrayInputStream byteArrayInputStream = Util.setObject(dBConnection.insertConsumerStmt, 2, consumer);
                    dBConnection.insertConsumerStmt.executeUpdate();
                    byteArrayInputStream.close();
                    this.interestMap.put(consumerUID, consumer);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.insertConsumerSQL + "]", iOException);
                    logger.log(32, "B4012", (Object)consumerUID, (Throwable)iOException2);
                    throw new BrokerException(br.getString("B4012", consumerUID), iOException2);
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.insertConsumerSQL + "]", sQLException);
                    logger.log(32, "B4012", (Object)consumerUID, (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4012", consumerUID), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInterest(Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        HashMap hashMap = this.interestMap;
        synchronized (hashMap) {
            if (this.interestMap.remove(consumerUID) == null) {
                logger.log(32, "B3011", (Object)consumerUID, consumer.getDestinationUID().getLongString());
                throw new BrokerException(br.getString("B3011", consumerUID, consumer.getDestinationUID().getLongString()));
            }
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteConsumerStmt.setLong(1, consumerUID.longValue());
                    dBConnection.deleteConsumerStmt.executeUpdate();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteConsumerSQL + "]", sQLException);
                    logger.log(32, "B4034", (Object)consumerUID, (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4034", consumerUID), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Consumer[] getAllInterests() throws IOException {
        HashMap hashMap = this.interestMap;
        synchronized (hashMap) {
            return this.interestMap.values().toArray(new Consumer[0]);
        }
    }

    private void loadInterests() throws BrokerException {
        DBConnection dBConnection = DBConnection.getDBConnection();
        try {
            ResultSet resultSet = dBConnection.selectAllConsumersStmt.executeQuery();
            while (resultSet.next()) {
                try {
                    Consumer consumer = (Consumer)Util.readObject(resultSet, 1);
                    this.interestMap.put(consumer.getConsumerUID(), consumer);
                }
                catch (IOException iOException) {
                    IOException iOException2 = DBManager.wrapIOException("[" + DBConnection.selectAllConsumersSQL + "]", iOException);
                    logger.logStack(32, "B4125", iOException2);
                }
            }
            resultSet.close();
            if (Store.DEBUG) {
                logger.log(4, "LOADED " + new Integer(this.interestMap.size()) + " INTERESTS FROM DATABASE");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(32, "B4035", classNotFoundException);
            throw new BrokerException(br.getString("B4035"), classNotFoundException);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.selectAllConsumersSQL + "]", sQLException);
            logger.log(32, "B4035", sQLException2);
            throw new BrokerException(br.getString("B4035"), sQLException2);
        }
        finally {
            DBConnection.putDBConnection(dBConnection);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Conusmers(IMQINT35)", String.valueOf(this.interestMap.size()));
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.DEBUG) {
            logger.log(1, "InterestTable.clearAll() called");
        }
        HashMap hashMap = this.interestMap;
        synchronized (hashMap) {
            boolean bl = false;
            do {
                bl = false;
                DBConnection dBConnection = DBConnection.getDBConnection();
                try {
                    dBConnection.getConnection().setAutoCommit(true);
                    dBConnection.deleteAllConsumersStmt.executeUpdate();
                    this.interestMap.clear();
                }
                catch (SQLException sQLException) {
                    bl = DBConnection.handleException(dBConnection, sQLException);
                    if (bl) continue;
                    SQLException sQLException2 = DBManager.wrapSQLException("[" + DBConnection.deleteAllConsumersSQL + "]", sQLException);
                    logger.log(32, "B4169", (Object)DBConnection.consumerTable, (Throwable)sQLException2);
                    throw new BrokerException(br.getString("B4169", DBConnection.consumerTable), sQLException2);
                }
                finally {
                    DBConnection.putDBConnection(dBConnection);
                }
            } while (bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInterest(Consumer consumer) throws BrokerException {
        ConsumerUID consumerUID = consumer.getConsumerUID();
        HashMap hashMap = this.interestMap;
        synchronized (hashMap) {
            if (!this.interestMap.containsKey(consumerUID)) {
                logger.log(32, "B3011", (Object)consumerUID, consumer.getDestinationUID().getLongString());
                throw new BrokerException(br.getString("B3011", consumerUID, consumer.getDestinationUID().getLongString()));
            }
        }
    }

    void close(boolean bl) {
        if (Store.DEBUG) {
            logger.log(1, "InterestTable.close() called");
        }
    }
}

