/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

class DBConnection
implements DBConstants {
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();
    private static final String NUM_CONN_PROP = "imq.persist.jdbc.connection.limit";
    private static final String USE_TRUNCATE_PROP = "imq.persist.jdbc.sql.useTruncate";
    private static final int DEFAULT_NUM_CONN = 4;
    private static int numConnections = 4;
    private static boolean useTruncate = true;
    private static boolean initialized = false;
    static LinkedList idleConnections = null;
    static HashSet active = null;
    static DBManager dbmgr;
    static String ccrecordTable;
    static String dstTable;
    static String consumerTable;
    static String msgTable;
    static String stateTable;
    static String propTable;
    static String txnTable;
    static String txnackTable;
    static String versionTable;
    static String testSQL;
    static String insertCCRecordSQL;
    static final int insertCCRTimeIndex = 1;
    static final int insertCCRRecordIndex = 2;
    static String deleteAllCCRecordsSQL;
    static String selectAllCCRecordsSQL;
    static final int selectAllCCRTimeIndex = 1;
    static final int selectAllCCRRecordIndex = 2;
    static String insertDstSQL;
    static final int insertDstDidIndex = 1;
    static final int insertDstDstIndex = 2;
    static String updateDstSQL;
    static final int updateDstDstIndex = 1;
    static final int updateDstDidIndex = 2;
    static String deleteDstSQL;
    static final int deleteDstDidIndex = 1;
    static String selectAllDstsSQL;
    static final int selectDestIndex = 1;
    static String deleteAllDstsSQL;
    static String insertConsumerSQL;
    static final int insertConsumerCUIDIndex = 1;
    static final int insertConsumerConsIndex = 2;
    static String deleteConsumerSQL;
    static final int deleteConsumerCUIDIndex = 1;
    static String selectAllConsumersSQL;
    static final int selectAllConsumersConsIndex = 1;
    static String deleteAllConsumersSQL;
    static String insertMsgSQL;
    static final int insertMsgMIDIndex = 1;
    static final int insertMsgDIDIndex = 2;
    static final int insertMsgSizeIndex = 3;
    static final int insertMsgMsgIndex = 4;
    static String updateMsgSQL;
    static final int updateMsgDIDIndex = 1;
    static final int updateMsgSizeIndex = 2;
    static final int updateMsgMsgIndex = 3;
    static final int updateMsgMIDIndex = 4;
    static String deleteMsgSQL;
    static final int deleteMsgMidIndex = 1;
    static String deleteMsgsForDstSQL;
    static final int deleteMsgsForDstDidIndex = 1;
    static String getCountsSQL;
    static final int getCountsDidIndex = 1;
    static final int getCountsMCIndex = 1;
    static final int getCountsBCIndex = 2;
    static String selectMsgSQL;
    static final int selectMsgMidIndex = 1;
    static final int selectMsgMsgIndex = 1;
    static String selectMsgIDsForDstSQL;
    static final int selectMsgIDsForDstDstIndex = 1;
    static final int selectMsgIDsForDstMidIndex = 1;
    static String deleteAllMsgsSQL;
    static String truncateMsgsTableSQL;
    static String insertConsumerStatesSQL;
    static final int insertConsumerStatesMIDIndex = 1;
    static final int insertConsumerStatesCUIDIndex = 2;
    static final int insertConsumerStatesDIDIndex = 3;
    static final int insertConsumerStatesStateIndex = 4;
    static String updateConsumerStateSQL;
    static final int updateConsumerStateStateIndex = 1;
    static final int updateConsumerStateMidIndex = 2;
    static final int updateConsumerStateCUIDIndex = 3;
    static String deleteConsumerStatesSQL;
    static final int deleteConsumerStatesMidIndex = 1;
    static String deleteConsumerStatesForMsgSQL;
    static final int deleteConsumerStatesForMsgMidIndex = 1;
    static String deleteConsumerStatesForDstSQL;
    static final int deleteConsumerStatesForDstDidIndex = 1;
    static String selectAllConsumerStatesSQL;
    static final int selectAllConsumerStatesMidIndex = 1;
    static final int selectAllConsumerStatesCUIDIndex = 2;
    static final int selectAllConsumerStatesStateIndex = 3;
    static String deleteAllConsumerStatesSQL;
    static String deleteAckStatesSQL;
    static String insertPropSQL;
    static final int insertPropNameIndex = 1;
    static final int insertPropValueIndex = 2;
    static String updatePropSQL;
    static final int updatePropValueIndex = 1;
    static final int updatePropNameIndex = 2;
    static String deletePropSQL;
    static final int deletePropNameIndex = 1;
    static String selectAllPropsSQL;
    static final int selectAllPropsNameIndex = 1;
    static final int selectAllPropsValueIndex = 2;
    static String deleteAllPropsSQL;
    static String insertTxnSQL;
    static final int insertTxnTidIndex = 1;
    static final int insertTxnStateIndex = 2;
    static final int insertTxnStateObjIndex = 3;
    static String updateTxnStateSQL;
    static final int updateTxnStateStateIndex = 1;
    static final int updateTxnStateTidIndex = 2;
    static String deleteTxnSQL;
    static final int deleteTxnTidIndex = 1;
    static String deleteTxnsNotInStateSQL;
    static final int deleteTxnsNotInStateStateIndex = 1;
    static String deleteAllTxnsSQL;
    static String selectAllTxnsSQL;
    static final int selectAllTxnsTidIndex = 1;
    static final int selectAllTxnsStateIndex = 2;
    static final int selectAllTxnsStateObjIndex = 3;
    static String insertTxnAckSQL;
    static final int insertTxnAckTidIndex = 1;
    static final int insertTxnAckAckIndex = 2;
    static String deleteAcksForTxnSQL;
    static final int deleteAcksForTxnTidIndex = 1;
    static String deleteAllTxnAcksSQL;
    static String deleteTxnAcksNotInStateSQL;
    static String selectAllTxnAcksSQL;
    static final int selectAllTxnAcksTidIndex = 1;
    static final int selectAllTxnAcksAckIndex = 2;
    private static Object lock;
    Connection conn = dbmgr.connectToUse(true);
    boolean valid = false;
    PreparedStatement testStmt = Util.getPreparedStatement(this.conn, testSQL);
    PreparedStatement insertCCRecordStmt = Util.getPreparedStatement(this.conn, insertCCRecordSQL);
    PreparedStatement deleteAllCCRecordsStmt = Util.getPreparedStatement(this.conn, deleteAllCCRecordsSQL);
    PreparedStatement selectAllCCRecordsStmt = Util.getPreparedStatement(this.conn, selectAllCCRecordsSQL);
    PreparedStatement insertDstStmt = Util.getPreparedStatement(this.conn, insertDstSQL);
    PreparedStatement updateDstStmt = Util.getPreparedStatement(this.conn, updateDstSQL);
    PreparedStatement deleteDstStmt = Util.getPreparedStatement(this.conn, deleteDstSQL);
    PreparedStatement selectAllDstsStmt = Util.getPreparedStatement(this.conn, selectAllDstsSQL);
    PreparedStatement deleteAllDstsStmt = Util.getPreparedStatement(this.conn, deleteAllDstsSQL);
    PreparedStatement insertConsumerStmt = Util.getPreparedStatement(this.conn, insertConsumerSQL);
    PreparedStatement deleteConsumerStmt = Util.getPreparedStatement(this.conn, deleteConsumerSQL);
    PreparedStatement selectAllConsumersStmt = Util.getPreparedStatement(this.conn, selectAllConsumersSQL);
    PreparedStatement deleteAllConsumersStmt = Util.getPreparedStatement(this.conn, deleteAllConsumersSQL);
    PreparedStatement insertMsgStmt = Util.getPreparedStatement(this.conn, insertMsgSQL);
    PreparedStatement selectMsgStmt = Util.getPreparedStatement(this.conn, selectMsgSQL);
    PreparedStatement selectMsgIDsForDstStmt = Util.getPreparedStatement(this.conn, selectMsgIDsForDstSQL);
    PreparedStatement deleteAllMsgsStmt = Util.getPreparedStatement(this.conn, deleteAllMsgsSQL);
    PreparedStatement truncateMsgsTableStmt;
    PreparedStatement getCountsStmt;
    PreparedStatement insertPropStmt;
    PreparedStatement updatePropStmt;
    PreparedStatement deletePropStmt;
    PreparedStatement selectAllPropsStmt;
    PreparedStatement deleteAllPropsStmt;
    PreparedStatement updateConsumerStateStmt;
    PreparedStatement deleteAckStatesStmt;
    PreparedStatement selectAllConsumerStatesStmt;
    PreparedStatement deleteAllConsumerStatesStmt;
    PreparedStatement insertTxnStmt;
    PreparedStatement updateTxnStateStmt;
    PreparedStatement deleteTxnStmt;
    PreparedStatement deleteAllTxnsStmt;
    PreparedStatement selectAllTxnsStmt;
    PreparedStatement insertTxnAckStmt;
    PreparedStatement deleteAcksForTxnStmt;
    PreparedStatement deleteAllTxnAcksStmt;
    PreparedStatement selectAllTxnAcksStmt;
    PreparedStatement insertConsumerStatesStmt;
    PreparedStatement updateMsgStmt;
    PreparedStatement deleteMsgStmt;
    PreparedStatement deleteConsumerStatesForMsgStmt;
    PreparedStatement deleteMsgsForDstStmt;
    PreparedStatement deleteConsumerStatesForDstStmt;
    PreparedStatement deleteTxnsNotInStateStmt;
    PreparedStatement deleteTxnAcksNotInStateStmt;

    static void init(DBManager dBManager) throws BrokerException {
        numConnections = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 4);
        useTruncate = Globals.getConfig().getBooleanProperty(USE_TRUNCATE_PROP, true);
        if (numConnections < 1) {
            numConnections = 4;
            logger.log(4, "Bad number of connection specified, set to default of 4");
        }
        idleConnections = new LinkedList();
        active = new HashSet(numConnections);
        dbmgr = dBManager;
        String string = dbmgr.getBrokerID();
        versionTable = "IMQSV35" + string;
        ccrecordTable = "IMQCCREC35" + string;
        dstTable = "IMQDEST35" + string;
        consumerTable = "IMQINT35" + string;
        msgTable = "IMQMSG35" + string;
        stateTable = "IMQILIST35" + string;
        propTable = "IMQPROPS35" + string;
        txnTable = "IMQTXN35" + string;
        txnackTable = "IMQTACK35" + string;
        testSQL = "SELECT COUNT(*) FROM " + versionTable;
        insertCCRecordSQL = "INSERT INTO " + ccrecordTable + " ( " + "RECORDTIME" + ", " + "RECORD" + ") " + "VALUES ( ?,? )";
        deleteAllCCRecordsSQL = "DELETE FROM " + ccrecordTable;
        selectAllCCRecordsSQL = "SELECT RECORDTIME, RECORD FROM " + ccrecordTable + " ORDER BY " + "RECORDTIME";
        insertDstSQL = "INSERT INTO " + dstTable + " (" + "DID" + ", " + "DEST" + ") VALUES ( ?,? )";
        updateDstSQL = "UPDATE " + dstTable + " SET " + "DEST" + " = ? WHERE " + "DID" + " = ?";
        deleteDstSQL = "DELETE FROM " + dstTable + " WHERE " + "DID" + " = ?";
        selectAllDstsSQL = "SELECT DEST FROM " + dstTable;
        deleteAllDstsSQL = "DELETE FROM " + dstTable;
        insertConsumerSQL = "INSERT INTO " + consumerTable + " (" + "CUID" + ", " + "INTEREST" + ") VALUES ( ?,? )";
        deleteConsumerSQL = "DELETE FROM " + consumerTable + " WHERE " + "CUID" + " = ?";
        selectAllConsumersSQL = "SELECT INTEREST FROM " + consumerTable;
        deleteAllConsumersSQL = "DELETE FROM " + consumerTable;
        insertMsgSQL = "INSERT INTO " + msgTable + " (" + "MID" + ", " + "DID" + ", " + "MSGSIZE" + ", " + "MSG" + ") VALUES ( ?,?,?,? )";
        updateMsgSQL = "UPDATE " + msgTable + " SET " + "DID" + "=?," + "MSGSIZE" + "=?," + "MSG" + "=? WHERE " + "MID" + "=?";
        deleteMsgSQL = "DELETE FROM " + msgTable + " WHERE " + "MID" + " = ?";
        deleteMsgsForDstSQL = "DELETE FROM " + msgTable + " WHERE " + "DID" + " = ?";
        getCountsSQL = "SELECT COUNT(MSGSIZE), SUM(MSGSIZE) FROM " + msgTable + " WHERE " + "DID" + "=?";
        selectMsgSQL = "SELECT MSG FROM " + msgTable + " WHERE " + "MID" + " = ?";
        selectMsgIDsForDstSQL = "SELECT MID FROM " + msgTable + " WHERE " + "DID" + " = ?";
        deleteAllMsgsSQL = "DELETE FROM " + msgTable;
        truncateMsgsTableSQL = "TRUNCATE TABLE " + msgTable;
        deleteAllConsumerStatesSQL = "DELETE FROM " + stateTable;
        insertConsumerStatesSQL = "INSERT INTO " + stateTable + " (" + "MID" + ", " + "CUID" + ", " + "DID" + ", " + "STATE" + ") " + "VALUES ( ?,?,?,? )";
        updateConsumerStateSQL = "UPDATE " + stateTable + " SET " + "STATE" + " = ? WHERE " + "MID" + " = ? AND " + "CUID" + " = ?";
        deleteConsumerStatesSQL = "DELETE FROM " + stateTable + " WHERE " + "MID" + "=?";
        deleteConsumerStatesForDstSQL = "DELETE FROM " + stateTable + " WHERE " + "DID" + " = ?";
        deleteConsumerStatesForMsgSQL = "DELETE FROM " + stateTable + " WHERE " + "MID" + "=?";
        deleteAckStatesSQL = "DELETE FROM " + stateTable + " WHERE " + "STATE" + "=" + 2;
        selectAllConsumerStatesSQL = "SELECT MID, CUID, STATE FROM " + stateTable;
        insertPropSQL = "INSERT INTO " + propTable + " (" + "PROPNAME" + ", " + "PROPVALUE" + ") VALUES ( ?,? )";
        updatePropSQL = "UPDATE " + propTable + " SET " + "PROPVALUE" + " = ? WHERE " + "PROPNAME" + " = ?";
        deletePropSQL = "DELETE FROM " + propTable + " WHERE " + "PROPNAME" + " = ?";
        selectAllPropsSQL = "SELECT PROPNAME, PROPVALUE FROM " + propTable;
        deleteAllPropsSQL = "DELETE FROM " + propTable;
        insertTxnSQL = "INSERT INTO " + txnTable + " (" + "TUID" + ", " + "STATE" + ", " + "TSTATEOBJ" + ") VALUES ( ?,?,? )";
        updateTxnStateSQL = "UPDATE " + txnTable + " SET " + "STATE" + " = ? WHERE " + "TUID" + "=?";
        deleteTxnSQL = "DELETE FROM " + txnTable + " WHERE " + "TUID" + "= ?";
        deleteTxnsNotInStateSQL = "DELETE FROM " + txnTable + " WHERE " + "STATE" + " <> ?";
        deleteAllTxnsSQL = "DELETE FROM " + txnTable;
        selectAllTxnsSQL = "SELECT TUID, STATE, TSTATEOBJ FROM " + txnTable + " WHERE " + "STATE" + " <> " + -1;
        insertTxnAckSQL = "INSERT INTO " + txnackTable + " (" + "TUID" + ", " + "TXNACK" + ") VALUES ( ?,? )";
        deleteAcksForTxnSQL = "DELETE FROM " + txnackTable + " WHERE " + "TUID" + "= ?";
        deleteAllTxnAcksSQL = "DELETE FROM " + txnackTable;
        deleteTxnAcksNotInStateSQL = "DELETE FROM " + txnackTable + " WHERE " + "TUID" + " NOT IN " + "(SELECT " + "TUID" + " FROM " + txnTable + ")";
        selectAllTxnAcksSQL = "SELECT TUID, TXNACK FROM " + txnackTable;
        DBConnection.initConnections();
        initialized = true;
    }

    static void reset() {
        if (!initialized) {
            return;
        }
        Iterator iterator = idleConnections.iterator();
        while (iterator.hasNext()) {
            DBConnection dBConnection = (DBConnection)iterator.next();
            try {
                dBConnection.getConnection().close();
            }
            catch (SQLException sQLException) {
                logger.log(16, "B4103", sQLException);
            }
        }
        idleConnections.clear();
        initialized = false;
    }

    private static void initConnections() throws BrokerException {
        for (int i = 0; i < numConnections; ++i) {
            DBConnection dBConnection = new DBConnection();
            idleConnections.add(dBConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBConnection getDBConnection() throws BrokerException {
        Object object = lock;
        synchronized (object) {
            while (idleConnections.isEmpty()) {
                try {
                    lock.wait();
                }
                catch (Exception exception) {
                    logger.log(4, "getConnection got: " + exception);
                }
            }
            DBConnection dBConnection = (DBConnection)idleConnections.removeFirst();
            if (!dBConnection.valid) {
                try {
                    DBConnection dBConnection2;
                    dBConnection = dBConnection2 = new DBConnection();
                    logger.log(8, br.getString("B1149", dbmgr.getOpenDBURL()));
                }
                catch (BrokerException brokerException) {
                    logger.log(32, br.getString("B4206", dbmgr.getOpenDBURL()), brokerException);
                    idleConnections.add(dBConnection);
                    throw brokerException;
                }
            }
            active.add(dBConnection);
            if (Store.DEBUG) {
                logger.log(4, "hand out connection:" + dBConnection + ",valid=" + dBConnection.valid);
            }
            return dBConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putDBConnection(DBConnection dBConnection) {
        if (Store.DEBUG) {
            logger.log(4, "put connection back to pool:" + dBConnection + ",valid=" + dBConnection.valid);
        }
        Object object = lock;
        synchronized (object) {
            active.remove(dBConnection);
            idleConnections.add(dBConnection);
            lock.notify();
        }
    }

    static boolean handleException(DBConnection dBConnection, Throwable throwable) {
        try {
            dBConnection.testStmt.executeQuery();
            logger.log(4, "connection is good; return false (no need to retry)");
            return false;
        }
        catch (SQLException sQLException) {
            logger.log(4, "testSQL(" + testSQL + ") returns:" + sQLException);
            logger.log(8, "Lost database connection to " + dbmgr.getOpenDBURL(), sQLException);
            dBConnection.valid = false;
            return true;
        }
    }

    DBConnection() throws BrokerException {
        if (useTruncate) {
            try {
                this.truncateMsgsTableStmt = this.conn.prepareStatement(truncateMsgsTableSQL);
            }
            catch (SQLException sQLException) {
                logger.log(4, "JDBC: DB does not support '" + truncateMsgsTableSQL + "'");
                logger.log(4, "Will use '" + deleteAllMsgsSQL + "' instead");
                this.truncateMsgsTableStmt = this.deleteAllMsgsStmt;
                truncateMsgsTableSQL = deleteAllMsgsSQL;
            }
        } else {
            this.truncateMsgsTableStmt = this.deleteAllMsgsStmt;
            truncateMsgsTableSQL = deleteAllMsgsSQL;
        }
        this.getCountsStmt = Util.getPreparedStatement(this.conn, getCountsSQL);
        this.insertPropStmt = Util.getPreparedStatement(this.conn, insertPropSQL);
        this.updatePropStmt = Util.getPreparedStatement(this.conn, updatePropSQL);
        this.deletePropStmt = Util.getPreparedStatement(this.conn, deletePropSQL);
        this.selectAllPropsStmt = Util.getPreparedStatement(this.conn, selectAllPropsSQL);
        this.deleteAllPropsStmt = Util.getPreparedStatement(this.conn, deleteAllPropsSQL);
        this.updateConsumerStateStmt = Util.getPreparedStatement(this.conn, updateConsumerStateSQL);
        this.deleteAckStatesStmt = Util.getPreparedStatement(this.conn, deleteAckStatesSQL);
        this.selectAllConsumerStatesStmt = Util.getPreparedStatement(this.conn, selectAllConsumerStatesSQL);
        this.deleteAllConsumerStatesStmt = Util.getPreparedStatement(this.conn, deleteAllConsumerStatesSQL);
        this.insertTxnStmt = Util.getPreparedStatement(this.conn, insertTxnSQL);
        this.updateTxnStateStmt = Util.getPreparedStatement(this.conn, updateTxnStateSQL);
        this.deleteTxnStmt = Util.getPreparedStatement(this.conn, deleteTxnSQL);
        this.deleteAllTxnsStmt = Util.getPreparedStatement(this.conn, deleteAllTxnsSQL);
        this.selectAllTxnsStmt = Util.getPreparedStatement(this.conn, selectAllTxnsSQL);
        this.insertTxnAckStmt = Util.getPreparedStatement(this.conn, insertTxnAckSQL);
        this.deleteAcksForTxnStmt = Util.getPreparedStatement(this.conn, deleteAcksForTxnSQL);
        this.deleteAllTxnAcksStmt = Util.getPreparedStatement(this.conn, deleteAllTxnAcksSQL);
        this.selectAllTxnAcksStmt = Util.getPreparedStatement(this.conn, selectAllTxnAcksSQL);
        this.insertMsgStmt = Util.getPreparedStatement(this.conn, insertMsgSQL);
        this.insertConsumerStatesStmt = Util.getPreparedStatement(this.conn, insertConsumerStatesSQL);
        this.updateMsgStmt = Util.getPreparedStatement(this.conn, updateMsgSQL);
        this.deleteMsgStmt = Util.getPreparedStatement(this.conn, deleteMsgSQL);
        this.deleteConsumerStatesForMsgStmt = Util.getPreparedStatement(this.conn, deleteConsumerStatesForMsgSQL);
        this.deleteMsgsForDstStmt = Util.getPreparedStatement(this.conn, deleteMsgsForDstSQL);
        this.deleteConsumerStatesForDstStmt = Util.getPreparedStatement(this.conn, deleteConsumerStatesForDstSQL);
        this.deleteTxnsNotInStateStmt = Util.getPreparedStatement(this.conn, deleteTxnsNotInStateSQL);
        this.deleteTxnAcksNotInStateStmt = Util.getPreparedStatement(this.conn, deleteTxnAcksNotInStateSQL);
        this.valid = true;
    }

    Connection getConnection() {
        return this.conn;
    }

    static {
        lock = new Object();
    }
}

