/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.tls;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.net.tls.TLSStreams;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class TLSProtocol
extends TcpProtocol {
    public static final String KEYSTORE_DIR_PROP = "imq.keystore.file.dirpath";
    public static final String KEYSTORE_FILE_PROP = "imq.keystore.file.name";
    public static final String KEYSTORE_PASSWORD_PROP = "imq.keystore.password";
    private static final int defaultPort = 11001;
    protected static boolean TLS_ALLOWED = false;
    private static SSLServerSocketFactory ssfactory = null;
    protected static Logger logger = Globals.getLogger();
    protected static BrokerResources br = Globals.getBrokerResources();
    private SSLServerSocket serversocket = null;
    private static boolean registered;
    private static final Object classlock;

    public TLSProtocol() {
        this.CanChangeBlocking = false;
        this.port = 11001;
        if (!TLS_ALLOWED) {
            Globals.getLogger().log(32, "B3123", Globals.getBrokerResources().getString("B0036"));
            Broker.exit(1);
        }
    }

    public ProtocolStreams accept() throws IOException {
        if (this.serversocket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Unable to accept on un-opened protocol"));
        }
        SSLSocket sSLSocket = (SSLSocket)this.serversocket.accept();
        sSLSocket.setTcpNoDelay(this.nodelay);
        TLSStreams tLSStreams = this.createConnection(sSLSocket);
        return tLSStreams;
    }

    public String toString() {
        return "SSL/TLS [ " + this.port + "," + this.backlog + "]";
    }

    protected ServerSocket createSocket(String string, int n, int n2, boolean bl, boolean bl2) throws IOException {
        TLSProtocol.registerSSLProvider();
        SSLServerSocketFactory sSLServerSocketFactory = (SSLServerSocketFactory)TLSProtocol.getServerSocketFactory();
        if (string != null && !string.equals("*")) {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.serversocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n, n2, inetAddress);
        } else {
            this.serversocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n, n2);
        }
        return this.serversocket;
    }

    protected TLSStreams createConnection(SSLSocket sSLSocket) throws IOException {
        return new TLSStreams(sSLSocket, this.inputBufferSize, this.outputBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocketFactory getServerSocketFactory() throws IOException {
        Object object = classlock;
        synchronized (object) {
            if (ssfactory == null) {
                try {
                    BrokerConfig brokerConfig = Globals.getConfig();
                    Password password = null;
                    String string = System.getProperty("file.separator");
                    String string2 = brokerConfig.getProperty(KEYSTORE_DIR_PROP);
                    String string3 = string2 != null ? (string2 = StringUtil.expandVariables(string2, brokerConfig)) : brokerConfig.getProperty("imq.varhome") + string + "security";
                    String string4 = string3 + string + brokerConfig.getProperty(KEYSTORE_FILE_PROP);
                    File file = new File(string4);
                    if (!file.exists()) {
                        throw new IOException(br.getKString("B3019", string4));
                    }
                    String string5 = brokerConfig.getProperty(KEYSTORE_PASSWORD_PROP);
                    password = new Password();
                    for (int i = 0; (string5 == null || string5.equals("")) && i <= 5; ++i) {
                        System.err.print(br.getString("B0004", string4));
                        System.err.flush();
                        if (Broker.background) {
                            System.err.print("\n");
                            break;
                        }
                        string5 = password.getPassword();
                    }
                    if (string5 == null) {
                        string5 = new String();
                        logger.log(32, br.getKString("B3021"));
                    }
                    char[] cArray = string5.toCharArray();
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(new FileInputStream(string4), cArray);
                    keyManagerFactory.init(keyStore, cArray);
                    TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
                    SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
                    ssfactory = sSLContext.getServerSocketFactory();
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    logger.logStack(32, br.getKString("B4022"), exception);
                    throw new IOException(exception.getMessage());
                }
            }
            return ssfactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSSLProvider() {
        if (!registered) {
            Object object = classlock;
            synchronized (object) {
                if (!registered) {
                    Provider provider = new Provider();
                    Security.addProvider((java.security.Provider)provider);
                    registered = true;
                }
            }
        }
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            TLS_ALLOWED = licenseBase.getBooleanProperty("imq.enable_ssl", false);
        }
        catch (BrokerException brokerException) {
            TLS_ALLOWED = false;
        }
        registered = false;
        classlock = new Object();
    }
}

