/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.http;

import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Hashtable;

public class HTTPStreams
implements ProtocolStreams {
    private HttpTunnelSocket socket = null;
    private InputStream is = null;
    private OutputStream os = null;
    private int inputBufferSize = 2048;
    private int outputBufferSize = 2048;

    public HTTPStreams(HttpTunnelSocket httpTunnelSocket) {
        this.socket = httpTunnelSocket;
    }

    public HTTPStreams(HttpTunnelSocket httpTunnelSocket, int n, int n2) {
        this.socket = httpTunnelSocket;
        this.inputBufferSize = n;
        this.outputBufferSize = n2;
    }

    public boolean getBlocking() {
        return true;
    }

    public AbstractSelectableChannel getChannel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Can not get an input stream without a socket");
        }
        if (this.is == null) {
            HTTPStreams hTTPStreams = this;
            synchronized (hTTPStreams) {
                if (this.is == null) {
                    this.is = this.socket.getInputStream();
                    if (this.inputBufferSize > 0) {
                        this.is = new BufferedInputStream(this.is, this.inputBufferSize);
                    }
                }
            }
        }
        return this.is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException("Can not get an output stream without a socket");
        }
        if (this.os == null) {
            HTTPStreams hTTPStreams = this;
            synchronized (hTTPStreams) {
                if (this.os == null) {
                    this.os = this.socket.getOutputStream();
                    if (this.outputBufferSize > 0) {
                        this.os = new BufferedOutputStream(this.os, this.outputBufferSize);
                    }
                }
            }
        }
        return this.os;
    }

    public synchronized void close() throws IOException {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        this.socket.close();
        this.socket = null;
    }

    public int getLocalPort() {
        return this.socket.getConnId();
    }

    public int getRemotePort() {
        return -1;
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public InetAddress getRemoteAddress() {
        return null;
    }

    public String toString() {
        return "HTTP connection to " + this.socket;
    }

    public String toDebugString() {
        return "HTTP connection to " + this.socket;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public Hashtable getDebugState() {
        if (this.socket != null) {
            return this.socket.getDebugState();
        }
        return new Hashtable();
    }
}

