/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class MessageDataHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public MessageDataHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            logger.log(4, "MessageDataHandler");
        }
        if (gPacket.getType() == 1) {
            this.handleMessageData(brokerAddress, gPacket);
        } else if (gPacket.getType() == 2) {
            this.handleMessageDataReply(brokerAddress, gPacket);
        } else {
            logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleMessageData(BrokerAddress brokerAddress, GPacket gPacket) {
        Object object;
        Serializable serializable;
        int n;
        boolean bl = (Boolean)gPacket.getProp("D");
        byte[] byArray = gPacket.getPayload().array();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        ArrayList<Consumer> arrayList = new ArrayList<Consumer>();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        PacketReference packetReference = null;
        if (DEBUG) {
            logger.log(2, "MessageBus: receiving message.");
        }
        try {
            int n2 = (Integer)gPacket.getProp("C");
            for (n = 0; n < n2; ++n) {
                ConsumerUID consumerUID = this.p.readConsumerUID(dataInputStream);
                serializable = Consumer.getConsumer(consumerUID);
                if (serializable != null) {
                    arrayList.add((Consumer)serializable);
                    continue;
                }
                arrayList2.add(consumerUID);
            }
            Packet packet = new Packet(false);
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            packet.readPacket(dataInputStream);
            n = 0;
            packetReference = Destination.get(packet.getSysMessageID());
            if (packetReference != null) {
                n = 1;
            } else {
                packetReference = PacketReference.createReference(packet, null);
                packetReference.setBrokerAddress(brokerAddress);
            }
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    serializable = (Consumer)arrayList.get(i);
                    packetReference.addMessageDeliveredAck(((Consumer)serializable).getConsumerUID());
                }
            }
            try {
                if (packetReference == null) {
                    return;
                }
                object = Destination.getDestination(packetReference.getDestinationUID().getName(), packetReference.getDestinationUID().isQueue() ? 1 : 2, true, true);
                if (object == null) {
                    arrayList2.addAll(arrayList);
                } else if (n == 0 && !arrayList.isEmpty()) {
                    packetReference.setNeverStore(true);
                    packetReference.store(arrayList);
                    ((Destination)object).queueMessage(packetReference, false);
                } else if (n != 0) {
                    packetReference.add(arrayList);
                }
            }
            catch (BrokerException brokerException) {
                brokerException.printStackTrace();
                arrayList2.addAll(arrayList);
            }
        }
        catch (IOException iOException) {
            logger.log(8, "Internal Exception, unable to process message " + packetReference, iOException);
            return;
        }
        String string = "\n";
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Consumer)arrayList.get(n);
            if (!((Consumer)object).routeMessage(packetReference, false)) {
                try {
                    if (packetReference.acknowledged(((Consumer)object).getConsumerUID(), ((Consumer)object).getStoredConsumerUID(), true, false)) {
                        serializable = Destination.getDestination(packetReference.getDestinationUID());
                        ((Destination)serializable).removeMessage(packetReference.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                }
                catch (Exception exception) {
                    logger.log(8, "Internal error processing ack", exception);
                }
            }
            if (!DEBUG) continue;
            string = string + "\t" + ((Consumer)object).getConsumerUID() + "\n";
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Delivering message to : {0}", string);
        }
        string = "\n";
        for (n = 0; n < arrayList2.size(); ++n) {
            this.p.sendMessageAck(brokerAddress, packetReference, (ConsumerUID)arrayList2.get(n), 1);
            if (!DEBUG) continue;
            string = string + "\t" + arrayList2.get(n) + "\n";
        }
        if (DEBUG && arrayList2.size() > 0) {
            logger.log(1, "MessageBus: Invalid targets : {0}", string);
        }
        if (gPacket.getBit(1)) {
            object = GPacket.getInstance();
            ((GPacket)object).setType((short)2);
            ((GPacket)object).putProp("S", new Integer(200));
            try {
                this.c.unicast(brokerAddress, (GPacket)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleMessageDataReply(BrokerAddress brokerAddress, GPacket gPacket) {
        logger.log(4, "MessageBus: Received reset G_MESSAGE_DATA_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

