/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerLinkWriter;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerListLock;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.ClusterImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.LinkInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.Packet;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class BrokerLink
extends Thread {
    private boolean connected = false;
    private boolean expectBrokerInfoPkt = true;
    private Socket conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private BrokerLinkWriter writer = null;
    private Packet linkInitPkt;
    private BrokerAddressImpl self;
    private BrokerAddressImpl remote;
    private ClusterImpl parent = null;
    private boolean linkInitDone = false;
    private Object linkInitWaitObject = null;
    private boolean autoConnect = false;
    private BrokerListLock brokerListLock = new BrokerListLock();
    private static boolean DEBUG_CLUSTER_PACKET = Globals.getConfig().getBooleanProperty("imq.cluster.debug.packet");
    private static boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    private static boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn");
    public static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private long createLinkFailures = 0L;
    private SSLSocketFactory factory = null;

    public BrokerLink(BrokerAddressImpl brokerAddressImpl, BrokerAddressImpl brokerAddressImpl2, ClusterImpl clusterImpl) {
        this.self = brokerAddressImpl;
        this.remote = brokerAddressImpl2;
        this.setName("BrokerLink:" + brokerAddressImpl2);
        this.parent = clusterImpl;
        this.linkInitDone = false;
        this.linkInitWaitObject = new Object();
        this.setDaemon(true);
    }

    public void setAutoConnect(boolean bl) {
        this.autoConnect = bl;
    }

    public boolean getAutoConnect() {
        return this.autoConnect;
    }

    private void setRemote(BrokerAddressImpl brokerAddressImpl) {
        this.remote = brokerAddressImpl;
        this.setName("BrokerLink:" + brokerAddressImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLinkInit() {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.waitLinkInit : " + this);
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            while (!this.linkInitDone) {
                try {
                    this.logger.log(8, "B1150", this.remote.toString());
                    this.linkInitWaitObject.wait(60000L);
                }
                catch (Exception exception) {}
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Returning from BrokerLink.waitLinkInit : " + this);
        }
    }

    public synchronized void setFlowControl(boolean bl) {
        if (this.writer == null) {
            return;
        }
        this.writer.setFlowControl(bl);
    }

    public synchronized void sendPacket(GPacket gPacket) throws IOException {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.sendPacket(GPacket)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.remote);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            this.logger.log(4, "SENDING PACKET :\n" + gPacket.toLongString());
            if (gPacket.getPayload() != null) {
                byte[] byArray = gPacket.getPayload().array();
                this.logger.log(4, "Payload : " + Packet.hexdump(byArray, Integer.MAX_VALUE));
            }
        }
        this.writer.sendPacket(gPacket);
    }

    public synchronized void sendPacket(Packet packet) throws IOException {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.sendPacket(Packet)");
        }
        if (this.writer == null) {
            throw new IOException("Packet send failed. Broker unreachable : " + this.remote);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            this.logger.log(4, "SENDING PACKET :\nLink = " + this + "\n" + "Packet = " + packet + "\n");
        }
        this.writer.sendPacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkDown() {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.linkDown()");
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
            this.logger.log(8, "Link down\n\tRemote BrokerAddress = " + this.remote + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        if (DEBUG) {
            this.logger.log(2, "Cluster connection closed.");
        }
        this.brokerListLock.lock();
        try {
            BrokerLink brokerLink = this;
            synchronized (brokerLink) {
                block17: {
                    if (this.writer != null) break block17;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connected = false;
                    return;
                }
                this.writer.shutdown();
                this.writer = null;
                try {
                    this.is.close();
                    this.os.close();
                    this.conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connected = false;
                this.is = null;
                this.os = null;
            }
            this.parent.removeBroker(this.remote, this);
        }
        finally {
            this.brokerListLock.unlock();
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized SSLSocketFactory getTrustSocketFactory() throws Exception {
        if (this.factory == null) {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{new DefaultTrustManager()};
            sSLContext.init(null, trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
        }
        return this.factory;
    }

    private Socket makeSSLSocket(InetAddress inetAddress, int n) throws Exception {
        if (Globals.getConfig().getBooleanProperty("imq.cluster.trust_all", true)) {
            SSLSocketFactory sSLSocketFactory = this.getTrustSocketFactory();
            return sSLSocketFactory.createSocket(inetAddress, n);
        }
        return SSLSocketFactory.getDefault().createSocket(inetAddress, n);
    }

    private PortMapperEntry getRealRemotePort() throws Exception {
        String string = String.valueOf(101) + "\n";
        PortMapperTable portMapperTable = new PortMapperTable();
        Socket socket = new Socket(this.remote.getHost(), this.remote.getPort());
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        portMapperTable.read(inputStream);
        inputStream.close();
        outputStream.close();
        socket.close();
        return portMapperTable.get("cluster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createLink() {
        boolean bl;
        block23: {
            if (DEBUG) {
                this.logger.log(4, "BrokerLink.createLink()");
            }
            this.brokerListLock.lock();
            bl = false;
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            if (!this.autoConnect) {
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return;
            }
            if (!this.connected) break block23;
            this.brokerListLock.unlock();
            return;
        }
        try {
            try {
                PortMapperEntry portMapperEntry = this.getRealRemotePort();
                int n = portMapperEntry.getPort();
                if (!portMapperEntry.getProtocol().equalsIgnoreCase(this.parent.getTransport())) {
                    throw new BrokerException(br.getKString("B4208", this.parent.getTransport(), portMapperEntry.getProtocol()));
                }
                this.conn = portMapperEntry.getProtocol().equalsIgnoreCase("ssl") ? this.makeSSLSocket(this.remote.getHost(), n) : new Socket(this.remote.getHost(), n);
                InputStream inputStream = this.conn.getInputStream();
                this.initNewConn(false);
                this.connected = true;
                bl = this.consumeLinkInit(inputStream);
            }
            catch (Exception exception) {
                if (!this.connected) {
                    if (this.conn != null) {
                        try {
                            this.conn.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (this.writer != null) {
                        this.writer.shutdown();
                        this.writer = null;
                    }
                }
                if (this.createLinkFailures % 40L == 0L) {
                    this.logger.log(16, "B2105", (Object)this.remote.toString(), exception.getMessage());
                    this.logger.logStack(4, "BrokerLink.createLink() failed", exception);
                }
                ++this.createLinkFailures;
                Object object = this.linkInitWaitObject;
                // MONITORENTER : object
                if (!this.linkInitDone) {
                    this.linkInitDone = true;
                    this.linkInitWaitObject.notifyAll();
                }
                // MONITOREXIT : object
            }
            if (bl && !this.parent.addBroker(this.remote, this)) {
                this.closeConn();
            }
        }
        finally {
            this.brokerListLock.unlock();
        }
        if (!DEBUG) return;
        this.logger.log(4, "BrokerLink.createLink() finished.");
    }

    private boolean consumeLinkInit(InputStream inputStream) throws IOException {
        BrokerAddressImpl brokerAddressImpl;
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.consumeLinkInit()");
        }
        Packet packet = new Packet();
        try {
            packet.readPacket(inputStream);
        }
        catch (SSLException sSLException) {
            this.logger.logStack(16, "L10N-XXX SSL Connection failed due to security configuration problems.", sSLException);
            throw sSLException;
        }
        if (packet.getPacketType() != 4) {
            this.logger.log(4, "Link = " + this + ", Missed the LINK_INIT :" + packet.getPacketType());
            this.conn.close();
            return false;
        }
        LinkInfo linkInfo = null;
        try {
            linkInfo = this.parent.processLinkInit(packet);
        }
        catch (Exception exception) {
            this.conn.close();
            return false;
        }
        if (DEBUG) {
            this.logger.log(4, "processLinkInit returned!");
        }
        if (!(brokerAddressImpl = linkInfo.getAddress()).verifyAddress()) {
            this.logger.log(32, "B3099", (Object)this.conn.getInetAddress().toString(), brokerAddressImpl.toString());
            this.shutdown();
            return false;
        }
        this.setRemote(brokerAddressImpl);
        if (!this.parent.checkConfigServer(this.remote)) {
            this.logger.log(4, "Closing cluster connection with " + this.remote + ". Waiting for master broker");
            this.conn.close();
            return false;
        }
        try {
            if (!BrokerAddressImpl.compareIpPort((BrokerAddressImpl)this.parent.getConfigServer(), linkInfo.getConfigServer())) {
                this.logger.log(32, "B3097", this.remote);
                this.shutdown();
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Link Down " + this, exception);
            this.linkDown();
        }
        if (DEBUG) {
            this.logger.log(2, "remote.matchProps = " + linkInfo.getMatchProps());
            this.logger.log(2, "local.matchProps = " + this.parent.getMatchProps());
        }
        Properties properties = linkInfo.getMatchProps();
        Properties properties2 = this.parent.getMatchProps();
        String string = this.compareProps(properties2, properties);
        if (string != null) {
            this.logger.log(32, "B3098", (Object)this.remote, string);
            this.shutdown();
        }
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.consumeLinkInit() finished");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean acceptConnection(BrokerAddressImpl brokerAddressImpl, Socket socket) {
        block18: {
            if (DEBUG) {
                this.logger.log(4, "BrokerLink.acceptConnection()");
            }
            this.brokerListLock.lock();
            BrokerLink brokerLink = this;
            // MONITORENTER : brokerLink
            this.setRemote(brokerAddressImpl);
            if (this.connected) {
                if (DEBUG) {
                    this.logger.log(4, "Already connected!");
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = false;
                // MONITOREXIT : brokerLink
                this.brokerListLock.unlock();
                return bl;
            }
            if (this.parent.addBroker(brokerAddressImpl, this)) break block18;
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        this.conn = socket;
        try {
            this.initNewConn(true);
        }
        catch (Exception exception) {
            boolean bl = true;
            // MONITOREXIT : brokerLink
            this.brokerListLock.unlock();
            return bl;
        }
        try {
            this.connected = true;
            // MONITOREXIT : brokerLink
            return true;
        }
        finally {
            this.brokerListLock.unlock();
        }
    }

    private void initNewConn(boolean bl) throws IOException {
        Object object;
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.initNewconn()");
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
            object = bl ? "Accepted" : "Established";
            this.logger.log(8, "Connection " + (String)object + "\n\tRemote BrokerAddress = " + this.remote + "\n\tRemote IP = " + this.conn.getInetAddress() + "\n\tRemote Port = " + this.conn.getPort() + "\n\tLocal IP = " + this.conn.getLocalAddress() + "\n\tLocal Port = " + this.conn.getLocalPort());
        }
        this.expectBrokerInfoPkt = true;
        this.is = this.conn.getInputStream();
        this.os = this.conn.getOutputStream();
        this.writer = new BrokerLinkWriter(this.remote, this);
        this.writer.startWriterThread(this.os);
        if (this.linkInitPkt == null) {
            this.linkInitPkt = this.parent.getLinkInitPkt();
        }
        object = this.parent.getBrokerInfoPkt();
        if (DEBUG) {
            this.logger.log(2, "Cluster connection established: {0}", this);
        }
        this.sendPacket(this.linkInitPkt);
        this.sendPacket((Packet)object);
        this.parent.sendFlowControlUpdate(this.remote);
    }

    public void closeConn() {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.closeConn()");
        }
        if (!this.connected && !this.autoConnect) {
            try {
                this.interrupt();
            }
            catch (Exception exception) {
                this.logger.log(4, "BrokerLink.closeConn(): interrupt thread failed: " + exception.getMessage());
            }
        }
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.shutdown()");
        }
        this.autoConnect = false;
        this.closeConn();
    }

    private String compareProps(Properties properties, Properties properties2) {
        String string = null;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            String string4 = properties2.getProperty(string2);
            if (string3 == null && string4 == null) continue;
            if (string3 == null && string4 != null || string4 == null && string3 != null) {
                string = string + "\t" + string2;
                continue;
            }
            if (string3.equals(string4)) continue;
            if (string == null) {
                string = "\t" + string2 + "\n";
                continue;
            }
            string = string + "\t" + string2 + "\n";
        }
        return string;
    }

    private Packet tryReadPacket(boolean bl) throws IOException {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.tryReadPacket()");
        }
        Packet packet = null;
        try {
            packet = new Packet();
            packet.readPacket(this.is);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (!bl) {
                throw outOfMemoryError;
            }
            Globals.handleGlobalError(outOfMemoryError, br.getKString("B0019"));
            packet = this.tryReadPacket(false);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeBrokerInfoPkt() throws Exception {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.consumeBrokerInfoPkt()");
        }
        Packet packet = new Packet();
        packet.readPacket(this.is);
        if (packet.getPacketType() != 3) {
            this.logger.log(4, "Link = " + this + ", Missed the BROKER_INFO :" + packet.getPacketType());
            this.conn.close();
            return;
        }
        this.parent.receivePacket(this.remote, packet);
        this.expectBrokerInfoPkt = false;
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            if (this.parent.isConfigServerResolved()) {
                this.linkInitDone = true;
                this.linkInitWaitObject.notify();
            }
        }
    }

    private void consumePacket() throws IOException {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.consumePacket()");
        }
        Packet packet = new Packet();
        try {
            packet = this.tryReadPacket(true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logger.log(32, "B3108");
            System.exit(2);
        }
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            this.logger.log(4, "RECEIVING PACKET :\nLink = " + this + "\n" + "Packet = " + packet);
        }
        try {
            this.parent.receivePacket(this.remote, packet);
        }
        catch (Exception exception) {
            this.logger.logStack(32, "B2036", packet, (Throwable)exception);
        }
    }

    private void consumeGPacket() throws IOException {
        if (DEBUG) {
            this.logger.log(4, "BrokerLink.consumeGPacket()");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.read(this.is);
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_PACKET) {
            this.logger.log(4, "RECEIVING PACKET :\nLink = " + this + "\n" + "Packet = " + gPacket.toLongString());
            if (gPacket.getPayload() != null) {
                byte[] byArray = gPacket.getPayload().array();
                this.logger.log(4, "Payload : " + Packet.hexdump(byArray, Integer.MAX_VALUE));
            }
        }
        try {
            this.parent.receivePacket(this.remote, gPacket);
        }
        catch (Exception exception) {
            this.logger.logStack(32, "B2036", gPacket, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (!this.connected) {
                if (!this.autoConnect) break;
                this.createLink();
                if (this.connected) continue;
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                if (this.expectBrokerInfoPkt) {
                    if (DEBUG) {
                        this.logger.log(4, "Waiting for BROKER_INFO...");
                    }
                    this.consumeBrokerInfoPkt();
                    if (DEBUG) {
                        this.logger.log(4, "Received BROKER_INFO...");
                    }
                }
                if (this.parent.useGPackets) {
                    this.consumeGPacket();
                    continue;
                }
                this.consumePacket();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.logger.log(32, "B3108");
                System.exit(2);
            }
            catch (Exception exception) {
                this.logger.logStack(4, "Link Down " + this, exception);
                this.linkDown();
            }
        }
        Object object = this.linkInitWaitObject;
        synchronized (object) {
            this.linkInitDone = true;
            this.linkInitWaitObject.notify();
        }
        this.parent.handleBrokerLinkShutdown(this.remote);
    }

    public String toString() {
        return this.self.toString() + " <---> " + this.remote.toString();
    }
}

