/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class BrokerAddressImpl
extends BrokerAddress {
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    static final long serialVersionUID = 2088198635383118304L;
    private String hostName = null;
    private String instName = null;
    private int port = -1;
    private transient InetAddress host = null;
    private transient String hostAddressString = null;
    private transient int clusterVersion = 0;
    private transient String ipPortString = null;
    public static final int VERSION = 100;

    public BrokerAddressImpl(String string) throws Exception {
        this(string, false);
    }

    public BrokerAddressImpl(String string, boolean bl) throws Exception {
        if (bl) {
            if (string != null) {
                this.hostName = string;
                this.host = InetAddress.getByName(this.hostName);
            } else {
                this.host = InetAddress.getLocalHost();
            }
            this.hostName = this.host.getHostAddress();
            this.instName = Globals.getConfigName();
            this.port = Globals.getPortMapper().getPort();
        } else {
            this.hostName = string;
            int n = string.indexOf(58);
            if (n >= 0) {
                this.hostName = string.substring(0, n);
            }
            if (this.hostName != null && !this.verifyAddress()) {
                this.hostName = null;
                this.host = null;
            }
            if (this.hostName == null || this.hostName.equals("")) {
                try {
                    this.hostName = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.host = InetAddress.getByName(this.hostName);
            this.instName = new String("???");
            Globals.getPortMapper();
            this.port = 7676;
            try {
                this.port = Integer.parseInt(string.substring(n + 1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public BrokerAddressImpl(String string, String string2, int n) throws Exception {
        this.hostName = string;
        if (string == null || string.equals("")) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.instName = string2;
        this.host = InetAddress.getByName(string);
        this.port = n;
    }

    public BrokerAddressImpl() throws Exception {
        this(null, true);
    }

    public void resolveHostName() {
        if (this.host == null) {
            try {
                this.host = InetAddress.getByName(this.hostName);
            }
            catch (Exception exception) {
                logger.logStack(16, "resolveHostName failed : " + this.hostName, exception);
            }
        }
    }

    public int getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(int n) {
        this.clusterVersion = n;
    }

    public boolean verifyAddress() {
        this.resolveHostName();
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (Exception exception) {
            return false;
        }
        return inetAddress != null && !inetAddress.equals(this.host);
    }

    public String getIpPortString() {
        this.resolveHostName();
        if (this.ipPortString == null) {
            this.ipPortString = this.host.getHostAddress() + ":" + this.port;
        }
        return this.ipPortString;
    }

    public String getHostName() {
        this.resolveHostName();
        return this.host.getHostAddress();
    }

    public String getInstName() {
        return this.instName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getHost() {
        this.resolveHostName();
        return this.host;
    }

    public Object clone() {
        BrokerAddressImpl brokerAddressImpl;
        try {
            brokerAddressImpl = (BrokerAddressImpl)super.getObjectClone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("BrokerAddressImpl: Could not clone: " + cloneNotSupportedException);
            return null;
        }
        brokerAddressImpl.hostName = new String(this.hostName);
        brokerAddressImpl.instName = new String(this.instName);
        try {
            brokerAddressImpl.resolveHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brokerAddressImpl;
    }

    public static boolean compareIpPort(BrokerAddressImpl brokerAddressImpl, BrokerAddressImpl brokerAddressImpl2) {
        if (brokerAddressImpl == null || brokerAddressImpl2 == null) {
            return brokerAddressImpl == brokerAddressImpl2;
        }
        return brokerAddressImpl.getIpPortString().equals(brokerAddressImpl2.getIpPortString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof BrokerAddressImpl)) {
            return false;
        }
        BrokerAddressImpl brokerAddressImpl = (BrokerAddressImpl)object;
        if (!this.instName.equals(brokerAddressImpl.instName)) {
            return false;
        }
        this.resolveHostName();
        brokerAddressImpl.resolveHostName();
        if (this.host == null || brokerAddressImpl.host == null) {
            return false;
        }
        return this.host.equals(brokerAddressImpl.host);
    }

    public int hashCode() {
        this.resolveHostName();
        if (this.host == null) {
            return 0;
        }
        return 31 * this.host.hashCode() + this.instName.hashCode();
    }

    public void writeBrokerAddress(DataOutputStream dataOutputStream) throws IOException {
        this.resolveHostName();
        dataOutputStream.writeInt(100);
        if (this.hostAddressString == null) {
            this.hostAddressString = this.host.getHostAddress();
        }
        dataOutputStream.writeUTF(this.hostAddressString);
        dataOutputStream.writeUTF(this.instName);
        dataOutputStream.writeInt(this.port);
        dataOutputStream.flush();
    }

    public void readBrokerAddress(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n > 100) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "BrokerAddress version mismatch."));
        }
        this.hostName = dataInputStream.readUTF();
        this.instName = dataInputStream.readUTF();
        this.port = dataInputStream.readInt();
        this.host = InetAddress.getByName(this.hostName);
    }

    public String toConfigString() {
        return this.hostName + ":" + this.port;
    }

    public String toString() {
        if (this.host != null) {
            this.host.getHostName();
        }
        return this.host + ":" + this.port + " (" + this.instName + ")";
    }
}

