/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.FileLicense;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Properties;

public class LicenseManager {
    private static BrokerResources br = Globals.getBrokerResources();
    private static Logger logger = Globals.getLogger();
    private LicenseBase currentLicense = null;
    private LicenseBase base = null;
    private static final String LICENSE_BASE_PKG_PREFIX = "com.sun.messaging.jmq.jmsserver.license.";
    private static final String STANDALONE_LICENSE_BASE = "StandaloneLicense";
    private static final String LICENSE_BASE_CLASS_PREFIX = "L";
    private static final int MAX_LICENSE_BASE_CLASSES = 16;
    private static final String LICENSE_DIR = Globals.JMQ_ETC_HOME + File.separator + "lic" + File.separator;
    private static final String TRIAL_LICENSE_DIR = Globals.JMQ_VAR_HOME + File.separator + "lic" + File.separator;
    private static final String LICENSE_FILE_PREFIX = "imqbroker";
    private static final String LICENSE_FILE_SUBFIX = ".lic";
    private static FilenameFilter licFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.startsWith(LicenseManager.LICENSE_FILE_PREFIX) && string.endsWith(LicenseManager.LICENSE_FILE_SUBFIX);
        }
    };

    public LicenseBase getLicense(String string) throws BrokerException {
        if (this.currentLicense != null) {
            return this.currentLicense;
        }
        this.base = this.getLicenseBase();
        if (this.base == null) {
            throw new BrokerException("Could not find license base class.This is a broker packaging error.");
        }
        FileLicense fileLicense = null;
        fileLicense = this.loadLicenseFile(string);
        if (fileLicense != null) {
            try {
                fileLicense.rewriteLicense();
            }
            catch (IOException iOException) {
                throw new BrokerException(br.getString("B3054"), iOException);
            }
        }
        if (fileLicense != null) {
            if (string != null || fileLicense.getPrecedence() > this.base.getPrecedence()) {
                this.base.superimpose(fileLicense.getProperties());
                logger.log(4, br.getString("B1139", fileLicense.getLicenseFile()));
            }
        } else if (this.base.isLicenseFileRequired()) {
            throw new BrokerException(br.getString("B3057"));
        }
        this.currentLicense = this.base;
        return this.base;
    }

    private LicenseBase getLicenseBase() throws BrokerException {
        Class<?> clazz = null;
        String string = "com.sun.messaging.jmq.jmsserver.license.StandaloneLicense";
        try {
            clazz = Class.forName(string);
            return this.newInstance(clazz);
        }
        catch (Exception exception) {
            ArrayList<LicenseBase> arrayList = new ArrayList<LicenseBase>();
            for (int i = 0; i < 16; ++i) {
                string = "com.sun.messaging.jmq.jmsserver.license.L" + i;
                try {
                    clazz = Class.forName(string);
                    arrayList.add(this.newInstance(clazz));
                    continue;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            LicenseBase[] licenseBaseArray = arrayList.toArray(new LicenseBase[0]);
            return this.selectBestLicense(licenseBaseArray);
        }
    }

    private LicenseBase newInstance(Class clazz) throws Exception {
        Constructor constructor = clazz.getConstructor(null);
        return (LicenseBase)constructor.newInstance(null);
    }

    private LicenseBase selectBestLicense(LicenseBase[] licenseBaseArray) throws BrokerException {
        if (licenseBaseArray == null || licenseBaseArray.length == 0) {
            throw new BrokerException(br.getString("B3057"));
        }
        LicenseBase licenseBase = licenseBaseArray[0];
        for (int i = 1; i < licenseBaseArray.length; ++i) {
            boolean bl = licenseBase.willExpire();
            boolean bl2 = licenseBaseArray[i].willExpire();
            if (bl && !bl2) {
                licenseBase = licenseBaseArray[i];
            }
            if (bl != bl2 || licenseBase.getPrecedence() >= licenseBaseArray[i].getPrecedence()) continue;
            licenseBase = licenseBaseArray[i];
        }
        return licenseBase;
    }

    private FileLicense loadLicenseFile(String string) throws BrokerException {
        File file = new File(LICENSE_DIR);
        File file2 = new File(TRIAL_LICENSE_DIR);
        FileLicense fileLicense = null;
        Object var5_5 = null;
        if (string != null) {
            String string2 = this.base.getProperty("imq.license_type");
            if (string.equalsIgnoreCase(string2)) {
                return null;
            }
            String string3 = LICENSE_FILE_PREFIX + string + LICENSE_FILE_SUBFIX;
            File file3 = null;
            file3 = string.equalsIgnoreCase("try") ? new File(file2, string3) : new File(file, string3);
            if (!file3.exists()) {
                throw new BrokerException(br.getString("B3159", string));
            }
            if (!file3.canRead()) {
                throw new BrokerException(br.getString("B3163", string3));
            }
            fileLicense = new FileLicense(file3);
        } else {
            LicenseBase[] licenseBaseArray = LicenseManager.loadFileLicenses();
            if (LicenseManager.loadFileLicenses().length != 0) {
                fileLicense = (FileLicense)this.selectBestLicense(licenseBaseArray);
                File file4 = fileLicense.getLicenseFile();
                if (!file4.canRead()) {
                    throw new BrokerException(br.getString("B3163", file4.toString()));
                }
                FileLicense fileLicense2 = fileLicense;
                Properties properties = fileLicense2.props;
                String string4 = properties.getProperty("date_string");
                if (string4.startsWith("TRY")) {
                    return null;
                }
            }
        }
        return fileLicense;
    }

    public static FileLicense[] loadFileLicenses() {
        Object object;
        File file = new File(LICENSE_DIR);
        File file2 = new File(TRIAL_LICENSE_DIR);
        String[] stringArray = file.list(licFilter);
        ArrayList<FileLicense> arrayList = new ArrayList<FileLicense>();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            try {
                File file3 = new File(file, stringArray[i]);
                object = new FileLicense(file3);
                arrayList.add((FileLicense)object);
                continue;
            }
            catch (BrokerException brokerException) {
                // empty catch block
            }
        }
        String[] stringArray2 = file2.list(licFilter);
        for (int i = 0; stringArray2 != null && i < stringArray2.length; ++i) {
            try {
                object = new File(file2, stringArray2[i]);
                FileLicense fileLicense = new FileLicense((File)object);
                arrayList.add(fileLicense);
                continue;
            }
            catch (BrokerException brokerException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FileLicense[0]);
    }
}

