/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class LicenseBase {
    protected Properties props = new Properties();
    private boolean autoChecking = true;
    private int daysToTry = 0;
    private Date expirationDate = null;
    private Date startDate = null;
    protected static final long LICENSE_MAGIC_NUMBER = 1011902605893L;
    private static final String CURRENT_FILE_VERSION = "4";
    public static final String CURRENT_LICENSE_VERSION = "3.6";
    public static final String PROP_FILE_VERSION = "imq.file_version";
    public static final String PROP_LICENSE_VERSION = "imq.license_version";
    public static final String PROP_LICENSE_TYPE = "imq.license_type";
    public static final String PROP_DATE_STRING = "date_string";
    public static final String PROP_PRECEDENCE = "imq.precedence";
    public static final String PROP_DESCRIPTION = "description";
    protected static final String NONE_STRING = "NONE";
    protected static final String TRY_STRING = "TRY";
    protected static final String VALID_STRING = "VALID";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String DASH = "-";
    public static final String PROP_CLIENT_CONNLIMIT = "imq.max_client_conns";
    public static final String PROP_BROKER_CONNLIMIT = "imq.max_broker_conns";
    public static final String PROP_MAX_BACKUP_CONS = "imq.max_backup_cons";
    public static final String PROP_MAX_ACTIVE_CONS = "imq.max_active_cons";
    public static final String PROP_ENABLE_CLUSTER = "imq.enable_cluster";
    public static final String PROP_ENABLE_HTTP = "imq.enable_http";
    public static final String PROP_ENABLE_SSL = "imq.enable_ssl";
    public static final String PROP_ENABLE_SHAREDPOOL = "imq.enable_sharedpool";
    public static final String PROP_ENABLE_C_API = "imq.enable_c_api";
    public static final String PROP_ENABLE_FAILOVER = "imq.enable_failover";
    public static final String PROP_ENABLE_MONITORING = "imq.enable_monitoring";
    public static final String PROP_ENABLE_LOCALDEST = "imq.enable_localdest";
    public static final String PROP_ENABLE_DMQ = "imq.enable_dmq";
    public static final String PROP_ENABLE_CLIENTPING = "imq.enable_clientping";
    public static final String PROP_ENABLE_MSGBODY_COMPRESSION = "imq.enable_msgbody_compression";
    public static final String PROP_ENABLE_SHARED_SUB = "imq.enable_shared_sub";
    public static final String PROP_ENABLE_AUDIT_CCC = "imq.enable_audit_ccc";
    public static final String PROP_ENABLE_NO_ACK = "imq.enable_no_ack";
    public static final String PROP_ENABLE_RECONNECT = "imq.enable_reconnect";
    protected static BrokerResources br = Globals.getBrokerResources();
    protected static Logger logger = Globals.getLogger();

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public int getIntProperty(String string, int n) {
        try {
            return Integer.parseInt(this.getProperty(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        try {
            return Boolean.valueOf(this.getProperty(string));
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getPrecedence() {
        int n = 0;
        try {
            n = Integer.parseInt(this.props.getProperty(PROP_PRECEDENCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public boolean willExpire() {
        String string = this.props.getProperty(PROP_DATE_STRING);
        return string == null || !string.equals(NONE_STRING);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        this.expirationDate = date;
    }

    public int getDaysToTry() {
        return this.daysToTry;
    }

    public void setDaysToTry(int n) {
        this.daysToTry = n;
    }

    public boolean isLicenseFileRequired() {
        return true;
    }

    public void setAutoChecking(boolean bl) {
        this.autoChecking = bl;
    }

    public void superimpose(Properties properties) throws BrokerException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.props.setProperty(string, string2);
        }
        this.processLicenseInfo();
    }

    private void processLicenseInfo() throws BrokerException {
        if (!this.autoChecking) {
            return;
        }
        String string = this.props.getProperty(PROP_FILE_VERSION);
        if (string == null || !string.equals(CURRENT_FILE_VERSION)) {
            throw new BrokerException(br.getString("B3054"));
        }
        String string2 = this.props.getProperty(PROP_LICENSE_VERSION);
        if (string2 == null || !string2.equals(CURRENT_LICENSE_VERSION)) {
            throw new BrokerException(br.getString("B3054"));
        }
        this.parseDateString();
        this.checkValidity();
    }

    private void parseDateString() throws BrokerException {
        String string = this.props.getProperty(PROP_DATE_STRING);
        if (string == null) {
            throw new BrokerException(br.getString("B3054"));
        }
        if (!string.startsWith(NONE_STRING)) {
            if (string.startsWith(TRY_STRING)) {
                int n = string.indexOf(OPEN_BRACKET);
                int n2 = string.indexOf(CLOSE_BRACKET);
                int n3 = Integer.parseInt(string.substring(n + 1, n2));
                this.setDaysToTry(n3);
            } else if (string.startsWith(VALID_STRING)) {
                long l;
                int n = string.indexOf(OPEN_BRACKET);
                int n4 = string.indexOf(DASH);
                int n5 = string.indexOf(CLOSE_BRACKET);
                if (n4 - n > 1) {
                    l = Long.parseLong(string.substring(n + 1, n4));
                    this.setStartDate(new Date(l));
                }
                if (n5 - n4 > 1) {
                    l = Long.parseLong(string.substring(n4 + 1, n5));
                    this.setExpirationDate(new Date(l));
                }
            } else {
                throw new BrokerException(br.getString("B3054"));
            }
        }
    }

    private void checkValidity() throws BrokerException {
        if (!this.willExpire()) {
            return;
        }
        if (this.getExpirationDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getExpirationDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (calendar.getTime().getTime() <= new Date().getTime()) {
                throw new BrokerException(br.getString("B3055", calendar.getTime()));
            }
        } else if (this.getStartDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getStartDate());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (new Date().getTime() < calendar.getTime().getTime()) {
                throw new BrokerException(br.getString("B3111", this.getStartDate()));
            }
        }
    }
}

