/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class RedeliverHandler
extends PacketHandler {
    static final int REDELIVER_BLOCK_SIZE = 40;
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Boolean bl;
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: unable to retrieve  properties from redeliver message " + packet, exception);
            hashtable = new Hashtable();
        }
        boolean bl2 = false;
        if (hashtable != null && (bl = (Boolean)hashtable.get("JMQSetRedelivered")) != null) {
            bl2 = bl;
        }
        int n = packet.getMessageBodySize();
        int n2 = n / 40;
        int n3 = n % 40;
        if (n2 == 0) {
            return true;
        }
        if (n3 != 0) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Message Size: " + n + ". Not multiple of " + 40));
        }
        if (DEBUG) {
            this.logger.log(4, "RedeliverMessage: processing message {0} {1}", (Object)packet.toString(), iMQConnection.getConnectionUID().toString());
        }
        SysMessageID sysMessageID = new SysMessageID();
        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
        try {
            Object object;
            Object object2;
            HashSet<Session> hashSet = new HashSet<Session>();
            HashMap<Consumer, LinkedHashSet<Object>> hashMap = new HashMap<Consumer, LinkedHashSet<Object>>();
            boolean bl3 = false;
            for (int i = 0; i < n2; ++i) {
                Consumer consumer;
                object2 = new ConsumerUID(dataInputStream.readLong());
                ((ConsumerUID)object2).setConnectionUID(iMQConnection.getConnectionUID());
                sysMessageID.readID(dataInputStream);
                object = Destination.get(sysMessageID);
                if (object == null || ((PacketReference)object).isInvalid()) continue;
                Session session = Session.getSession((ConsumerUID)object2);
                if (!hashSet.contains(session)) {
                    session.pause("redeliver");
                    hashSet.add(session);
                }
                if ((consumer = session.getConsumerOnSession((ConsumerUID)object2)) == null) {
                    consumer = Consumer.getConsumer((ConsumerUID)object2);
                    if (consumer != null) {
                        this.logger.log(16, "Internal Error  consumer with id of " + object2 + " is unavailable " + " on session " + session + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (session == null ? 0L : session.getConnectionUID().longValue()) + "] consumer session is : " + consumer.getSessionUID());
                        continue;
                    }
                    this.logger.log(4, "Internal Error  consumer with id of " + object2 + " is unavailable " + " on session " + session + "[conuid,sess conuid] =" + "[" + iMQConnection.getConnectionUID().longValue() + "," + (session == null ? 0L : session.getConnectionUID().longValue()) + "] it has been closed");
                    continue;
                }
                LinkedHashSet<Object> linkedHashSet = (LinkedHashSet<Object>)hashMap.get(consumer);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<Object>();
                    hashMap.put(consumer, linkedHashSet);
                }
                linkedHashSet.add(object);
                if (bl2) {
                    ((PacketReference)object).consumed(consumer.getStoredConsumerUID(), session.isDupsOK(consumer.getConsumerUID()), false);
                    continue;
                }
                ((PacketReference)object).removeDelivered(consumer.getStoredConsumerUID(), true);
            }
            Iterator<Object> iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (Consumer)iterator.next();
                object = (Set)hashMap.get(object2);
                ((Consumer)object2).pause("start redeliver");
                ((Consumer)object2).routeMessages((Collection)object, true);
                ((Consumer)object2).resume("end redeliver");
            }
            hashMap.clear();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object2 = (Session)iterator.next();
                ((Session)object2).resume("redeliver");
            }
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Packet", exception), exception);
        }
        return true;
    }
}

