/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class ProducerHandler
extends PacketHandler {
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Hashtable<String, Object> hashtable;
        Packet packet2;
        block45: {
            block44: {
                packet2 = new Packet(iMQConnection.useDirectBuffers());
                packet2.setPacketType(packet.getPacketType() + 1);
                packet2.setConsumerID(packet.getConsumerID());
                int n = 200;
                String string = null;
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = packet.getProperties();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Can not load props", exception);
                }
                hashtable = new Hashtable<String, Object>();
                Destination destination = null;
                try {
                    if (packet.getPacketType() == 18) {
                        Object object;
                        Session session;
                        String string2 = (String)hashtable2.get("JMQDestination");
                        Integer n2 = (Integer)hashtable2.get("JMQDestType");
                        if (!$assertionsDisabled && string2 == null) {
                            throw new AssertionError((Object)" bad protocol ");
                        }
                        if (!$assertionsDisabled && n2 == null) {
                            throw new AssertionError((Object)" bad protocol ");
                        }
                        Long l = (Long)hashtable2.get("JMQSessionID");
                        if (l != null && (session = iMQConnection.getSession((SessionUID)(object = new SessionUID(l)))) == null) {
                            throw new BrokerException("Internal Error: client sent invalid sessionUID w/ ADD_PRODUCER " + object + " session does not exist");
                        }
                        if (!iMQConnection.isAdminConnection() && MemoryGlobals.MEM_DISALLOW_PRODUCERS) {
                            n = 500;
                            string = "Low memory";
                            logger.log(16, "B2076");
                        } else {
                            if (string2 != null && n2 != null) {
                                while ((destination = Destination.getDestination(string2, n2, true, !iMQConnection.isAdminConnection())) != null) {
                                    try {
                                        destination.incrementRefCount();
                                        break;
                                    }
                                    catch (BrokerException brokerException) {
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", illegalStateException, 500);
                                    }
                                }
                                if (destination == null) {
                                    logger.log(4, "Unable to add producer to " + string2 + " :" + DestType.toString(n2) + " destination can not be autocreated ");
                                    string = "can not create destination";
                                    n = 404;
                                }
                            } else if (string2 == null || n2 == null) {
                                string = "no destination passed [dest,type] = [" + string2 + "," + n2 + "]";
                                n = 500;
                            }
                            if (!$assertionsDisabled && destination == null) {
                                throw new AssertionError();
                            }
                            if (n == 200) {
                                object = Producer.createProducer(destination.getDestinationUID(), iMQConnection.getConnectionUID());
                                if (!$assertionsDisabled && object == null) {
                                    throw new AssertionError();
                                }
                                boolean bl = true;
                                iMQConnection.addProducer((Producer)object);
                                if (destination != null) {
                                    bl = destination.addProducer((Producer)object);
                                }
                                ProducerUID producerUID = ((Producer)object).getProducerUID();
                                if (!$assertionsDisabled && producerUID == null) {
                                    throw new AssertionError();
                                }
                                hashtable.put("JMQProducerID", new Long(producerUID.longValue()));
                                hashtable.put("JMQDestinationID", destination.getDestinationUID().toString());
                                if (bl) {
                                    hashtable.put("JMQBytes", new Long(destination.getBytesProducerFlow()));
                                    hashtable.put("JMQSize", new Integer(destination.getSizeProducerFlow()));
                                } else {
                                    hashtable.put("JMQBytes", new Long(0L));
                                    hashtable.put("JMQSize", new Integer(0));
                                }
                            }
                        }
                    } else {
                        if (!$assertionsDisabled && packet.getPacketType() != 66) {
                            throw new AssertionError();
                        }
                        Long l = (Long)hashtable2.get("JMQProducerID");
                        if (!$assertionsDisabled && l == null) {
                            throw new AssertionError();
                        }
                        ProducerUID producerUID = new ProducerUID(l == null ? 0L : l);
                        Producer producer = Producer.getProducer(producerUID);
                        if (producer == null) {
                            logger.log(8, "B3100", "Internal error Unable to find producer " + producerUID + "\n\t checking if producer was removed recently " + Producer.checkProducer(producerUID));
                            string = "unknown producer";
                            n = 500;
                        } else if (producer.getConnectionUID() != iMQConnection.getConnectionUID()) {
                            logger.log(8, "B3100", " error connection removing producer it doesnt own\n\tPID=" + producerUID + "\n\tconnectionUID of request " + iMQConnection.getConnectionUID() + "\n\tconnectionUID of creator " + producer.getConnectionUID() + "\n\tchecking producer state: " + Producer.checkProducer(producerUID));
                            string = "unknown producer";
                            n = 500;
                        } else {
                            iMQConnection.removeProducer(producerUID, "Producer closed requested:\n\tconnection: " + iMQConnection.getConnectionUID() + "\n\tproducerID: " + producerUID + "\n\trequest sysmsgid message: " + packet.getSysMessageID());
                        }
                    }
                }
                catch (BrokerException brokerException) {
                    n = brokerException.getStatusCode();
                    string = brokerException.getMessage();
                    logger.log(8, string);
                }
                catch (Exception exception) {
                    logger.logStack(8, "B3100", "producer message ", (Throwable)exception);
                    string = exception.getMessage();
                    n = 500;
                }
                finally {
                    if (destination != null) {
                        destination.decrementRefCount();
                    }
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (IMQConnection.DUMP_PACKET) break block44;
                if (!IMQConnection.OUT_DUMP_PACKET) break block45;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        return true;
    }

    static {
        $assertionsDisabled = !ProducerHandler.class.desiredAssertionStatus();
    }
}

