/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.ClientIDHandler;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class ConsumerHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    boolean ALWAYS_WAIT_ON_DESTROY = Globals.getConfig().getBooleanProperty("imq.waitForConsumerDestroy");
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Consumer consumer;
        Hashtable<String, Object> hashtable;
        Packet packet2;
        Consumer consumer2;
        Session session;
        boolean bl;
        block94: {
            block93: {
                Object v;
                ConsumerUID consumerUID;
                int n;
                String string;
                block92: {
                    bl = false;
                    boolean bl2 = false;
                    Hashtable hashtable2 = null;
                    try {
                        hashtable2 = packet.getProperties();
                    }
                    catch (Exception exception) {
                        this.logger.log(8, "Internal Error: unable to retrieve  properties from consumer message " + packet, exception);
                        hashtable2 = new Hashtable();
                    }
                    Long l = (Long)hashtable2.get("JMQSessionID");
                    session = null;
                    string = null;
                    Boolean bl3 = (Boolean)hashtable2.get("JMQBlock");
                    consumer2 = null;
                    if (!$assertionsDisabled && bl3 != null && packet.getPacketType() != 16) {
                        throw new AssertionError(packet);
                    }
                    boolean bl4 = bl3 != null && bl3 != false;
                    packet2 = new Packet(iMQConnection.useDirectBuffers());
                    packet2.setConsumerID(packet.getConsumerID());
                    hashtable = new Hashtable<String, Object>();
                    packet2.setPacketType(packet.getPacketType() + 1);
                    n = 200;
                    String string2 = "B2009";
                    consumerUID = null;
                    v = null;
                    Integer n2 = null;
                    consumer = null;
                    try {
                        Object object;
                        int n3;
                        Serializable serializable;
                        iMQConnection.suspend();
                        bl2 = true;
                        if (packet.getPacketType() == 14) {
                            int n4;
                            Serializable serializable2;
                            if (DEBUG) {
                                this.logger.log(1, "ConsumerHandler: handle() [ Received AddConsumer message {0}]", packet.toString());
                            }
                            packet2.setPacketType(15);
                            if (l == null) {
                                if (DEBUG) {
                                    this.logger.log(4, "not Raptor consumer packet (no session id)");
                                }
                                if ((session = iMQConnection.getSession((SessionUID)(serializable2 = new SessionUID(iMQConnection.getConnectionUID().longValue())))) == null) {
                                    session = Session.createSession((SessionUID)serializable2, iMQConnection.getConnectionUID());
                                    iMQConnection.attachSession(session);
                                }
                            } else {
                                serializable2 = new SessionUID(l);
                                session = iMQConnection.getSession((SessionUID)serializable2);
                                if (session == null) {
                                    throw new BrokerException("Internal Error: client set invalid sessionUID " + serializable2 + " session does not exist");
                                }
                            }
                            if (bl4) {
                                session.pause("Consumer - Block flag");
                                bl = true;
                            }
                            if ((n2 = (Integer)hashtable2.get("JMQConsumerID")) != null) {
                                hashtable.put("JMQOldConsumerID", n2);
                            }
                            if (hashtable2 == null) {
                                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "no properties in addConsumer packet - client does not match protocol"));
                            }
                            serializable2 = (Integer)hashtable2.get("JMQDestType");
                            int n5 = n4 = serializable2 == null ? -1 : (Integer)serializable2;
                            if (n4 == -1) {
                                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Client is not sending DestType, unable to add interest"));
                            }
                            boolean bl5 = DestType.isQueue(n4);
                            String string3 = (String)hashtable2.get("JMQDestination");
                            String string4 = (String)hashtable2.get("JMQSelector");
                            Boolean bl6 = (Boolean)hashtable2.get("JMQNoLocal");
                            String string5 = (String)hashtable2.get("JMQDurableName");
                            String string6 = this.getClientID(hashtable2, iMQConnection);
                            Boolean bl7 = (Boolean)hashtable2.get("JMQReconnect");
                            Boolean bl8 = (Boolean)hashtable2.get("JMQShare");
                            Integer n6 = (Integer)hashtable2.get("JMQSize");
                            if (bl5 && bl6 != null && bl6.booleanValue()) {
                                Globals.getLogger().log(32, "B3100", "NoLocal is not supported on Queue Receivers");
                                throw new BrokerException("Unsupported property on queues JMQNoLocal is set to " + bl6, 500);
                            }
                            if (bl7 != null && bl7.booleanValue()) {
                                Globals.getLogger().log(32, "B3100", "JMQReconnect not implemented");
                            }
                            if (bl8 != null && bl8.booleanValue() && !ClientIDHandler.CAN_USE_SHARED_CONSUMERS) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4180", Globals.getBrokerResources().getKString("B0072"), string3), "B4180", null, 405);
                            }
                            Destination destination = null;
                            while (true) {
                                if ((destination = Destination.getDestination(string3, n4, true, !iMQConnection.isAdminConnection())).isAutoCreated()) {
                                    string2 = "B2106";
                                }
                                try {
                                    if (destination == null) break;
                                    destination.incrementRefCount();
                                }
                                catch (BrokerException brokerException) {
                                    continue;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", illegalStateException, 500);
                                }
                                break;
                            }
                            if (destination == null) {
                                n = 404;
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4017", string3), "B4017", null, 404);
                            }
                            if (string5 != null && string6 == null) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4135", string5), "B4135", null, 412);
                            }
                            DestinationUID destinationUID = destination.getDestinationUID();
                            Consumer consumer3 = null;
                            try {
                                int n7;
                                consumer2 = consumer3 = new Consumer(destinationUID, string4, bl6 == null ? false : bl6, iMQConnection.getConnectionUID());
                                consumer2.pause("Consumer: new consumer");
                                int n8 = n6 == null ? -1 : n6;
                                int n9 = n7 = bl8 == null || bl8 == false ? destination.getMaxPrefetch() : destination.getSharedConsumerFlowLimit();
                                int n10 = n7 == -1 ? n8 : (n8 == -1 ? n8 : (n8 > n7 ? n7 : n8));
                                consumer3.setPrefetch(n10);
                                if (n10 != -1 || n6 != null) {
                                    hashtable.put("JMQSize", new Integer(n10));
                                }
                                if (string5 != null) {
                                    consumer = Subscription.findCreateDurableSubscription(string6, string5, destinationUID, string4, bl6 == null ? false : bl6, true);
                                    consumer.pause("Consumer attaching to durable");
                                    boolean bl9 = bl8 == null ? false : bl8;
                                    ((Subscription)consumer).setShared(bl9);
                                    ((Subscription)consumer).attachConsumer(consumer3);
                                    Subscription subscription = (Subscription)destination.addConsumer(consumer, true);
                                    if (subscription != null) {
                                        subscription.purge();
                                    }
                                    ((Subscription)consumer).sendCreateSubscriptionNotification(consumer3);
                                } else if (!destination.isQueue() && bl8 != null && bl8.booleanValue()) {
                                    this.logger.log(4, "Creating shared non-durable " + consumer3);
                                    consumer = Subscription.createAttachNonDurableSub(consumer3, iMQConnection);
                                    if (consumer != null) {
                                        consumer.pause("Consumer: attaching to nondurable");
                                        ((Subscription)consumer).setShared(true);
                                        destination.addConsumer(consumer, true);
                                    }
                                    consumer3.attachToConnection(iMQConnection.getConnectionUID());
                                    if (consumer != null) {
                                        ((Subscription)consumer).sendCreateSubscriptionNotification(consumer3);
                                    }
                                } else {
                                    destination.addConsumer(consumer3, true);
                                    consumer3.attachToConnection(iMQConnection.getConnectionUID());
                                    consumer3.sendCreateConsumerNotification();
                                }
                            }
                            catch (SelectorFormatException selectorFormatException) {
                                throw new BrokerException(Globals.getBrokerResources().getKString("B2016", string4), "B2016", selectorFormatException, 400);
                            }
                            catch (OutOfLimitsException outOfLimitsException) {
                                if (destination.isQueue()) {
                                    Object[] objectArray = new String[]{destinationUID.getName(), String.valueOf(destination.getActiveConsumerCount()), String.valueOf(destination.getFailoverConsumerCount())};
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4006", objectArray), "B4006", outOfLimitsException, 409);
                                }
                                Object[] objectArray = new String[]{destinationUID.getName(), string5, string6, String.valueOf(outOfLimitsException.getLimit())};
                                throw new BrokerException(Globals.getBrokerResources().getKString("B4186", objectArray), "B4186", outOfLimitsException, 409);
                            }
                            finally {
                                if (destination != null) {
                                    destination.decrementRefCount();
                                }
                            }
                            session.attachConsumer(consumer3);
                            Integer n11 = (Integer)hashtable2.get("JMQAckMode");
                            if (n11 != null) {
                                consumer3.getConsumerUID().setAckType(n11);
                            }
                            consumerUID = consumer3.getConsumerUID();
                            break block92;
                        }
                        if (DEBUG) {
                            this.logger.log(1, "ConsumerHandler: handle() [ Received DestroyConsumer message {0}]", packet.toString());
                        }
                        string2 = "B2010";
                        packet2.setPacketType(17);
                        String string7 = (String)hashtable2.get("JMQDurableName");
                        String string8 = this.getClientID(hashtable2, iMQConnection);
                        Long l2 = (Long)hashtable2.get("JMQConsumerID");
                        ConsumerUID consumerUID2 = consumerUID = l2 == null ? null : new ConsumerUID(l2);
                        if (l != null) {
                            serializable = new SessionUID(l);
                            session = iMQConnection.getSession((SessionUID)serializable);
                        } else {
                            session = Session.getSession(consumerUID);
                        }
                        if (session == null && string7 == null) {
                            this.logger.log(32, "Internal error processing delete consumer\n" + PacketUtil.dumpPacket(packet));
                            Session.dumpAll();
                        }
                        int n12 = (serializable = (Integer)hashtable2.get("JMQBodyType")) == null ? 0 : (Integer)serializable;
                        SysMessageID sysMessageID = null;
                        if (n12 == 3) {
                            n3 = packet.getMessageBodySize();
                            if (!n3) {
                                this.logger.log(8, "Warning, bad body in destroy consumer");
                            } else {
                                object = new DataInputStream(packet.getMessageBodyStream());
                                sysMessageID = new SysMessageID();
                                sysMessageID.readID((DataInputStream)object);
                            }
                        }
                        if (DEBUG && sysMessageID != null) {
                            this.logger.log(4, "Sent lastID [" + sysMessageID + "]" + " for consumer " + consumerUID + Destination.get(sysMessageID));
                        }
                        if (!bl && session != null) {
                            bl = true;
                            session.pause("Consumer removeconsumer");
                        }
                        if (string7 != null) {
                            Subscription subscription = Subscription.unsubscribe(string7, string8);
                            if (subscription == null) {
                                throw new BrokerException(Globals.getBrokerResources().getString("B4058", string7, string8), 404);
                            }
                            object = subscription.getDestinationUID();
                            Destination destination = Destination.getDestination((DestinationUID)object);
                            if (!$assertionsDisabled && destination == null) {
                                throw new AssertionError();
                            }
                            if (destination != null) {
                                destination.removeConsumer(consumerUID, true);
                            }
                        } else {
                            DestinationUID destinationUID;
                            Destination destination;
                            if (!$assertionsDisabled && session == null) {
                                throw new AssertionError();
                            }
                            n3 = 0;
                            if (iMQConnection.getClientProtocolVersion() < 350) {
                                n3 = 1;
                            }
                            if ((destination = Destination.getDestination(destinationUID = ((Consumer)(object = session.detatchConsumer(consumerUID, sysMessageID, n3 != 0))).getDestinationUID())) != null) {
                                destination.removeConsumer(consumerUID, true);
                            }
                        }
                    }
                    catch (BrokerException brokerException) {
                        n = brokerException.getStatusCode();
                        String string9 = null;
                        String string10 = null;
                        try {
                            string10 = (String)hashtable2.get("JMQDestination");
                            if (string10 == null && packet.getPacketType() != 14) {
                                string10 = "";
                            }
                            string9 = n2 != null ? n2.toString() : "";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Object[] objectArray = new String[]{string9, iMQConnection.getRemoteConnectionString(), string10};
                        if (brokerException.getStatusCode() == 412 || brokerException.getStatusCode() == 409) {
                            this.logger.log(16, string2, objectArray, (Throwable)brokerException);
                        } else if (brokerException.getStatusCode() == 400) {
                            this.logger.log(16, string2, objectArray, (Throwable)brokerException);
                            if (brokerException.getCause() != null) {
                                this.logger.log(8, brokerException.getCause().toString());
                            }
                        } else {
                            this.logger.logStack(16, string2, objectArray, (Throwable)brokerException);
                        }
                        string = brokerException.getMessage();
                    }
                    catch (IOException iOException) {
                        this.logger.log(8, "Internal Error: unable to process  consumer request " + packet, iOException);
                        hashtable2 = new Hashtable();
                        string = iOException.getMessage();
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    catch (SecurityException securityException) {
                        n = 403;
                        string = securityException.getMessage();
                        String string11 = null;
                        String string12 = null;
                        try {
                            string11 = (String)hashtable2.get("JMQDestination");
                            if (n2 != null) {
                                string12 = n2.toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.logger.log(16, string2, string11, string12, securityException);
                    }
                    finally {
                        if (bl2) {
                            iMQConnection.resume();
                        }
                    }
                }
                hashtable.put("JMQStatus", new Integer(n));
                if (string != null) {
                    hashtable.put("JMQReason", string);
                }
                if (consumerUID != null) {
                    hashtable.put("JMQConsumerID", new Long(consumerUID.longValue()));
                }
                if (v != null) {
                    hashtable.put("JMQDestType", v);
                }
                if (IMQConnection.DUMP_PACKET) break block93;
                if (!IMQConnection.OUT_DUMP_PACKET) break block94;
            }
            hashtable.put("JMQReqID", packet.getSysMessageID().toString());
        }
        packet2.setProperties(hashtable);
        iMQConnection.sendControlMessage(packet2);
        if (bl) {
            session.resume("Consumer - session was paused");
        }
        if (consumer2 != null) {
            consumer2.resume("Consumer - new consumer");
        }
        if (consumer != null) {
            consumer.resume("Consumer - added to sub");
        }
        return true;
    }

    public String getClientID(Hashtable hashtable, Connection connection) {
        String string = (String)connection.getClientData("client id");
        if (string == null && (string = (String)hashtable.get("JMQClientID")) != null) {
            this.logger.log(32, "B3100", "client did not send setCLIENTID method before adding/removing a consumer, retrieved clientid " + string + " from packet properties");
        }
        return string;
    }

    static {
        $assertionsDisabled = !ConsumerHandler.class.desiredAssertionStatus();
        DEBUG = false;
    }
}

