/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.auth.FailedLoginException;
import com.sun.messaging.jmq.auth.server.AccessControlException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class AuthHandler
extends PacketHandler {
    private ConnectionManager connectionList;
    private Logger logger = Globals.getLogger();

    public AuthHandler(ConnectionManager connectionManager) {
        this.connectionList = connectionManager;
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        Object object;
        int n;
        block24: {
            Object object2;
            byte[] byArray;
            block29: {
                block28: {
                    AccessController accessController;
                    block25: {
                        block27: {
                            block26: {
                                block23: {
                                    byte[] byArray2 = null;
                                    ByteBuffer byteBuffer = packet.getMessageBody();
                                    int n2 = byteBuffer.remaining();
                                    byArray2 = new byte[n2];
                                    byteBuffer.get(byArray2);
                                    String string = null;
                                    accessController = iMQConnection.getAccessController();
                                    byArray = null;
                                    n = 500;
                                    if (iMQConnection.isAuthenticated()) {
                                        string = "already authenticated";
                                        this.logger.log(16, "Received unexpected authentication " + iMQConnection.getRemoteConnectionString() + ":" + iMQConnection.getConnectionUID());
                                        n = 500;
                                        byArray2 = null;
                                    } else if (!iMQConnection.setConnectionState(3)) {
                                        string = "bad connection state";
                                        n = 503;
                                        byArray2 = null;
                                    }
                                    if (byArray2 != null) {
                                        try {
                                            byArray = accessController.handleResponse(byArray2, packet.getSequence());
                                            n = 200;
                                            Globals.getAuditSession().authentication(iMQConnection.getUserName(), iMQConnection.remoteHostString(), true);
                                            if (byArray == null) {
                                                object = (IMQService)iMQConnection.getService();
                                                object2 = ServiceType.getServiceTypeString(((IMQService)object).getServiceType());
                                                try {
                                                    AuthCacheData authCacheData = ((IMQService)object).getAuthCacheData();
                                                    authCacheData.setCacheData(accessController.getCacheData());
                                                    accessController.checkConnectionPermission(((IMQService)object).getName(), (String)object2);
                                                    Globals.getAuditSession().connectionAuth(iMQConnection.getUserName(), iMQConnection.remoteHostString(), (String)object2, ((IMQService)object).getName(), true);
                                                }
                                                catch (AccessControlException accessControlException) {
                                                    string = "Forbidden";
                                                    n = 403;
                                                    accessController.logout();
                                                    this.logger.log(16, Globals.getBrokerResources().getKString("B2040", ((IMQService)object).getName(), object2) + " - " + accessControlException.getMessage(), accessControlException);
                                                    Globals.getAuditSession().connectionAuth(iMQConnection.getUserName(), iMQConnection.remoteHostString(), (String)object2, ((IMQService)object).getName(), false);
                                                }
                                            }
                                        }
                                        catch (FailedLoginException failedLoginException) {
                                            Globals.getAuditSession().authentication(failedLoginException.getUser(), iMQConnection.remoteHostString(), false);
                                            n = 413;
                                            string = failedLoginException.getMessage();
                                            this.logger.log(16, failedLoginException.getMessage(), failedLoginException);
                                        }
                                        catch (OutOfMemoryError outOfMemoryError) {
                                            throw outOfMemoryError;
                                        }
                                        catch (Throwable throwable) {
                                            n = 403;
                                            string = throwable.getMessage();
                                            this.logger.log(32, throwable.getMessage(), throwable);
                                        }
                                    }
                                    object = new Packet(iMQConnection.useDirectBuffers());
                                    ((Packet)object).setConsumerID(packet.getConsumerID());
                                    object2 = new Hashtable<String, Object>();
                                    if (string != null) {
                                        ((Hashtable)object2).put("JMQReason", string);
                                    }
                                    if (byArray2 != null) break block23;
                                    ((Packet)object).setPacketType(13);
                                    ((Hashtable)object2).put("JMQStatus", new Integer(n));
                                    ((Packet)object).setProperties((Hashtable)object2);
                                    break block24;
                                }
                                if (byArray != null && !iMQConnection.setConnectionState(2)) {
                                    n = 503;
                                    byArray = null;
                                }
                                if (byArray != null) break block25;
                                if (n == 200 && !iMQConnection.setConnectionState(4)) {
                                    n = 503;
                                }
                                ((Packet)object).setPacketType(13);
                                ((Hashtable)object2).put("JMQStatus", new Integer(n));
                                if (IMQConnection.DUMP_PACKET) break block26;
                                if (!IMQConnection.OUT_DUMP_PACKET) break block27;
                            }
                            ((Hashtable)object2).put("JMQReqID", packet.getSysMessageID().toString());
                        }
                        ((Packet)object).setProperties((Hashtable)object2);
                        break block24;
                    }
                    ((Packet)object).setPacketType(38);
                    ((Hashtable)object2).put("JMQAuthType", accessController.getAuthType());
                    ((Hashtable)object2).put("JMQChallenge", new Boolean(false));
                    if (IMQConnection.DUMP_PACKET) break block28;
                    if (!IMQConnection.OUT_DUMP_PACKET) break block29;
                }
                ((Hashtable)object2).put("JMQReqID", packet.getSysMessageID().toString());
            }
            ((Packet)object).setProperties((Hashtable)object2);
            ((Packet)object).setMessageBody(byArray);
        }
        iMQConnection.sendControlMessage((Packet)object);
        if (n != 200) {
            iMQConnection.closeConnection(true, Globals.getBrokerResources().getKString("B0064"));
        }
        return true;
    }
}

