/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.auth.server.AccessControlException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.DefaultHandler;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class PacketRouter {
    public static boolean DEBUG;
    private static final Logger logger;
    private PacketHandler[] list = new PacketHandler[78];
    private ErrHandler defaultHandler = new DefaultHandler();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addHandler(int n, PacketHandler packetHandler) throws ArrayIndexOutOfBoundsException {
        if (n > 78) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "Trying to add handler which has no corresponding packet type [ " + n + "]"));
        }
        this.list[n] = packetHandler;
    }

    public void addHandler(int n, int n2, PacketHandler packetHandler) throws ArrayIndexOutOfBoundsException {
        for (int i = n; i < n2; ++i) {
            this.addHandler(i, packetHandler);
        }
    }

    public PacketHandler getHandler(int n) throws ArrayIndexOutOfBoundsException {
        if (n > 78) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.list[n];
    }

    public void handleMessage(IMQConnection iMQConnection, Packet packet) {
        int n = packet.getPacketType();
        if (n < 0) {
            logger.log(32, Globals.getBrokerResources().getString("B4117", "invalid packet type {0}", String.valueOf(n)));
            this.defaultHandler.sendError(iMQConnection, 2, "invalid packet type " + n, packet);
            return;
        }
        PacketHandler packetHandler = null;
        packetHandler = n >= 78 ? this.defaultHandler : this.list[n];
        if (packetHandler == null) {
            packetHandler = this.defaultHandler;
        }
        if (packetHandler != this.defaultHandler && !this.accessControlCheck(packet, iMQConnection, packetHandler, n)) {
            return;
        }
        try {
            boolean bl = packetHandler.handle(iMQConnection, packet);
            if (bl) {
                packet.destroy();
                packet = null;
            }
        }
        catch (BrokerException brokerException) {
            if (!$assertionsDisabled && this.defaultHandler == null) {
                throw new AssertionError();
            }
            if (this.defaultHandler != null) {
                this.defaultHandler.sendError(iMQConnection, brokerException, packet);
            }
        }
        catch (Exception exception) {
            this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
        }
    }

    private boolean accessControlCheck(Packet packet, IMQConnection iMQConnection, PacketHandler packetHandler, int n) {
        AccessController accessController = iMQConnection.getAccessController();
        if (n != 10 && n != 54 && n != 12 && n != 28) {
            block13: {
                if (!accessController.isAuthenticated()) {
                    String string = Globals.getBrokerResources().getKString("B3059", PacketType.getString(n));
                    if (this.defaultHandler != null) {
                        this.defaultHandler.sendError(iMQConnection, 2, string, packet);
                    } else {
                        logger.log(32, string);
                    }
                    return false;
                }
                try {
                    packetHandler.checkPermission(packet, iMQConnection);
                    return true;
                }
                catch (AccessControlException accessControlException) {
                    try {
                        packetHandler.handleForbidden(iMQConnection, packet, n + 1);
                    }
                    catch (BrokerException brokerException) {
                        if (!$assertionsDisabled && this.defaultHandler == null) {
                            throw new AssertionError();
                        }
                        if (this.defaultHandler != null) {
                            this.defaultHandler.sendError(iMQConnection, brokerException, packet);
                        }
                    }
                    catch (Exception exception) {
                        if (this.defaultHandler != null) {
                            this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.defaultHandler == null) break block13;
                    this.defaultHandler.sendError(iMQConnection, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), exception), packet);
                }
            }
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !PacketRouter.class.desiredAssertionStatus();
        DEBUG = false;
        logger = Globals.getLogger();
    }
}

