/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.memory.MemoryGlobals;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PacketReference
implements Sized {
    public static ConsumerUID queueUID;
    private static boolean PREPEND_ID;
    public static boolean DEBUG;
    private static Logger logger;
    private boolean isStored = false;
    private boolean neverStore = false;
    private boolean isStoredWithInterest = false;
    private HashMap attachedData = null;
    private boolean destroyed = false;
    private SysMessageID msgid;
    transient ConnectionUID con_uid;
    private long creationtime;
    private long lastaccesstime;
    private int sequence;
    private boolean persist;
    private Set lbit_set = null;
    private boolean sendMessageDeliveredAck = false;
    private long size;
    private Hashtable props;
    private HashMap headers;
    private Object pktPtr;
    private int priority = 4;
    boolean isQueue = false;
    boolean invalid = false;
    DestinationUID destination = null;
    ExpirationInfo expire = null;
    boolean isExpired = false;
    long timestamp = 0L;
    TransactionUID transactionid;
    transient BrokerAddress addr = null;
    transient Destination d = null;
    transient String clientID = null;
    int interestCnt;
    int deliveredCnt;
    int ackCnt;
    int deadCnt;
    Map ackInfo = null;
    private static final int INITIAL = 0;
    private static final int ROUTED = 1;
    private static final int DELIVERED = 2;
    private static final int CONSUMED = 3;
    private static final int ACKED = 4;
    private static final int DEAD = 5;
    ConsumerUID lastDead = null;
    Set deliveredMsgAcks = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static PacketReference createReference(Packet packet, DestinationUID destinationUID, Connection connection) {
        PacketReference packetReference = new PacketReference(packet, destinationUID, connection);
        if (connection != null && packetReference.getExpiration() != null) {
            connection.checkClockSkew(packetReference.getTime(), packetReference.getTimestamp(), packetReference.getExpireTime());
        }
        return packetReference;
    }

    public static PacketReference createReference(Packet packet, Connection connection) {
        return PacketReference.createReference(packet, null, connection);
    }

    public static void moveMessage(PacketReference packetReference, PacketReference packetReference2, Set set) throws BrokerException, IOException {
        Object var3_3 = null;
        Object var4_4 = null;
        if (set == null) {
            throw new RuntimeException("Internal error: moving message to null targets not supported");
        }
        ReturnInfo returnInfo = PacketReference.calculateConsumerInfo(set, true);
        packetReference2.ackInfo = returnInfo.ackInfo;
        packetReference2.ackCnt = returnInfo.ackInfo.size();
        if (returnInfo.uids == null || returnInfo.uids.length == 0) {
            packetReference2.neverStore = true;
            return;
        }
        if (packetReference.isStored) {
            Globals.getStore().moveMessage(packetReference2.getPacket(), packetReference.getDestinationUID(), packetReference2.getDestinationUID(), returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
        }
        packetReference2.isStored = true;
        packetReference2.isStoredWithInterest = true;
        packetReference.isStored = false;
    }

    private static ReturnInfo calculateConsumerInfo(Collection collection, boolean bl) {
        Object object;
        if (collection.isEmpty()) {
            return null;
        }
        ReturnInfo returnInfo = new ReturnInfo();
        returnInfo.ackInfo = Collections.synchronizedMap(new HashMap());
        ArrayList<ConsumerUID> arrayList = bl ? new ArrayList<ConsumerUID>() : null;
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            object = iterator.next();
            ConsumerUID consumerUID = null;
            consumerUID = object instanceof Consumer ? ((Consumer)object).getStoredConsumerUID() : (ConsumerUID)object;
            ++returnInfo.interestCnt;
            boolean bl3 = false;
            if (arrayList != null && consumerUID.shouldStore()) {
                arrayList.add(consumerUID);
                bl3 = true;
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, bl3);
            returnInfo.ackInfo.put(consumerUID, consumerMessagePair);
        }
        if (arrayList != null) {
            object = new ConsumerUID[]{};
            returnInfo.uids = (ConsumerUID[])arrayList.toArray((T[])object);
            returnInfo.states = new int[returnInfo.uids.length];
            for (int i = 0; i < returnInfo.states.length; ++i) {
                returnInfo.states[i] = 0;
            }
        }
        return returnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacketReference(Packet packet, DestinationUID destinationUID, Connection connection) {
        this.lastaccesstime = this.creationtime = System.currentTimeMillis();
        this.msgid = (SysMessageID)packet.getSysMessageID().clone();
        this.isQueue = packet.getIsQueue();
        this.persist = packet.getPersistent();
        this.priority = packet.getPriority();
        this.sequence = packet.getSequence();
        this.timestamp = packet.getTimestamp();
        if (connection != null) {
            this.clientID = (String)connection.getClientData("client id");
        }
        this.setExpireTime(packet.getExpiration());
        this.size = packet.getPacketSize();
        String string = packet.getDestination();
        this.con_uid = connection == null ? null : connection.getConnectionUID();
        this.destination = destinationUID != null ? destinationUID : DestinationUID.getUID(string, this.isQueue);
        long l = packet.getTransactionID();
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.setPacketObject(false, packet);
        }
        this.transactionid = l != 0L ? new TransactionUID(l) : null;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public String getClientID() {
        return this.clientID;
    }

    private ConsumerMessagePair getAck(Object object) {
        ConsumerUID consumerUID = null;
        if (object instanceof ConsumerUID) {
            consumerUID = (ConsumerUID)object;
        } else if (object instanceof Consumer) {
            consumerUID = ((Consumer)object).getConsumerUID();
        } else {
            throw new RuntimeException("Bogus ID");
        }
        return (ConsumerMessagePair)this.ackInfo.get(consumerUID);
    }

    public void setDestination(Destination destination) {
        this.d = destination;
    }

    public Destination getDestination() {
        if (this.d == null) {
            this.d = Destination.getDestination(this.destination);
        }
        return this.d;
    }

    boolean isStored() {
        return this.isStored;
    }

    public void setBrokerAddress(BrokerAddress brokerAddress) {
        this.addr = brokerAddress;
    }

    public BrokerAddress getAddress() {
        return this.addr;
    }

    public boolean isLocal() {
        return this.addr == null || this.addr == Globals.getMyAddress();
    }

    public String toString() {
        return "PacketReference[" + this.msgid + "]";
    }

    public boolean getMessageDeliveredAck(ConsumerUID consumerUID) {
        return !this.deliveredMsgAcks.isEmpty() && this.deliveredMsgAcks.contains(consumerUID);
    }

    public ConsumerUID[] getConsumersForMsgDelivered() {
        return this.deliveredMsgAcks.toArray(new ConsumerUID[0]);
    }

    public void removeMessageDeliveredAck(ConsumerUID consumerUID) {
        this.deliveredMsgAcks.remove(consumerUID);
    }

    public void addMessageDeliveredAck(ConsumerUID consumerUID) {
        this.deliveredMsgAcks.add(consumerUID);
    }

    private void setExpireTime(long l) {
        this.expire = l == 0L ? null : new ExpirationInfo(this.msgid, l);
    }

    public long getExpireTime() {
        if (this.expire == null) {
            return 0L;
        }
        return this.expire.getExpireTime();
    }

    public ExpirationInfo getExpiration() {
        return this.expire;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    private Packet getPacketObject() {
        if (!($assertionsDisabled || this.pktPtr == null || this.pktPtr instanceof SoftReference || this.pktPtr instanceof Packet)) {
            throw new AssertionError(this.pktPtr);
        }
        Object object = this.pktPtr;
        if (object == null) {
            return null;
        }
        if (object instanceof SoftReference) {
            return (Packet)((SoftReference)this.pktPtr).get();
        }
        return (Packet)this.pktPtr;
    }

    private void setPacketObject(boolean bl, Packet packet) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.pktPtr = bl ? new SoftReference<Packet>(packet) : packet;
    }

    private void makePacketSoftRef() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        Object object = this.pktPtr;
        if (object != null && object instanceof Packet) {
            this.pktPtr = new SoftReference<Object>(object);
        }
    }

    public void setNeverStore(boolean bl) {
        this.neverStore = bl;
    }

    public long byteSize() {
        return this.size;
    }

    public synchronized void setLoaded() {
        this.isStoredWithInterest = true;
        this.isStored = true;
        this.makePacketSoftRef();
    }

    public ConnectionUID getProducingConnectionUID() {
        return this.con_uid;
    }

    public int getPriority() {
        return this.priority;
    }

    public TransactionUID getTransactionID() {
        return this.transactionid;
    }

    public boolean getIsQueue() {
        return this.isQueue;
    }

    public long getTime() {
        return this.creationtime;
    }

    public long getSequence() {
        return this.sequence;
    }

    public synchronized void setLastBit(ConsumerUID consumerUID) throws IllegalStateException {
        if (this.isInvalid() && this.isDestroyed()) {
            throw new IllegalStateException(Globals.getBrokerResources().getString("B4117", "reference has been destroyed"));
        }
        if (this.lbit_set == null) {
            this.lbit_set = new HashSet();
        }
        this.lbit_set.add(consumerUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("AckCount", String.valueOf(this.ackCnt));
        hashtable.put("DeadCount", String.valueOf(this.deadCnt));
        hashtable.put("ackInfo[#]", String.valueOf(this.ackInfo.size()));
        hashtable.put("interestCount", String.valueOf(this.interestCnt));
        Vector<String> vector = new Vector<String>();
        Map map = this.ackInfo;
        synchronized (map) {
            Iterator iterator = this.ackInfo.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                ConsumerMessagePair consumerMessagePair = this.getAck(k);
                vector.add(consumerMessagePair.toString());
            }
        }
        if (!vector.isEmpty()) {
            hashtable.put("Acks", vector);
        }
        return hashtable;
    }

    public synchronized boolean isLast(ConsumerUID consumerUID) {
        if (this.lbit_set == null) {
            return false;
        }
        return this.lbit_set.contains(consumerUID);
    }

    public synchronized void removeIsLast(ConsumerUID consumerUID) {
        if (this.lbit_set == null) {
            return;
        }
        this.lbit_set.remove(consumerUID);
        if (this.lbit_set.isEmpty() && this.invalid) {
            this.destroy();
        }
    }

    public synchronized boolean getLBitSet() {
        return this.lbit_set != null && !this.lbit_set.isEmpty();
    }

    public DestinationUID getDestinationUID() {
        return this.destination;
    }

    public String getDestinationName() {
        return this.destination.getName();
    }

    public synchronized Packet getPacket() {
        Packet packet = this.getPacketObject();
        if (packet != null || this.destroyed) {
            return packet;
        }
        if (!$assertionsDisabled && !this.persist) {
            throw new AssertionError();
        }
        if (!this.persist) {
            return null;
        }
        packet = this.recoverPacket();
        if (!$assertionsDisabled && packet == null) {
            throw new AssertionError();
        }
        this.setPacketObject(true, packet);
        return packet;
    }

    private Packet recoverPacket() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.pktPtr == null || this.pktPtr instanceof SoftReference && ((Reference)this.pktPtr).get() == null)) {
            throw new AssertionError();
        }
        try {
            Packet packet = Globals.getStore().getMessage(this.destination, this.msgid);
            if (!$assertionsDisabled && packet == null) {
                throw new AssertionError();
            }
            return packet;
        }
        catch (BrokerException brokerException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)brokerException);
            }
            logger.logStack(32, "B3144", this.msgid.toString(), (Throwable)brokerException);
            return null;
        }
    }

    public synchronized Hashtable getProperties() throws ClassNotFoundException {
        if (this.destroyed || this.invalid) {
            return new Hashtable();
        }
        this.lastaccesstime = System.currentTimeMillis();
        Packet packet = this.getPacketObject();
        if (this.props == null && !this.destroyed) {
            if (packet == null) {
                packet = this.getPacket();
            }
            try {
                this.props = packet.getProperties();
            }
            catch (IOException iOException) {
                logger.log(8, "Internal Exception: ", iOException);
                this.props = new Hashtable();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw classNotFoundException;
            }
        }
        return this.props;
    }

    public synchronized HashMap getHeaders() {
        if (this.headers == null) {
            if (this.destroyed || this.invalid) {
                return new HashMap();
            }
            Packet packet = this.getPacketObject();
            if (!$assertionsDisabled && packet == null) {
                throw new AssertionError();
            }
            this.headers = new HashMap();
            if (packet == null) {
                if (DEBUG) {
                    logger.log(4, "no packet for non-destroyed message " + this.msgid);
                }
                return this.headers;
            }
            this.headers.put("JMSPriority", new Integer(this.priority));
            this.headers.put("JMSMessageID", (PREPEND_ID ? "ID:" : "") + this.msgid.toString());
            this.headers.put("JMSTimestamp", new Long(this.timestamp));
            this.headers.put("JMSDeliveryMode", packet.getPersistent() ? "PERSISTENT" : "NON_PERSISTENT");
            this.headers.put("JMSCorrelationID", packet.getCorrelationID());
            this.headers.put("JMSType", packet.getMessageType());
        }
        return this.headers;
    }

    public SysMessageID getSysMessageID() {
        return this.msgid;
    }

    public long getCreateTime() {
        return this.creationtime;
    }

    public long getLastAccessTime() {
        return this.lastaccesstime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void overridePersistence(boolean bl) {
        this.persist = bl;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized boolean isInvalid() {
        return this.invalid;
    }

    public boolean mayExpire() {
        return this.expire == null;
    }

    public boolean isExpired() {
        if (this.expire == null) {
            return false;
        }
        return this.isExpired(System.currentTimeMillis());
    }

    public void overrideExpireTime(long l) {
        this.setExpireTime(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired(long l) {
        if (this.isExpired) {
            return true;
        }
        if (this.expire == null) {
            return false;
        }
        boolean bl = this.expire.isExpired(l);
        if (bl) {
            PacketReference packetReference = this;
            synchronized (packetReference) {
                this.makePacketSoftRef();
            }
        }
        return bl;
    }

    void clearExpirationInfo() {
        this.isExpired = true;
        this.expire = null;
    }

    public boolean equals(Object object) {
        if (this.msgid == null) {
            return this.msgid == object;
        }
        if (object instanceof SysMessageID) {
            return this.msgid.equals(object);
        }
        if (object instanceof Packet) {
            return this.msgid.equals(((Packet)object).getSysMessageID());
        }
        if (object instanceof PacketReference) {
            return this.msgid.equals(((PacketReference)object).msgid);
        }
        return false;
    }

    public int hashCode() {
        return this.msgid == null ? 0 : this.msgid.hashCode();
    }

    public boolean matches(DestinationUID destinationUID) {
        return true;
    }

    public static String stateToString(int n) {
        switch (n) {
            case 0: {
                return "INITIAL";
            }
            case 1: {
                return "ROUTED";
            }
            case 2: {
                return "DELIVERED";
            }
            case 3: {
                return "CONSUMED";
            }
            case 4: {
                return "ACKED";
            }
            case 5: {
                return "DEAD";
            }
        }
        return "UNKNOWN";
    }

    public synchronized void store() throws BrokerException {
        if (!this.destroyed && this.persist && !this.neverStore && !this.isStored) {
            if (!$assertionsDisabled && !(this.pktPtr instanceof Packet)) {
                throw new AssertionError();
            }
            try {
                Globals.getStore().storeMessage(this.destination, (Packet)this.pktPtr, Destination.PERSIST_SYNC);
                this.makePacketSoftRef();
            }
            catch (IOException iOException) {
                throw new BrokerException(iOException.toString(), iOException);
            }
            catch (Exception exception) {
                logger.logStack(32, "B2011", this.msgid.toString(), (Throwable)exception);
                throw new BrokerException(exception.toString(), exception);
            }
            this.isStored = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Collection collection) throws BrokerException {
        block15: {
            if (this.destroyed || this.pktPtr == null) {
                return;
            }
            if (this.isStoredWithInterest) {
                return;
            }
            boolean bl = !this.neverStore && this.persist;
            ReturnInfo returnInfo = PacketReference.calculateConsumerInfo(collection, bl);
            if (this.ackInfo != null) {
                this.ackInfo.putAll(returnInfo.ackInfo);
            } else {
                this.ackInfo = returnInfo.ackInfo;
            }
            this.interestCnt = returnInfo.ackInfo.size();
            if (!bl) {
                return;
            }
            if (returnInfo.uids == null || returnInfo.uids.length == 0) {
                this.neverStore = true;
                return;
            }
            try {
                if (this.isStored) {
                    Globals.getStore().storeInterestStates(this.destination, this.msgid, returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
                    break block15;
                }
                if (!($assertionsDisabled || this.pktPtr instanceof Packet || this.pktPtr == null && this.destroyed)) {
                    throw new AssertionError((Object)("PktPtr is " + this.pktPtr.getClass()));
                }
                Globals.getStore().storeMessage(this.destination, (Packet)this.pktPtr, returnInfo.uids, returnInfo.states, Destination.PERSIST_SYNC);
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    this.makePacketSoftRef();
                }
            }
            catch (IOException iOException) {
                throw new BrokerException(iOException.toString(), iOException);
            }
            catch (Exception exception) {
                logger.logStack(32, "B2011", this.msgid.toString(), (Throwable)exception);
                throw new BrokerException(exception.toString(), exception);
            }
        }
        this.isStored = true;
        this.isStoredWithInterest = true;
        if (!$assertionsDisabled && this.interestCnt == 0) {
            throw new AssertionError();
        }
    }

    public void add(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            ConsumerUID consumerUID = null;
            consumerUID = e instanceof ConsumerUID ? (ConsumerUID)e : ((Consumer)e).getStoredConsumerUID();
            ++this.interestCnt;
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, false);
            consumerMessagePair.setState(1);
            this.ackInfo.put(consumerUID, consumerMessagePair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ConsumerUID[] consumerUIDArray, int[] nArray) {
        if (!$assertionsDisabled && !this.isStored) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && consumerUIDArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && nArray == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && consumerUIDArray.length != nArray.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.ackInfo != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && consumerUIDArray.length == 0) {
            throw new AssertionError();
        }
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.interestCnt += consumerUIDArray.length;
        }
        for (int i = 0; i < consumerUIDArray.length; ++i) {
            ConsumerUID consumerUID = consumerUIDArray[i];
            if (!$assertionsDisabled && consumerUIDArray[i] == null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || nArray[i] >= 0 && nArray[i] <= 2)) {
                throw new AssertionError();
            }
            if (nArray[i] == 2) continue;
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            ConsumerMessagePair consumerMessagePair = new ConsumerMessagePair(consumerUID, true);
            this.ackInfo.put(consumerUID, consumerMessagePair);
            consumerMessagePair.setState(nArray[i] == 0 ? 1 : 3);
        }
        if (!$assertionsDisabled && this.interestCnt == 0) {
            throw new AssertionError();
        }
    }

    public void debug(String string) {
        if (string == null) {
            string = "";
        }
        logger.log(8, string + "Message " + this.msgid);
        logger.log(8, string + "size " + this.ackInfo.size());
        Iterator iterator = this.ackInfo.values().iterator();
        while (iterator.hasNext()) {
            ConsumerMessagePair consumerMessagePair = (ConsumerMessagePair)iterator.next();
            logger.log(8, string + "\t " + consumerMessagePair);
        }
    }

    public void routed(ConsumerUID consumerUID) throws BrokerException, IOException {
        if (this.destroyed || this.invalid) {
            logger.log(4, "route on destroyed ref " + this.msgid + ":" + consumerUID);
            return;
        }
    }

    public int getCompleteCnt() {
        return this.ackCnt + this.deadCnt;
    }

    public int getDeliverCnt() {
        return this.deliveredCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delivered(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2) throws BrokerException, IOException {
        PacketReference packetReference;
        if (this.destroyed || this.invalid) {
            logger.log(4, "delivered on destroyed ref " + this.msgid + ":" + consumerUID2);
            return true;
        }
        if (consumerUID.isNoAck()) {
            return this.acknowledged(consumerUID, consumerUID2, bl, bl2);
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID2);
        if (consumerMessagePair == null) {
            logger.log(4, "Received Unknown delivered:\n\tStoreUID: " + consumerUID2 + "\n\tConsumerUID: " + consumerUID + "\n\tConsumer: " + Consumer.getConsumer(consumerUID));
            if (DEBUG) {
                this.debug("\t- ");
            }
            return false;
        }
        if (!consumerMessagePair.compareStateLT(2)) {
            packetReference = this;
            synchronized (packetReference) {
                ++this.deliveredCnt;
            }
        }
        consumerMessagePair.setStateIfLess(2, 2);
        if (consumerMessagePair.isStored() && bl2) {
            Globals.getStore().updateInterestState(this.destination, this.msgid, consumerUID2, 1, Destination.PERSIST_SYNC && bl);
        }
        packetReference = this;
        synchronized (packetReference) {
            if (this.deliveredCnt >= this.interestCnt && this.isStored && (MemoryGlobals.MEM_FREE_P_ACKED && this.persist || MemoryGlobals.MEM_FREE_NP_ACKED && !this.persist)) {
                this.unload();
            }
        }
        return false;
    }

    public int getRedeliverCount(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        return consumerMessagePair == null ? 0 : consumerMessagePair.getRedeliverCount();
    }

    public void consumed(ConsumerUID consumerUID, boolean bl, boolean bl2) throws BrokerException, IOException {
        if (this.destroyed || this.invalid) {
            logger.log(4, "consumed on destroyed ref " + this.msgid + ":" + consumerUID);
            return;
        }
        if (bl2) {
            this.delivered(consumerUID, consumerUID, bl, true);
        }
        if (!$assertionsDisabled && this.ackInfo == null) {
            throw new AssertionError();
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (!$assertionsDisabled && consumerMessagePair == null) {
            throw new AssertionError();
        }
        if (consumerMessagePair == null) {
            logger.log(32, "Internal Error: unknown interest for  consumed on " + this.msgid + consumerUID);
            return;
        }
        consumerMessagePair.incrementRedeliver();
        consumerMessagePair.setStateIfLess(3, 3);
    }

    public boolean matches(ConsumerUID consumerUID) {
        return this.getAck(consumerUID) != null;
    }

    public boolean isAcknowledged(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            return true;
        }
        return consumerMessagePair.compareState(4);
    }

    public boolean isDelivered(ConsumerUID consumerUID) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            return true;
        }
        return consumerMessagePair.compareState(2) || consumerMessagePair.compareState(3);
    }

    public boolean removeDelivered(ConsumerUID consumerUID, boolean bl) {
        if (this.destroyed || this.invalid) {
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (!$assertionsDisabled && consumerMessagePair == null) {
            throw new AssertionError();
        }
        if (consumerMessagePair == null) {
            logger.log(32, "Internal Error: unknown interest for  remove consumed on " + this.msgid + consumerUID);
            return false;
        }
        if (bl) {
            consumerMessagePair.decrementRedeliver();
        }
        consumerMessagePair.compareAndSetState(1, 2);
        return consumerMessagePair.getRedeliverCount() >= 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledged(ConsumerUID consumerUID, ConsumerUID consumerUID2, boolean bl, boolean bl2) throws BrokerException, IOException {
        try {
            if (this.destroyed || this.invalid) {
                return true;
            }
            ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID2);
            if (consumerMessagePair == null) {
                logger.log(32, "Internal Error: Received Unknown ack " + consumerUID);
                logger.log(32, "AckInfo" + this.ackInfo.toString());
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    return this.ackCnt + this.deadCnt >= this.interestCnt;
                }
            }
            if (consumerMessagePair.setState(4)) {
                if (consumerMessagePair.isStored()) {
                    Globals.getStore().updateInterestState(this.destination, this.msgid, consumerUID2, 2, Destination.PERSIST_SYNC && bl);
                }
                if (!this.isLocal()) {
                    if (bl2) {
                        Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this, consumerUID, 1);
                    } else {
                        Globals.getClusterBroadcast().acknowledgeMessage(this.getAddress(), this, consumerUID, 2);
                    }
                }
            } else {
                Consumer consumer = Consumer.getConsumer(consumerUID);
                if (consumer == null || !consumer.isValid()) {
                    PacketReference packetReference = this;
                    synchronized (packetReference) {
                        return this.ackCnt + this.deadCnt >= this.interestCnt;
                    }
                }
                Exception exception = new Exception("double ack " + consumerMessagePair);
                exception.fillInStackTrace();
                logger.logStack(32, "Internal Error: received ack twice  on " + this.msgid + " for " + consumerUID + " state is = " + consumerMessagePair, exception);
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    return this.ackCnt + this.deadCnt >= this.interestCnt;
                }
            }
            PacketReference packetReference = this;
            synchronized (packetReference) {
                ++this.ackCnt;
                return this.ackCnt + this.deadCnt >= this.interestCnt;
            }
        }
        catch (Throwable throwable) {
            logger.logStack(32, "Internal Error processing ack on " + this.msgid + " for " + consumerUID, throwable);
            return false;
        }
    }

    public boolean getRedeliverFlag(ConsumerUID consumerUID) {
        if (this.destroyed || this.invalid) {
            logger.log(4, "redeliver for destroyed " + this.msgid + ":" + consumerUID);
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (!$assertionsDisabled && consumerMessagePair == null) {
            throw new AssertionError();
        }
        if (consumerMessagePair == null) {
            return false;
        }
        return !consumerMessagePair.compareStateLT(2);
    }

    public boolean getConsumed(ConsumerUID consumerUID) {
        if (this.destroyed || this.invalid) {
            logger.log(4, "getConsumed for destroyed " + this.msgid + ":" + consumerUID);
            return true;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            logger.log(32, "Internal Error: unknown interest for  getConsumed on " + this.msgid + consumerUID);
            return true;
        }
        return consumerMessagePair.compareState(3);
    }

    public synchronized void clear() {
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
        this.msgid = null;
    }

    public void remove() {
        if (this.isStored) {
            try {
                Globals.getStore().removeMessage(this.destination, this.msgid, false);
                this.isStored = false;
            }
            catch (IOException iOException) {
                logger.logStack(32, "B3145", this.msgid.toString(), (Throwable)iOException);
            }
            catch (BrokerException brokerException) {
                logger.logStack(32, "B3145", this.msgid.toString(), (Throwable)brokerException);
            }
            this.isStored = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (!$assertionsDisabled && this.getLBitSet()) {
            throw new AssertionError();
        }
        PacketReference packetReference = this;
        synchronized (packetReference) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        if (this.isStored) {
            try {
                Globals.getStore().removeMessage(this.destination, this.msgid, false);
                this.isStored = false;
            }
            catch (IOException iOException) {
                logger.logStack(32, "B3145", this.msgid.toString(), (Throwable)iOException);
            }
            catch (BrokerException brokerException) {
                logger.logStack(32, "B3145", this.msgid.toString(), (Throwable)brokerException);
            }
        }
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
    }

    void unload() {
        if (this.pktPtr instanceof SoftReference) {
            ((SoftReference)this.pktPtr).clear();
        }
    }

    public String getDeadComment() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadComment();
    }

    public int getDeadDeliverCnt() {
        if (this.lastDead == null) {
            return this.getDeliverCnt();
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? this.getDeliverCnt() : consumerMessagePair.getRedeliverCount();
    }

    public Reason getDeadReason() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadReason();
    }

    public Throwable getDeadException() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair consumerMessagePair = this.getAck(this.lastDead);
        return consumerMessagePair == null ? null : consumerMessagePair.getDeadException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDead(ConsumerUID consumerUID, String string, Throwable throwable, Reason reason, int n) {
        ConsumerMessagePair consumerMessagePair = this.getAck(consumerUID);
        if (consumerMessagePair == null) {
            logger.log(4, "Received unknown dead message " + consumerUID);
            return false;
        }
        this.lastDead = consumerUID;
        consumerMessagePair.setState(5);
        consumerMessagePair.setDeadComment(string);
        consumerMessagePair.setDeadReason(reason);
        consumerMessagePair.setDeadException(throwable);
        if (n > -1) {
            consumerMessagePair.setRedeliverCount(n);
        }
        PacketReference packetReference = this;
        synchronized (packetReference) {
            ++this.deadCnt;
            return this.ackCnt + this.deadCnt >= this.interestCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDead() {
        PacketReference packetReference = this;
        synchronized (packetReference) {
            return this.deadCnt > 0 && this.ackCnt + this.deadCnt >= this.interestCnt;
        }
    }

    static {
        $assertionsDisabled = !PacketReference.class.desiredAssertionStatus();
        queueUID = null;
        PREPEND_ID = Globals.getConfig().getBooleanProperty("imq.fix.JMSMessageID", false);
        queueUID = new ConsumerUID(true);
        queueUID.setShouldStore(true);
        DEBUG = false;
        logger = Globals.getLogger();
    }

    static class ReturnInfo {
        ConsumerUID[] uids;
        int[] states;
        int interestCnt;
        Map ackInfo;

        ReturnInfo() {
        }
    }

    static class ConsumerMessagePair {
        private ConsumerUID uid;
        private int state = 0;
        private int redeliverCnt = 0;
        private boolean stored;
        private String deadComment = null;
        private Reason deadReason = null;
        private Throwable deadException = null;
        private long timestamp = 0L;

        public ConsumerMessagePair(ConsumerUID consumerUID, boolean bl) {
            this.uid = consumerUID;
            this.stored = bl;
        }

        public synchronized int incrementRedeliver() {
            ++this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized int decrementRedeliver() {
            --this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized boolean setState(int n) {
            if (this.state == n) {
                return false;
            }
            this.state = n;
            this.timestamp = System.currentTimeMillis();
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }

        public synchronized boolean compareAndSetState(int n, int n2) {
            if (this.state != n2) {
                return false;
            }
            this.timestamp = System.currentTimeMillis();
            this.state = n;
            return true;
        }

        public synchronized boolean compareState(int n) {
            return this.state == n;
        }

        public synchronized boolean compareStateGT(int n) {
            return this.state > n;
        }

        public synchronized boolean compareStateLT(int n) {
            return this.state < n;
        }

        public synchronized boolean setStateIfLess(int n, int n2) {
            if (this.compareStateLT(n2)) {
                return this.setState(n);
            }
            return false;
        }

        public boolean isStored() {
            return this.stored;
        }

        public int getRedeliverCount() {
            return this.redeliverCnt;
        }

        public void setRedeliverCount(int n) {
            this.redeliverCnt = n;
        }

        public void setDeadComment(String string) {
            this.deadComment = string;
        }

        public void setDeadReason(Reason reason) {
            this.deadReason = reason;
        }

        public String getDeadComment() {
            return this.deadComment;
        }

        public Reason getDeadReason() {
            return this.deadReason;
        }

        public Throwable getDeadException() {
            return this.deadException;
        }

        public void setDeadException(Throwable throwable) {
            this.deadException = throwable;
        }

        public String toString() {
            return ": CMPair[" + this.uid.longValue() + ":" + PacketReference.stateToString(this.state) + ":" + this.stored + "] - " + this.timestamp;
        }
    }
}

