/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.file;

import com.sun.messaging.jmq.auth.LoginException;
import com.sun.messaging.jmq.auth.server.model.Subject;
import com.sun.messaging.jmq.auth.server.model.UserRepository;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.file.JMQFileSubject;
import com.sun.messaging.jmq.util.MD5;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class JMQFileUserRepository
implements UserRepository {
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String DEFAULT_PW_FILENAME = "passwd";
    public static boolean DEBUG = false;
    private transient Logger logger = Globals.getLogger();
    private String authType;
    private Properties authProps = null;
    private HashMap userPTable = null;
    private HashMap userRTable = null;
    private boolean tableOld = true;

    public void JMQFileUserRepository() {
    }

    public String getType() {
        return TYPE;
    }

    public void open(String string, Properties properties, Object object, boolean bl) throws LoginException {
        this.authType = string;
        this.authProps = properties;
    }

    public Subject findMatch(String string, Object object, Object object2, String string2) throws LoginException {
        if (this.userPTable == null || this.userRTable == null) {
            try {
                this.loadUserTable();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.userPTable = null;
                this.userRTable = null;
                throw new LoginException(iOException.getMessage());
            }
        }
        if (string2 != null) {
            if (string2.equals("basic")) {
                return this.jmqbasicFindMatch(string, (String)object);
            }
            if (string2.equals("digest")) {
                return this.jmqdigestFindMatch(string, (String)object, (String)object2);
            }
        }
        String string3 = string2 == null ? "null" : string2;
        Object[] objectArray = new String[]{string3, this.authType, this.getType(), "basic:digest"};
        throw new LoginException(Globals.getBrokerResources().getKString("B4079", objectArray));
    }

    private Subject jmqbasicFindMatch(String string, String string2) throws LoginException {
        if (DEBUG) {
            this.logger.log(4, "basic matching " + string + ":" + string2);
        }
        Subject subject = null;
        String string3 = (String)this.userPTable.get(string);
        if (string3 != null && string3.equals(MD5.getHashString(string + ":" + string2))) {
            subject = this.getSubject(string);
        }
        return subject;
    }

    private Subject jmqdigestFindMatch(String string, String string2, String string3) throws LoginException {
        String string4;
        if (DEBUG) {
            this.logger.log(4, "digest matching " + string2);
        }
        Subject subject = null;
        String string5 = (String)this.userPTable.get(string);
        if (string5 != null && string2.equals(string4 = MD5.getHashString(string5 + ":" + string3))) {
            subject = this.getSubject(string);
        }
        return subject;
    }

    private Subject getSubject(String string) {
        JMQFileSubject jMQFileSubject = null;
        String string2 = (String)this.userRTable.get(string);
        if (string2 != null && !string2.trim().equals("")) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string2);
            jMQFileSubject = new JMQFileSubject(string);
            jMQFileSubject.setGroups(hashSet);
            if (string2.equals("admin")) {
                jMQFileSubject.setIsAdministrator(true);
            }
            jMQFileSubject.setUserAttributes(TYPE);
        }
        return jMQFileSubject;
    }

    private void loadUserTable() throws IOException {
        String string = this.authProps.getProperty("imq.authentication." + this.authType + ".user_repository");
        if (string == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B4041", this.authType));
        }
        if (!string.equals(TYPE)) {
            Object[] objectArray = new String[]{string, TYPE, this.getClass().getName()};
            throw new IOException(Globals.getBrokerResources().getKString("B4070", objectArray));
        }
        File file = JMQFileUserRepository.getPasswordFile(this.authProps);
        this.userPTable = new HashMap();
        this.userRTable = new HashMap();
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":", false);
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                }
                if (DEBUG) {
                    this.logger.log(4, "passwd entry " + string6 + ":" + string5 + ":" + string4 + ":" + string3);
                }
                if (string6 == null || string5 == null || string4 == null || string3 == null || !string3.equals("1")) continue;
                this.userPTable.put(string6, string5);
                this.userRTable.put(string6, string4);
            }
            bufferedReader.close();
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public Object getCacheData() {
        return null;
    }

    public void close() throws LoginException {
    }

    public static File getPasswordFile(Properties properties) {
        String string = properties.getProperty("imq.user_repository.file.dirpath", Globals.getInstanceEtcDir());
        string = StringUtil.expandVariables(string, properties);
        String string2 = properties.getProperty("imq.user_repository.file.filename", DEFAULT_PW_FILENAME);
        String string3 = string + File.separator + string2;
        return new File(string3);
    }
}

