/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.Link;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ConnKey;
import com.sun.messaging.jmq.transport.httptunnel.servlet.Connection;
import com.sun.messaging.jmq.transport.httptunnel.servlet.HelperThread;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLink;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServerLinkTable
implements HttpTunnelDefaults {
    private static final int RUNNING = 0;
    private static final int SHUTTINGDOWN = 1;
    private static final int DESTROYED = 2;
    private int linkTableState = 0;
    private int serverPort;
    private int rxBufSize;
    private String serverHost = null;
    private HelperThread helperThread;
    private Hashtable linkTable;
    private Hashtable connTable;
    private Vector tmpList;
    private int nextConnId = 0;
    private long lastCheck = 0L;
    protected ServletContext servletContext;

    public ServerLinkTable(ServletConfig servletConfig) throws Exception {
        this(servletConfig, false);
    }

    public ServerLinkTable(ServletConfig servletConfig, boolean bl) throws Exception {
        this.servletContext = servletConfig.getServletContext();
        this.linkTableState = 0;
        this.nextConnId = (int)System.currentTimeMillis();
        this.lastCheck = 0L;
        this.linkTable = new Hashtable();
        this.connTable = new Hashtable();
        this.tmpList = new Vector();
        this.rxBufSize = 0;
        String string = servletConfig.getInitParameter("rxBufSize");
        if (string != null) {
            try {
                this.rxBufSize = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.servletContext.log("Exception in HttpTunnelServlet : " + exception.getMessage());
            }
        }
        int n = bl ? 7674 : 7675;
        String string2 = servletConfig.getInitParameter("serverPort");
        if (string2 != null) {
            try {
                this.serverPort = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                this.serverPort = n;
            }
        } else {
            this.serverPort = n;
        }
        this.serverHost = servletConfig.getInitParameter("serverHost");
        if (bl) {
            String string3 = servletConfig.getInitParameter("keystoreLocation");
            if (string3 == null || string3.equals("")) {
                throw new Exception("keystore location not specified");
            }
            String string4 = servletConfig.getInitParameter("keystorePassword");
            if (string4 == null || string4.equals("")) {
                throw new Exception("keystore password not specified");
            }
            this.helperThread = new HelperThread(this.serverPort, this.serverHost, this.rxBufSize, string3, string4, this);
        } else {
            this.helperThread = new HelperThread(this.serverPort, this.serverHost, this.rxBufSize, this);
        }
        this.helperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuttingDown() {
        Enumeration enumeration;
        Object object;
        this.helperThread.close();
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            this.linkTableState = 1;
        }
        cloneable = this.linkTable;
        synchronized (cloneable) {
            object = this.linkTable.keys();
            while (object.hasMoreElements()) {
                enumeration = (String)object.nextElement();
                ServerLink serverLink = (ServerLink)this.linkTable.get(enumeration);
                this.linkTable.remove(enumeration);
                serverLink.shutdown();
                serverLink.linkDown();
            }
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            for (int i = this.tmpList.size() - 1; i >= 0; --i) {
                enumeration = (ServerLink)this.tmpList.elementAt(i);
                ((Link)((Object)enumeration)).shutdown();
                ((ServerLink)((Object)enumeration)).linkDown();
            }
        }
        cloneable = this.connTable;
        synchronized (cloneable) {
            enumeration = this.connTable.keys();
            while (enumeration.hasMoreElements()) {
                Vector vector;
                ConnKey connKey = (ConnKey)enumeration.nextElement();
                object = (Connection)this.connTable.get(connKey);
                Vector vector2 = vector = ((Connection)object).getPullQ();
                synchronized (vector2) {
                    vector.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.linkTableState = 2;
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            this.linkTable.clear();
        }
        cloneable = this.connTable;
        synchronized (cloneable) {
            this.connTable.clear();
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            this.tmpList.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServer(Socket socket) {
        try {
            ServerLink serverLink = new ServerLink(socket, this);
            Vector vector = this.tmpList;
            synchronized (vector) {
                this.tmpList.addElement(serverLink);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerName(ServerLink serverLink) throws IllegalStateException {
        String string = serverLink.getServerName();
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            if (this.linkTableState >= 1) {
                throw new IllegalStateException("HttpTunnelServlet: in destory");
            }
            ServerLink serverLink2 = (ServerLink)this.linkTable.get(string);
            if (serverLink2 != null && !serverLink2.isDone()) {
                throw new IllegalStateException("HttpTunnelServlet: ServerName " + string + " conflict");
            }
            this.linkTable.put(string, serverLink);
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            int n = this.tmpList.indexOf(serverLink);
            if (n > -1) {
                this.tmpList.removeElementAt(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(int n, int n2, ServerLink serverLink) throws IllegalStateException {
        Connection connection = new Connection(serverLink);
        connection.setPullPeriod(n2);
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                throw new IllegalStateException("HttpTunnelServlet: in destory");
            }
            this.connTable.put(new ConnKey(serverLink.getServerName(), n), connection);
        }
    }

    private boolean sameServerName(String string, Connection connection) {
        String string2 = connection.getServerLink().getServerName();
        return string2 != null && string != null && string2.equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverDown(ServerLink serverLink) {
        Object object;
        Object object2;
        String string = serverLink.getServerName();
        if (string != null) {
            object2 = null;
            object = this.linkTable;
            synchronized (object) {
                object2 = (ServerLink)this.linkTable.get(string);
                if (object2 != serverLink) {
                    return;
                }
                this.linkTable.remove(string);
            }
        }
        serverLink.shutdown();
        object2 = this.connTable;
        synchronized (object2) {
            object = this.connTable.keys();
            while (object.hasMoreElements()) {
                ConnKey connKey = (ConnKey)object.nextElement();
                Connection connection = (Connection)this.connTable.get(connKey);
                if (connection.getServerLink() != serverLink) continue;
                int n = connKey.getConnId();
                Vector vector = connection.getPullQ();
                this.abortClientConnection(n, vector);
            }
        }
    }

    private static HttpTunnelPacket genAbortPacket(int n) {
        HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
        httpTunnelPacket.setPacketType(9);
        httpTunnelPacket.setConnId(n);
        httpTunnelPacket.setSequence(0);
        httpTunnelPacket.setWinsize(0);
        httpTunnelPacket.setChecksum(0);
        httpTunnelPacket.setPacketBody(null);
        return httpTunnelPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortClientConnection(int n, Vector vector) {
        HttpTunnelPacket httpTunnelPacket = ServerLinkTable.genAbortPacket(n);
        Vector vector2 = vector;
        synchronized (vector2) {
            vector.addElement(httpTunnelPacket);
            vector.notify();
        }
    }

    private void abortServerConnection(int n, Connection connection) {
        HttpTunnelPacket httpTunnelPacket = ServerLinkTable.genAbortPacket(n);
        connection.getServerLink().sendPacket(httpTunnelPacket);
    }

    public String getDefaultServer() {
        String string = null;
        try {
            ServerLink serverLink = (ServerLink)this.linkTable.elements().nextElement();
            if (serverLink != null) {
                string = serverLink.getServerName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getListenState(String string) {
        if (string == null) {
            return false;
        }
        ServerLink serverLink = null;
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                return false;
            }
            serverLink = (ServerLink)this.linkTable.get(string);
            if (serverLink == null) {
                return false;
            }
        }
        return serverLink.getListenState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNewConn(String string) {
        if (string == null) {
            return -1;
        }
        ServerLink serverLink = null;
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                return -1;
            }
            serverLink = (ServerLink)this.linkTable.get(string);
            if (serverLink == null) {
                return -1;
            }
        }
        hashtable = this.connTable;
        synchronized (hashtable) {
            int n = this.nextConnId++;
            ConnKey connKey = new ConnKey(serverLink.getServerName(), n);
            this.connTable.put(connKey, new Connection(serverLink));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConn(int n, String string) {
        if (string == null) {
            return;
        }
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            this.connTable.remove(new ConnKey(string, n));
        }
    }

    public void sendPacket(HttpTunnelPacket httpTunnelPacket, String string) {
        if (string == null) {
            return;
        }
        ConnKey connKey = new ConnKey(string, httpTunnelPacket.getConnId());
        Connection connection = (Connection)this.connTable.get(connKey);
        if (connection == null) {
            return;
        }
        if (!this.sameServerName(string, connection)) {
            return;
        }
        if (httpTunnelPacket.getPacketType() == 10) {
            this.interceptConnOption(connection, httpTunnelPacket);
        }
        connection.getServerLink().sendPacket(httpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePacket(HttpTunnelPacket httpTunnelPacket, ServerLink serverLink) {
        Vector vector = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            ConnKey connKey = new ConnKey(serverLink.getServerName(), httpTunnelPacket.getConnId());
            Connection connection = (Connection)this.connTable.get(connKey);
            if (connection == null) {
                return;
            }
            vector = connection.getPullQ();
        }
        cloneable = vector;
        synchronized (cloneable) {
            vector.addElement(httpTunnelPacket);
            vector.notify();
        }
    }

    private void interceptConnOption(Connection connection, HttpTunnelPacket httpTunnelPacket) {
        byte[] byArray = httpTunnelPacket.getPacketBody();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n = dataInputStream.readInt();
            switch (n) {
                case 1: {
                    int n2 = dataInputStream.readInt();
                    connection.setPullPeriod(n2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTunnelPacket waitForPacket(String string, String string2) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 == null) {
            return ServerLinkTable.genAbortPacket(n);
        }
        ConnKey connKey = new ConnKey(string2, n);
        Connection connection = null;
        Object object = this.connTable;
        synchronized (object) {
            connection = (Connection)this.connTable.get(connKey);
        }
        if (connection == null) {
            if (this.linkTable.get(string2) != null) {
                return ServerLinkTable.genAbortPacket(n);
            }
            return null;
        }
        if (!this.sameServerName(string2, connection)) {
            return ServerLinkTable.genAbortPacket(n);
        }
        connection.setInUse(true);
        object = this.waitForPacket(connKey, connection);
        connection.setInUse(false);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpTunnelPacket waitForPacket(ConnKey connKey, Connection connection) {
        Vector vector = connection.getPullQ();
        int n = connection.getPullPeriod();
        HttpTunnelPacket httpTunnelPacket = null;
        boolean bl = false;
        Cloneable cloneable = vector;
        synchronized (cloneable) {
            if (n > 0 && vector.isEmpty()) {
                return null;
            }
            long l = System.currentTimeMillis();
            long l2 = 60000L;
            while (vector.isEmpty() && this.linkTableState == 0) {
                try {
                    vector.wait(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((l2 -= System.currentTimeMillis() - l) > 0L) continue;
                return null;
            }
            if (vector.isEmpty()) {
                return null;
            }
            httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(0);
            vector.removeElementAt(0);
            switch (httpTunnelPacket.getPacketType()) {
                case 9: {
                    bl = true;
                    vector.insertElementAt(httpTunnelPacket, 0);
                    vector.notifyAll();
                    break;
                }
                case 7: {
                    bl = true;
                    vector.insertElementAt(httpTunnelPacket, 0);
                    vector.notifyAll();
                    httpTunnelPacket = null;
                    break;
                }
                case 10: {
                    this.interceptConnOption(connection, httpTunnelPacket);
                }
            }
        }
        if (bl) {
            cloneable = this.connTable;
            synchronized (cloneable) {
                this.connTable.remove(connKey);
            }
        }
        return httpTunnelPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector waitForPackets(String string, String string2) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 == null) {
            Vector<HttpTunnelPacket> vector = new Vector<HttpTunnelPacket>();
            vector.addElement(ServerLinkTable.genAbortPacket(n));
            return vector;
        }
        ConnKey connKey = new ConnKey(string2, n);
        Connection connection = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            connection = (Connection)this.connTable.get(connKey);
        }
        if (connection == null) {
            if (this.linkTable.get(string2) != null) {
                cloneable = new Vector();
                ((Vector)cloneable).addElement(ServerLinkTable.genAbortPacket(n));
                return cloneable;
            }
            return null;
        }
        if (!this.sameServerName(string2, connection)) {
            cloneable = new Vector();
            ((Vector)cloneable).addElement(ServerLinkTable.genAbortPacket(n));
            return cloneable;
        }
        connection.setInUse(true);
        cloneable = this.waitForPackets(connKey, connection);
        connection.setInUse(false);
        return cloneable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector waitForPackets(ConnKey connKey, Connection connection) {
        Vector vector = connection.getPullQ();
        int n = connection.getPullPeriod();
        Vector<HttpTunnelPacket> vector2 = new Vector<HttpTunnelPacket>();
        boolean bl = false;
        Cloneable cloneable = vector;
        synchronized (cloneable) {
            if (n > 0 && vector.isEmpty()) {
                return null;
            }
            long l = System.currentTimeMillis();
            long l2 = 60000L;
            while (vector.isEmpty() && this.linkTableState == 0) {
                try {
                    vector.wait(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((l2 -= System.currentTimeMillis() - l) > 0L) continue;
                return null;
            }
            if (vector.isEmpty()) {
                return vector2;
            }
            int n2 = 0;
            while (this.linkTableState == 0) {
                HttpTunnelPacket httpTunnelPacket = (HttpTunnelPacket)vector.elementAt(0);
                switch (httpTunnelPacket.getPacketType()) {
                    case 9: {
                        bl = true;
                        vector.notifyAll();
                        vector2.addElement(httpTunnelPacket);
                        break;
                    }
                    case 7: {
                        bl = true;
                        vector.notifyAll();
                        break;
                    }
                    case 10: {
                        this.interceptConnOption(connection, httpTunnelPacket);
                    }
                }
                if (bl || n2 > 0 && n2 + httpTunnelPacket.getPacketSize() > 8192) break;
                vector2.addElement(httpTunnelPacket);
                n2 += httpTunnelPacket.getPacketSize();
                vector.removeElementAt(0);
                if (httpTunnelPacket.getPacketType() != 2 && !vector.isEmpty()) continue;
            }
        }
        if (bl) {
            cloneable = this.connTable;
            synchronized (cloneable) {
                this.connTable.remove(connKey);
            }
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrySendPacket(HttpTunnelPacket httpTunnelPacket, String string, String string2) {
        ConnKey connKey;
        if (string2 == null) {
            return;
        }
        Vector vector = null;
        try {
            connKey = new ConnKey(string2, string);
        }
        catch (Exception exception) {
            return;
        }
        Connection connection = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            connection = (Connection)this.connTable.get(connKey);
        }
        if (connection == null) {
            return;
        }
        if (!this.sameServerName(string2, connection)) {
            return;
        }
        vector = connection.getPullQ();
        cloneable = vector;
        synchronized (cloneable) {
            vector.insertElementAt(httpTunnelPacket, 0);
            vector.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrySendPackets(Vector vector, String string, String string2) {
        ConnKey connKey;
        if (string2 == null) {
            return;
        }
        Vector vector2 = null;
        try {
            connKey = new ConnKey(string2, string);
        }
        catch (Exception exception) {
            return;
        }
        Connection connection = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            connection = (Connection)this.connTable.get(connKey);
        }
        if (connection == null) {
            return;
        }
        if (!this.sameServerName(string2, connection)) {
            return;
        }
        vector2 = connection.getPullQ();
        cloneable = vector2;
        synchronized (cloneable) {
            for (int i = 0; i < vector.size(); ++i) {
                vector2.insertElementAt(vector.elementAt(i), i);
            }
            vector2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionTimeouts() {
        Object object;
        Object object2;
        Object object3;
        long l = System.currentTimeMillis();
        if (this.lastCheck != 0L && l - this.lastCheck < 5000L) {
            return;
        }
        this.lastCheck = l;
        Vector<ConnKey> vector = new Vector<ConnKey>();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            object3 = this.connTable.keys();
            while (object3.hasMoreElements()) {
                object2 = (ConnKey)object3.nextElement();
                object = (Connection)this.connTable.get(object2);
                if (!((Connection)object).checkConnectionTimeout(l)) continue;
                vector.addElement((ConnKey)object2);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            object3 = (ConnKey)vector.elementAt(i);
            object2 = null;
            object = this.connTable;
            synchronized (object) {
                object2 = (Connection)this.connTable.get(object3);
            }
            int n = ((ConnKey)object3).getConnId();
            this.abortServerConnection(n, (Connection)object2);
            Hashtable hashtable2 = this.connTable;
            synchronized (hashtable2) {
                this.connTable.remove(vector.elementAt(i));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getServerList() {
        Vector vector = new Vector();
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.linkTable.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public int getServerPort() {
        return this.serverPort;
    }
}

