/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.servlet;

import com.sun.messaging.jmq.transport.httptunnel.servlet.HttpTunnelServlet;
import com.sun.messaging.jmq.transport.httptunnel.servlet.ServerLinkTable;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpsTunnelServlet
extends HttpTunnelServlet {
    public void init() throws ServletException {
        this.servletContext = this.getServletContext();
        this.startTime = new Date();
        this.servletName = "HttpsTunnelServlet";
        try {
            this.linkTable = new ServerLinkTable(this.getServletConfig(), true);
            this.inService = true;
        }
        catch (Exception exception) {
            this.initException = exception;
            this.servletContext.log(this.servletName + ": initialization failed, " + exception);
        }
    }

    public void handleTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setContentType("text/html");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<HEAD>");
            printWriter.println("<TITLE> JMQ HTTPS Tunneling Servlet </TITLE>");
            printWriter.println("</HEAD>");
            printWriter.println("<BODY>");
            if (this.inService) {
                printWriter.println("HTTPS tunneling servlet ready.<BR>");
                printWriter.println("Servlet Start Time : " + this.startTime + " <BR>");
                printWriter.println("Accepting secured connections from brokers on port : " + this.linkTable.getServerPort() + " <P>");
                Vector vector = this.linkTable.getServerList();
                printWriter.println("Total available brokers = " + vector.size() + "<BR>");
                printWriter.println("Broker List : <BR>");
                printWriter.println("<BLOCKQUOTE><PRE>");
                for (int i = 0; i < vector.size(); ++i) {
                    printWriter.println((String)vector.elementAt(i));
                }
                printWriter.println("</PRE></BLOCKQUOTE>");
            } else {
                printWriter.println(new Date() + "<br>");
                printWriter.println("HTTPS Tunneling servlet cannot be started.<br>");
                if (this.initException != null) {
                    printWriter.println("    " + this.initException);
                }
            }
            printWriter.println("</BODY>");
            printWriter.println("</HTML>");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

