/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.MultiColumnPrinter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebugPrinter
extends MultiColumnPrinter {
    private Hashtable hashtable = null;
    private Vector vector = null;
    private String filename = null;
    private File f;
    private FileOutputStream fos;
    private PrintStream ps = System.out;
    private boolean useFile = false;

    public DebugPrinter(int n) {
        this((Hashtable)null, n);
    }

    public DebugPrinter(Hashtable hashtable, int n) {
        this(hashtable, n, null);
    }

    public DebugPrinter(Vector vector, int n) {
        this(vector, n, null);
    }

    public DebugPrinter(Vector vector, int n, String string) {
        super(2, n, "-");
        this.filename = string;
        this.vector = vector;
        this.initOutput();
        this.setupTitle();
        this.setupData();
    }

    public DebugPrinter(Hashtable hashtable, int n, String string) {
        super(2, n, "-");
        this.filename = string;
        this.hashtable = hashtable;
        this.initOutput();
        this.setupTitle();
        this.setupData();
    }

    public void setHashtable(Hashtable hashtable) {
        this.hashtable = hashtable;
        this.clear();
        this.setupData();
    }

    public void setFile(String string) {
        this.filename = string;
        this.closeOutput();
        this.initOutput();
    }

    public void doPrint(String string) {
        this.ps.print(string);
    }

    public void doPrintln(String string) {
        this.ps.println(string);
    }

    public boolean printObject(Object object, int n) {
        if (object instanceof String) {
            this.doPrint((String)object);
            return true;
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            String[] stringArray = new String[2];
            Object[] objectArray = new Object[2];
            String string = object.getClass().getName();
            this.doPrintln(string);
            DebugPrinter debugPrinter = new DebugPrinter(hashtable, 4, this.filename);
            debugPrinter.setIndent(n);
            debugPrinter.print();
            return false;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (vector.isEmpty()) {
                String string = "Empty    (" + object.getClass().getName() + ")";
                this.doPrint(string);
                return true;
            }
            String[] stringArray = new String[2];
            Object[] objectArray = new Object[2];
            String string = object.getClass().getName();
            this.doPrintln(string);
            DebugPrinter debugPrinter = new DebugPrinter(vector, 4, this.filename);
            debugPrinter.setIndent(n);
            debugPrinter.print();
            return false;
        }
        if (object instanceof Boolean || object instanceof Integer || object instanceof Long) {
            String string = object.toString() + "    (" + object.getClass().getName() + ")";
            this.doPrint(string);
            return true;
        }
        String string = object.getClass().getName();
        this.doPrint(string);
        this.doPrintln("");
        this.printSpaces(n);
        string = object.toString();
        this.doPrint(string);
        return true;
    }

    private void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            this.doPrint(" ");
        }
    }

    private void setupTitle() {
        String[] stringArray = new String[2];
        if (this.vector != null) {
            stringArray[0] = "index";
            stringArray[1] = "Value";
            this.addTitle(stringArray);
            return;
        }
        stringArray[0] = "Property Name";
        stringArray[1] = "Property Value";
        this.addTitle(stringArray);
    }

    private void setupData() {
        if (this.hashtable == null) {
            if (this.vector == null) {
                return;
            }
            this.setSortNeeded(false);
            Object[] objectArray = new Object[2];
            int n = 0;
            Enumeration enumeration = this.vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                objectArray[0] = String.valueOf(++n);
                objectArray[1] = e;
                this.add(objectArray);
            }
            return;
        }
        this.setSortNeeded(true);
        Object[] objectArray = new Object[2];
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            objectArray[0] = string;
            Object v = this.hashtable.get(string);
            objectArray[1] = v;
            this.add(objectArray);
        }
    }

    private void initOutput() {
        if (this.filename != null) {
            try {
                this.f = new File(this.filename);
                this.fos = new FileOutputStream(this.f, true);
                this.ps = new PrintStream(this.fos);
            }
            catch (Exception exception) {
                System.err.println("Exception caught when setting output to file: " + this.filename + ": " + exception.toString());
                System.err.println("Reverting to stdout");
            }
        }
    }

    private void closeOutput() {
        if (this.filename != null) {
            try {
                if (this.ps != null && this.ps != System.out) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.fos != null) {
                    this.fos.close();
                    this.fos = null;
                }
                this.f = null;
            }
            catch (Exception exception) {
                System.err.println("Exception caught when closing print streams to: " + this.filename + ": " + exception.toString());
            }
        }
    }

    public void close() {
        this.closeOutput();
    }
}

