/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.PacketProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class GPacket {
    public static final int A_BIT = 1;
    public static final int B_BIT = 2;
    public static final int C_BIT = 4;
    public static final int D_BIT = 8;
    public static final int E_BIT = 16;
    public static final int F_BIT = 32;
    public static final int G_BIT = 64;
    public static final int H_BIT = 128;
    public static final int I_BIT = 256;
    public static final int J_BIT = 512;
    public static final int K_BIT = 1024;
    public static final int L_BIT = 2048;
    public static final int M_BIT = 4096;
    public static final int N_BIT = 8192;
    public static final int O_BIT = 16384;
    public static final int P_BIT = 32768;
    public static final int Q_BIT = 65536;
    public static final int R_BIT = 131072;
    public static final int S_BIT = 262144;
    public static final int T_BIT = 524288;
    public static final int U_BIT = 0x100000;
    public static final int V_BIT = 0x200000;
    public static final int W_BIT = 0x400000;
    public static final int X_BIT = 0x800000;
    public static final int Y_BIT = 0x1000000;
    public static final int Z_BIT = 0x2000000;
    public static final int a_BIT = 0x4000000;
    public static final int b_BIT = 0x8000000;
    public static final int c_BIT = 0x10000000;
    public static final int d_BIT = 0x20000000;
    public static final int e_BIT = 0x40000000;
    public static final int f_BIT = Integer.MIN_VALUE;
    public static final int VERSION350 = 350;
    public static final int VERSION = 350;
    public static final int MAGIC = 2147476418;
    public static final int HEADER_SIZE = 36;
    private static boolean genTimestamp = true;
    private static boolean genSequenceNumber = true;
    protected static long sequenceCounter = 0L;
    protected short version = (short)350;
    protected short type = 0;
    protected int size = 0;
    protected int propsByteSize = 0;
    protected int magic = 2147476418;
    protected long sequence = 0L;
    protected long timestamp = 0L;
    protected int bitFlags = 0;
    protected ByteBuffer propsBuf = null;
    protected Map props = null;
    protected boolean propsDirty = false;
    protected boolean versionMismatch = false;
    protected ByteBuffer headerBuf = ByteBuffer.allocate(36);
    protected boolean headerDirty = false;
    protected ByteBuffer payload = null;

    public static GPacket getInstance() {
        return new GPacket();
    }

    private GPacket() {
    }

    private void unmarshallHeader() throws StreamCorruptedException, IOException {
        this.headerBuf.rewind();
        this.version = this.headerBuf.getShort();
        this.type = this.headerBuf.getShort();
        this.size = this.headerBuf.getInt();
        this.magic = this.headerBuf.getInt();
        this.versionMismatch = this.version != 350;
        if (this.magic != 2147476418) {
            throw new StreamCorruptedException("Bad packet magic number: " + this.magic + ". Expecting: " + 2147476418);
        }
        this.propsByteSize = this.headerBuf.getInt();
        this.timestamp = this.headerBuf.getLong();
        this.sequence = this.headerBuf.getLong();
        this.bitFlags = this.headerBuf.getInt();
        this.headerBuf.rewind();
        this.headerDirty = false;
    }

    private void marshallHeader() throws IOException {
        if (this.propsDirty) {
            this.marshallProperties();
        }
        if (!this.headerDirty) {
            return;
        }
        this.size = this.headerBuf.capacity() + this.propsByteSize;
        if (this.payload != null) {
            this.size += this.payload.capacity();
        }
        this.headerBuf.rewind();
        this.headerBuf.putShort(this.version);
        this.headerBuf.putShort(this.type);
        this.headerBuf.putInt(this.size);
        this.headerBuf.putInt(this.magic);
        this.headerBuf.putInt(this.propsByteSize);
        this.headerBuf.putLong(this.timestamp);
        this.headerBuf.putLong(this.sequence);
        this.headerBuf.putInt(this.bitFlags);
        this.headerBuf.rewind();
        this.headerDirty = false;
    }

    private void unmarshallProperties() throws IOException, ClassNotFoundException {
        if (this.propsByteSize > 0) {
            this.props = PacketProperties.parseProperties(new JMQByteBufferInputStream(this.propsBuf));
            this.propsBuf.rewind();
        } else {
            this.props = new Hashtable();
        }
        this.propsDirty = false;
    }

    private void marshallProperties() throws IOException {
        if (!this.propsDirty) {
            return;
        }
        JMQByteArrayOutputStream jMQByteArrayOutputStream = new JMQByteArrayOutputStream(new byte[256]);
        PacketProperties.write(this.props, jMQByteArrayOutputStream);
        this.propsBuf = ByteBuffer.wrap(jMQByteArrayOutputStream.getBuf(), 0, jMQByteArrayOutputStream.getCount());
        this.propsBuf.rewind();
        this.propsByteSize = jMQByteArrayOutputStream.getCount();
        this.propsDirty = false;
        this.headerDirty = true;
    }

    public synchronized void setPayload(ByteBuffer byteBuffer) {
        this.payload = byteBuffer == null ? null : byteBuffer.slice();
        this.headerDirty = true;
    }

    public synchronized ByteBuffer getPayload() {
        if (this.payload == null) {
            return null;
        }
        return this.payload.slice();
    }

    public synchronized void setVersion(short s) {
        this.version = s;
        this.headerDirty = true;
    }

    public synchronized short getVersion() {
        return this.version;
    }

    public synchronized void setType(short s) {
        this.type = s;
        this.headerDirty = true;
    }

    public synchronized short getType() {
        return this.type;
    }

    public synchronized void setTimestamp(long l) {
        this.timestamp = l;
        this.headerDirty = true;
    }

    public synchronized long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void setSequence(long l) {
        this.sequence = l;
        this.headerDirty = true;
    }

    public synchronized long getSequence() {
        return this.sequence;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized int getPropsByteSize() throws IOException {
        this.getProperties();
        if (this.propsDirty) {
            this.marshallProperties();
        }
        return this.propsByteSize;
    }

    public synchronized int getPayloadSize() {
        if (this.payload == null) {
            return 0;
        }
        return this.payload.capacity();
    }

    public synchronized int getMagic() {
        return this.magic;
    }

    public synchronized void clearProps() {
        this.getProperties();
        this.propsDirty = true;
        this.props.clear();
    }

    public synchronized Object getProp(Object object) {
        this.getProperties();
        return this.props.get(object);
    }

    public synchronized void putProp(Object object, Object object2) {
        this.getProperties();
        this.propsDirty = true;
        this.props.put(object, object2);
    }

    public synchronized void putAllProps(Map map) {
        this.getProperties();
        this.propsDirty = true;
        this.props.putAll(map);
    }

    public synchronized Object removeProp(Object object) {
        this.propsDirty = true;
        this.getProperties();
        this.propsDirty = true;
        return this.props.remove(object);
    }

    public synchronized boolean isEmptyProps() {
        if (this.props == null && this.propsByteSize == 0) {
            return true;
        }
        this.getProperties();
        return this.props.isEmpty();
    }

    public synchronized int propsSize() {
        if (this.props == null && this.propsByteSize == 0) {
            return 0;
        }
        this.getProperties();
        return this.props.size();
    }

    public synchronized Set propsKeySet() {
        this.getProperties();
        return this.props.keySet();
    }

    public synchronized Set propsEntrySet() {
        this.getProperties();
        return this.props.entrySet();
    }

    public synchronized void setBit(int n, boolean bl) {
        this.bitFlags = bl ? (this.bitFlags |= n) : (this.bitFlags &= ~n);
        this.headerDirty = true;
    }

    public synchronized boolean getBit(int n) {
        return (this.bitFlags & n) == n;
    }

    public void generateSequenceNumber(boolean bl) {
        genSequenceNumber = bl;
    }

    public void generateTimestamp(boolean bl) {
        genTimestamp = bl;
    }

    public synchronized void updateTimestamp() {
        this.setTimestamp(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateSequenceNumber() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.setSequence(++sequenceCounter);
        }
    }

    public synchronized void read(InputStream inputStream) throws IOException, EOFException, StreamCorruptedException, IllegalArgumentException {
        this.headerBuf.rewind();
        GPacket.readFully(inputStream, this.headerBuf);
        this.headerBuf.rewind();
        this.unmarshallHeader();
        this.props = null;
        this.payload = null;
        if (this.propsByteSize > 0) {
            if (this.propsBuf != null && this.propsBuf.capacity() >= this.propsByteSize) {
                this.propsBuf.clear();
                this.propsBuf.limit(this.propsByteSize);
            } else {
                this.propsBuf = ByteBuffer.allocate(this.propsByteSize);
            }
            GPacket.readFully(inputStream, this.propsBuf);
            this.propsBuf.rewind();
        } else {
            this.propsBuf = null;
        }
        int n = this.size - this.propsByteSize - 36;
        if (n > 0) {
            this.payload = ByteBuffer.allocate(n);
            GPacket.readFully(inputStream, this.payload);
        } else {
            this.payload = null;
        }
        if (this.versionMismatch) {
            throw new IllegalArgumentException("Bad packet version number: " + this.version + ". Expecting: " + 350);
        }
    }

    public synchronized void write(OutputStream outputStream) throws IOException {
        if (genSequenceNumber) {
            this.updateSequenceNumber();
        }
        if (genTimestamp) {
            this.updateTimestamp();
        }
        this.marshallHeader();
        this.headerBuf.rewind();
        GPacket.writeFully(outputStream, this.headerBuf);
        this.headerBuf.rewind();
        if (this.propsByteSize > 0) {
            this.propsBuf.rewind();
            GPacket.writeFully(outputStream, this.propsBuf);
            this.propsBuf.rewind();
        }
        if (this.payload != null) {
            this.payload.rewind();
            GPacket.writeFully(outputStream, this.payload);
            this.payload.rewind();
        }
        outputStream.flush();
    }

    private Map getProperties() {
        if (this.props == null) {
            try {
                this.unmarshallProperties();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't unmarshall pkt", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Can't unmarshall pkt", classNotFoundException);
            }
        }
        return this.props;
    }

    private static void writeFully(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.remaining();
        outputStream.write(byArray, n, n2);
    }

    private static void readFully(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.remaining();
        GPacket.readFully(inputStream, byArray, n, n2, true);
    }

    private static void readFully(InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) throws IOException, EOFException, InterruptedIOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            try {
                n3 = inputStream.read(byArray, n + i, n2 - i);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!bl && i == 0 && n3 == 0 && interruptedIOException.bytesTransferred == 0) {
                    throw new InterruptedIOException("no data available");
                }
                n3 = interruptedIOException.bytesTransferred;
                Thread.currentThread();
                Thread.yield();
            }
            if (n3 >= 0) continue;
            throw new EOFException("Trying to read " + (n2 - i) + " bytes. Already read " + i + " bytes.");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GPacket)) {
            return false;
        }
        GPacket gPacket = (GPacket)object;
        try {
            this.marshallHeader();
            gPacket.marshallHeader();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't marshall pkt", iOException);
        }
        if (this.timestamp != gPacket.timestamp || this.sequence != gPacket.sequence || this.size != gPacket.size || this.type != gPacket.type || this.bitFlags != gPacket.bitFlags || this.propsByteSize != gPacket.propsByteSize || this.version != gPacket.version || this.magic != gPacket.magic) {
            return false;
        }
        return this.propsByteSize <= 0 || this.propsBuf.equals(gPacket.propsBuf);
    }

    public String toString() {
        this.getProperties();
        try {
            this.marshallHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = this.type + ": v=" + this.version + ",sz=" + this.size + ",mg=" + this.magic + ",ts=" + this.timestamp + ",sq=" + this.sequence + ",prop_sz=" + this.propsByteSize + ",pay_sz=" + (this.size - this.propsByteSize - 36);
        return string;
    }

    public String toLongString() {
        this.getProperties();
        try {
            this.marshallHeader();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = "    Packet: " + this.type + "\n" + "   Version: " + this.version + "\t\t        Size: " + this.size + "\tMagic: " + this.magic + "\n" + " Timestamp: " + this.timestamp + "\tSequence: " + this.sequence + "\t Bits: " + this.bitsToString() + "\n" + " Prop Size: " + this.propsByteSize + ": " + (this.props == null ? "null" : this.props.toString()) + "\n" + "Payload Size: " + (this.size - this.propsByteSize - 36);
        return string;
    }

    protected String bitsToString() {
        String string = (this.getBit(1) ? "A" : "") + (this.getBit(2) ? "B" : "") + (this.getBit(4) ? "C" : "") + (this.getBit(8) ? "D" : "") + (this.getBit(16) ? "E" : "") + (this.getBit(32) ? "F" : "") + (this.getBit(64) ? "G" : "") + (this.getBit(128) ? "H" : "") + (this.getBit(256) ? "I" : "") + (this.getBit(512) ? "J" : "") + (this.getBit(1024) ? "K" : "") + (this.getBit(2048) ? "L" : "") + (this.getBit(4096) ? "M" : "") + (this.getBit(8192) ? "N" : "") + (this.getBit(16384) ? "O" : "") + (this.getBit(32768) ? "P" : "") + (this.getBit(65536) ? "Q" : "") + (this.getBit(131072) ? "R" : "") + (this.getBit(262144) ? "S" : "") + (this.getBit(524288) ? "T" : "") + (this.getBit(0x100000) ? "U" : "") + (this.getBit(0x200000) ? "V" : "") + (this.getBit(0x400000) ? "W" : "") + (this.getBit(0x800000) ? "X" : "") + (this.getBit(0x1000000) ? "Y" : "") + (this.getBit(0x2000000) ? "Z" : "") + (this.getBit(0x4000000) ? "a" : "") + (this.getBit(0x8000000) ? "b" : "") + (this.getBit(0x10000000) ? "c" : "") + (this.getBit(0x20000000) ? "d" : "") + (this.getBit(0x40000000) ? "e" : "") + (this.getBit(Integer.MIN_VALUE) ? "f" : "");
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            GPacket gPacket = GPacket.getInstance();
            GPacket gPacket2 = GPacket.getInstance();
            gPacket.putProp("name", "joe");
            gPacket.putProp("seq", new Integer(1));
            gPacket.setType((short)100);
            gPacket.setBit(1, true);
            gPacket.setBit(0x2000000, true);
            gPacket.setBit(0x4000000, true);
            gPacket.setBit(Integer.MIN_VALUE, true);
            ByteBuffer byteBuffer = ByteBuffer.allocate(128);
            byteBuffer.putChar('j');
            byteBuffer.putChar('o');
            byteBuffer.putChar('e');
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.rewind();
            gPacket.setPayload(byteBuffer);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            gPacket.write(byteArrayOutputStream);
            System.out.println("Out:\n" + gPacket.toLongString());
            gPacket2.putProp("seq", new Integer(2));
            gPacket2.setType((short)104);
            gPacket2.setBit(Integer.MIN_VALUE, true);
            gPacket2.write(byteArrayOutputStream);
            System.out.println("Out:\n" + gPacket2.toLongString());
            GPacket gPacket3 = GPacket.getInstance();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            gPacket3.read(byteArrayInputStream);
            System.out.println(" In:\n" + gPacket3.toLongString());
            if (!gPacket.equals(gPacket3)) {
                throw new Exception("Packet '" + gPacket + "' != " + "Packet '" + gPacket3 + "'");
            }
            gPacket3.read(byteArrayInputStream);
            System.out.println(" In:\n" + gPacket3.toLongString());
            if (!gPacket2.equals(gPacket3)) {
                throw new Exception("Packet '" + gPacket2 + "' != " + "Packet '" + gPacket3 + "'");
            }
        }
        catch (Exception exception) {
            System.out.println("FAILED!");
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("PASSED");
        System.exit(1);
    }
}

