/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jms.MessageEOFException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Traceable {
    private byte[] messageBody = null;
    private JMQByteArrayOutputStream byteArrayOutputStream = null;
    private DataOutputStream dataOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private DataInputStream dataInputStream = null;
    private boolean bufferIsDirty = false;
    private int validCount = 0;

    protected BytesMessageImpl() throws JMSException {
        this.setPacketType(2);
    }

    protected BytesMessageImpl(boolean bl) throws JMSException {
        this();
        if (bl) {
            this.initOutputStream();
        }
    }

    protected void initOutputStream() {
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
        this.validCount = 0;
    }

    protected void setMessageBodyToPacket() throws JMSException {
        this.reset();
        this.pkt.setMessageBody(this.messageBody, 0, this.validCount);
    }

    protected void getMessageBodyFromPacket() throws JMSException {
        this.messageBody = this.getMessageBody();
        this.validCount = this.messageBody == null ? 0 : this.messageBody.length;
        this.reset();
    }

    protected void setBufferIsDirty(boolean bl) {
        this.bufferIsDirty = bl;
    }

    protected boolean getBufferIsDirty() {
        return this.bufferIsDirty;
    }

    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageBody(null);
        this.initOutputStream();
        this.setMessageReadMode(false);
    }

    public long getBodyLength() throws JMSException {
        this.checkReadAccess();
        if (this.messageBody == null) {
            return 0L;
        }
        return this.validCount;
    }

    public boolean readBoolean() throws JMSException {
        boolean bl = false;
        this.checkReadAccess();
        try {
            bl = this.dataInputStream.readBoolean();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4010", true);
        }
        return bl;
    }

    public byte readByte() throws JMSException {
        byte by = 0;
        this.checkReadAccess();
        try {
            by = this.dataInputStream.readByte();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return by;
    }

    public int readUnsignedByte() throws JMSException {
        int n = 0;
        this.checkReadAccess();
        try {
            n = this.dataInputStream.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return n;
    }

    public short readShort() throws JMSException {
        short s = 0;
        this.checkReadAccess();
        try {
            s = this.dataInputStream.readShort();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return s;
    }

    public int readUnsignedShort() throws JMSException {
        int n = 0;
        this.checkReadAccess();
        try {
            n = this.dataInputStream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return n;
    }

    public char readChar() throws JMSException {
        char c = '\u0000';
        this.checkReadAccess();
        try {
            c = this.dataInputStream.readChar();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return c;
    }

    public int readInt() throws JMSException {
        int n = 0;
        this.checkReadAccess();
        try {
            n = this.dataInputStream.readInt();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return n;
    }

    public long readLong() throws JMSException {
        long l = 0L;
        this.checkReadAccess();
        try {
            l = this.dataInputStream.readLong();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return l;
    }

    public float readFloat() throws JMSException {
        float f = 0.0f;
        this.checkReadAccess();
        try {
            f = this.dataInputStream.readFloat();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return f;
    }

    public double readDouble() throws JMSException {
        double d = 0.0;
        this.checkReadAccess();
        try {
            d = this.dataInputStream.readDouble();
        }
        catch (EOFException eOFException) {
            String string = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return d;
    }

    public String readUTF() throws JMSException {
        String string = null;
        this.checkReadAccess();
        try {
            string = this.dataInputStream.readUTF();
        }
        catch (EOFException eOFException) {
            String string2 = ExceptionHandler.getExceptionMessage(eOFException, "C4013");
            MessageEOFException messageEOFException = new MessageEOFException(string2, "C4013");
            ExceptionHandler.handleException((Exception)eOFException, messageEOFException);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return string;
    }

    public int readBytes(byte[] byArray) throws JMSException {
        int n = -1;
        this.checkReadAccess();
        try {
            n = this.dataInputStream.read(byArray);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4010", true);
        }
        return n;
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        int n2 = -1;
        this.checkReadAccess();
        try {
            n2 = this.dataInputStream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException(iOException, "C4010", true);
        }
        return n2;
    }

    public void writeBoolean(boolean bl) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeBoolean(bl);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeByte(byte by) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeByte(by);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeShort(short s) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeShort(s);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeChar(char c) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeChar(c);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeInt(int n) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeInt(n);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeLong(long l) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeLong(l);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeFloat(float f) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeFloat(f);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeDouble(double d) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeDouble(d);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeUTF(String string) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeUTF(string);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.write(byArray);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.write(byArray, n, n2);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeObject(Object object) throws JMSException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else {
            String string = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(string, "C4017");
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                this.dataOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.getBuf();
                this.validCount = this.byteArrayOutputStream.getCount();
                this.dataOutputStream.close();
                this.byteArrayOutputStream.close();
            }
            if (this.messageBody == null) {
                this.messageBody = new byte[0];
                this.validCount = 0;
            }
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody, 0, this.validCount);
            this.dataInputStream = new DataInputStream(this.byteArrayInputStream);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4012", true);
        }
        this.setBufferIsDirty(false);
        this.setMessageReadMode(true);
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ ByteMessageImpl dump ------");
        super.dump(printStream);
    }

    public String toString() {
        return super.toString();
    }
}

