/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel.server;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDefaults;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelDriver;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.transport.httptunnel.Link;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;

public class HttpTunnelServerDriver
extends Link
implements HttpTunnelDefaults,
HttpTunnelDriver {
    protected Socket serverConn = null;
    protected Hashtable connTable = null;
    protected String serviceName;
    protected InetAddress webServerHost = null;
    protected int webServerPort = 0;
    protected int inactiveConnAbortInterval = 900000;
    protected int totalRetryWaited = 0;
    protected static boolean DEBUG = Boolean.getBoolean("httptunnel.debug");
    protected static boolean DEBUGLINK = Boolean.getBoolean("httptunnel.link.debug");
    private Vector listenQ = null;
    private boolean listenState = false;
    protected int rxBufSize = 0;

    public HttpTunnelServerDriver(String string) throws IOException {
        this(string, InetAddress.getLocalHost().getHostAddress(), 7675);
    }

    public HttpTunnelServerDriver(String string, String string2, int n) throws IOException {
        this.serviceName = string;
        this.webServerHost = InetAddress.getByName(string2);
        this.webServerPort = n;
        this.connTable = new Hashtable();
        this.listenQ = new Vector();
        this.setName("HttpTunnelServerDriver");
        this.start();
    }

    public void setRxBufSize(int n) {
        this.rxBufSize = n;
    }

    public Vector getListenQ() {
        return this.listenQ;
    }

    public void listen(boolean bl) throws IOException {
        boolean bl2 = this.listenState;
        this.listenState = bl;
        if (bl != bl2) {
            this.sendListenStatePacket();
        }
    }

    public int getInactiveConnAbortInterval() {
        return this.inactiveConnAbortInterval;
    }

    public void setInactiveConnAbortInterval(int n) {
        this.inactiveConnAbortInterval = n;
    }

    protected void createLink() {
        this.totalRetryWaited = 0;
        if (DEBUG) {
            System.out.println("http:connecting to " + this.webServerHost + ":" + this.webServerPort);
        }
        while (true) {
            try {
                this.serverConn = new Socket();
                if (this.rxBufSize > 0) {
                    this.serverConn.setReceiveBufferSize(this.rxBufSize);
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.webServerHost, this.webServerPort);
                this.serverConn.connect(inetSocketAddress);
                this.serverConn.setTcpNoDelay(true);
                if (DEBUG) {
                    System.out.println("######## rcvbuf = " + this.serverConn.getReceiveBufferSize());
                }
                this.is = this.serverConn.getInputStream();
                this.os = this.serverConn.getOutputStream();
                if (DEBUG || DEBUGLINK) {
                    System.out.println("Broker HTTP link up");
                }
                this.totalRetryWaited = 0;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(5000L);
                    this.totalRetryWaited += 5000;
                    if (this.totalRetryWaited < this.inactiveConnAbortInterval * 1000) continue;
                    if (DEBUG || DEBUGLINK) {
                        System.out.println("Retry connect to servlet timeout - cleanup all (" + this.connTable.size() + ") connections ...");
                    }
                    this.cleanupAllConns();
                    this.totalRetryWaited = 0;
                }
                catch (Exception exception2) {}
                continue;
            }
            break;
        }
        this.sendLinkInitPacket();
        this.sendListenStatePacket();
    }

    protected void sendListenStatePacket() {
        ByteArrayOutputStream byteArrayOutputStream;
        HttpTunnelPacket httpTunnelPacket;
        block2: {
            httpTunnelPacket = new HttpTunnelPacket();
            httpTunnelPacket.setPacketType(11);
            httpTunnelPacket.setConnId(0);
            httpTunnelPacket.setSequence(0);
            httpTunnelPacket.setWinsize(0);
            httpTunnelPacket.setChecksum(0);
            byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(this.serviceName);
                dataOutputStream.writeBoolean(this.listenState);
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                if (!DEBUG && !DEBUGLINK) break block2;
                System.out.println("Got exception while sending LISTEN_STATE_PACKET packet: " + exception.getMessage());
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        httpTunnelPacket.setPacketBody(byArray);
        this.sendPacket(httpTunnelPacket);
    }

    void sendLinkInitPacket() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        HttpTunnelPacket httpTunnelPacket;
        block3: {
            httpTunnelPacket = new HttpTunnelPacket();
            httpTunnelPacket.setPacketType(8);
            httpTunnelPacket.setConnId(0);
            httpTunnelPacket.setSequence(0);
            httpTunnelPacket.setWinsize(0);
            httpTunnelPacket.setChecksum(0);
            byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(this.serviceName);
                dataOutputStream.writeInt(this.connTable.size());
                object = this.connTable.elements();
                while (object.hasMoreElements()) {
                    HttpTunnelConnection httpTunnelConnection = (HttpTunnelConnection)object.nextElement();
                    dataOutputStream.writeInt(httpTunnelConnection.getConnId());
                    dataOutputStream.writeInt(httpTunnelConnection.getPullPeriod());
                }
                dataOutputStream.flush();
                byteArrayOutputStream.flush();
            }
            catch (Exception exception) {
                if (!DEBUG && !DEBUGLINK) break block3;
                System.out.println("Got exception while sending LINK_INIT_PACKET packet: " + exception.getMessage());
            }
        }
        object = byteArrayOutputStream.toByteArray();
        httpTunnelPacket.setPacketBody((byte[])object);
        this.sendPacket(httpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupAllConns() {
        Object object;
        Vector<String> vector = new Vector<String>();
        Object object2 = this.connTable;
        synchronized (object2) {
            object = this.connTable.keys();
            while (object.hasMoreElements()) {
                vector.addElement((String)object.nextElement());
            }
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            String string = (String)vector.elementAt(i);
            object2 = (HttpTunnelConnection)this.connTable.get(string);
            if (object2 == null) continue;
            object = HttpTunnelServerDriver.genAbortPacket(((HttpTunnelConnection)object2).getConnId());
            this.receivePacket((HttpTunnelPacket)object);
        }
        this.connTable.clear();
        vector = null;
    }

    protected void handleLinkDown() {
        if ((DEBUG || DEBUGLINK) && this.serverConn != null) {
            System.out.println("Broker HTTP link down");
        }
        try {
            this.serverConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverConn = null;
    }

    public boolean isLinkReady() {
        return this.serverConn != null;
    }

    protected void receivePacket(HttpTunnelPacket httpTunnelPacket) {
        int n = httpTunnelPacket.getPacketType();
        if (DEBUG) {
            System.out.println("Received Packet : " + httpTunnelPacket);
        }
        switch (n) {
            case 1: {
                this.handleNewConn(httpTunnelPacket);
                break;
            }
            case 5: {
                this.handleConnClose(httpTunnelPacket);
                break;
            }
            case 9: {
                this.handleConnAbort(httpTunnelPacket);
                break;
            }
            case 10: {
                this.handleConnOption(httpTunnelPacket);
                break;
            }
            case 4: 
            case 6: {
                this.handlePacket(httpTunnelPacket);
                break;
            }
            case 100: {
                this.handleDummyPacket(httpTunnelPacket);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewConn(HttpTunnelPacket httpTunnelPacket) {
        int n = httpTunnelPacket.getConnId();
        HttpTunnelConnection httpTunnelConnection = new HttpTunnelConnection(n, this);
        Object object = this.connTable;
        synchronized (object) {
            this.connTable.put(Integer.toString(n), httpTunnelConnection);
        }
        object = new HttpTunnelPacket();
        ((HttpTunnelPacket)object).setPacketType(2);
        ((HttpTunnelPacket)object).setPacketBody(null);
        ((HttpTunnelPacket)object).setConnId(n);
        ((HttpTunnelPacket)object).setSequence(0);
        ((HttpTunnelPacket)object).setWinsize(0);
        ((HttpTunnelPacket)object).setChecksum(0);
        this.sendPacket((HttpTunnelPacket)object);
        Vector vector = this.listenQ;
        synchronized (vector) {
            this.listenQ.addElement(httpTunnelConnection);
            this.listenQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnClose(HttpTunnelPacket httpTunnelPacket) {
        HttpTunnelConnection httpTunnelConnection;
        int n = httpTunnelPacket.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            httpTunnelConnection = (HttpTunnelConnection)this.connTable.get(Integer.toString(n));
        }
        if (httpTunnelConnection == null) {
            return;
        }
        httpTunnelConnection.handleClose(httpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnAbort(HttpTunnelPacket httpTunnelPacket) {
        HttpTunnelConnection httpTunnelConnection;
        int n = httpTunnelPacket.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            httpTunnelConnection = (HttpTunnelConnection)this.connTable.get(Integer.toString(n));
        }
        if (httpTunnelConnection == null) {
            return;
        }
        httpTunnelConnection.handleAbort(httpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnOption(HttpTunnelPacket httpTunnelPacket) {
        HttpTunnelConnection httpTunnelConnection;
        int n = httpTunnelPacket.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            httpTunnelConnection = (HttpTunnelConnection)this.connTable.get(Integer.toString(n));
        }
        if (httpTunnelConnection == null) {
            return;
        }
        httpTunnelConnection.handleConnOption(httpTunnelPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePacket(HttpTunnelPacket httpTunnelPacket) {
        HttpTunnelConnection httpTunnelConnection;
        int n = httpTunnelPacket.getConnId();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            httpTunnelConnection = (HttpTunnelConnection)this.connTable.get(Integer.toString(n));
        }
        if (httpTunnelConnection == null) {
            return;
        }
        httpTunnelConnection.receivePacket(httpTunnelPacket, false);
    }

    private void handleDummyPacket(HttpTunnelPacket httpTunnelPacket) {
        if (DEBUG) {
            System.out.println("#### Received dummy packet :");
            System.out.println(httpTunnelPacket + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(int n) {
        Object object = this.connTable;
        synchronized (object) {
            this.connTable.remove(Integer.toString(n));
        }
        object = new HttpTunnelPacket();
        ((HttpTunnelPacket)object).setPacketType(7);
        ((HttpTunnelPacket)object).setPacketBody(null);
        ((HttpTunnelPacket)object).setConnId(n);
        ((HttpTunnelPacket)object).setSequence(0);
        ((HttpTunnelPacket)object).setWinsize(0);
        ((HttpTunnelPacket)object).setChecksum(0);
        this.sendPacket((HttpTunnelPacket)object);
    }

    private static HttpTunnelPacket genAbortPacket(int n) {
        HttpTunnelPacket httpTunnelPacket = new HttpTunnelPacket();
        httpTunnelPacket.setPacketType(9);
        httpTunnelPacket.setConnId(n);
        httpTunnelPacket.setSequence(0);
        httpTunnelPacket.setWinsize(0);
        httpTunnelPacket.setChecksum(0);
        httpTunnelPacket.setPacketBody(null);
        return httpTunnelPacket;
    }

    public Hashtable getDebugState() {
        return new Hashtable();
    }
}

