/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.pool;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.pool.BasicRunnable;
import com.sun.messaging.jmq.jmsserver.util.pool.RunnableFactory;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Vector;

public class ThreadPool {
    public Object lock = new Object();
    public boolean destroyed = false;
    private boolean in_destroy = false;
    public static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    RunnableFactory runfac = null;
    LinkedHashSet availIndx = null;
    ArrayList current = null;
    LinkedList available = null;
    int nextThreadId = 0;
    protected ThreadGroup tgroup = null;
    protected int min;
    protected int max;
    protected String name = null;
    protected int current_count = 0;
    protected boolean notActive = true;
    protected int priority = 5;

    public boolean isValid() {
        return !this.destroyed && !this.in_destroy;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public synchronized void setMinimum(int n) throws IllegalArgumentException {
        this.setMinMax(n, this.max);
    }

    public synchronized void setMaximum(int n) throws IllegalArgumentException {
        this.setMinMax(this.min, n);
    }

    public synchronized Hashtable getDebugState() {
        Object object;
        Iterator iterator;
        Vector<Object> vector;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("min", new Integer(this.min));
        hashtable.put("max", new Integer(this.max));
        hashtable.put("name", new String(this.name));
        hashtable.put("current_count", new Integer(this.current_count));
        hashtable.put("nextThreadId", new Integer(this.nextThreadId));
        hashtable.put("notActive", new Boolean(this.notActive));
        hashtable.put("destroyed", new Boolean(this.destroyed));
        hashtable.put("in_destroy", new Boolean(this.in_destroy));
        hashtable.put("priority", new Integer(this.priority));
        if (this.current != null) {
            hashtable.put("currentCnt", new Integer(this.current.size()));
            vector = new Vector<Object>();
            iterator = this.current.iterator();
            while (iterator.hasNext()) {
                object = (BasicRunnable)iterator.next();
                if (object == null) {
                    vector.add("Runner is null");
                    continue;
                }
                vector.add(((BasicRunnable)object).getDebugState());
            }
            hashtable.put("current", vector);
        } else {
            hashtable.put("currentCnt", "null");
        }
        if (this.availIndx != null) {
            hashtable.put("availIndxCnt", new Integer(this.availIndx.size()));
            vector = new Vector();
            iterator = this.availIndx.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                vector.add(object);
            }
            hashtable.put("availIndx", vector);
        } else {
            hashtable.put("availIndxCnt", "null");
        }
        if (this.available != null) {
            hashtable.put("availableCnt", new Integer(this.available.size()));
            vector = new Vector();
            iterator = this.available.iterator();
            while (iterator.hasNext()) {
                object = (BasicRunnable)iterator.next();
                vector.add(((BasicRunnable)object).getDebugState());
            }
            hashtable.put("available", vector);
        } else {
            hashtable.put("availableCnt", "null");
        }
        return hashtable;
    }

    public synchronized void setMinMax(int n, int n2) throws IllegalArgumentException {
        BasicRunnable basicRunnable;
        int n3;
        if (this.in_destroy) {
            return;
        }
        if (n == -1) {
            n = this.min;
        }
        if (n2 == -1) {
            n2 = this.max;
        }
        if (n > n2) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getKString("B4110", String.valueOf(n), String.valueOf(n2)));
        }
        int n4 = this.current.size();
        for (n3 = n2; n3 < this.max && n3 < n4; ++n3) {
            basicRunnable = (BasicRunnable)this.current.get(n3);
            if (basicRunnable == null) continue;
            basicRunnable.setThreadBehavior(2);
        }
        for (n3 = n; n3 > this.min && n3 > 0 && n3 < n4; --n3) {
            basicRunnable = (BasicRunnable)this.current.get(n3);
            if (basicRunnable == null) continue;
            basicRunnable.setThreadBehavior(0);
        }
        for (n3 = n; n3 < this.max && n3 < n4; ++n3) {
            basicRunnable = (BasicRunnable)this.current.get(n3);
            if (basicRunnable == null) continue;
            basicRunnable.setThreadBehavior(1);
        }
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        for (int i = 0; i < n4; ++i) {
            Object e = this.current.get(i);
            if (e != null) continue;
            linkedHashSet.add(new Integer(i));
        }
        this.min = n;
        this.max = n2;
        this.availIndx = linkedHashSet;
    }

    public synchronized void debug() {
        String string = "\n--------------------------------------------\n DUMPING THREAD POOL " + this + "\n" + "--------------------------------------------\n" + "[min, max] = [" + this.min + "," + this.max + "]\n" + "---- threads ----\n" + "#\tAvailable\thash\tRunner\n";
        for (int i = 0; i < this.max; ++i) {
            BasicRunnable basicRunnable = null;
            if (i < this.current.size()) {
                basicRunnable = (BasicRunnable)this.current.get(i);
            }
            if (basicRunnable == null) continue;
            string = string + i + "\t" + this.available.contains(basicRunnable) + "\t" + Long.toHexString(basicRunnable.hashCode()) + "\t" + basicRunnable + "\n";
        }
        string = string + "--------------------------------------------\nDONE DUMPING THREAD POOL\n--------------------------------------------\n\n";
        this.logger.log(4, string);
    }

    public synchronized int getThreadNum() {
        return this.current_count;
    }

    public synchronized int getAssignedCnt() {
        return this.current_count - this.available.size() - this.availIndx.size();
    }

    public ThreadPool(String string, int n, int n2, RunnableFactory runnableFactory) {
        if (DEBUG) {
            Object[] objectArray = new String[]{string, String.valueOf(n), String.valueOf(n2)};
            this.logger.log(4, "ThreadPool: Creating Thread Pool({0}) = [ {1}, {2} ]", objectArray);
        }
        this.min = n;
        this.max = n2;
        this.tgroup = new MyThreadGroup("ThreadPool(" + string + ")");
        this.name = string;
        this.availIndx = new LinkedHashSet();
        this.current = new ArrayList();
        this.available = new LinkedList();
        this.runfac = runnableFactory;
        this.current_count = 0;
        this.nextThreadId = 0;
    }

    public void start() {
        this.resume();
    }

    public synchronized boolean isSuspended() {
        return this.notActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (DEBUG) {
            this.logger.log(4, "ThreadPool:  SUSPENDING ThreadPool({0})", this.name);
        }
        if (this.in_destroy) {
            return;
        }
        this.notActive = true;
        ArrayList arrayList = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            arrayList = new ArrayList(this.current);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicRunnable basicRunnable = (BasicRunnable)arrayList.get(i);
            if (basicRunnable == null) continue;
            basicRunnable.suspend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (DEBUG) {
            this.logger.log(4, "ThreadPool:  RESUMING ThreadPool({0})", this.name);
        }
        if (this.in_destroy) {
            return;
        }
        this.notActive = false;
        ArrayList arrayList = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            arrayList = new ArrayList(this.current);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicRunnable basicRunnable = (BasicRunnable)arrayList.get(i);
            if (basicRunnable == null) continue;
            basicRunnable.resume();
        }
        ThreadPool threadPool2 = this;
        synchronized (threadPool2) {
            this.notifyAll();
        }
    }

    public void setSuspended(boolean bl) {
        if (bl) {
            this.suspend();
        } else {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRunnable getAvailRunnable(boolean bl) {
        try {
            BasicRunnable basicRunnable = null;
            String string = null;
            while (!this.in_destroy && !this.destroyed) {
                Object object = this;
                synchronized (object) {
                    if (!this.available.isEmpty()) {
                        string = "availableList";
                        basicRunnable = (BasicRunnable)this.available.removeFirst();
                    } else if (!this.availIndx.isEmpty()) {
                        string = "existing index";
                        Iterator iterator = this.availIndx.iterator();
                        int n = (Integer)iterator.next();
                        iterator.remove();
                        basicRunnable = this.createNewThread(n);
                    } else if (this.nextThreadId < this.max) {
                        string = "new thread";
                        int n = this.nextThreadId++;
                        basicRunnable = this.createNewThread(n);
                    } else {
                        return null;
                    }
                }
                if (basicRunnable == null) {
                    this.logger.log(32, "B3100", string);
                    continue;
                }
                object = basicRunnable;
                synchronized (object) {
                    if (!basicRunnable.available()) {
                        basicRunnable = null;
                        continue;
                    }
                    basicRunnable.setState(2);
                }
                if (basicRunnable != null) break;
                object = this;
                synchronized (object) {
                    if (bl) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
            }
            return basicRunnable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized BasicRunnable createNewThread(int n) throws ArrayIndexOutOfBoundsException {
        if (n >= this.max) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "Too many threads " + this.current_count + "," + this.max));
        }
        BasicRunnable basicRunnable = null;
        if (n < this.current.size()) {
            basicRunnable = (BasicRunnable)this.current.get(n);
        }
        if (basicRunnable == null) {
            basicRunnable = this.runfac.getRunnable(n, this);
            if (this.current.size() <= n) {
                this.current.add(n, basicRunnable);
            } else {
                this.current.set(n, basicRunnable);
            }
        }
        basicRunnable.setState(1);
        Thread thread = new Thread(this.tgroup, basicRunnable, "Thread-" + this.name + "[" + n + "]");
        thread.setPriority(this.priority);
        if (n >= this.min) {
            basicRunnable.setThreadBehavior(1);
        }
        ++this.current_count;
        thread.start();
        return basicRunnable;
    }

    public synchronized void runnableDestroying(int n) {
        if (n >= this.current.size()) {
            this.logger.log(32, "B3100", " attempting to destroy unknown thread  " + n);
            this.debug();
            return;
        }
        BasicRunnable basicRunnable = (BasicRunnable)this.current.get(n);
        this.current.set(n, null);
        this.available.remove(basicRunnable);
    }

    public synchronized void runnableExit(int n) {
        if (this.in_destroy) {
            return;
        }
        --this.current_count;
        if (n < this.min) {
            BasicRunnable basicRunnable = this.createNewThread(n);
            this.available.add(basicRunnable);
        } else if (n <= this.max) {
            this.availIndx.add(new Integer(n));
        }
        this.notify();
    }

    public synchronized void releaseRunnable(BasicRunnable basicRunnable) {
        if (this.in_destroy) {
            return;
        }
        if (basicRunnable == null) {
            this.logger.log(16, "B3100", "null basic runnable " + basicRunnable);
            return;
        }
        int n = basicRunnable.getId();
        if (n < this.min) {
            if (!this.available.contains(basicRunnable)) {
                this.available.addFirst(basicRunnable);
            }
        } else if (!this.available.contains(basicRunnable)) {
            this.available.addLast(basicRunnable);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList arrayList = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.in_destroy = true;
            arrayList = new ArrayList(this.current);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicRunnable basicRunnable = (BasicRunnable)arrayList.get(i);
            if (basicRunnable == null) continue;
            basicRunnable.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnDestroy(long l) {
        this.destroy();
        ArrayList arrayList = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            arrayList = new ArrayList(this.current);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BasicRunnable basicRunnable = (BasicRunnable)arrayList.get(i);
            if (basicRunnable == null) continue;
            if (basicRunnable.isBusy()) {
                basicRunnable.waitOnDestroy(l);
            }
            if (basicRunnable.isDestroyed() || !basicRunnable.isCritical()) continue;
            this.logger.log(16, "B2046", (Object)basicRunnable, String.valueOf(l));
        }
        this.destroyed = true;
        ThreadPool threadPool2 = this;
        synchronized (threadPool2) {
            this.notifyAll();
        }
    }

    public void handleException(Throwable throwable) {
        this.logger.logStack(16, "B3100", "Unexpected Exception or Error", throwable);
    }

    public class MyThreadGroup
    extends ThreadGroup {
        public MyThreadGroup(String string) {
            super(string);
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            Globals.handleGlobalError(throwable, "Unexpected thread pool error");
        }
    }
}

